/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.quickfixes.OCSymbolQuickFix;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.types.ARCAttribute;
import org.jetbrains.annotations.NotNull;

public class OCChangeARCAttributeIntentionAction
extends OCSymbolQuickFix<OCSymbol> {
    private ARCAttribute myAttribute;

    public OCChangeARCAttributeIntentionAction(OCSymbol symbol, ARCAttribute attribute) {
        super(symbol);
        this.myAttribute = attribute;
    }

    @Override
    protected String getTextInternal(OCSymbol symbol) {
        return "Make " + symbol.getNameWithKindLowercase() + " " + this.myAttribute.getTokenName();
    }

    @NotNull
    public String getFamilyName() {
        return "Change ARC attribute";
    }

    @Override
    protected boolean isAvailable(OCSymbol symbol) {
        return OCSearchScope.isInProjectSources(symbol);
    }

    @Override
    protected void invoke(OCSymbol symbol) {
        Object declarator = symbol.locateDefinition();
        OCDeclaration declaration = (OCDeclaration)PsiTreeUtil.getParentOfType(declarator, OCDeclaration.class);
        if (declaration == null) {
            return;
        }
        OCTypeElement typeElement = declaration.getTypeElement();
        if (typeElement == null) {
            return;
        }
        OCChangeARCAttributeIntentionAction.removeOldAttributes(typeElement);
        OCChangeARCAttributeIntentionAction.removeOldAttributes(declarator);
        OCChangeUtil.changeText(declaration.getProject(), declaration.getContainingFile(), declaration.getTextOffset(), 0, this.myAttribute.getTokenName() + " ", true);
    }

    private static void removeOldAttributes(PsiElement typeElement) {
        for (ASTNode node : typeElement.getNode().getChildren(null)) {
            IElementType elementType = node.getElementType();
            if (elementType != OCTokenTypes.STRONG_KEYWORD && elementType != OCTokenTypes.WEAK_KEYWORD && elementType != OCTokenTypes.UNSAFE_UNRETAINED_KEYWORD && elementType != OCTokenTypes.AUTORELEASING_KEYWORD) continue;
            OCChangeUtil.delete(node.getPsi());
        }
    }
}

