/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.lang.ASTNode;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.quickfixes.OCSymbolQuickFix;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCAddTypeModifierIntentionAction
extends OCSymbolQuickFix<OCSymbol> {
    private OCElementType myModifier;
    private String mySubject;
    private boolean myProcessSameSymbols = true;

    public OCAddTypeModifierIntentionAction(@Nullable OCSymbolWithQualifiedName symbol, OCElementType modifier, @Nullable String subject, boolean processSameSymbols) {
        super(symbol);
        this.myModifier = modifier;
        this.mySubject = subject;
        this.myProcessSameSymbols = processSameSymbols;
    }

    public OCAddTypeModifierIntentionAction(@Nullable OCSymbolWithQualifiedName symbol, OCElementType modifier, boolean processSameSymbols) {
        this(symbol, modifier, symbol != null ? symbol.getNameWithKindLowercase() : null, processSameSymbols);
    }

    public OCAddTypeModifierIntentionAction(OCSymbolWithQualifiedName symbol, OCElementType modifier) {
        this(symbol, modifier, symbol != null ? symbol.getNameWithKindLowercase() : null, true);
    }

    @Override
    protected String getTextInternal(OCSymbol symbol) {
        return "Make " + this.mySubject + " " + this.myModifier.getName();
    }

    @NotNull
    public String getFamilyName() {
        return "Add '" + this.myModifier.getName() + "'";
    }

    @Override
    protected boolean isAvailable(OCSymbol symbol) {
        if (!OCSearchScope.isInProjectSources(symbol) || !OCCodeInsightUtil.isValid(symbol.locateDefinition())) {
            return false;
        }
        if (this.myModifier == OCTokenTypes.CONST_KEYWORD && (((OCDeclaratorSymbol)symbol).isConst() || symbol.getKind() == OCSymbolKind.ENUM_CONST)) {
            return false;
        }
        if (this.myModifier == OCTokenTypes.BLOCK_KEYWORD && (((OCDeclaratorSymbol)symbol).isBlockModifiable() || symbol.getKind() != OCSymbolKind.LOCAL_VARIABLE)) {
            return false;
        }
        return this.myModifier != OCTokenTypes.VIRTUAL_CPP_KEYWORD || !((OCFunctionSymbol)symbol).isVirtual();
    }

    @Override
    protected void invoke(OCSymbol symbol) {
        final ArrayList nodesToUpdate = new ArrayList();
        Processor<OCSymbol> processor2 = new Processor<OCSymbol>(){

            public boolean process(OCSymbol symbol) {
                Object element = symbol.locateDefinition();
                if (element == null || !(element.getParent() instanceof OCDeclaration)) {
                    return true;
                }
                OCTypeElement typeElement = ((OCDeclaration)element.getParent()).getTypeElement();
                if (typeElement == null) {
                    return true;
                }
                ASTNode typeNode = typeElement.getNode();
                if (typeNode != null && typeNode.getFirstChildNode() != null && typeNode.findChildByType((IElementType)OCAddTypeModifierIntentionAction.this.myModifier) == null) {
                    nodesToUpdate.add(typeNode);
                }
                return true;
            }
        };
        if (this.myProcessSameSymbols) {
            symbol.processSameSymbols(processor2);
        } else {
            processor2.process((Object)symbol);
        }
        OCFile context = symbol.getContainingOCFile();
        for (ASTNode node : nodesToUpdate) {
            node.addChild(OCElementFactory.spaceFromText(context).getNode(), node.getFirstChildNode());
            CodeEditUtil.addChild(node, OCElementFactory.typeModifierFromText(this.myModifier.getName(), context), node.getFirstChildNode());
        }
    }
}

