/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.quickfixes.OCPsiElementQuickFix;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCAddRawStringSuffix
extends OCPsiElementQuickFix<PsiElement> {
    private final PsiElement myRawString;

    public OCAddRawStringSuffix(PsiElement element) {
        super(element);
        this.myRawString = element;
    }

    @Override
    protected String getTextInternal() {
        return "Add suffix";
    }

    @NotNull
    public String getFamilyName() {
        return "Check raw string";
    }

    @Override
    protected boolean isAvailable() {
        return OCElementUtil.getElementType(this.myRawString) == OCTokenTypes.WRONG_RAW_STRING_LITERAL;
    }

    @Override
    public void invoke(@NotNull Project project2, final @Nullable Editor editor, PsiFile file2) throws IncorrectOperationException {
        String prefix;
        boolean hasLPAR;
        boolean hasRQUOTE;
        String rawText = this.myRawString.getText();
        int prefixStart = rawText.indexOf(34);
        int prefixEnd = rawText.length() - 1;
        int prefixInsert = rawText.length();
        boolean bl = hasRQUOTE = rawText.charAt(prefixEnd) == '\"';
        if (hasRQUOTE) {
            --prefixEnd;
            --prefixInsert;
        }
        boolean bl2 = hasLPAR = rawText.charAt(prefixEnd) == '(';
        if (hasLPAR) {
            --prefixEnd;
        }
        if (prefixStart <= prefixEnd) {
            prefix = rawText.substring(prefixStart + 1, prefixEnd + 1);
        } else {
            prefixInsert = prefixStart + 1;
            hasRQUOTE = false;
            prefix = "";
        }
        final StringBuilder subst = new StringBuilder(19);
        if (!hasLPAR) {
            subst.append('(');
        }
        subst.append(')');
        subst.append(prefix);
        if (!hasRQUOTE) {
            subst.append('\"');
        }
        final int insertPos = this.myRawString.getTextOffset() + prefixInsert;
        new WriteCommandAction(project2, new PsiFile[]{file2}){

            protected void run(@NotNull Result result) throws Throwable {
                Document document = editor.getDocument();
                document.insertString(insertPos, (CharSequence)subst);
            }
        }.execute();
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        if (!hasLPAR) {
            editor.getCaretModel().moveToOffset(insertPos + 1);
        }
    }
}

