/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.completion.CodeCompletionHandlerBase;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.lookup.LookupAdapter;
import com.intellij.codeInsight.lookup.LookupEvent;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.ide.util.EditorHelper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.quickfixes.OCPsiElementQuickFix;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerHelper;
import java.awt.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCAddInitializerIntentionAction
extends OCPsiElementQuickFix<OCDeclarator> {
    private OCSymbol mySymbol;

    public OCAddInitializerIntentionAction(@Nullable OCDeclarator declarator, OCSymbol symbol) {
        super(declarator);
        this.mySymbol = symbol;
    }

    @Override
    protected String getTextInternal() {
        return "Initialize " + this.mySymbol.getNameWithKindLowercase();
    }

    @NotNull
    public String getFamilyName() {
        return "Add initializers";
    }

    @Override
    protected boolean isAvailable(@NotNull OCDeclarator declarator) {
        if (this.mySymbol != null) {
            OCType type = this.mySymbol.getResolvedType();
            return !(type instanceof OCStructType) || type.isCppStructType() || ((OCStructType)type).isEnum();
        }
        return false;
    }

    @Override
    public void invoke(@NotNull Project project2, @Nullable Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (FileModificationService.getInstance().prepareFileForWrite(file2)) {
            PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
            OCDeclarator declarator = (OCDeclarator)this.myElementPtr.getElement();
            if (declarator != null) {
                this.invoke(file2, declarator, editor);
            }
        }
    }

    protected void invoke(PsiFile file2, @NotNull OCDeclarator declarator, Editor editor) {
        OCType type = this.mySymbol.getResolvedType();
        String declarationText = "int " + declarator.getTextWithMacros() + "=" + type.getDefaultValue((PsiElement)file2);
        OCDeclaration declaration = OCElementFactory.declarationFromText(declarationText, (PsiElement)file2, true);
        declarator = (OCDeclarator)OCChangeUtil.replaceHandlingMacros(declarator, declaration.getDeclarators().get(0));
        OCAddInitializerIntentionAction.invokeSmartCompletion(declarator.getInitializer(), type);
    }

    public static void invokeSmartCompletion(final @NotNull OCExpression expression, @NotNull OCType type) {
        final OCFile file2 = expression.getContainingOCFile();
        final boolean deleteOnEsc = type.isPointerToObjectCompatible() && !OCCompilerHelper.isArcDisabled(file2);
        TextRange initializerRange = expression.getRangeWithMacros();
        final Editor editor = EditorHelper.openInEditor(expression);
        if (editor == null) {
            return;
        }
        editor.getCaretModel().moveToOffset(initializerRange.getEndOffset());
        editor.getSelectionModel().setSelection(initializerRange.getStartOffset(), initializerRange.getEndOffset());
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                if (file2.getProject().isDisposed() || !file2.isValid()) {
                    return;
                }
                CodeCompletionHandlerBase base = new CodeCompletionHandlerBase(CompletionType.SMART, false, false, true);
                base.invokeCompletion(file2.getProject(), editor, 1, true, false);
                LookupEx lookup = LookupManager.getActiveLookup(editor);
                if (lookup != null) {
                    lookup.addLookupListener(new LookupAdapter(){

                        @Override
                        public void lookupCanceled(LookupEvent event) {
                            if (deleteOnEsc && expression.isValid()) {
                                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                                    @Override
                                    public void run() {
                                        Document document = PsiDocumentManager.getInstance((Project)expression.getProject()).getDocument(expression.getContainingFile());
                                        if (document != null) {
                                            PsiDocumentManager.getInstance((Project)expression.getProject()).commitDocument(document);
                                        }
                                        OCChangeUtil.delete(expression);
                                    }
                                });
                            } else {
                                editor.getSelectionModel().removeSelection();
                            }
                        }
                    });
                }
            }
        }, ModalityState.stateForComponent((Component)editor.getComponent()));
    }
}

