/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.text.CharArrayUtil;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.psi.OCUndefDirective;
import com.jetbrains.cidr.lang.psi.impl.OCDirectiveImpl;
import com.jetbrains.cidr.lang.symbols.OCSymbolImpl;
import com.jetbrains.cidr.lang.symbols.OCSymbolOffsetUtil;
import com.jetbrains.cidr.lang.symbols.cpp.OCUndefMacroSymbol;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCUndefDirectiveImpl
extends OCDirectiveImpl
implements OCUndefDirective {
    public OCUndefDirectiveImpl(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    public String getName() {
        OCUndefMacroSymbol def = this.getSymbol();
        return OCSymbolImpl.getSymbolName(def);
    }

    @Override
    public OCUndefMacroSymbol getSymbol() {
        ASTNode content;
        if (this.isValid() && (content = this.findContentNode()) != null) {
            return OCUndefMacroSymbol.parseFromDirectiveContent(content.getText(), this.getContainingOCFile(), content.getStartOffset());
        }
        return null;
    }

    @Nullable
    private ASTNode findContentNode() {
        return this.getNode().findChildByType((IElementType)OCElementTypes.MACRO_REF);
    }

    @Override
    public int getTextOffset() {
        ASTNode content = this.findContentNode();
        if (content == null) {
            return super.getTextOffset();
        }
        return content.getStartOffset() + CharArrayUtil.shiftForward((CharSequence)content.getText(), (int)0, (String)" \t");
    }

    @Override
    public long getComplexOffset() {
        ASTNode content = this.findContentNode();
        if (content == null) {
            return super.getComplexOffset();
        }
        return OCSymbolOffsetUtil.getComplexOffset(content.getPsi()) + (long)CharArrayUtil.shiftForward((CharSequence)content.getText(), (int)0, (String)" \t");
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        ASTNode content = this.findContentNode();
        String newContent = content.getText().replaceFirst(this.getName(), name);
        PsiElement psiElement = OCElementFactory.topLevelDeclarationFromText("#undef " + newContent, this);
        CodeEditUtil.replaceChild(this.getNode(), content, ((OCUndefDirectiveImpl)psiElement).findContentNode());
        return this;
    }
}

