/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCExpressionStatement;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.psi.OCStatementExpression;
import com.jetbrains.cidr.lang.psi.impl.OCExpressionBase;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCStatementExpressionImpl
extends OCExpressionBase
implements OCStatementExpression {
    public OCStatementExpressionImpl(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    @Nullable
    public OCBlockStatement getBody() {
        return (OCBlockStatement)this.findChildByType(OCElementTypes.BLOCK_STATEMENTS);
    }

    @Override
    public void accept(@NotNull OCVisitor visitor) {
        visitor.visitStatementExpression(this);
    }

    @Override
    @NotNull
    public OCType getType(@NotNull OCResolveContext context) {
        OCBlockStatement body = this.getBody();
        if (body == null) {
            return OCVoidType.instance();
        }
        List<OCStatement> statements = body.getStatements();
        if (statements == null || statements.isEmpty()) {
            return OCVoidType.instance();
        }
        OCStatement last = statements.get(statements.size() - 1);
        if (!(last instanceof OCExpressionStatement)) {
            return OCVoidType.instance();
        }
        OCExpression expression = ((OCExpressionStatement)last).getExpression();
        return expression == null ? OCVoidType.instance() : expression.getType(context);
    }
}

