/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.impl.OCExpressionBase;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCUsingSymbol;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCObjectTypeContext;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.OCVariadicType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCReferenceExpressionImpl
extends OCExpressionBase
implements OCReferenceExpression {
    public OCReferenceExpressionImpl(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    @Nullable
    public OCReferenceElement getReferenceElement() {
        return (OCReferenceElement)this.findChildByType(OCElementTypes.REFERENCE_ELEMENT);
    }

    @Override
    public OCSymbol resolveToSymbol() {
        OCReferenceElement referenceElement = this.getReferenceElement();
        return referenceElement != null ? referenceElement.resolveToSymbol() : null;
    }

    @Override
    public void accept(@NotNull OCVisitor visitor) {
        visitor.visitReferenceExpression(this);
    }

    @Override
    @Nullable
    public OCElementTypes.SelfSuperToken getSelfSuperToken() {
        OCReferenceElement referenceElement = this.getReferenceElement();
        return referenceElement != null ? OCElementUtil.getSelfSuperToken(referenceElement.getCanonicalText(), this, new OCResolveContext(referenceElement)) : null;
    }

    @Override
    public boolean isCppThis() {
        OCReferenceElement referenceElement = this.getReferenceElement();
        return referenceElement != null && referenceElement.isCppThis();
    }

    @Override
    public boolean isSelfSuperOrThis() {
        return this.getSelfSuperToken() != null || this.isCppThis();
    }

    @Override
    public OCObjectTypeContext getTypeContext(OCExpression qualifier, OCType type, OCType unresolvedType, boolean treatIDAsNSObject, boolean ignoreImports) {
        OCElementTypes.SelfSuperToken selfSuper = this.getSelfSuperToken();
        if (selfSuper == null) {
            return super.getTypeContext(qualifier, type, unresolvedType, treatIDAsNSObject, ignoreImports);
        }
        return this.getTypeContext(treatIDAsNSObject, ignoreImports);
    }

    @Override
    @Nullable
    public OCObjectTypeContext getTypeContext(boolean treatIDAsNSObject, boolean ignoreImports) {
        OCElementTypes.SelfSuperToken selfSuper = this.getSelfSuperToken();
        if (selfSuper == null) {
            return super.getTypeContext(treatIDAsNSObject, ignoreImports);
        }
        OCMethod containingMethod = (OCMethod)PsiTreeUtil.getContextOfType((PsiElement)this, (Class[])new Class[]{OCMethod.class});
        if (containingMethod == null) {
            return null;
        }
        OCClassDeclaration containingClass = containingMethod.getContainingClass();
        String name = containingClass.getName();
        OCType result = OCReferenceType.resolvedFromText(name, this.getContainingFile(), ignoreImports);
        if (selfSuper == OCElementTypes.SelfSuperToken.SUPER && result instanceof OCObjectType) {
            OCObjectType superType = ((OCObjectType)result).getSuperType();
            if (superType != null) {
                result = superType;
            } else if (containingMethod.isInstanceMethod()) {
                result = null;
            }
        }
        if (result instanceof OCObjectType) {
            return new OCObjectTypeContext(!containingMethod.isInstanceMethod(), false, (OCObjectType)result, result);
        }
        return null;
    }

    @Override
    @NotNull
    public OCType getType(@NotNull OCResolveContext context) {
        OCReferenceElement referenceElement = this.getReferenceElement();
        return OCReferenceExpressionImpl.getReferenceExpressionType(referenceElement != null ? referenceElement.resolveToSymbol(context) : null);
    }

    public static OCType getReferenceExpressionType(OCSymbol symbol) {
        if (symbol instanceof OCStructSymbol) {
            return new OCFunctionType(OCVoidType.instance(), Collections.emptyList());
        }
        OCType type = symbol != null ? symbol.getType() : OCUnknownType.INSTANCE;
        return type instanceof OCVariadicType ? ((OCVariadicType)type).getUnderlyingType() : type;
    }

    @Override
    public boolean isExpression() {
        OCSymbol symbol = this.resolveToSymbol();
        if (symbol == null) {
            return true;
        }
        if (symbol.getKind() == OCSymbolKind.SYMBOL_USING_SYMBOL) {
            List<OCSymbol> symbols = ((OCUsingSymbol)symbol).getSymbolReference().resolveToSymbols(this.getContainingOCFile());
            if (symbols.size() != 0) {
                symbol = symbols.get(0);
            }
            return symbol.getKind().isExpression();
        }
        return symbol.getKind().isExpression();
    }
}

