/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.meta.PsiMetaOwner;
import com.intellij.psi.meta.PsiWritableMetaData;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCCaseStatement;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCCompatibilityAlias;
import com.jetbrains.cidr.lang.psi.OCConstructorFieldInitializer;
import com.jetbrains.cidr.lang.psi.OCCppBaseClause;
import com.jetbrains.cidr.lang.psi.OCCppNamespaceQualifier;
import com.jetbrains.cidr.lang.psi.OCCppNewExpression;
import com.jetbrains.cidr.lang.psi.OCCppUsingStatement;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarationOrExpression;
import com.jetbrains.cidr.lang.psi.OCDeclarationStatement;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCDefineDirective;
import com.jetbrains.cidr.lang.psi.OCDirective;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCExpressionStatement;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCGotoStatement;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCMacroParameter;
import com.jetbrains.cidr.lang.psi.OCMacroParameterList;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCNamespaceQualifierOwner;
import com.jetbrains.cidr.lang.psi.OCParameterDeclaration;
import com.jetbrains.cidr.lang.psi.OCParameterList;
import com.jetbrains.cidr.lang.psi.OCParenthesizedExpression;
import com.jetbrains.cidr.lang.psi.OCProtocolExpression;
import com.jetbrains.cidr.lang.psi.OCProtocolList;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCSizeofExpression;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.psi.OCSuperClassRef;
import com.jetbrains.cidr.lang.psi.OCSwitchStatement;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.OCSynthesizeProperty;
import com.jetbrains.cidr.lang.psi.OCTemplateArgumentList;
import com.jetbrains.cidr.lang.psi.OCTypeArgumentList;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.psi.impl.OCDeclarationImpl;
import com.jetbrains.cidr.lang.psi.impl.OCElementBase;
import com.jetbrains.cidr.lang.psi.impl.OCFileImpl;
import com.jetbrains.cidr.lang.psi.impl.OCMacroReferenceElementImpl;
import com.jetbrains.cidr.lang.psi.impl.OCQualifiedExpressionImpl;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.refactoring.util.OCBindUtil;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.resolve.OCArgumentsList;
import com.jetbrains.cidr.lang.resolve.OCResolveOverloadsUtil;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolGroupContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolHolderVirtualPsiElement;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.OCSymbolReferenceResolver;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCMacroSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCThisSelfSuperSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.symbols.symtable.OCFileSymbols;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import com.jetbrains.cidr.lang.types.CVQualifiers;
import com.jetbrains.cidr.lang.types.OCIdType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.visitors.OCArgumentDepLookupAccumulator;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCCommonProcessors;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCExpectedTypeUtil;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCReferenceElementImpl
extends OCElementBase
implements OCNamespaceQualifierOwner,
OCReferenceElement,
OCExpectedTypeUtil.Expectable,
PsiMetaOwner {
    private static final Condition<OCSymbol> IN_HEADER_FILE = new Condition<OCSymbol>(){

        public boolean value(OCSymbol symbol) {
            VirtualFile file2 = symbol.getContainingFile();
            return file2 != null && OCFileImpl.isHeaderFile(file2.getName());
        }
    };

    public OCReferenceElementImpl(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    @NotNull
    public PsiReference getReference() {
        return this;
    }

    @Override
    public void accept(@NotNull OCVisitor visitor) {
        visitor.visitReferenceElement(this);
    }

    public OCReferenceElement getElement() {
        return this;
    }

    @Override
    public PsiElement getNameIdentifier() {
        return this.findReferenceToken();
    }

    @Override
    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        OCElementUtil.replaceWithIdentifier(this.findReferenceToken(), name, this);
        return this;
    }

    @Override
    @NotNull
    public String getName() {
        return this.getCanonicalText();
    }

    @Override
    public OCCppNamespaceQualifier getNamespaceQualifier() {
        return (OCCppNamespaceQualifier)this.findChildByType(OCElementTypes.CPP_NAMESPACE_QUALIFIER);
    }

    @Override
    public OCTypeArgumentList getTemplateArgumentList() {
        return (OCTypeArgumentList)this.findChildByType(OCElementTypes.TYPE_ARGUMENT_LIST);
    }

    public TextRange getRangeInElement() {
        PsiElement child = this.findReferenceToken();
        if (child != null) {
            int startOffset = child.getStartOffsetInParent();
            int length = child.getTextLength();
            if (OCElementUtil.getElementType(child) == OCTokenTypes.OPERATOR_CPP_KEYWORD) {
                return TextRange.create((int)startOffset, (int)this.getTextLength());
            }
            PsiElement prevSibling = PsiTreeUtil.skipSiblingsBackward((PsiElement)child, (Class[])new Class[]{PsiWhiteSpace.class});
            if (prevSibling != null && "~".equals(prevSibling.getText())) {
                return TextRange.create((int)prevSibling.getStartOffsetInParent(), (int)(startOffset + length));
            }
            return TextRange.from((int)startOffset, (int)length);
        }
        return TextRange.EMPTY_RANGE;
    }

    @Nullable
    protected PsiElement findReferenceToken() {
        return this.findChildByType(OCTokenTypes.POSSIBLE_CPP_NAMES);
    }

    public PsiElement resolve() {
        OCSymbol symbol = this.resolveToSymbol();
        if (symbol == null || symbol.getKind() == OCSymbolKind.BUILTIN_SYMBOL) {
            return null;
        }
        Object element = symbol.locateDefinition();
        return element != null ? element : OCSymbolHolderVirtualPsiElement.create(symbol);
    }

    @Override
    public OCSymbol resolveToSymbol() {
        return this.resolveToSymbol(new OCResolveContext(this));
    }

    @Override
    @Nullable
    public OCSymbol resolveToSymbol(@NotNull OCResolveContext context) {
        Pair<OCSymbol, Boolean> pair = ResolveCache.getInstance(this.getProject()).resolveWithCaching(this, new MyResolver(context), false, false);
        return pair != null && (Boolean)pair.second != false ? (OCSymbol)pair.first : null;
    }

    @Override
    public OCSymbol resolveToSymbolIgnoringSymbolContext() {
        Pair<OCSymbol, Boolean> pair = ResolveCache.getInstance(this.getProject()).resolveWithCaching(this, new MyResolver(new OCResolveContext(this)), false, false);
        return pair != null ? (OCSymbol)pair.first : null;
    }

    @Override
    @Nullable
    public OCSymbol resolveToSymbol(@Nullable OCSymbolGroupContext context) {
        return this.resolveToSymbol(context, new OCResolveContext(this), false, false, false);
    }

    @Override
    public boolean isCppThis() {
        OCSymbol symbol = this.resolveToSymbol();
        return symbol instanceof OCThisSelfSuperSymbol && ((OCThisSelfSuperSymbol)symbol).getSelfSuperThisKind() == OCThisSelfSuperSymbol.Kind.THIS;
    }

    @Override
    @NotNull
    public Collection<OCSymbol> resolveToOverloadsSymbols() {
        return this.resolveToOverloadsSymbols(this.getSymbolContext(), false, true, new OCResolveContext(this));
    }

    @Override
    @NotNull
    public Collection<OCSymbol> resolveToOverloadsSymbols(@Nullable OCSymbolGroupContext symbolContext, boolean ignoreImports) {
        return this.resolveToOverloadsSymbols(symbolContext, ignoreImports, true, new OCResolveContext(this));
    }

    @NotNull
    private Collection<OCSymbol> resolveToOverloadsSymbols(final @Nullable OCSymbolGroupContext symbolContext, boolean ignoreImports, boolean filterByTemplates, @NotNull OCResolveContext context) {
        PsiElement parent = this.getContext();
        Collection<OCSymbol> result = this.processMacros(symbolContext);
        if (result != null) {
            return result;
        }
        result = this.processSelfSuper(context);
        if (result != null) {
            return result;
        }
        CommonProcessors.CollectProcessor<OCSymbol> processor2 = new CommonProcessors.CollectProcessor<OCSymbol>(){

            public boolean process(OCSymbol symbol) {
                if (symbolContext == null || symbolContext.isSuitableSymbol(symbol)) {
                    return symbol instanceof OCClassSymbol && ((OCClassSymbol)symbol).getCategoryName() != null || super.process((Object)symbol);
                }
                return true;
            }
        };
        OCFile containingOCFile = this.getContainingOCFile();
        OCSymbolReference.SymbolFilter filter = OCSymbolReference.SymbolFilter.NONE;
        if (parent instanceof OCCppUsingStatement && ((OCCppUsingStatement)parent).isNamespaceUsing()) {
            filter = OCSymbolReference.SymbolKindFilter.ONLY_NAMESPACE;
        }
        OCSymbolReference reference = OCSymbolReference.getLocalReference(this, filter);
        Object filteredProcessor = processor2;
        if (!this.canBeLocalReference(reference)) {
            reference = OCSymbolReferenceResolver.getGlobalReferenceFromLocal(reference);
            filteredProcessor = OCSymbolReferenceResolver.createResolveFilteringProcessor((Processor<OCSymbol>)processor2, context);
        }
        if (ignoreImports) {
            OCCommonProcessors.OrderedProcessor orderedProcessor = new OCCommonProcessors.OrderedProcessor(filteredProcessor, (Condition<T>[])new Condition[]{IN_HEADER_FILE});
            OCResolveContext context2 = new OCResolveContext(containingOCFile);
            context2.setProcessNonImported(true);
            ContainerUtil.process(context2.resolveToSymbols(reference), orderedProcessor);
            orderedProcessor.finish();
        } else {
            reference.processPossibleSymbols((Processor<OCSymbol>)filteredProcessor, filterByTemplates, context);
        }
        if (processor2.getResults().size() == 0) {
            return this.processOtherSources(symbolContext, ignoreImports, processor2, context, containingOCFile);
        }
        return processor2.getResults();
    }

    @Override
    @NotNull
    public Collection<OCSymbol> resolveTemplateDeclarations() {
        return OCResolveUtil.resolveTemplateDeclarations(this);
    }

    private boolean canBeLocalReference(OCSymbolReference reference) {
        OCElement scope = (OCElement)PsiTreeUtil.getContextOfType((PsiElement)this, (Class[])new Class[]{OCBlockStatement.class, OCDeclarationImpl.class, OCCallable.class, OCCppUsingStatement.class, OCClassDeclaration.class});
        if (scope instanceof OCCppUsingStatement || PsiTreeUtil.getParentOfType((PsiElement)scope, OCClassDeclaration.class, (boolean)false) != null) {
            return true;
        }
        OCQualifiedName name = reference.getQualifiedName();
        while (name.getQualifier() != null) {
            name = name.getQualifier();
        }
        String qualifier = name.getName();
        if (scope != null && qualifier != null) {
            OCFile file2 = this.getContainingOCFile();
            while (file2 != null) {
                if (OCFileSymbols.canBeLocalSymbol(file2, qualifier)) {
                    return true;
                }
                PsiElement context = file2.getContext();
                file2 = context != null ? (OCFile)context.getContainingFile() : null;
            }
        }
        return false;
    }

    @Nullable
    protected Collection<OCSymbol> processMacros(OCSymbolGroupContext symbolContext) {
        OCMacroParameterList macroParameters;
        OCDefineDirective directive;
        if (symbolContext == OCSymbolGroupContext.MACRO_OR_MACRO_PARAMETER_CONTEXT && (directive = (OCDefineDirective)PsiTreeUtil.getContextOfType((PsiElement)this, (Class[])new Class[]{OCDefineDirective.class})) != null && (macroParameters = directive.getMacroParameters()) != null) {
            for (OCMacroParameter param : macroParameters.getParameters()) {
                if (!this.getText().equals(param.getText())) continue;
                return Collections.singletonList(param.getSymbol());
            }
        }
        return null;
    }

    @Nullable
    protected Collection<OCSymbol> processSelfSuper(@NotNull OCResolveContext context) {
        OCClassDeclaration clazz;
        PsiElement parent = this.getContext();
        String elementName = this.getCanonicalText();
        if (parent instanceof OCReferenceExpression) {
            OCSymbol thisSelfSuper = OCThisSelfSuperSymbol.tryResolveThisSelfSuper(elementName, parent, context);
            if (thisSelfSuper != null) {
                return Collections.singletonList(thisSelfSuper);
            }
        } else if (parent instanceof OCTypeElement && parent.getParent() instanceof OCMethod && "instancetype".equals(elementName) && (clazz = (OCClassDeclaration)PsiTreeUtil.getContextOfType((PsiElement)parent, (Class[])new Class[]{OCClassDeclaration.class})) != null) {
            return Collections.singletonList(clazz.getSymbol());
        }
        return null;
    }

    protected Collection<OCSymbol> processOtherSources(OCSymbolGroupContext symbolContext, boolean ignoreImports, CommonProcessors.CollectProcessor<OCSymbol> processor2, @NotNull OCResolveContext context, OCFile containingOCFile) {
        if (containingOCFile.isCpp() && symbolContext == OCSymbolGroupContext.PROTOCOL_CONTEXT) {
            return this.resolveToOverloadsSymbols(OCSymbolGroupContext.typeContext(containingOCFile.getKind()), ignoreImports, true, new OCResolveContext(this));
        }
        OCSymbolReference.LocalReference ref = OCSymbolReference.getLocalReference(this, OCSymbolReference.SymbolFilter.NONE);
        if (symbolContext == OCSymbolGroupContext.MACRO_OR_MACRO_PARAMETER_CONTEXT && ref.getQualifiedName().getQualifier() == null) {
            OCGlobalProjectSymbolsCache.processTopLevelSymbols(this.getProject(), processor2, ref.getQualifiedName().getName());
        } else if (containingOCFile.isInLibraries()) {
            boolean oldFlag = OCResolveContext.setNonImportedFlag(context, true);
            ContainerUtil.process(context.resolveToSymbols(ref), processor2);
            OCResolveContext.setNonImportedFlag(context, oldFlag);
        }
        return processor2.getResults();
    }

    protected Collection<OCSymbol> addConstructors(Collection<OCSymbol> symbols) {
        PsiElement parent = this.getParent();
        if (parent != null && (parent.getContext() instanceof OCCallExpression || parent.getContext() instanceof OCCppNewExpression) || parent instanceof OCConstructorFieldInitializer) {
            CommonProcessors.CollectProcessor collector = new CommonProcessors.CollectProcessor(new ArrayList<OCSymbol>(symbols));
            for (OCSymbol symbol : symbols) {
                if (!(symbol instanceof OCStructSymbol)) continue;
                OCStructSymbol struct = (OCStructSymbol)symbol;
                struct.processMembers(symbol.getName(), (Processor<OCSymbol>)collector);
            }
            return collector.getResults();
        }
        return symbols;
    }

    @Override
    @Nullable
    public OCSymbol resolveToSymbol(@Nullable OCSymbolGroupContext symbolContext, @NotNull OCResolveContext context, boolean filterByParameters, boolean filterByTemplates, boolean filterAmbigs) {
        boolean isOverloadable;
        ProgressManager.checkCanceled();
        Collection<OCSymbol> symbols = this.resolveToOverloadsSymbols(symbolContext, false, filterByTemplates, context);
        boolean bl = isOverloadable = this.getContainingOCFile().isCpp() || ContainerUtil.exists(symbols, (Condition)new Condition<OCSymbol>(){

            public boolean value(OCSymbol symbol) {
                return symbol.hasAttribute("overloadable");
            }
        });
        if (isOverloadable) {
            return this.resolveOverloads(symbols, context, filterByParameters, filterByTemplates, filterAmbigs);
        }
        return OCReferenceElementImpl.findPredeclaration(symbols);
    }

    @Nullable
    private OCSymbol resolveOverloads(Collection<OCSymbol> symbols, @NotNull OCResolveContext context, boolean filterByParameters, boolean filterByTemplates, boolean filterAmbigs) {
        PsiElement parent = this.getContext();
        if (parent instanceof OCExpression) {
            parent = OCParenthesesUtils.topmostParenthesized((OCExpression)parent);
        }
        if (parent != null) {
            OCSymbol result;
            OCFunctionDefinition method;
            List<OCExpression> args;
            OCStructType type = null;
            if (parent.getParent() instanceof OCCallExpression) {
                args = ((OCCallExpression)parent.getParent()).getArguments();
            } else if (parent.getParent() instanceof OCCppNewExpression) {
                args = ((OCCppNewExpression)parent.getParent()).getInitializers();
            } else if (parent instanceof OCConstructorFieldInitializer) {
                args = ((OCConstructorFieldInitializer)parent).getInitializers();
            } else {
                return OCReferenceElementImpl.findPredeclaration(symbols);
            }
            OCArgumentsList<OCExpression> arguments = OCArgumentsList.getArgumentList(args, context);
            List classes = ContainerUtil.findAll(symbols, OCStructSymbol.class);
            if (!classes.isEmpty()) {
                type = new OCStructType(classes);
            }
            OCFunctionSymbol methodSymbol = (method = (OCFunctionDefinition)PsiTreeUtil.getContextOfType((PsiElement)this, (boolean)false, (Class[])new Class[]{OCFunctionDefinition.class})) != null ? method.getSymbol() : null;
            CVQualifiers cvQualifiers = methodSymbol != null ? methodSymbol.getType().getCVQualifiers() : null;
            OCQualifiedName name = OCSymbolReferenceResolver.getQualifiedName(this);
            if (this.getContext().getParent() instanceof OCCallExpression) {
                symbols = OCArgumentDepLookupAccumulator.doArgDepLookup(symbols, arguments.getTypes(), args, name, context);
            }
            if ((result = OCResolveOverloadsUtil.resolveOverloads(type, symbols = this.addConstructors(symbols), arguments, cvQualifiers, null, true, filterByParameters, filterByTemplates, filterAmbigs, false, context)) != null) {
                return result;
            }
        }
        return null;
    }

    @Nullable
    public static OCSymbol findPredeclaration(@NotNull Collection<OCSymbol> symbols) {
        List filtered;
        if (symbols.size() != 1 && (filtered = ContainerUtil.filter(symbols, OCSymbol.NON_FANTOM_SYMBOL_CONDITION)).size() != 0) {
            symbols = filtered;
        }
        OCSymbol predefinition = null;
        OCSymbol definition = null;
        OCSymbol typedef = null;
        for (OCSymbol symbol : symbols) {
            if (symbol.getKind() == OCSymbolKind.TYPEDEF) {
                typedef = symbol;
                continue;
            }
            if (symbol instanceof OCStructSymbol && symbol.isPredeclaration()) {
                predefinition = symbol;
                continue;
            }
            if (definition != null && (definition.getOffset() >= symbol.getOffset() || definition.getKind() != OCSymbolKind.ENUM || symbol.getKind() != OCSymbolKind.ENUM_CONST) && (!definition.getKind().isConstructorOrDestructor() || symbol.getKind() != OCSymbolKind.STRUCT)) continue;
            definition = symbol;
        }
        OCSymbol result = definition != null ? definition : predefinition;
        return typedef != null && (result == null || !result.getKind().isLocal()) ? typedef : result;
    }

    @Override
    public OCType getExpectedType() {
        OCElement parent = (OCElement)this.getContext();
        OCType expectedType = null;
        if (parent instanceof OCReferenceExpression) {
            if (parent.getContext() instanceof OCCallExpression) {
                return OCQualifiedExpressionImpl.getCallExpectedType((OCCallExpression)parent.getParent());
            }
            expectedType = OCExpectedTypeUtil.getExpectedType((OCReferenceExpression)parent, true);
        } else if (parent instanceof OCSynthesizeProperty) {
            OCReferenceElement ivarRef = ((OCSynthesizeProperty)parent).getInstanceVariableRef();
            OCReferenceElement propertyRef = ((OCSynthesizeProperty)parent).getPropertyRef();
            OCSymbol peerSymbol = null;
            if (this == ivarRef && propertyRef != null) {
                peerSymbol = propertyRef.resolveToSymbol();
            } else if (this == propertyRef && ivarRef != null) {
                peerSymbol = ivarRef.resolveToSymbol();
            }
            if (peerSymbol != null) {
                return peerSymbol.getType();
            }
        }
        if (expectedType == null || expectedType == OCUnknownType.INSTANCE) {
            expectedType = this.getContainingOCFile().getKind().isObjC() ? OCIdType.pointerToID(this.getProject()) : OCIntType.INT;
        }
        return expectedType;
    }

    @Override
    public OCSymbolGroupContext getSymbolContext() {
        return this.getSymbolContext(new OCResolveContext(this));
    }

    private OCSymbolGroupContext getSymbolContext(@NotNull OCResolveContext context) {
        OCSymbolGroupContext result;
        OCCodeStyleSettings settings;
        PsiElement parent = this.getContext();
        OCLanguageKind languageKind = this.getContainingOCFile().getKind();
        boolean cpp = languageKind.isCpp();
        boolean objc = languageKind.isObjC();
        if (this instanceof OCMacroReferenceElementImpl) {
            return OCSymbolGroupContext.MACRO_CONTEXT;
        }
        if (parent == null) {
            return null;
        }
        if (parent instanceof OCSuperClassRef) {
            return OCSymbolGroupContext.CLASS_CONTEXT;
        }
        if (parent instanceof OCProtocolList) {
            return OCSymbolGroupContext.PROTOCOL_CONTEXT;
        }
        if (parent instanceof OCGotoStatement) {
            return OCSymbolGroupContext.LABEL_CONTEXT;
        }
        if (parent instanceof OCReferenceElement && objc) {
            return OCSymbolGroupContext.PROTOCOL_CONTEXT;
        }
        if (parent instanceof OCCppUsingStatement && ((OCCppUsingStatement)parent).isNamespaceUsing()) {
            return new OCSymbolGroupContext("namespace", OCSymbolKind.NAMESPACE, OCSymbolKind.NAMESPACE_ALIAS);
        }
        if (parent instanceof OCStructLike) {
            OCSymbolKind kind = ((OCStructLike)parent).getKind();
            return new OCSymbolGroupContext(kind.getNameLowercase(), kind, OCSymbolKind.SYMBOL_USING_SYMBOL, OCSymbolKind.TEMPLATE_TYPE_PARAMETER, OCSymbolKind.BUILTIN_SYMBOL);
        }
        OCReferenceElementImpl scopeKid = this;
        PsiElement scope = null;
        while (scopeKid != null) {
            OCExpression initializer;
            scope = PsiTreeUtil.getContextOfType((PsiElement)scopeKid, (Class[])new Class[]{OCParameterList.class, OCCallable.class, OCClassDeclaration.class, OCDirective.class, OCConstructorFieldInitializer.class});
            OCDeclarator declarator = scope instanceof OCFunctionDeclaration ? ((OCFunctionDeclaration)scope).getDeclarator() : null;
            OCExpression oCExpression = initializer = declarator != null ? declarator.getInitializer() : null;
            if (!PsiTreeUtil.isAncestor((PsiElement)initializer, (PsiElement)scopeKid, (boolean)true)) break;
            scopeKid = scope;
        }
        if (scope instanceof OCDirective) {
            return OCSymbolGroupContext.MACRO_OR_MACRO_PARAMETER_CONTEXT;
        }
        OCClassDeclaration clazz = (OCClassDeclaration)PsiTreeUtil.getContextOfType(scope, OCClassDeclaration.class, (boolean)false);
        OCClassSymbol classSymbol = clazz != null ? clazz.getSymbol() : null;
        OCInterfaceSymbol intfSymbol = classSymbol != null ? classSymbol.getInterface() : null;
        OCImplementationSymbol implSymbol = classSymbol != null ? classSymbol.getImplementation() : null;
        OCClassSymbol ivarsParent = intfSymbol;
        if (classSymbol != null && OCCompilerHelper.supportsIvarsInImplementation() && ((settings = (OCCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)this.getProject()).getCustomSettings(OCCodeStyleSettings.class)) == null || settings.PUT_IVARS_TO_IMPLEMENTATION)) {
            ivarsParent = implSymbol;
        }
        if (parent instanceof OCSynthesizeProperty && ((OCSynthesizeProperty)parent).getPropertyRef() == this) {
            return new OCSymbolGroupContext(new OCSymbolContext(this, OCSymbolKind.PROPERTY, intfSymbol));
        }
        if (parent instanceof OCSynthesizeProperty && ((OCSynthesizeProperty)parent).getInstanceVariableRef() == this) {
            return new OCSymbolGroupContext(new OCSymbolContext(this, OCSymbolKind.INSTANCE_VARIABLE, ivarsParent));
        }
        if (parent instanceof OCTypeElement && parent.getContext() instanceof OCProtocolExpression) {
            return OCSymbolGroupContext.PROTOCOL_CONTEXT;
        }
        if (parent instanceof OCCompatibilityAlias) {
            return OCSymbolGroupContext.union(OCSymbolGroupContext.CLASS_CONTEXT, OCSymbolKind.TYPEDEF);
        }
        OCCppNamespaceQualifier qualifier = this.getNamespaceQualifier();
        OCSymbol parentSymbol = OCReferenceElementImpl.getAppropriateToAppendSymbol(qualifier, context);
        String contextName = parentSymbol != null && parentSymbol.getKind().canBeNamespace() ? parentSymbol.getKind().getNameLowercase() + " member" : (parent instanceof OCCppUsingStatement ? "member" : "variable");
        OCSymbolGroupContext varContext = new OCSymbolGroupContext(contextName, new OCSymbolKind[0]);
        if (parentSymbol != null && parentSymbol.getKind() == OCSymbolKind.NAMESPACE) {
            varContext.addSymbolContext(new OCSymbolContext(this, OCSymbolKind.GLOBAL_VARIABLE, parentSymbol));
            varContext.addSymbolContext(new OCSymbolContext(this, OCSymbolKind.GLOBAL_VARIABLE_PREDECLARATION, parentSymbol));
            varContext.addSymbolContext(new OCSymbolContext(this, OCSymbolKind.FUNCTION_PREDECLARATION, parentSymbol));
            varContext.addSymbolContext(new OCSymbolContext(this, OCSymbolKind.FUNCTION_DECLARATION, parentSymbol));
            if (qualifier == null && parent instanceof OCExpression && !OCCodeInsightUtil.isLValue((OCExpression)parent)) {
                varContext.addSymbolContext(new OCSymbolContext(this, OCSymbolKind.MACRO, null));
            }
        } else {
            OCSymbolWithQualifiedName owner;
            boolean staticContext;
            OCFunctionDefinition method = (OCFunctionDefinition)PsiTreeUtil.getContextOfType((PsiElement)this, (boolean)false, (Class[])new Class[]{OCFunctionDefinition.class});
            OCFunctionSymbol methodSymbol = method != null ? method.getSymbol() : null;
            boolean bl = staticContext = methodSymbol != null && methodSymbol.resolveIsStatic();
            if (parentSymbol == null) {
                varContext.addSymbolContext(new OCSymbolContext(this, OCSymbolKind.GLOBAL_VARIABLE, null));
                varContext.addSymbolContext(new OCSymbolContext(this, OCSymbolKind.GLOBAL_VARIABLE_PREDECLARATION, null));
                if (qualifier == null && parent instanceof OCExpression && !OCCodeInsightUtil.isLValue((OCExpression)parent)) {
                    varContext.addSymbolContext(new OCSymbolContext(this, OCSymbolKind.MACRO, null));
                }
                owner = methodSymbol != null ? methodSymbol.getResolvedOwner() : null;
                varContext.addSymbolContext(new OCSymbolContext.StructMemberContext(this, OCSymbolKind.STRUCT_FIELD, staticContext, owner));
                varContext.addSymbolContext(new OCSymbolContext.StructMemberContext(this, OCSymbolKind.FUNCTION_PREDECLARATION, staticContext, owner));
                varContext.addSymbolContext(new OCSymbolContext.StructMemberContext(this, OCSymbolKind.FUNCTION_DECLARATION, staticContext, owner));
                if (!staticContext) {
                    varContext.addSymbolContext(new OCSymbolContext.StructMemberContext(this, OCSymbolKind.CPP_CONSTRUCTOR_PREDECLARATION, false, owner));
                    varContext.addSymbolContext(new OCSymbolContext.StructMemberContext(this, OCSymbolKind.CPP_CONSTRUCTOR_DECLARATION, false, owner));
                }
                if (objc && parent instanceof OCTypeElement && parent.getParent() instanceof OCTemplateArgumentList) {
                    varContext.addSymbolContext(new OCSymbolContext(OCSymbolKind.PROTOCOL));
                }
            } else if (parentSymbol.getKind().isType()) {
                if (!staticContext && methodSymbol != null) {
                    owner = methodSymbol.getResolvedOwner();
                    if (parentSymbol instanceof OCStructSymbol && owner instanceof OCStructSymbol) {
                        if (context == null) {
                            context = new OCResolveContext(this.getContainingOCFile());
                        }
                        staticContext = !OCStructType.isSubstructOf((OCStructSymbol)parentSymbol, (OCStructSymbol)owner, context);
                    } else {
                        staticContext = true;
                    }
                }
                varContext.addSymbolContext(new OCSymbolContext.StructMemberContext(this, OCSymbolKind.STRUCT_FIELD, staticContext, parentSymbol));
                varContext.addSymbolContext(new OCSymbolContext.StructMemberContext(this, OCSymbolKind.FUNCTION_PREDECLARATION, staticContext, parentSymbol));
                varContext.addSymbolContext(new OCSymbolContext.StructMemberContext(this, OCSymbolKind.FUNCTION_DECLARATION, staticContext, parentSymbol));
                if (!staticContext) {
                    varContext.addSymbolContext(new OCSymbolContext.StructMemberContext(this, OCSymbolKind.CPP_CONSTRUCTOR_PREDECLARATION, false, parentSymbol));
                    varContext.addSymbolContext(new OCSymbolContext.StructMemberContext(this, OCSymbolKind.CPP_CONSTRUCTOR_DECLARATION, false, parentSymbol));
                }
            }
        }
        varContext.addSymbolContext(new OCSymbolContext(this, OCSymbolKind.BUILTIN_SYMBOL, parentSymbol));
        if (cpp) {
            varContext.addSymbolContext(new OCSymbolContext(this, OCSymbolKind.TEMPLATE_VALUE_PARAMETER, parentSymbol));
            varContext.addSymbolContext(new OCSymbolContext(this, OCSymbolKind.SYMBOL_USING_SYMBOL, parentSymbol));
        }
        if (qualifier == null) {
            if (scope instanceof OCCallable) {
                varContext.addSymbolContext(new OCSymbolContext(this, OCSymbolKind.LOCAL_VARIABLE, null));
                varContext.addSymbolContext(new OCSymbolContext(this, OCSymbolKind.CATCH_EXCEPTION_VARIABLE, null));
            }
            if (classSymbol != null) {
                varContext.addSymbolContext(new OCSymbolContext(this, OCSymbolKind.INSTANCE_VARIABLE, ivarsParent));
            }
            if (scope instanceof OCCallable || scope instanceof OCParameterList || scope instanceof OCConstructorFieldInitializer) {
                OCCallable callable = (OCCallable)PsiTreeUtil.getParentOfType((PsiElement)scope, OCCallable.class, (boolean)false);
                varContext.addSymbolContext(new OCSymbolContext(this, OCSymbolKind.PARAMETER, callable != null ? callable.getSymbol() : null));
            }
        }
        OCSymbol enumParentSymbol = parentSymbol;
        if (parent instanceof OCReferenceExpression && parent.getParent() instanceof OCCaseStatement) {
            OCType type;
            OCSwitchStatement switchStatement = (OCSwitchStatement)PsiTreeUtil.getParentOfType((PsiElement)parent, OCSwitchStatement.class);
            OCDeclarationOrExpression expression = switchStatement != null ? switchStatement.getExpression() : null;
            OCType oCType = type = expression != null ? expression.getResolvedType() : null;
            if (type instanceof OCStructType && ((OCStructType)type).getKind() == OCSymbolKind.ENUM) {
                enumParentSymbol = ((OCStructType)type).getSymbol();
            }
        }
        varContext.addSymbolContext(new OCSymbolContext(this, OCSymbolKind.ENUM_CONST, enumParentSymbol));
        if (PsiTreeUtil.skipParentsOfType((PsiElement)parent, (Class[])new Class[]{OCReferenceExpression.class, OCParenthesizedExpression.class}) instanceof OCSizeofExpression) {
            result = new OCSymbolGroupContext("variable or type", OCSymbolKind.TYPEDEF);
            if (objc) {
                result.addSymbolContext(OCSymbolKind.INTERFACE);
                result.addSymbolContext(OCSymbolKind.IMPLEMENTATION);
                result.addSymbolContext(OCSymbolKind.COMPATIBILITY_ALIAS);
            }
            if (cpp) {
                result.addSymbolContext(OCSymbolKind.STRUCT);
                result.addSymbolContext(OCSymbolKind.ENUM);
                result.addSymbolContext(OCSymbolKind.UNION);
                result.addSymbolContext(OCSymbolKind.TEMPLATE_TYPE_PARAMETER);
                result.addSymbolContext(OCSymbolKind.SYMBOL_USING_SYMBOL);
                result.addSymbolContext(OCSymbolKind.USING_SYMBOL_ALIAS);
            }
            result.addSymbolContexts(varContext.getSymbolContexts());
            return result;
        }
        if (parent instanceof OCReferenceExpression && (parent.getContext() instanceof OCSendMessageExpression || parent.getContext() instanceof OCQualifiedExpression && ((OCQualifiedExpression)parent.getContext()).getQualifyingTokenKind() == OCTokenTypes.DOT)) {
            result = new OCSymbolGroupContext("variable or class", OCSymbolKind.TYPEDEF);
            if (objc) {
                result.addSymbolContext(OCSymbolKind.INTERFACE);
                result.addSymbolContext(OCSymbolKind.IMPLEMENTATION);
                result.addSymbolContext(OCSymbolKind.COMPATIBILITY_ALIAS);
            }
            if (cpp) {
                result.addSymbolContext(OCSymbolKind.USING_SYMBOL_ALIAS);
            }
            result.addSymbolContexts(varContext.getSymbolContexts());
            return result;
        }
        if ((parent instanceof OCTypeElement && parent.getParent().getParent() instanceof OCDeclarationStatement || parent instanceof OCReferenceExpression && parent.getParent() instanceof OCExpressionStatement) && !parent.isPhysical()) {
            varContext.addSymbolContexts(OCSymbolGroupContext.typeContext(languageKind).getSymbolContexts());
            return varContext;
        }
        if (parent instanceof OCReferenceExpression) {
            if (cpp && (parent.getContext() instanceof OCCallExpression || parent.getContext() instanceof OCTemplateArgumentList)) {
                varContext.addSymbolContext(OCSymbolKind.TYPEDEF);
                varContext.addSymbolContext(OCSymbolKind.USING_SYMBOL_ALIAS);
                varContext.addSymbolContext(OCSymbolKind.STRUCT);
                varContext.addSymbolContext(OCSymbolKind.UNION);
                varContext.addSymbolContext(OCSymbolKind.ENUM);
                varContext.addSymbolContext(OCSymbolKind.TEMPLATE_TYPE_PARAMETER);
                varContext.addSymbolContext(OCSymbolKind.SYMBOL_USING_SYMBOL);
                varContext.addSymbolContext(OCSymbolKind.CPP_CONSTRUCTOR_DECLARATION);
                varContext.addSymbolContext(OCSymbolKind.CPP_CONSTRUCTOR_PREDECLARATION);
            }
            return varContext;
        }
        if (parent instanceof OCTypeElement || parent instanceof OCCppBaseClause) {
            PsiElement krFunction;
            OCDeclarator declarator;
            PsiElement parentContext = parent.getContext();
            if (parentContext instanceof OCCppNewExpression) {
                return OCSymbolGroupContext.CONSTRUCTOR_CONTEXT;
            }
            if (parentContext instanceof OCDeclaration && ((OCDeclaration)parentContext).getDeclarators().size() == 0) {
                varContext.addSymbolContexts(OCSymbolGroupContext.typeContext(languageKind).getSymbolContexts());
                return varContext;
            }
            if (parentContext instanceof OCTemplateArgumentList) {
                varContext.addSymbolContexts(OCSymbolGroupContext.typeContext(languageKind).getSymbolContexts());
                return varContext;
            }
            if (parentContext instanceof OCParameterDeclaration && ((OCDeclaration)parentContext).getDeclarators().size() == 1 && (declarator = ((OCDeclaration)parentContext).getDeclarators().get(0)).isEmpty() && (krFunction = PsiTreeUtil.getContextOfType((PsiElement)parentContext, (Class[])new Class[]{OCFunctionDefinition.class})) instanceof OCFunctionDefinition && krFunction.getNode().getElementType() == OCElementTypes.FUNCTION_KR_DEFINITION) {
                return varContext;
            }
            return OCSymbolGroupContext.typeContext(languageKind);
        }
        if (parent instanceof OCCppUsingStatement) {
            varContext.addSymbolContexts(OCSymbolGroupContext.typeContext(languageKind).getSymbolContexts());
            return varContext;
        }
        return null;
    }

    public static OCSymbol getAppropriateToAppendSymbol(OCCppNamespaceQualifier qualifier, @NotNull OCResolveContext context) {
        OCSymbol parentSymbol = null;
        if (qualifier != null) {
            OCSymbolReference.LocalReference ref = OCSymbolReference.getLocalReference(qualifier, OCSymbolReference.SymbolKindFilter.ONLY_NAMESPACE_LIKE);
            PsiElement parent = qualifier.getParent();
            while (parent instanceof OCCppNamespaceQualifier) {
                parent = parent.getParent();
            }
            List<OCSymbol> symbols = ref.resolveToSymbols(true, true, true, context);
            List parentSymbols = ContainerUtil.filter(symbols, (Condition)new Condition<OCSymbol>(){

                public boolean value(OCSymbol symbol) {
                    return OCSymbol.NON_PREDIFINITION_CONDITION.value((Object)symbol) && symbol.getKind().canBeNamespace();
                }
            });
            if (parentSymbols.size() == 0) {
                parentSymbol = null;
            } else if (parentSymbols.size() == 1) {
                parentSymbol = (OCSymbol)parentSymbols.get(0);
            } else {
                for (OCSymbol candidate : parentSymbols) {
                    if (!Comparing.equal((Object)candidate.getContainingOCFile(), (Object)qualifier.getContainingOCFile())) continue;
                    parentSymbol = candidate;
                    break;
                }
                if (parentSymbol == null) {
                    parentSymbol = (OCSymbol)parentSymbols.get(0);
                }
            }
        }
        return parentSymbol;
    }

    @Override
    public OCInstanceVariableSymbol getSymbol() {
        if (!(this.getParent() instanceof OCSynthesizeProperty)) {
            return null;
        }
        return this.getContainingOCFile().findSymbol(this, OCInstanceVariableSymbol.class);
    }

    @NotNull
    public String getCanonicalText() {
        OCStructLike parent;
        String name = OCElementUtil.getIdentifierName(this.findReferenceToken(), false);
        if (this.getParent() instanceof OCStructLike && !(parent = (OCStructLike)this.getParent()).isDeclaration()) {
            return parent.getKind().getNameLowercase() + " " + name;
        }
        return name;
    }

    public OCReferenceElement handleElementRename(String newElementName) throws IncorrectOperationException {
        if (!newElementName.equals(this.getName())) {
            this.setName(newElementName);
            if (PsiTreeUtil.getContextOfType((PsiElement)this, (Class[])new Class[]{OCMacroCall.class}) != null) {
                FileSymbolTablesCache.getInstance(this.getProject()).scheduleReparseFile(this.getContainingOCFile());
            }
        }
        return this.getElement();
    }

    @Override
    public PsiElement bindToSymbol(@NotNull OCSymbol symbol) {
        OCMethod method;
        if (this.getParent() instanceof OCReferenceExpression && ((OCReferenceExpression)this.getParent()).getSelfSuperToken() != null && symbol instanceof OCClassSymbol && ((method = (OCMethod)PsiTreeUtil.getParentOfType((PsiElement)this, OCMethod.class)) == null || method.isInstanceMethod())) {
            return this;
        }
        if (!(symbol instanceof OCSymbolWithQualifiedName)) {
            return this.handleElementRename(symbol.getName());
        }
        OCQualifiedName qualifiedName = ((OCSymbolWithQualifiedName)symbol).getResolvedQualifiedName();
        if (symbol.getKind().isConstructorOrDestructor() && qualifiedName != null) {
            qualifiedName = qualifiedName.getQualifier();
        }
        if (!(qualifiedName != null && OCBindUtil.setShortestPossibleName(qualifiedName, this, (OCSymbolWithQualifiedName)symbol) || symbol.getKind() != OCSymbolKind.TYPEDEF)) {
            String typeName = symbol.getType().getBestNameInContext(this);
            return OCChangeUtil.replaceHandlingMacros(this, OCElementFactory.typeElementFromText(typeName, this));
        }
        return this;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        Object symbol = ((OCSymbolDeclarator)element).getSymbol();
        return symbol != null ? this.bindToSymbol((OCSymbol)symbol) : element;
    }

    public boolean isReferenceTo(PsiElement element) {
        if (!(element instanceof OCSymbolDeclarator)) {
            return false;
        }
        Object symbol = ((OCSymbolDeclarator)element).getSymbol();
        OCSymbol thisSymbol = symbol instanceof OCInstanceVariableSymbol && this.getParent() instanceof OCSynthesizeProperty && ((OCSynthesizeProperty)this.getParent()).getInstanceVariableRef() == null ? this.resolveToSymbol(new OCSymbolGroupContext(new OCSymbolContext(null, OCSymbolKind.INSTANCE_VARIABLE, null))) : this.resolveToSymbol();
        if (symbol instanceof OCMacroSymbol && thisSymbol instanceof OCMacroSymbol && symbol.getName().equals(thisSymbol.getName())) {
            return true;
        }
        return thisSymbol != null && thisSymbol.isSameSymbol((OCSymbol)symbol);
    }

    @NotNull
    public Object[] getVariants() {
        return new Object[0];
    }

    public boolean isSoft() {
        return false;
    }

    public PsiMetaData getMetaData() {
        return new PsiWritableMetaData(){

            public PsiElement getDeclaration() {
                return OCReferenceElementImpl.this;
            }

            public String getName(PsiElement context) {
                return OCReferenceElementImpl.this.getName();
            }

            public String getName() {
                return OCReferenceElementImpl.this.getName();
            }

            public void setName(String name) throws IncorrectOperationException {
                OCReferenceElementImpl.this.handleElementRename(name);
            }

            public void init(PsiElement element) {
                throw new UnsupportedOperationException("Not implemented");
            }

            public Object[] getDependences() {
                throw new UnsupportedOperationException("Not implemented");
            }
        };
    }

    private static class MyResolver
    implements ResolveCache.AbstractResolver<OCReferenceElement, Pair<OCSymbol, Boolean>> {
        private OCResolveContext myContext;

        public MyResolver(@NotNull OCResolveContext context) {
            this.myContext = context;
        }

        @Override
        public Pair<OCSymbol, Boolean> resolve(@NotNull OCReferenceElement element, boolean incompleteCode) {
            OCReferenceElementImpl referenceElement = (OCReferenceElementImpl)element;
            OCSymbol symbol = referenceElement.resolveToSymbol(referenceElement.getSymbolContext(this.myContext), this.myContext, false, false, false);
            if (symbol != null) {
                return new Pair((Object)symbol, (Object)true);
            }
            return new Pair((Object)referenceElement.resolveToSymbol(null, this.myContext, false, false, false), (Object)false);
        }
    }
}

