/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCPunctuatorElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.OCTemplateArgumentList;
import com.jetbrains.cidr.lang.psi.OCTypeArgumentList;
import com.jetbrains.cidr.lang.psi.impl.OCExpressionWithReferenceBase;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.resolve.OCArgumentsList;
import com.jetbrains.cidr.lang.resolve.OCResolveOverloadsUtil;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.resolve.references.OCOperatorReference;
import com.jetbrains.cidr.lang.resolve.references.OCReferenceWithContext;
import com.jetbrains.cidr.lang.search.usages.OCReadWriteAccessDetector;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolGroupContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.OCSymbolReferenceResolver;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCTemplateSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.types.CVQualifiers;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCIdType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCObjectTypeContext;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCTypeGuesser;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.OCVariadicType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.types.visitors.OCSimpleTypeSubstitution;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCCommonProcessors;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCExpectedTypeUtil;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCQualifiedExpressionImpl
extends OCExpressionWithReferenceBase
implements OCQualifiedExpression,
OCExpectedTypeUtil.Expectable {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.cidr.lang.psi.impl.OCQualifiedExpressionImpl");
    private static final Condition<OCSymbol> CAN_BE_STRUCTURE_FIELD = new Condition<OCSymbol>(){

        public boolean value(OCSymbol o) {
            return o.getKind().isExpression();
        }
    };

    public OCQualifiedExpressionImpl(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    @NotNull
    public OCExpression getQualifier() {
        OCExpression qualifier = (OCExpression)this.findChildByType(OCElementTypes.EXPRESSIONS);
        LOG.assertTrue(qualifier != null, (Object)("Qualifier is null in: " + this.getText()));
        return qualifier;
    }

    @Override
    @NotNull
    public OCPunctuatorElementType getQualifyingTokenKind() {
        return (OCPunctuatorElementType)this.getQualifyingToken().getElementType();
    }

    @Override
    @NotNull
    public ASTNode getQualifyingToken() {
        OCElement accessor = this.getQualifyingElement();
        for (ASTNode child = accessor.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            IElementType tt = child.getElementType();
            if (!(tt instanceof OCPunctuatorElementType)) continue;
            return child;
        }
        assert (false);
        return null;
    }

    @Override
    @Nullable
    public OCType getQualifierContainerType(@Nullable Ref<Boolean> outSynthetic) {
        return this.getQualifierContainerType(this.getQualifier().getResolvedType(), null, outSynthetic);
    }

    @Nullable
    private OCType getQualifierContainerType(OCType qualifierType, @Nullable OCPunctuatorElementType forcedQualifyingToken, Ref<Boolean> outSynthetic) {
        if (outSynthetic != null) {
            outSynthetic.set((Object)false);
        }
        if (qualifierType instanceof OCCppReferenceType) {
            qualifierType = ((OCCppReferenceType)qualifierType).getRefType();
        }
        if (qualifierType instanceof OCStructType && qualifierType.isSubclassOfMagic(this)) {
            return new OCMagicType();
        }
        OCPunctuatorElementType qualifyingToken = forcedQualifyingToken;
        if (qualifyingToken == null) {
            qualifyingToken = this.getQualifyingTokenKind();
        }
        if (qualifyingToken == OCTokenTypes.DEREF) {
            Set processedTypes = OCTypeUtils.newTypeSet();
            boolean wasDerefOperator = false;
            while (qualifierType instanceof OCStructType && processedTypes.add(qualifierType)) {
                OCStructType structType = (OCStructType)qualifierType;
                OCFunctionSymbol derefOperator = OCOperatorReference.resolveDerefOperator(this, structType);
                if (derefOperator == null) continue;
                wasDerefOperator = true;
                qualifierType = derefOperator.getEffectiveResolvedType();
            }
            if (qualifierType instanceof OCPointerType) {
                return ((OCPointerType)qualifierType).getRefType().resolve(this.getContainingFile());
            }
            if (wasDerefOperator) {
                return qualifierType;
            }
            if (outSynthetic != null) {
                outSynthetic.set((Object)true);
            }
            return OCUnknownType.INSTANCE;
        }
        return qualifierType;
    }

    @Override
    @NotNull
    public OCElement getQualifyingElement() {
        return (OCElement)this.findChildByType(OCElementTypes.QUALIFIED_EXPRESSION_ACCESSOR);
    }

    @Override
    public boolean canChangeQualifyingToken() {
        return OCElementUtil.getUserVisibleRangeInDocument(this.getQualifyingElement()) != null;
    }

    @Override
    @NotNull
    public List<OCPunctuatorElementType> qualifyingTokensForCompletion() {
        OCType type;
        OCPunctuatorElementType mQTK = this.getQualifyingTokenKind();
        if (this.canChangeQualifyingToken() && (!((type = this.getQualifier().getResolvedType(new OCResolveContext((PsiElement)this.getContainingFile())).getTerminalType()) instanceof OCStructType) || OCOperatorReference.resolveDerefOperator(this, (OCStructType)type) == null)) {
            return ContainerUtil.list((Object[])new OCPunctuatorElementType[]{mQTK, mQTK == OCTokenTypes.DEREF ? OCTokenTypes.DOT : OCTokenTypes.DEREF});
        }
        return Collections.singletonList(mQTK);
    }

    @Override
    @NotNull
    public String getName() {
        return OCElementUtil.getIdentifierName(this.getSelectorElement(), false);
    }

    @Override
    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        OCElementUtil.replaceWithIdentifier(this.getSelectorElement(), name, this);
        return this;
    }

    @Override
    @Nullable
    public PsiElement getSelectorElement() {
        return this.findChildByType(OCTokenTypes.POSSIBLE_CPP_NAMES);
    }

    @Override
    public OCType getExpectedType() {
        OCType expectedType = this.getContext() instanceof OCCallExpression ? OCQualifiedExpressionImpl.getCallExpectedType((OCCallExpression)this.getParent()) : OCExpectedTypeUtil.getExpectedType(this, true);
        if (expectedType == OCUnknownType.INSTANCE) {
            expectedType = OCIdType.pointerToID(this.getProject());
        }
        return expectedType;
    }

    public static OCType getCallExpectedType(OCCallExpression callExpr) {
        OCType returnExpectedType = OCExpectedTypeUtil.getExpectedType(callExpr, true);
        ArrayList<OCType> argumentTypes = new ArrayList<OCType>();
        if (returnExpectedType == OCUnknownType.INSTANCE) {
            returnExpectedType = OCVoidType.instance();
        }
        for (OCExpression argument : callExpr.getArguments()) {
            argumentTypes.add(OCExpectedTypeUtil.getExpressionType(argument, true));
        }
        return new OCFunctionType(returnExpectedType, argumentTypes);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public OCSymbolGroupContext getSymbolContext() {
        OCSymbolContext context;
        OCObjectTypeContext qualifierContext = this.getQualifier().getTypeContext();
        boolean shouldBeFunction = this.getParent() instanceof OCCallExpression && this.getContainingOCFile().isCpp();
        OCPunctuatorElementType qualifyingTokenKind = this.getQualifyingTokenKind();
        if (qualifierContext != null) {
            OCClassSymbol classSymbol = qualifierContext.getType().getClassSymbol();
            if (qualifierContext.getStaticMode() == OCObjectTypeContext.StaticMode.STATIC) {
                context = new OCSymbolContext(this, OCSymbolKind.METHOD, classSymbol);
                return new OCSymbolGroupContext(context);
            }
            if (qualifyingTokenKind == OCTokenTypes.DEREF) {
                context = new OCSymbolContext(this, OCSymbolKind.INSTANCE_VARIABLE, classSymbol);
                return new OCSymbolGroupContext(context);
            }
            if (qualifyingTokenKind != OCTokenTypes.DOT) return null;
            final OCSymbolContext context2 = new OCSymbolContext(this, OCSymbolKind.PROPERTY, classSymbol);
            OCSymbolGroupContext groupContext = new OCSymbolGroupContext(context2){

                @Override
                public String getCannotResolveMessagePrefix() {
                    return context2.getCannotResolveMessagePrefix();
                }
            };
            groupContext.addSymbolContext(new OCSymbolContext(this, OCSymbolKind.METHOD, classSymbol));
            return groupContext;
        }
        OCType qualifierType = this.getQualifier().getResolvedType();
        if (qualifyingTokenKind == OCTokenTypes.DOT && qualifierType instanceof OCStructType) {
            context = new OCSymbolContext(this, shouldBeFunction ? OCSymbolKind.FUNCTION_DECLARATION : OCSymbolKind.STRUCT_FIELD, ((OCStructType)qualifierType).getSymbol());
            return new OCSymbolGroupContext(context);
        }
        if (qualifyingTokenKind == OCTokenTypes.DEREF && qualifierType instanceof OCPointerType && ((OCPointerType)qualifierType).getRefType() instanceof OCStructType) {
            context = new OCSymbolContext(this, shouldBeFunction ? OCSymbolKind.FUNCTION_DECLARATION : OCSymbolKind.STRUCT_FIELD, ((OCStructType)((OCPointerType)qualifierType).getRefType()).getSymbol());
            return new OCSymbolGroupContext(context);
        }
        if (!(qualifierType instanceof OCObjectType)) return null;
        context = new OCSymbolContext(this, OCSymbolKind.INSTANCE_VARIABLE, ((OCObjectType)qualifierType).getClassSymbol());
        return new OCSymbolGroupContext(context);
    }

    @Override
    public void accept(@NotNull OCVisitor visitor) {
        visitor.visitQualifiedExpression(this);
    }

    @Nullable
    public PsiElement resolve() {
        OCSymbol symbol = this.resolveToSymbol();
        return symbol != null ? (PsiElement)symbol.locateDefinition() : null;
    }

    @Override
    public boolean processTargets(String name, Processor<OCSymbol> processor2, boolean processStaticMismatched, @Nullable OCPunctuatorElementType forcedQualifyingToken, boolean filterOverloads, boolean ignoreImports, @Nullable Ref<OCType> outQualifierType) {
        OCResolveContext resolveContext = new OCResolveContext(this.getContainingOCFile());
        Object qualifierContext = this.getContainerTypeContext(forcedQualifyingToken, ignoreImports, resolveContext);
        if (outQualifierType != null && qualifierContext instanceof QualifierTypeContext) {
            outQualifierType.set((Object)((QualifierTypeContext)qualifierContext).containerType);
        }
        return this.doProcessTargets(qualifierContext, name, processor2, processStaticMismatched, filterOverloads, false, false, resolveContext, true);
    }

    private boolean doProcessTargets(@Nullable Object qualifierContext, String name, Processor<OCSymbol> processor2, boolean processStaticMismatched, boolean filterOverloads, boolean filterAmbigs, boolean acceptOnlyCompatible, @NotNull OCResolveContext context, boolean resolveSpecializations) {
        if (qualifierContext instanceof OCObjectTypeContext) {
            return this.processObjCMembers((OCObjectTypeContext)qualifierContext, name, processor2, processStaticMismatched);
        }
        if (qualifierContext instanceof QualifierTypeContext) {
            OCType containerType = ((QualifierTypeContext)qualifierContext).containerType;
            if (containerType instanceof OCStructType && ((OCStructType)containerType).getKind() != OCSymbolKind.ENUM) {
                return this.processStructMembers(name, processor2, filterOverloads, context, (QualifierTypeContext)qualifierContext, acceptOnlyCompatible, filterAmbigs, resolveSpecializations);
            }
            if (containerType.isUnknown() || containerType instanceof OCMagicType) {
                processor2.process((Object)new OCDeclaratorSymbol(null, null, 0, null, name, Collections.emptyList(), new OCMagicType(name), OCSymbolKind.TEMPLATE_VALUE_PARAMETER));
            }
        }
        return true;
    }

    private boolean processObjCMembers(OCObjectTypeContext qualifierContext, String name, final Processor<OCSymbol> processor2, boolean processStaticMismatched) {
        ReadWriteAccessDetector.Access access;
        final OCObjectTypeContext objectTypeContext = qualifierContext;
        final boolean isStaticContext = objectTypeContext.getStaticMode() == OCObjectTypeContext.StaticMode.STATIC;
        final boolean isDotAccess = this.getQualifyingTokenKind() == OCTokenTypes.DOT;
        Processor<OCMemberSymbol> membersProcessor = new Processor<OCMemberSymbol>(){

            public boolean process(OCMemberSymbol symbol) {
                if (!OCCompilerHelper.supportsLaterMethodDeclaration() && !OCResolveUtil.isEarlierInCode((OCSymbol)symbol, OCQualifiedExpressionImpl.this) || OCResolveUtil.isDisabledSymbol(symbol, OCQualifiedExpressionImpl.this.getContainingOCFile())) {
                    return true;
                }
                if (isDotAccess && symbol instanceof OCMethodSymbol) {
                    return processor2.process((Object)symbol);
                }
                if (isDotAccess && symbol instanceof OCPropertySymbol && !isStaticContext) {
                    return processor2.process((Object)symbol);
                }
                if (!isDotAccess && symbol instanceof OCInstanceVariableSymbol && !isStaticContext) {
                    return processor2.process((Object)symbol);
                }
                return true;
            }
        };
        OCCommonProcessors.OrderedProcessor<OCMemberSymbol> orderedProcessor = new OCCommonProcessors.OrderedProcessor<OCMemberSymbol>(membersProcessor, new Condition<OCMemberSymbol>(){

            public boolean value(OCMemberSymbol symbol) {
                return symbol instanceof OCPropertySymbol && !((OCPropertySymbol)symbol).isReadonly();
            }
        }, new Condition<OCMemberSymbol>(){

            public boolean value(OCMemberSymbol symbol) {
                return symbol instanceof OCInstanceVariableSymbol && ((OCInstanceVariableSymbol)symbol).getGeneratedFromProperty() == null || symbol instanceof OCMethodSymbol && OCNameSuggester.isObjCSetter(symbol.getName()) && objectTypeContext.getStaticMode().fitsStaticness((OCMethodSymbol)symbol);
            }
        }, new Condition<OCMemberSymbol>(){

            public boolean value(OCMemberSymbol symbol) {
                return symbol instanceof OCPropertySymbol;
            }
        }, new Condition<OCMemberSymbol>(){

            public boolean value(OCMemberSymbol symbol) {
                return !(symbol instanceof OCMethodSymbol) || objectTypeContext.getStaticMode().fitsStaticness((OCMethodSymbol)symbol);
            }
        }, processStaticMismatched ? Conditions.alwaysTrue() : Conditions.alwaysFalse());
        objectTypeContext.getType().processMembers(name, OCMemberSymbol.class, orderedProcessor);
        if (name != null && isDotAccess && ((access = new OCReadWriteAccessDetector().getExpressionAccess(this)) == ReadWriteAccessDetector.Access.Write || access == ReadWriteAccessDetector.Access.ReadWrite && !objectTypeContext.getType().processMembers(name, OCMethodSymbol.class, new Processor<OCMethodSymbol>(){

            public boolean process(OCMethodSymbol symbol) {
                return symbol.isStatic();
            }
        }))) {
            objectTypeContext.getType().processMembers(OCQualifiedExpressionImpl.getSetterName(name), OCMethodSymbol.class, orderedProcessor);
        }
        return orderedProcessor.finish();
    }

    @Override
    @NotNull
    public CVQualifiers getCVQualifiers() {
        return this.getCVQualifiers(this.getQualifier().getResolvedType());
    }

    @NotNull
    public CVQualifiers getCVQualifiers(@NotNull OCType qualifierType) {
        CVQualifiers typeQualifiers = qualifierType.getCVQualifiers();
        CVQualifiers typeAndOuterFunctionQualifiers = OCCodeInsightUtil.getCVQualifiers(this.getQualifier(), qualifierType);
        if (this.getQualifyingTokenKind() == OCTokenTypes.DEREF) {
            if (qualifierType instanceof OCCppReferenceType) {
                qualifierType = ((OCCppReferenceType)qualifierType).getRefType();
            }
            if (qualifierType instanceof OCStructType && OCOperatorReference.resolveDerefOperator(this, (OCStructType)qualifierType) != null) {
                return typeQualifiers;
            }
        }
        return typeAndOuterFunctionQualifiers;
    }

    private boolean processStructMembers(String name, Processor<OCSymbol> processor2, boolean filterOverloads, OCResolveContext context, QualifierTypeContext qualifierContext, boolean acceptOnlyCompatible, boolean filterAmbigs, boolean resolveSpecializations) {
        List<OCTypeArgument> typeArguments = OCSymbolReferenceResolver.getTypeArguments(this);
        List<OCSymbol> filtered = OCQualifiedExpressionImpl.getResolvedMembers((OCStructType)qualifierContext.containerType, name, typeArguments, context, resolveSpecializations);
        if (name == null) {
            return ContainerUtil.process(filtered, processor2);
        }
        if (filterOverloads && OCParenthesesUtils.topmostParenthesized(this).getParent() instanceof OCCallExpression) {
            CVQualifiers cvQualifiers = this.getCVQualifiers(qualifierContext.qualifierType);
            OCCallExpression parent = (OCCallExpression)OCParenthesesUtils.topmostParenthesized(this).getParent();
            OCArgumentsList<OCExpression> arguments = OCArgumentsList.getArgumentList(parent.getArguments(), context);
            OCSymbol result = OCResolveOverloadsUtil.resolveOverloads(filtered, arguments, cvQualifiers, context, null, acceptOnlyCompatible, acceptOnlyCompatible, filterAmbigs);
            if (result != null) {
                return processor2.process((Object)result);
            }
        } else {
            return ContainerUtil.process(filtered, processor2);
        }
        return true;
    }

    public static List<OCSymbol> getResolvedMembers(OCStructType qualifierType, String memberName, List<OCTypeArgument> typeArguments, OCResolveContext context, boolean resolveSpecializations) {
        List<OCSymbol> filtered;
        OCSymbolReference.UsingAndTypedefSymbolsResolver usingsProcessor = new OCSymbolReference.UsingAndTypedefSymbolsResolver(false, true, false, null, context);
        qualifierType.processMembers(memberName, usingsProcessor, context);
        if (StringUtil.isNotEmpty((String)memberName) && memberName.charAt(0) == '~') {
            filtered = usingsProcessor.getAnswer();
            if (filtered.isEmpty()) {
                filtered = Collections.singletonList(qualifierType.getSymbol());
            }
        } else {
            filtered = ContainerUtil.filter(usingsProcessor.getAnswer(), CAN_BE_STRUCTURE_FIELD);
        }
        if (resolveSpecializations && typeArguments != null) {
            filtered = new ArrayList<OCTemplateSymbol>(OCSimpleTypeSubstitution.resolveTemplateSpecialization(ContainerUtil.findAll(filtered, OCTemplateSymbol.class), typeArguments, context));
        }
        return filtered;
    }

    @Nullable
    private Object getContainerTypeContext(@Nullable OCPunctuatorElementType forcedQualifyingToken, boolean ignoreImports, @NotNull OCResolveContext context) {
        OCType qualifierType;
        OCFile containingOCFile = this.getContainingOCFile();
        OCExpression qualifier = OCParenthesesUtils.diveIntoParentheses(this.getQualifier());
        if (qualifier == null) {
            return null;
        }
        OCType qualifierUnresolvedType = qualifier.getType(context);
        OCType oCType = qualifierType = ignoreImports ? qualifierUnresolvedType.resolve(containingOCFile, true) : qualifierUnresolvedType.resolve(context);
        if (qualifier instanceof OCSendMessageExpression && OCTypeGuesser.isOfficialNamingConvention(((OCSendMessageExpression)qualifier).getMessageSelector())) {
            qualifierType = qualifierType.getGuessedType();
        }
        if (qualifier instanceof OCQualifiedExpression && OCTypeGuesser.isOfficialNamingConvention(((OCQualifiedExpression)qualifier).getName())) {
            qualifierType = qualifierType.getGuessedType();
        }
        boolean treatIDAsNSObject = forcedQualifyingToken == OCTokenTypes.DEREF;
        OCObjectTypeContext typeContext = qualifier.getTypeContext(qualifier, qualifierType, qualifierUnresolvedType, treatIDAsNSObject, ignoreImports);
        return typeContext != null ? typeContext : new QualifierTypeContext(qualifierType, this.getQualifierContainerType(qualifierType, forcedQualifyingToken, null));
    }

    private static String getSetterName(String getterName) {
        return "set" + StringUtil.capitalize((String)getterName) + ":";
    }

    @Override
    @Nullable
    public OCSymbol resolveToSymbol() {
        return this.resolveToSymbol(new OCResolveContext(this), true, false, false);
    }

    @Override
    @Nullable
    public OCSymbol resolveToSymbol(@NotNull OCResolveContext context, boolean filterOverloads, boolean filterAmbigs, boolean acceptOnlyCompatible) {
        CommonProcessors.FindFirstProcessor collector = new CommonProcessors.FindFirstProcessor();
        this.doProcessTargets(this.getContainerTypeContext(null, false, context), this.getName(), (Processor<OCSymbol>)collector, true, filterOverloads, filterAmbigs, acceptOnlyCompatible, context, true);
        return (OCSymbol)collector.getFoundValue();
    }

    @Override
    @NotNull
    public Collection<OCSymbol> resolveToOverloadsSymbols() {
        return this.resolveToOverloadsSymbols(true);
    }

    @Override
    @NotNull
    public Collection<OCSymbol> resolveTemplateDeclarations() {
        return this.resolveToOverloadsSymbols(false);
    }

    @NotNull
    private Collection<OCSymbol> resolveToOverloadsSymbols(boolean resolveSpecializations) {
        CommonProcessors.CollectProcessor collector = new CommonProcessors.CollectProcessor();
        OCResolveContext resolveContext = new OCResolveContext(this.getContainingOCFile());
        Object qualifierContext = this.getContainerTypeContext(null, false, resolveContext);
        this.doProcessTargets(qualifierContext, this.getName(), (Processor<OCSymbol>)collector, true, false, false, false, resolveContext, resolveSpecializations);
        return collector.getResults();
    }

    @Nullable
    protected PsiReference createReference() {
        return new OCReferenceWithContext(){

            public PsiElement getElement() {
                return OCQualifiedExpressionImpl.this;
            }

            public TextRange getRangeInElement() {
                PsiElement child = OCQualifiedExpressionImpl.this.getSelectorElement();
                if (child != null) {
                    int startOffset = child.getStartOffsetInParent();
                    int length = child.getTextLength();
                    if (OCElementUtil.getElementType(child) == OCTokenTypes.OPERATOR_CPP_KEYWORD) {
                        return TextRange.create((int)startOffset, (int)OCQualifiedExpressionImpl.this.getTextLength());
                    }
                    PsiElement prevSibling = PsiTreeUtil.skipSiblingsBackward((PsiElement)child, (Class[])new Class[]{PsiWhiteSpace.class});
                    if (prevSibling != null && "~".equals(prevSibling.getText())) {
                        return TextRange.create((int)prevSibling.getStartOffsetInParent(), (int)(startOffset + length));
                    }
                    return TextRange.from((int)startOffset, (int)length);
                }
                return TextRange.EMPTY_RANGE;
            }

            public PsiElement resolve() {
                return OCQualifiedExpressionImpl.this.resolve();
            }

            @NotNull
            public String getCanonicalText() {
                return OCQualifiedExpressionImpl.this.getName();
            }

            public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
                return OCQualifiedExpressionImpl.this.setName(newElementName);
            }

            @Override
            public PsiElement bindToSymbol(@NotNull OCSymbol symbol) {
                String newName = symbol.getName();
                String getterFromSetter = OCNameSuggester.getObjCGetterFromSetter(newName);
                if (getterFromSetter != null) {
                    this.handleElementRename(getterFromSetter);
                } else {
                    this.handleElementRename(newName);
                }
                return this.getElement();
            }

            public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
                Object symbol = ((OCSymbolDeclarator)element).getSymbol();
                return symbol != null ? this.bindToSymbol((OCSymbol)symbol) : element;
            }

            public boolean isReferenceTo(PsiElement element) {
                if (!(element instanceof OCSymbolDeclarator)) {
                    return false;
                }
                Object symbol = ((OCSymbolDeclarator)element).getSymbol();
                OCSymbol thisSymbol = this.resolveToSymbol();
                if (Comparing.equal((Object)thisSymbol, symbol)) {
                    return true;
                }
                if (symbol instanceof OCMethodSymbol && thisSymbol instanceof OCPropertySymbol) {
                    ReadWriteAccessDetector.Access access = new OCReadWriteAccessDetector().getExpressionAccess(OCQualifiedExpressionImpl.this);
                    if (access == ReadWriteAccessDetector.Access.Read && OCNameSuggester.isObjCSetter(symbol.getName())) {
                        return false;
                    }
                    if (access == ReadWriteAccessDetector.Access.Write && OCNameSuggester.isObjCGetter(symbol.getName())) {
                        return false;
                    }
                    if ((symbol = symbol.getAssociatedSymbol()) != null) {
                        symbol = ((OCMethodSymbol)symbol).getGeneratedFromProperty();
                    }
                    return thisSymbol == symbol;
                }
                if (symbol instanceof OCPropertySymbol && thisSymbol instanceof OCMethodSymbol) {
                    if (symbol.equals(((OCMethodSymbol)thisSymbol).getGeneratedFromProperty())) {
                        return true;
                    }
                    return (thisSymbol = thisSymbol.getAssociatedSymbol()) != null && ((OCMethodSymbol)thisSymbol).getGeneratedFromProperty() == symbol;
                }
                return thisSymbol != null && thisSymbol.isSameSymbol((OCSymbol)symbol);
            }

            @NotNull
            public Object[] getVariants() {
                return new Object[0];
            }

            public boolean isSoft() {
                return false;
            }

            @Override
            public OCSymbol resolveToSymbol() {
                return OCQualifiedExpressionImpl.this.resolveToSymbol();
            }

            @Nullable
            public OCSymbol resolveToSymbol(@NotNull OCResolveContext context) {
                return OCQualifiedExpressionImpl.this.resolveToSymbol(context, true, false, false);
            }
        };
    }

    @Override
    @NotNull
    public OCType getType(@NotNull OCResolveContext context) {
        final Object qualifierContext = this.getContainerTypeContext(null, false, context);
        CommonProcessors.FindFirstProcessor collector = new CommonProcessors.FindFirstProcessor();
        OCCommonProcessors.OrderedProcessor<OCSymbol> orderedProcessor = new OCCommonProcessors.OrderedProcessor<OCSymbol>((Processor<OCSymbol>)collector, (Condition<T>[])new Condition[]{new Condition<OCSymbol>(){

            public boolean value(OCSymbol symbol) {
                return symbol instanceof OCMethodSymbol && OCNameSuggester.isObjCGetter(symbol.getName()) && qualifierContext instanceof OCObjectTypeContext && ((OCObjectTypeContext)qualifierContext).getStaticMode() == OCObjectTypeContext.StaticMode.STATIC == ((OCMethodSymbol)symbol).isStatic();
            }
        }, OCSymbol.NON_FANTOM_SYMBOL_CONDITION, Conditions.alwaysTrue()});
        this.doProcessTargets(qualifierContext, this.getName(), orderedProcessor, true, true, false, false, context, true);
        orderedProcessor.finish();
        OCSymbol symbol = (OCSymbol)collector.getFoundValue();
        if (symbol != null) {
            if (symbol instanceof OCMethodSymbol) {
                if (OCNameSuggester.isObjCGetter(symbol.getName())) {
                    OCType type;
                    if (qualifierContext instanceof OCObjectTypeContext) {
                        type = ((OCMethodSymbol)symbol).getReturnType(((OCObjectTypeContext)qualifierContext).getType()).resolve(context);
                        OCType guessedType = OCTypeGuesser.getMethodGuessedReturnType((OCMethodSymbol)symbol, (OCObjectTypeContext)qualifierContext, null, this);
                        if (guessedType != null) {
                            return type.cloneWithGuessedType(guessedType);
                        }
                    } else {
                        type = ((OCMethodSymbol)symbol).getReturnType().resolve(context);
                    }
                    return type;
                }
                if (OCNameSuggester.isObjCSetter(symbol.getName())) {
                    List<OCMethodSymbol.SelectorPartSymbol> selectors = ((OCMethodSymbol)symbol).getSelectors();
                    OCDeclaratorSymbol parameter = selectors != null && selectors.size() == 1 ? selectors.get(0).getParameter() : null;
                    return parameter != null ? parameter.getType() : OCUnknownType.INSTANCE;
                }
                return OCVoidType.instance();
            }
            if (symbol instanceof OCStructSymbol) {
                return new OCFunctionType(OCVoidType.instance(), Collections.emptyList());
            }
            OCType type = symbol.getType();
            return type instanceof OCVariadicType ? ((OCVariadicType)type).getUnderlyingType() : type;
        }
        if (qualifierContext instanceof QualifierTypeContext && ((QualifierTypeContext)qualifierContext).qualifierType instanceof OCMagicType) {
            return new OCMagicType(this.getName());
        }
        return OCUnknownType.INSTANCE;
    }

    @Override
    public OCTypeArgumentList getTemplateArgumentList() {
        return (OCTemplateArgumentList)this.findChildByType(OCElementTypes.TEMPLATE_ARGUMENT_LIST);
    }

    private static class QualifierTypeContext {
        OCType qualifierType;
        OCType containerType;

        public QualifierTypeContext(OCType qualifierType, OCType containerType) {
            this.qualifierType = qualifierType;
            this.containerType = containerType;
        }
    }
}

