/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCCompoundInitializer;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCQualifiedDesignator;
import com.jetbrains.cidr.lang.psi.OCReference;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.impl.OCElementWithReferenceBase;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCQualifiedDesignatorImpl
extends OCElementWithReferenceBase
implements OCQualifiedDesignator {
    public OCQualifiedDesignatorImpl(@NotNull ASTNode node) {
        super(node);
    }

    @Nullable
    public OCQualifiedDesignatorImpl getQualifier() {
        return (OCQualifiedDesignatorImpl)this.findChildByType(OCElementTypes.QUALIFIED_DESIGNATOR);
    }

    @Nullable
    protected PsiElement getNameIdentifier() {
        ASTNode astNode = this.getNode().findChildByType((IElementType)OCTokenTypes.IDENTIFIER);
        return astNode != null ? astNode.getPsi() : null;
    }

    @Override
    @Nullable
    public String getName() {
        PsiElement ident = this.getNameIdentifier();
        return ident != null ? ident.getText() : null;
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        OCElementUtil.replaceWithIdentifier(this.getNameIdentifier(), name, this);
        return this;
    }

    @Override
    @Nullable
    public OCExpression getArrayStartIndexer() {
        ASTNode index = this.getNode().findChildByType(OCElementTypes.EXPRESSIONS);
        return index != null ? (OCExpression)index.getPsi() : null;
    }

    @Override
    public OCExpression getArrayStopIndexer() {
        PsiElement nextSibling;
        OCExpression arrayStartIndexer = this.getArrayStartIndexer();
        if (arrayStartIndexer != null && (nextSibling = arrayStartIndexer.getNextSibling()) != null) {
            ASTNode index = this.getNode().findChildByType(OCElementTypes.EXPRESSIONS, nextSibling.getNode());
            return index != null ? (OCExpression)index.getPsi() : null;
        }
        return null;
    }

    @Nullable
    public PsiElement resolve() {
        OCSymbol symbol = this.resolveToSymbol();
        return symbol != null ? (PsiElement)symbol.locateDefinition() : null;
    }

    @Override
    @Nullable
    public OCSymbol resolveToSymbol() {
        OCType structType = this.getParentType();
        if (structType instanceof OCStructType && this.getName() != null) {
            CommonProcessors.FindFirstProcessor collector = new CommonProcessors.FindFirstProcessor();
            OCResolveContext context = new OCResolveContext(this.getContainingOCFile());
            ((OCStructType)structType).processFields(this.getName(), (Processor<? super OCDeclaratorSymbol>)collector, context);
            return (OCSymbol)collector.getFoundValue();
        }
        return null;
    }

    @Override
    @Nullable
    public OCType getParentType() {
        OCQualifiedDesignatorImpl qualifier = this.getQualifier();
        OCType type = null;
        if (qualifier != null) {
            OCType qualifierParentType = qualifier.getParentType();
            if (qualifierParentType instanceof OCStructType && qualifier.getName() != null) {
                CommonProcessors.FindFirstProcessor collector = new CommonProcessors.FindFirstProcessor();
                OCResolveContext context = new OCResolveContext(this.getContainingOCFile());
                ((OCStructType)qualifierParentType).processFields(qualifier.getName(), (Processor<? super OCDeclaratorSymbol>)collector, context);
                if (collector.isFound()) {
                    type = ((OCSymbol)collector.getFoundValue()).getType();
                }
            } else if (qualifierParentType instanceof OCArrayType && qualifier.getArrayStartIndexer() != null) {
                type = ((OCArrayType)qualifierParentType).getRefType();
            }
        } else {
            OCCompoundInitializer compoundInitializer = (OCCompoundInitializer)PsiTreeUtil.getParentOfType((PsiElement)this, OCCompoundInitializer.class);
            type = compoundInitializer.inferType();
        }
        return type != null ? type.resolve(this.getContainingFile()) : null;
    }

    @Nullable
    protected PsiReference createReference() {
        if (this.getName() == null) {
            return null;
        }
        return new OCReference(){

            public PsiElement getElement() {
                return OCQualifiedDesignatorImpl.this;
            }

            public TextRange getRangeInElement() {
                return OCElementUtil.getRangeInParent(OCQualifiedDesignatorImpl.this.getNode().getLastChildNode());
            }

            public PsiElement resolve() {
                return OCQualifiedDesignatorImpl.this.resolve();
            }

            @NotNull
            public String getCanonicalText() {
                return OCQualifiedDesignatorImpl.this.getName();
            }

            public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
                return OCQualifiedDesignatorImpl.this.setName(newElementName);
            }

            @Override
            public PsiElement bindToSymbol(@NotNull OCSymbol symbol) {
                return this.getElement();
            }

            public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
                Object symbol = ((OCSymbolDeclarator)element).getSymbol();
                return symbol != null ? this.bindToSymbol((OCSymbol)symbol) : element;
            }

            public boolean isReferenceTo(PsiElement element) {
                if (!(element instanceof OCSymbolDeclarator)) {
                    return false;
                }
                Object symbol = ((OCSymbolDeclarator)element).getSymbol();
                OCSymbol thisSymbol = this.resolveToSymbol();
                return Comparing.equal((Object)thisSymbol, symbol);
            }

            @NotNull
            public Object[] getVariants() {
                return new Object[0];
            }

            public boolean isSoft() {
                return false;
            }

            @Override
            public OCSymbol resolveToSymbol() {
                return OCQualifiedDesignatorImpl.this.resolveToSymbol();
            }
        };
    }

    @Override
    public void accept(@NotNull OCVisitor visitor) {
        visitor.visitQualifiedDesignator(this);
    }
}

