/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.psi.OCPragma;
import com.jetbrains.cidr.lang.psi.impl.OCDirectiveImpl;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCPragmaImpl
extends OCDirectiveImpl
implements OCPragma {
    public OCPragmaImpl(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    @NotNull
    public String getContent() {
        PsiElement pragma = this.getHeaderToken();
        PsiElement content = pragma.getNextSibling();
        if (content != null) {
            return content.getText();
        }
        return "";
    }

    @Override
    @Nullable
    public Pair<String, Boolean> getMarkContent() {
        String pragmaText = this.getContent().trim();
        if (pragmaText.length() > 4 && pragmaText.substring(0, 4).equalsIgnoreCase("mark")) {
            String content = pragmaText.substring(5).trim();
            boolean hasSeparator = false;
            if (content.startsWith("-") && (content.length() == 1 || Character.isWhitespace(content.charAt(1)))) {
                hasSeparator = true;
                content = content.substring(1).trim();
            }
            hasSeparator = hasSeparator || content.isEmpty();
            return Pair.create((Object)content, (Object)hasSeparator);
        }
        return null;
    }

    @Override
    public void accept(@NotNull OCVisitor visitor) {
        visitor.visitPragma(this);
    }
}

