/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCParameterDeclaration;
import com.jetbrains.cidr.lang.psi.OCParameterList;
import com.jetbrains.cidr.lang.psi.impl.OCElementBase;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCParameterListImpl
extends OCElementBase
implements OCParameterList {
    public OCParameterListImpl(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    @NotNull
    public List<OCParameterDeclaration> getParameterDeclarations() {
        return this.findChildrenByType(OCElementTypes.PARAMETER_DECLARATION);
    }

    @Override
    @NotNull
    public List<OCDeclarator> getParameters() {
        ArrayList<OCDeclarator> result = new ArrayList<OCDeclarator>();
        for (OCParameterDeclaration declaration : this.getParameterDeclarations()) {
            OCDeclarator declarator = declaration.getDeclarator();
            if (declarator == null) continue;
            result.add(declarator);
        }
        return result;
    }

    @Override
    @Nullable
    public ASTNode getLParenth() {
        return this.getNode().findChildByType((IElementType)OCTokenTypes.LPAR);
    }

    @Override
    @Nullable
    public ASTNode getRParenth() {
        return this.getNode().findChildByType((IElementType)OCTokenTypes.RPAR);
    }

    @Override
    public void accept(@NotNull OCVisitor visitor) {
        visitor.visitParameterList(this);
    }
}

