/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.AbstractElementManipulator;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import org.jetbrains.annotations.NotNull;

public class OCLiteralExpressionManipulator
extends AbstractElementManipulator<OCLiteralExpression> {
    public OCLiteralExpression handleContentChange(@NotNull OCLiteralExpression element, @NotNull TextRange range, String newContent) throws IncorrectOperationException {
        ASTNode literal = element.getNode().findChildByType((IElementType)OCTokenTypes.STRING_LITERAL);
        if (literal == null) {
            throw new IncorrectOperationException("Content change of non-string literals is not supported");
        }
        String literalText = literal.getText();
        element.getNode().addLeaf((IElementType)OCTokenTypes.STRING_LITERAL, (CharSequence)(literalText.substring(0, range.getStartOffset() - 1) + newContent + literalText.substring(range.getEndOffset() - 1)), null);
        element.getNode().removeChild(literal);
        return element;
    }

    @NotNull
    public TextRange getRangeInElement(@NotNull OCLiteralExpression element) {
        int endOffset;
        int offset;
        int startOffset;
        ASTNode literal = element.getNode().findChildByType((IElementType)OCTokenTypes.STRING_LITERAL);
        if (literal != null && (startOffset = (offset = literal.getPsi().getStartOffsetInParent()) + 1) <= (endOffset = offset + literal.getTextLength() - 1)) {
            return new TextRange(startOffset, endOffset);
        }
        return element.getTextRange();
    }
}

