/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ContributedReferenceHost;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCMacroRange;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.psi.impl.OCExpressionWithReferenceBase;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCRealType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.util.OCCharLiteral;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCFloatLiteral;
import com.jetbrains.cidr.lang.util.OCIntegerLiteral;
import com.jetbrains.cidr.lang.util.OCLiteral;
import com.jetbrains.cidr.lang.util.OCStringLiteral;
import com.jetbrains.cidr.lang.util.OCStringLiteralUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCLiteralExpressionImpl
extends OCExpressionWithReferenceBase
implements OCLiteralExpression,
ContributedReferenceHost {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.cidr.lang.psi.impl.OCLiteralExpressionImpl");

    @NotNull
    private String getLiteralText(@NotNull LiteralPresentation presentation) {
        ASTNode firstChild = this.getNode().getFirstChildNode();
        IElementType tt = firstChild.getElementType();
        OCLiteral literal = OCLiteralExpressionImpl.getLiteral(tt, this.getRawLiteralTextElements());
        if (literal instanceof OCStringLiteral) {
            OCStringLiteral stringLiteral = (OCStringLiteral)literal;
            return stringLiteral.getContents(presentation == LiteralPresentation.TEXT_ESCAPED);
        }
        if (literal instanceof OCCharLiteral) {
            OCCharLiteral charLiteral = (OCCharLiteral)literal;
            return charLiteral.getContents(presentation == LiteralPresentation.TEXT_ESCAPED);
        }
        return this.getRawLiteralText();
    }

    @Nullable
    private static OCLiteral getLiteral(@NotNull IElementType tt, @NotNull List<String> childTextElements) {
        if (tt == OCTokenTypes.AT || OCTokenTypes.ALL_STRINGS.contains(tt)) {
            if (childTextElements.isEmpty()) {
                return OCStringLiteral.BAD_LITERAL;
            }
            if (childTextElements.size() == 1) {
                return OCStringLiteralUtil.parseStringLiteral(childTextElements.get(0));
            }
            int elementsSize = childTextElements.size();
            OCStringLiteral[] stringLiterals = new OCStringLiteral[elementsSize];
            for (int i = 0; i < elementsSize; ++i) {
                stringLiterals[i] = OCStringLiteralUtil.parseStringLiteral(childTextElements.get(i));
            }
            return OCStringLiteralUtil.concatStrings(stringLiterals);
        }
        String childText = StringUtil.join(childTextElements, (String)"");
        if (tt == OCTokenTypes.CHARACTER_LITERAL) {
            return OCStringLiteralUtil.parseCharLiteral(childText);
        }
        if (tt == OCTokenTypes.INTEGER_LITERAL) {
            return new OCIntegerLiteral(childText);
        }
        if (tt == OCTokenTypes.FLOAT_LITERAL) {
            return new OCFloatLiteral(childText);
        }
        return null;
    }

    public OCLiteralExpressionImpl(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    public void accept(@NotNull OCVisitor visitor) {
        visitor.visitLiteralExpression(this);
    }

    @Override
    @NotNull
    public String getUnescapedLiteralText() {
        return this.getLiteralText(LiteralPresentation.TEXT_UNESCAPED);
    }

    @Override
    @NotNull
    public String getEscapedLiteralText() {
        return this.getLiteralText(LiteralPresentation.TEXT_ESCAPED);
    }

    @Override
    @NotNull
    public String getRawLiteralText() {
        return StringUtil.join(this.getRawLiteralTextElements(), (String)"");
    }

    @NotNull
    public List<ASTNode> findStringLiteralNodes() {
        ArrayList<ASTNode> nodes = new ArrayList<ASTNode>();
        for (ASTNode child = this.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (!OCTokenTypes.ALL_STRINGS.contains(child.getElementType())) continue;
            nodes.add(child);
        }
        return nodes;
    }

    @NotNull
    private List<String> getRawLiteralTextElements() {
        ASTNode firstChild = this.getNode().getFirstChildNode();
        IElementType tt = firstChild.getElementType();
        if (tt == OCTokenTypes.AT || OCTokenTypes.ALL_STRINGS.contains(tt)) {
            return ContainerUtil.map(this.findStringLiteralNodes(), (Function)new Function<ASTNode, String>(){

                public String fun(ASTNode node) {
                    return node.getText();
                }
            });
        }
        return Collections.singletonList(firstChild.getText());
    }

    @Override
    @NotNull
    public PsiReference[] getReferences() {
        PsiReferenceService service = PsiReferenceService.getService();
        PsiReference[] ret = null;
        if (service != null) {
            ret = service.getContributedReferences((PsiElement)this);
        }
        if (ret == null) {
            ret = PsiReference.EMPTY_ARRAY;
            LOG.assertTrue(ret.length == 0);
        }
        return ret;
    }

    @Nullable
    public PsiReference createReference() {
        PsiReference[] references = this.getReferences();
        return references.length == 1 ? references[0] : null;
    }

    @Override
    @NotNull
    public OCType getType(@NotNull OCResolveContext context) {
        OCMacroRange macroRange;
        IElementType tt = this.getNode().getFirstChildNode().getElementType();
        String literalText = this.getRawLiteralText();
        if (tt == OCTokenTypes.INTEGER_LITERAL && ("0".equals(literalText) || "1".equals(literalText)) && (macroRange = OCElementUtil.getRangeInMacroCall(this)) != null) {
            String macroText = macroRange.getMacroCall().getText();
            if (macroText.equals("TRUE") || macroText.equals("FALSE") || macroText.equals("YES") || macroText.equals("NO")) {
                return OCIntType.BOOL;
            }
            if (macroText.equals("true") || macroText.equals("false")) {
                return OCIntType.BOOL_NATIVE;
            }
        }
        if (tt == OCElementTypes.NS_ARRAY_LITERAL) {
            return OCPointerType.to(OCReferenceType.fromText("NSArray"));
        }
        if (tt == OCElementTypes.NS_DICTIONARY_LITERAL) {
            return OCPointerType.to(OCReferenceType.fromText("NSDictionary"));
        }
        if (this.isNSNumberLiteral()) {
            return OCPointerType.to(OCReferenceType.fromText("NSNumber"));
        }
        if (this.isNSStringLiteral()) {
            return OCPointerType.to(OCReferenceType.fromText("NSString"));
        }
        return OCLiteralExpressionImpl.getLiteralTypeFromTT(tt, this.getContainingFile(), OCLiteralExpressionImpl.getLiteral(tt, this.getRawLiteralTextElements()));
    }

    public static OCType getLiteralType(IElementType tt, String childText, @NotNull PsiFile file2) {
        return OCLiteralExpressionImpl.getLiteralTypeFromTT(tt, file2, OCLiteralExpressionImpl.getLiteral(tt, Collections.singletonList(childText)));
    }

    private static OCType getLiteralTypeFromTT(IElementType tt, @NotNull PsiFile file2, @Nullable OCLiteral literal) {
        if (tt == OCTokenTypes.TRUE_CPP_KEYWORD || tt == OCTokenTypes.FALSE_CPP_KEYWORD) {
            return OCIntType.BOOL_NATIVE;
        }
        if (tt == OCTokenTypes.NULL_CPP_KEYWORD) {
            return OCPointerType.to(OCVoidType.instance());
        }
        if (literal != null) {
            return literal.getType(file2, OCCodeInsightUtil.isInPlainOldC((PsiElement)file2));
        }
        if (tt == OCTokenTypes.WRONG_INTEGER_LITERAL) {
            return OCIntType.INT;
        }
        if (tt == OCTokenTypes.WRONG_FLOAT_LITERAL) {
            return OCRealType.FLOAT;
        }
        if (tt == OCTokenTypes.TEMPLATE_START_MARK) {
            return OCUnknownType.INSTANCE;
        }
        if (tt == OCTokenTypes.FAKE_FALSE || tt == OCTokenTypes.FAKE_TRUE) {
            return OCIntType.INT;
        }
        if (tt == OCTokenTypes.__NULL_KEYWORD) {
            return OCPointerType.to(OCVoidType.instance());
        }
        return OCUnknownType.INSTANCE;
    }

    @Override
    public boolean isNSNumberLiteral() {
        IElementType tt = this.getNode().getFirstChildNode().getElementType();
        if (tt == OCTokenTypes.AT) {
            IElementType type = this.getNode().getLastChildNode().getElementType();
            return type == OCTokenTypes.INTEGER_LITERAL || type == OCTokenTypes.FLOAT_LITERAL || type == OCTokenTypes.CHARACTER_LITERAL;
        }
        return false;
    }

    @Override
    public boolean isNSStringLiteral() {
        IElementType tt = this.getNode().getFirstChildNode().getElementType();
        if (tt == OCTokenTypes.AT) {
            IElementType type = this.getNode().getLastChildNode().getElementType();
            return type == OCTokenTypes.STRING_LITERAL;
        }
        return false;
    }

    @Override
    public boolean isStringLiteral() {
        return !this.findStringLiteralNodes().isEmpty();
    }

    public static enum LiteralPresentation {
        TEXT_ESCAPED,
        TEXT_UNESCAPED;

    }
}

