/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCLambdaExpression;
import com.jetbrains.cidr.lang.psi.OCLambdaIntroducer;
import com.jetbrains.cidr.lang.psi.OCNoexceptSpecifier;
import com.jetbrains.cidr.lang.psi.OCParameterDeclaration;
import com.jetbrains.cidr.lang.psi.OCParameterList;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.psi.impl.OCExpressionBase;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCCallableKind;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolImpl;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCExpectedTypeUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCLambdaExpressionImpl
extends OCExpressionBase
implements OCLambdaExpression {
    public OCLambdaExpressionImpl(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    public OCCallableKind getKind() {
        return OCCallableKind.LAMBDA;
    }

    @Override
    @NotNull
    public OCType getReturnType() {
        OCTypeElement typeElement = this.getReturnTypeElement();
        return typeElement != null ? typeElement.getType() : OCExpectedTypeUtil.getReturnTypeOfLambda(this.getBody());
    }

    public List<OCDeclarator> getParameters() {
        OCParameterList parameterList = this.getParameterList();
        return parameterList != null ? parameterList.getParameters() : null;
    }

    @Override
    @Nullable
    public OCNoexceptSpecifier getNoexceptSpecifier() {
        return (OCNoexceptSpecifier)this.findChildByType(OCElementTypes.CPP_NOEXCEPT_SPECIFIER);
    }

    @Override
    public OCSymbol getSymbol() {
        return new OCLambdaSymbol(this);
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public OCLambdaIntroducer getLambdaIntroducer() {
        return (OCLambdaIntroducer)this.findChildByType(OCElementTypes.CPP_LAMBDA_INTRODUCER);
    }

    @Override
    @NotNull
    public OCType getType(@NotNull OCResolveContext context) {
        OCParameterList params = this.getParameterList();
        ArrayList<OCType> paramTypes = new ArrayList<OCType>();
        ArrayList<String> paramNames = new ArrayList<String>();
        if (params != null) {
            for (OCParameterDeclaration parameterDeclaration : params.getParameterDeclarations()) {
                OCDeclarator paramDeclarator = parameterDeclaration.getDeclarator();
                if (paramDeclarator == null) continue;
                paramTypes.add(paramDeclarator.getType());
                paramNames.add(paramDeclarator.getName());
            }
        }
        return OCPointerType.to(new OCFunctionType(this.getReturnType(), paramTypes, paramNames));
    }

    @Override
    @Nullable
    public OCBlockStatement getBody() {
        return (OCBlockStatement)this.findChildByType(OCElementTypes.BLOCK_STATEMENTS);
    }

    @Override
    public OCTypeElement getReturnTypeElement() {
        return (OCTypeElement)this.findChildByType(OCElementTypes.TYPE_ELEMENT);
    }

    @Override
    public OCParameterList getParameterList() {
        return (OCParameterList)this.findChildByType(OCElementTypes.PARAMETER_LIST);
    }

    @Override
    public void accept(@NotNull OCVisitor visitor) {
        visitor.visitLambdaExpression(this);
    }

    public static class OCLambdaSymbol
    extends OCSymbolImpl {
        public OCLambdaSymbol() {
        }

        public OCLambdaSymbol(OCLambdaExpression expr) {
            super(expr.getProject(), expr.getContainingFile().getVirtualFile(), expr.getTextOffset(), OCLambdaSymbol.calcName(expr), Collections.emptyList());
        }

        private static String calcName(OCLambdaExpression expr) {
            StringBuilder result = new StringBuilder();
            result.append("[");
            OCLambdaIntroducer introducer = expr.getLambdaIntroducer();
            if (introducer.getCaptureDefault() != null) {
                result.append(introducer.getCaptureDefault());
            }
            if (!introducer.getReferencedElements().isEmpty()) {
                result.append("...");
            }
            result.append("]");
            if (expr.getReturnTypeElement() != null) {
                result.append(expr.getReturnTypeElement().getText());
            }
            result.append("{...}");
            return result.toString();
        }

        @Override
        @NotNull
        public OCSymbolKind getKind() {
            return OCSymbolKind.LAMBDA;
        }
    }
}

