/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCDeclarationOrExpression;
import com.jetbrains.cidr.lang.psi.OCIfStatement;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.psi.impl.OCElementBase;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCIfStatementImpl
extends OCElementBase
implements OCIfStatement {
    public OCIfStatementImpl(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    @Nullable
    public OCDeclarationOrExpression getCondition() {
        return (OCDeclarationOrExpression)this.findChildByType(OCElementTypes.DECLARATION_OR_EXPRESSION);
    }

    @Override
    @Nullable
    public OCStatement getThenBranch() {
        for (PsiElement child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            ASTNode node = child.getNode();
            assert (node != null);
            IElementType tt = node.getElementType();
            if (tt == OCTokenTypes.ELSE_KEYWORD) {
                return null;
            }
            if (!(child instanceof OCStatement)) continue;
            return (OCStatement)child;
        }
        return null;
    }

    @Override
    @Nullable
    public OCStatement getElseBranch() {
        boolean elsepassed = false;
        for (PsiElement child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            ASTNode node = child.getNode();
            assert (node != null);
            IElementType tt = node.getElementType();
            if (tt == OCTokenTypes.ELSE_KEYWORD) {
                elsepassed = true;
            }
            if (!elsepassed || !(child instanceof OCStatement)) continue;
            return (OCStatement)child;
        }
        return null;
    }

    @Override
    public void setCondition(OCDeclarationOrExpression newCondition) {
        throw new UnsupportedOperationException("setCondition is not implemented");
    }

    @Override
    public void setElse(OCStatement elseStatement) {
        throw new UnsupportedOperationException("setElse is not implemented");
    }

    @Override
    public void setThen(OCStatement thenStatement) {
        throw new UnsupportedOperationException("setThen is not implemented");
    }

    @Override
    public ASTNode getLParenth() {
        return this.getNode().findChildByType((IElementType)OCTokenTypes.LPAR);
    }

    @Override
    public ASTNode getRParenth() {
        return this.getNode().findChildByType((IElementType)OCTokenTypes.RPAR);
    }

    @Override
    public ASTNode getElseKeyword() {
        return this.getNode().findChildByType((IElementType)OCTokenTypes.ELSE_KEYWORD);
    }

    @Override
    public void accept(@NotNull OCVisitor visitor) {
        visitor.visitIfStatement(this);
    }
}

