/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.impl.OCElementBase;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.types.OCBlockPointerType;
import com.jetbrains.cidr.lang.types.OCIdType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCObjectTypeContext;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCReferenceTypeBuilder;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeResolveVisitor;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCExpressionBase
extends OCElementBase
implements OCExpression {
    public OCExpressionBase(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    @NotNull
    public OCType getType() {
        return this.getType(new OCResolveContext(this));
    }

    @Override
    @NotNull
    public OCType getType(@NotNull OCResolveContext context) {
        return OCUnknownType.INSTANCE;
    }

    @Override
    @NotNull
    public OCType getResolvedType() {
        return this.getResolvedType(new OCResolveContext(this));
    }

    @Override
    @NotNull
    public OCType getResolvedType(@NotNull OCResolveContext context) {
        return this.getType(context).resolve(context);
    }

    @Override
    @NotNull
    public String findBestTypeName(OCType type) {
        String name = type.getBestNameInContext(this);
        String bestAliasName = type.getAliasName();
        String nonAliasName = type.cloneWithAliasName(null).getBestNameInContext(this);
        if (type.isBetterAliasName(type, nonAliasName, name, this)) {
            name = nonAliasName;
        }
        if (bestAliasName == null) {
            bestAliasName = name;
        }
        bestAliasName = this.checkType(type, bestAliasName, this.getResolvedType());
        for (OCExpression expression : this.getDependentExpressions()) {
            String candidateName;
            if (expression == null) continue;
            OCType curType = expression.getResolvedType();
            if (type.isBetterAliasName(curType, candidateName = expression.findBestTypeName(curType), bestAliasName, this)) {
                bestAliasName = candidateName;
            }
            bestAliasName = this.checkType(type, bestAliasName, curType);
        }
        return bestAliasName != type.getAliasName() && bestAliasName != name ? bestAliasName : name;
    }

    private String checkType(OCType type, String bestAliasName, OCType curType) {
        if (curType instanceof OCStructType) {
            for (OCTypeArgument typeArgument : ((OCStructType)curType).getSymbol().getSubstitution().getSubstitutedTypes()) {
                if (!(typeArgument instanceof OCType)) continue;
                String candidateName = ((OCType)typeArgument).getAliasName();
                if (candidateName == null) {
                    candidateName = ((OCType)typeArgument).getBestNameInContext(this);
                }
                if (!type.isBetterAliasName((OCType)typeArgument, candidateName, bestAliasName, this)) continue;
                bestAliasName = candidateName;
            }
        }
        return bestAliasName;
    }

    public static String getBestTypeName(@NotNull OCType contextType, @NotNull OCType targetType, @NotNull PsiElement context) {
        String nameWithoutAlias;
        String bestAliasName = targetType.getBestNameInContext(context);
        if ((targetType = targetType.cloneWithAliasName(null)).isBetterAliasName(targetType, nameWithoutAlias = targetType.getBestNameInContext(context), bestAliasName, context)) {
            bestAliasName = nameWithoutAlias;
        }
        if (contextType instanceof OCStructType) {
            for (OCTypeArgument typeArgument : ((OCStructType)contextType).getSymbol().getSubstitution().getSubstitutedTypes()) {
                if (!(typeArgument instanceof OCType)) continue;
                String candidateName = ((OCType)typeArgument).getBestNameInContext(context);
                String aliasName = ((OCType)typeArgument).getAliasName();
                if (targetType.isBetterAliasName((OCType)typeArgument, candidateName, bestAliasName, context)) {
                    bestAliasName = candidateName;
                }
                if (aliasName == null || !targetType.isBetterAliasName((OCType)typeArgument, aliasName, bestAliasName, context)) continue;
                bestAliasName = aliasName;
            }
        }
        return bestAliasName;
    }

    protected List<OCExpression> getDependentExpressions() {
        return Collections.emptyList();
    }

    @Override
    public OCObjectTypeContext getTypeContext() {
        return this.getTypeContext(false, false);
    }

    @Override
    @Nullable
    public OCObjectTypeContext getTypeContext(boolean treatIDAsNSObject, boolean ignoreImports) {
        OCType guessedType;
        OCFile file2 = this.getContainingOCFile();
        OCType type = this.getType();
        OCType resolvedType = type.resolve(file2, ignoreImports);
        if (ignoreImports) {
            OCTypeResolveVisitor.OCObjectTypeReResolver resolver = new OCTypeResolveVisitor.OCObjectTypeReResolver(file2);
            guessedType = resolvedType.getGuessedType().accept(resolver);
        } else {
            guessedType = resolvedType.getGuessedType();
        }
        return this.getTypeContext(null, guessedType, type, treatIDAsNSObject, ignoreImports);
    }

    @Override
    @Nullable
    public OCObjectTypeContext getTypeContext(OCExpression qualifier, OCType type, OCType unresolvedType, boolean treatIDAsNSObject, boolean ignoreImports) {
        boolean isQualifier = OCParenthesesUtils.topmostParenthesized(this).getParent() instanceof OCQualifiedExpression;
        if (type.isClassType() && qualifier != null) {
            OCObjectType containingType;
            OCClassDeclaration containingClass = (OCClassDeclaration)PsiTreeUtil.getParentOfType((PsiElement)qualifier, OCClassDeclaration.class);
            OCObjectType oCObjectType = containingType = containingClass != null ? containingClass.getType() : null;
            if (containingType != null) {
                return new OCObjectTypeContext(OCObjectTypeContext.StaticMode.STATIC, containingType, type);
            }
        }
        if (!isQualifier && (type.isClassType() || type instanceof OCBlockPointerType) || type.isPointerToID() && ((OCObjectType)type.getTerminalType()).getAllProtocols().isEmpty() && treatIDAsNSObject) {
            OCType nsObjectType;
            OCReferenceTypeBuilder typeBuilder = new OCReferenceTypeBuilder("NSObject");
            if (type.isClassType() && unresolvedType instanceof OCReferenceType) {
                typeBuilder.setProtocolNames(((OCReferenceType)unresolvedType).getProtocolNames());
            }
            if ((nsObjectType = typeBuilder.build().resolve(this.getContainingFile(), ignoreImports)) instanceof OCObjectType) {
                return new OCObjectTypeContext(false, type.isClassType() || type.isPointerToID(), (OCObjectType)nsObjectType, type);
            }
            return null;
        }
        if (type.isPointerToObject()) {
            return new OCObjectTypeContext(false, type.isPointerToID(), (OCObjectType)type.getTerminalType(), type);
        }
        if (type instanceof OCObjectType) {
            return new OCObjectTypeContext(OCObjectTypeContext.StaticMode.STATIC, (OCObjectType)type, type);
        }
        if (type instanceof OCMagicType) {
            return new OCObjectTypeContext(OCObjectTypeContext.StaticMode.NO_MATTER, (OCObjectType)OCIdType.pointerToID(this.getProject()).getRefType(), type);
        }
        return null;
    }
}

