/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.extapi.psi.ASTWrapperPsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.SearchScope;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolOffsetUtil;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCElementBase
extends ASTWrapperPsiElement
implements OCElement {
    public OCElementBase(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    @NotNull
    public Language getLanguage() {
        return OCLanguage.getInstance();
    }

    @Override
    public String toString() {
        return OCElementUtil.getElementDebugName(this);
    }

    @Override
    public OCFile getContainingOCFile() {
        return (OCFile)super.getContainingFile();
    }

    protected Icon getBaseIcon() {
        OCSymbol symbol = this.getElementSymbolIfAny();
        return symbol != null ? symbol.getBaseIcon() : super.getBaseIcon();
    }

    @Nullable
    protected Icon getElementIcon(@Iconable.IconFlags int flags) {
        OCSymbol symbol = this.getElementSymbolIfAny();
        return symbol != null ? symbol.computeFullIcon(this) : super.getElementIcon(flags);
    }

    @Override
    public ItemPresentation getPresentation() {
        OCSymbol symbol = this.getElementSymbolIfAny();
        return symbol != null ? symbol.getPresentation() : super.getPresentation();
    }

    @Nullable
    private OCSymbol getElementSymbolIfAny() {
        return this instanceof OCSymbolDeclarator ? (OCSymbol)((OCSymbolDeclarator)((Object)this)).getSymbol() : null;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor instanceof OCVisitor) {
            this.accept((OCVisitor)visitor);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public void accept(@NotNull OCVisitor visitor) {
        visitor.visitOCElement(this);
    }

    @Override
    @NotNull
    public String getTextWithMacros() {
        return OCElementUtil.getTextWithMacros(this);
    }

    @Override
    @NotNull
    public TextRange getRangeWithMacros() {
        return OCElementUtil.getRangeWithMacros(this);
    }

    @Override
    public boolean isEmpty() {
        return OCElementUtil.isElementEmpty(this);
    }

    @Override
    public PsiReference findReferenceAt(int offset) {
        PsiReference refInMacro = OCElementUtil.findReferenceInMacro(this.findElementAt(offset));
        return refInMacro != null ? refInMacro : super.findReferenceAt(offset);
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        return OCElementUtil.getUseScope(this);
    }

    @Override
    public void deleteChildInternal(@NotNull ASTNode child) {
        OCChangeUtil.delete(child.getPsi());
    }

    @Override
    public long getComplexOffset() {
        return OCSymbolOffsetUtil.getComplexOffset(this);
    }
}

