/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.CommonProcessors;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCCppNamespaceQualifier;
import com.jetbrains.cidr.lang.psi.OCPolyVariantReference;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.OCTemplateArgumentList;
import com.jetbrains.cidr.lang.psi.OCTypeArgumentList;
import com.jetbrains.cidr.lang.psi.impl.OCElementWithReferenceBase;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.refactoring.util.OCBindUtil;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.resolve.references.OCPolyVariantReferenceImpl;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCAliasUsingSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceAliasSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeEqualityAfterResolvingVisitor;
import com.jetbrains.cidr.lang.util.OCCommonProcessors;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCCppNamespaceQualifierImpl
extends OCElementWithReferenceBase<OCPolyVariantReference<OCSymbol>>
implements OCCppNamespaceQualifier {
    public OCCppNamespaceQualifierImpl(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    @Nullable
    public OCCppNamespaceQualifier getNamespaceQualifier() {
        return (OCCppNamespaceQualifier)this.findChildByType(OCElementTypes.CPP_NAMESPACE_QUALIFIER);
    }

    @Nullable
    public PsiElement getNameIdentifier() {
        return this.findReferenceToken();
    }

    public TextRange getRangeInElement() {
        PsiElement referenceToken = this.findReferenceToken();
        if (referenceToken != null) {
            return TextRange.from((int)referenceToken.getStartOffsetInParent(), (int)referenceToken.getTextLength());
        }
        return TextRange.EMPTY_RANGE;
    }

    @Override
    @Nullable
    public OCTypeArgumentList getTemplateArgumentList() {
        return (OCTemplateArgumentList)this.findChildByType(OCElementTypes.TEMPLATE_ARGUMENT_LIST);
    }

    @Nullable
    private PsiElement findReferenceToken() {
        return this.findChildByType(OCTokenTypes.POSSIBLE_CPP_NAMES);
    }

    @Override
    @Nullable
    public String getName() {
        PsiElement identifier = this.getNameIdentifier();
        return identifier != null ? identifier.getText() : null;
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        OCElementUtil.replaceWithIdentifier(this.getNameIdentifier(), name, this);
        return this;
    }

    @Override
    public void accept(@NotNull OCVisitor visitor) {
        visitor.visitNamespaceQualifier(this);
    }

    @Override
    @NotNull
    public List<OCSymbol> resolveToSymbols() {
        return this.resolveToSymbols(new OCResolveContext(this));
    }

    @Override
    @NotNull
    public Collection<OCSymbol> resolveTemplateDeclarations() {
        return OCResolveUtil.resolveTemplateDeclarations(this);
    }

    @Override
    @NotNull
    public List<OCSymbol> resolveToSymbols(@NotNull OCResolveContext context) {
        final ArrayList<OCSymbol> result = new ArrayList<OCSymbol>();
        OCCommonProcessors.OrderedProcessor<OCSymbol> processor2 = new OCCommonProcessors.OrderedProcessor<OCSymbol>(new Processor<OCSymbol>(){

            public boolean process(OCSymbol ocSymbol) {
                if (ocSymbol instanceof OCNamespaceSymbol) {
                    if (ocSymbol.isPredeclaration()) {
                        if (result.size() == 0) {
                            result.add(ocSymbol);
                        }
                    } else {
                        result.add(ocSymbol);
                    }
                }
                if (ocSymbol instanceof OCNamespaceAliasSymbol) {
                    if (result.size() == 0) {
                        result.add(ocSymbol);
                    }
                } else if (ocSymbol instanceof OCTypeParameterSymbol || ocSymbol instanceof OCDeclaratorSymbol || ocSymbol instanceof OCAliasUsingSymbol) {
                    result.add(ocSymbol);
                }
                return true;
            }
        }, OCSymbol.NON_PREDIFINITION_CONDITION, Conditions.alwaysTrue());
        PsiElement parent = this.getParent();
        while (parent instanceof OCCppNamespaceQualifier) {
            parent = parent.getParent();
        }
        OCSymbolReference.LocalReference ref = OCSymbolReference.getLocalReference(this, OCSymbolReference.SymbolKindFilter.ONLY_NAMESPACE_LIKE);
        List<OCSymbol> symbols = ref.resolveToSymbols(false, true, true, context);
        if (symbols.isEmpty()) {
            symbols = ref.resolveToSymbols(false, true, false, context);
        }
        ContainerUtil.process(symbols, processor2);
        processor2.finish();
        if (result.isEmpty() && this.getContainingOCFile().isInLibraries()) {
            OCResolveContext context2 = new OCResolveContext(this.getContainingOCFile());
            context2.setProcessNonImported(true);
            ContainerUtil.process(context2.resolveToSymbols(ref, false, true), processor2);
            processor2.finish();
        }
        return result;
    }

    @Override
    @Nullable
    public OCSymbol getPredeclarationInParent(OCSymbolWithQualifiedName symbol, final boolean checkTypes) {
        PsiFile file2 = this.getContainingFile();
        OCType resolvedType = symbol.getResolvedType();
        final OCTypeEqualityAfterResolvingVisitor stongEqualer = new OCTypeEqualityAfterResolvingVisitor(resolvedType, true, false, true, false, true, file2);
        final OCTypeEqualityAfterResolvingVisitor weakEqualer = new OCTypeEqualityAfterResolvingVisitor(resolvedType, true, true, true, false, true, file2);
        CommonProcessors.FindFirstProcessor<OCSymbol> finder = new CommonProcessors.FindFirstProcessor<OCSymbol>(){

            protected boolean accept(OCSymbol symbol) {
                return !OCSymbolWithQualifiedName.isFriend(symbol);
            }
        };
        OCCommonProcessors.OrderedProcessor<OCSymbol> processor2 = new OCCommonProcessors.OrderedProcessor<OCSymbol>((Processor<OCSymbol>)finder, (Condition<T>[])new Condition[]{new Condition<OCSymbol>(){

            public boolean value(OCSymbol predeclaration) {
                if (checkTypes && predeclaration instanceof OCFunctionSymbol) {
                    OCType symbolType = predeclaration.getType().resolve(predeclaration.getContainingOCFile());
                    return stongEqualer.equal(symbolType);
                }
                return true;
            }
        }, new Condition<OCSymbol>(){

            public boolean value(OCSymbol predeclaration) {
                if (checkTypes && predeclaration instanceof OCFunctionSymbol) {
                    OCType symbolType = predeclaration.getType().resolve(predeclaration.getContainingOCFile());
                    return weakEqualer.isFunctionSignatureEqual(symbolType);
                }
                return true;
            }
        }});
        for (OCSymbol parentSymbol : this.resolveToSymbols()) {
            OCType type;
            if (parentSymbol.getKind() == OCSymbolKind.TYPEDEF && (type = parentSymbol.getResolvedType()) instanceof OCStructType) {
                for (OCStructSymbol parentSymbolPart : ((OCStructType)type).getStructs()) {
                    parentSymbolPart.processMembers(symbol.getName(), (Processor<OCSymbol>)processor2);
                }
            }
            if (!(parentSymbol instanceof OCNamespaceSymbol)) continue;
            ((OCNamespaceSymbol)parentSymbol).processMembers(symbol.getName(), (Processor<OCSymbol>)processor2);
        }
        processor2.finish();
        return (OCSymbol)finder.getFoundValue();
    }

    @Override
    @Nullable
    protected OCPolyVariantReference<OCSymbol> createReference() {
        return new OCPolyVariantReferenceImpl<OCSymbol>(){

            @Override
            @NotNull
            public List<OCSymbol> resolveToSymbols() {
                return OCCppNamespaceQualifierImpl.this.resolveToSymbols();
            }

            @Override
            @NotNull
            public List<OCSymbol> resolveToSymbols(@NotNull OCResolveContext context) {
                return OCCppNamespaceQualifierImpl.this.resolveToSymbols(context);
            }

            public PsiElement getElement() {
                return OCCppNamespaceQualifierImpl.this;
            }

            public TextRange getRangeInElement() {
                return OCCppNamespaceQualifierImpl.this.getRangeInElement();
            }

            @NotNull
            public String getCanonicalText() {
                String name = OCCppNamespaceQualifierImpl.this.getName();
                return name != null ? name : "";
            }

            public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
                return OCCppNamespaceQualifierImpl.this.setName(newElementName);
            }

            @Override
            public PsiElement bindToSymbol(@NotNull OCSymbol symbol) {
                List symbols = ((OCPolyVariantReference)OCCppNamespaceQualifierImpl.this.getReference()).resolveToSymbols();
                if (symbols.contains(symbol)) {
                    return OCCppNamespaceQualifierImpl.this;
                }
                if (!(symbol instanceof OCSymbolWithQualifiedName)) {
                    return OCCppNamespaceQualifierImpl.this;
                }
                OCQualifiedName qualifiedName = ((OCSymbolWithQualifiedName)symbol).getResolvedQualifiedName();
                if (qualifiedName != null) {
                    OCBindUtil.setShortestPossibleName(qualifiedName, OCCppNamespaceQualifierImpl.this, (OCSymbolWithQualifiedName)symbol);
                }
                return OCCppNamespaceQualifierImpl.this;
            }

            public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
                Object symbol = ((OCSymbolDeclarator)element).getSymbol();
                return symbol != null ? this.bindToSymbol((OCSymbol)symbol) : element;
            }

            public boolean isSoft() {
                return false;
            }
        };
    }
}

