/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCArgumentList;
import com.jetbrains.cidr.lang.psi.OCCastExpression;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.psi.impl.OCExpressionBase;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCCastExpressionImpl
extends OCExpressionBase
implements OCCastExpression {
    public OCCastExpressionImpl(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    @Nullable
    public OCExpression getOperand() {
        return (OCExpression)this.findChildByType(OCElementTypes.EXPRESSIONS);
    }

    @Override
    @Nullable
    public OCArgumentList getArgumentList() {
        return (OCArgumentList)this.findChildByType(OCElementTypes.ARGUMENT_LIST);
    }

    @Override
    @NotNull
    public OCType getCastType() {
        OCTypeElement typeElement = this.getTypeElement();
        return typeElement != null ? typeElement.getType() : OCUnknownType.INSTANCE;
    }

    @Override
    public PsiElement getBridgeCastModifier() {
        for (PsiElement child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            IElementType elementType = OCElementUtil.getElementType(child);
            if (!OCTokenTypes.BRIDGE_CAST_KEYWORDS.contains(elementType)) continue;
            return child;
        }
        return null;
    }

    @Override
    @Nullable
    public OCTypeElement getTypeElement() {
        return (OCTypeElement)this.findChildByType(OCElementTypes.TYPE_ELEMENT);
    }

    @Override
    public void accept(@NotNull OCVisitor visitor) {
        visitor.visitCastExpression(this);
    }

    @Override
    @NotNull
    public OCType getType(@NotNull OCResolveContext context) {
        return this.getCastType();
    }
}

