/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.MultiRangeReference;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.psi.OCArgumentList;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.impl.OCExpressionWithReferenceBase;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.resolve.references.OCOperatorReference;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCNumericType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCCallExpressionImpl
extends OCExpressionWithReferenceBase<OCOperatorReference>
implements OCCallExpression {
    public OCCallExpressionImpl(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    @NotNull
    protected OCOperatorReference createReference() {
        return this.createReference(this.getFunctionReferenceExpression(), null);
    }

    public OCOperatorReference createReference(OCExpression function, @Nullable OCType functionType) {
        List<OCType> types = functionType != null ? Collections.singletonList(functionType) : null;
        ArrayList<OCExpression> exprs = new ArrayList<OCExpression>();
        exprs.add(function);
        exprs.addAll(this.getArguments());
        class OCCallOperatorReference
        extends OCOperatorReference
        implements MultiRangeReference {
            OCCallOperatorReference(OCElement element, List<OCExpression> arguments, List<OCType> paramTypes) {
                super(element, "()", OCOperatorReference.OperatorPlacement.POSTFIX, null, arguments, paramTypes);
            }

            @Override
            public boolean isValid() {
                return super.isValid() && this.myArguments.size() == OCCallExpressionImpl.this.getArguments().size() + 1;
            }

            @NotNull
            public List<TextRange> getRanges() {
                PsiElement right;
                ArrayList<TextRange> result = new ArrayList<TextRange>();
                OCArgumentList argumentList = OCCallExpressionImpl.this.getArgumentList();
                TextRange argListRange = OCElementUtil.getRangeInParent(argumentList);
                PsiElement left = argumentList.getLeftPar();
                if (left != null) {
                    result.add(OCElementUtil.getRangeInParent(left).shiftRight(argListRange.getStartOffset()));
                }
                if ((right = argumentList.getRightPar()) != null) {
                    result.add(OCElementUtil.getRangeInParent(right).shiftRight(argListRange.getStartOffset()));
                }
                return result;
            }
        }
        return new OCCallOperatorReference(this, exprs, types);
    }

    @Override
    @NotNull
    public OCExpression getFunctionReferenceExpression() {
        return (OCExpression)this.findChildByType(OCElementTypes.EXPRESSIONS);
    }

    @Override
    @NotNull
    public OCArgumentList getArgumentList() {
        return (OCArgumentList)this.findNotNullChildByType(OCElementTypes.ARGUMENT_LIST);
    }

    @Override
    @NotNull
    public List<OCExpression> getArguments() {
        return this.getArgumentList().getArguments();
    }

    @Override
    public void accept(@NotNull OCVisitor visitor) {
        visitor.visitCallExpression(this);
    }

    @Override
    @NotNull
    public OCType getType(@NotNull OCResolveContext context) {
        OCType funType;
        OCExpression funRef = this.getFunctionReferenceExpression();
        OCOperatorReference reference = this.createReference(funRef, funType = funRef.getResolvedType(context));
        if (reference != null) {
            for (OCSymbol operator : reference.resolveToSymbols(context)) {
                if (!(operator instanceof OCFunctionSymbol)) continue;
                return operator.getEffectiveType();
            }
        }
        OCSymbol callerSymbol = null;
        if (funRef instanceof OCReferenceExpression) {
            OCReferenceElement referenceElement = ((OCReferenceExpression)funRef).getReferenceElement();
            callerSymbol = referenceElement != null ? referenceElement.resolveToSymbol(context) : null;
        }
        OCType result = OCCallExpressionImpl.getCallExprType(funType, callerSymbol);
        OCType guessedType = this.getGuessedType();
        return guessedType != null ? result.cloneWithGuessedType(guessedType) : result;
    }

    @NotNull
    public static OCType getCallExprType(@Nullable OCType funType, @Nullable OCSymbol callerSymbol) {
        OCType result;
        if (callerSymbol instanceof OCStructSymbol) {
            result = callerSymbol.getType();
        } else if (callerSymbol != null && callerSymbol.getKind() == OCSymbolKind.TYPEDEF) {
            result = funType;
        } else {
            result = OCUnknownType.INSTANCE;
            if (funType instanceof OCMagicType) {
                return funType;
            }
            if (funType instanceof OCStructType) {
                result = funType;
            }
            if (funType instanceof OCPointerType) {
                funType = ((OCPointerType)funType).getRefType();
            }
            if (funType instanceof OCFunctionType) {
                result = ((OCFunctionType)funType).getReturnType();
            }
        }
        if (result instanceof OCNumericType) {
            result = result.cloneWithoutCVQualifiers(callerSymbol != null ? callerSymbol.getProject() : null);
        }
        return result;
    }

    @Nullable
    private OCType getGuessedType() {
        VirtualFile containingFile;
        OCSymbol symbol;
        OCExpression function = this.getFunctionReferenceExpression();
        if (function instanceof OCReferenceExpression && (symbol = ((OCReferenceExpression)function).resolveToSymbol()) instanceof OCFunctionSymbol && symbol.getName().startsWith("is") && (containingFile = symbol.getContainingFile()) != null && containingFile.getName().equals("ctype.h")) {
            return OCIntType.getAppropriateBool(this);
        }
        return null;
    }

    @Override
    protected List<OCExpression> getDependentExpressions() {
        OCExpression function = this.getFunctionReferenceExpression();
        return function instanceof OCQualifiedExpression ? Collections.singletonList(((OCQualifiedExpression)function).getQualifier()) : Collections.emptyList();
    }
}

