/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCPunctuatorElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCBinaryExpression;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.impl.OCExpressionWithReferenceBase;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.resolve.references.OCOperatorReference;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCNumericType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCBinaryExpressionImpl
extends OCExpressionWithReferenceBase<OCOperatorReference>
implements OCBinaryExpression {
    public OCBinaryExpressionImpl(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    @Nullable
    protected OCOperatorReference createReference() {
        String name = this.getOperationSign().getName();
        OCExpression left = this.getLeft();
        OCExpression right = this.getRight();
        if (left != null && right != null) {
            return new OCOperatorReference((OCElement)this, name, OCOperatorReference.OperatorPlacement.INFIX, this.getOperationSignNode().getPsi(), left, right);
        }
        return null;
    }

    @Override
    @Nullable
    public OCExpression getLeft() {
        for (ASTNode child = this.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            IElementType tt = child.getElementType();
            if (!OCElementTypes.EXPRESSIONS.contains(tt)) continue;
            return (OCExpression)child.getPsi();
        }
        return null;
    }

    @Override
    public OCExpression getRight() {
        boolean passedSign = false;
        for (ASTNode child = this.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            IElementType tt = child.getElementType();
            if (tt instanceof OCPunctuatorElementType) {
                passedSign = true;
                continue;
            }
            if (!passedSign || !OCElementTypes.EXPRESSIONS.contains(tt)) continue;
            return (OCExpression)child.getPsi();
        }
        return null;
    }

    @Override
    @NotNull
    public ASTNode getOperationSignNode() {
        for (ASTNode child = this.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            IElementType tt = child.getElementType();
            if (!(tt instanceof OCPunctuatorElementType)) continue;
            return child;
        }
        throw new AssertionError((Object)("Cannot find operation sign in binary expression: " + this.getText()));
    }

    @Override
    @NotNull
    public OCElementType getOperationSign() {
        return (OCElementType)this.getOperationSignNode().getElementType();
    }

    @Override
    public void accept(@NotNull OCVisitor visitor) {
        visitor.visitBinaryExpression(this);
    }

    @Override
    @NotNull
    public OCType getType(@NotNull OCResolveContext context) {
        OCOperatorReference reference = (OCOperatorReference)this.getReference();
        if (reference != null) {
            for (OCSymbol operator : reference.resolveToSymbols(context)) {
                if (!(operator instanceof OCFunctionSymbol)) continue;
                return operator.getEffectiveType();
            }
        }
        OCExpression l = this.getLeft();
        OCExpression r = this.getRight();
        if (l == null) {
            return r != null ? r.getType(context) : OCUnknownType.INSTANCE;
        }
        if (r == null) {
            return l.getType(context);
        }
        OCElementType sign = this.getOperationSign();
        OCType lt = l.getResolvedType(context);
        OCType rt = r.getResolvedType(context);
        return OCBinaryExpressionImpl.getBinaryExprType(sign, lt, rt, this);
    }

    public static OCType getBinaryExprType(OCElementType sign, OCType lt, OCType rt, @Nullable PsiElement context) {
        OCType result;
        if (OCTokenTypes.LOGIC_OPERATIONS.contains((IElementType)sign) || OCTokenTypes.COMPARISON_OPERATIONS.contains((IElementType)sign)) {
            result = OCIntType.getAppropriateBool((OCElement)context);
        } else if (lt.isSubclassOfMagic(context) || rt.isSubclassOfMagic(context)) {
            result = OCUnknownType.INSTANCE;
        } else if (sign == OCTokenTypes.DOT_MUL || sign == OCTokenTypes.DEREF_MUL) {
            if (rt instanceof OCCppReferenceType) {
                rt = ((OCCppReferenceType)rt).getRefType();
            }
            result = rt instanceof OCPointerType ? ((OCPointerType)rt).getRefType() : OCUnknownType.INSTANCE;
        } else {
            if (lt instanceof OCCppReferenceType) {
                lt = ((OCCppReferenceType)lt).getRefType();
            }
            if (rt instanceof OCCppReferenceType) {
                rt = ((OCCppReferenceType)rt).getRefType();
            }
            result = lt instanceof OCNumericType && rt instanceof OCNumericType && (sign == OCTokenTypes.PLUS || sign == OCTokenTypes.MINUS || sign == OCTokenTypes.DIV || sign == OCTokenTypes.PERC || sign == OCTokenTypes.MUL || sign == OCTokenTypes.AND || sign == OCTokenTypes.OR || sign == OCTokenTypes.XOR) ? lt.getLeastCommonType(rt, context) : (lt instanceof OCPointerType && rt instanceof OCPointerType ? OCIntType.ULONG : (lt instanceof OCPointerType && rt.isIntegerCompatible(context) ? lt : (rt instanceof OCPointerType && lt.isIntegerCompatible(context) ? rt : (!(!lt.isNumberCompatible(context) && !lt.isPointerCompatible(context) || !rt.isNumberCompatible(context) && !rt.isPointerCompatible(context)) ? lt : (lt.isCppStructType() || rt.isCppStructType() ? new OCMagicType(lt) : OCUnknownType.INSTANCE)))));
        }
        if (result instanceof OCNumericType) {
            result = result.cloneWithoutCVQualifiers(context != null ? context.getProject() : null);
        }
        return result;
    }

    @Override
    protected List<OCExpression> getDependentExpressions() {
        return Arrays.asList(this.getLeft(), this.getRight());
    }
}

