/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.preprocessor;

import com.intellij.lang.ForeignLeafType;
import com.intellij.lang.TokenWrapper;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.LexerPosition;
import com.intellij.lexer.LexerUtil;
import com.intellij.lexer.LookAheadLexer;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.HashMap;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.lexer.OCLexer;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCPragmaOnceContentElementType;
import com.jetbrains.cidr.lang.parser.OCPunctuatorElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.preprocessor.OCContextChangeSet;
import com.jetbrains.cidr.lang.preprocessor.OCImmutableInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.preprocessor.OCMacroForeignLeafType;
import com.jetbrains.cidr.lang.preprocessor.OCMacroReferenceTokenType;
import com.jetbrains.cidr.lang.preprocessor.OCModuleResolver;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.symbols.cpp.OCIncludeSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCMacroSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.SymbolTableProvider;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import com.jetbrains.cidr.lang.util.OCImmutableList;
import com.jetbrains.cidr.lang.util.OCStringLiteralUtil;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerHelper;
import gnu.trove.THashMap;
import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCPreprocessingLexer
extends LookAheadLexer {
    private static final String VARARG_MACRO_PARAMS_SEPARATOR = ",";
    private static final int MACRO_SUBSTITUTIONS_LIMIT_PER_FILE = 200000;
    public static final Key<Boolean> DONT_SUBSTITUTE_IN_DEFINES = Key.create((String)"DONT_SUBSTITUTE_IN_DEFINES");
    private static final String LINE_MACRO = "__LINE__";
    private static final String LINE_MACRO_STUB_START = "__CIDR_LINE_MACRO_STUB_";
    private static final Pattern LINE_MACRO_STUB_PATTERN = Pattern.compile("^\\s*__CIDR_LINE_MACRO_STUB_(\\d+)\\s*$");
    public static final String VA_ARGS_TOKEN = "__VA_ARGS__";
    @NotNull
    private final OCInclusionContext myState;
    @Nullable
    private OCContextChangeSet myChangeSet;
    private final boolean myEvalDefinedFunction;
    @Nullable
    private final OCFile myFile;
    private VirtualFile myCurrentFile;
    private PsiFile myIncludeAnchor;
    private int myMacroLevel;
    private Ref<Integer> myTotalMacroSubstitutionsCnt;
    private boolean myAtDefineDirective;
    private final boolean myAddTokensFromDirective;
    private Stack<Boolean> myBraceStack;
    private CurrentState myAtExternDeclaration;
    private List<String> myModuleNameParts;
    private boolean myDontSubstituteInDefines;
    private TObjectIntHashMap<PsiFile> myProcessingFiles = new TObjectIntHashMap();
    private int myIncludeLevel;
    private boolean myInsideIfCondition;
    @NotNull
    private final Ref<Long> myLineCount;
    private final boolean myForcePreprocessingOfIncludes;
    private final Function<CharSequence, Boolean> IF_EVAL = new Function<CharSequence, Boolean>(){

        public Boolean fun(CharSequence charSequence) {
            return OCPreprocessingLexer.this.evaluate(charSequence);
        }
    };
    private final Function<CharSequence, Boolean> IFDEF_EVAL = new Function<CharSequence, Boolean>(){

        public Boolean fun(CharSequence charSequence) {
            List words = StringUtil.getWordsIn((String)charSequence.toString());
            String identifier = words.isEmpty() ? charSequence.toString().trim() : (String)words.get(0);
            return OCPreprocessingLexer.this.myState.isDefined(identifier);
        }
    };
    private final Function<CharSequence, Boolean> IFNDEF_EVAL = new Function<CharSequence, Boolean>(){

        public Boolean fun(CharSequence charSequence) {
            List words = StringUtil.getWordsIn((String)charSequence.toString());
            String identifier = words.isEmpty() ? charSequence.toString().trim() : (String)words.get(0);
            return !OCPreprocessingLexer.this.myState.isDefined(identifier);
        }
    };
    private static final Condition<Boolean> ID = new Condition<Boolean>(){

        public boolean value(Boolean v) {
            return v;
        }
    };
    private static final TokenSet SKIP_TOKENS = TokenSet.create((IElementType[])new IElementType[]{OCTokenTypes.INCLUDE_DIRECTIVE_CONTENT, OCTokenTypes.CONDITIONALLY_NON_COMPILED_COMMENT, OCTokenTypes.EOL_ESCAPE});
    private static final TokenSet NON_CLOSING_DIRECTIVES = TokenSet.create((IElementType[])new IElementType[]{OCTokenTypes.INCLUDE_DIRECTIVE, OCTokenTypes.INCLUDE_NEXT_DIRECTIVE, OCTokenTypes.IMPORT_DIRECTIVE});

    public OCPreprocessingLexer(@NotNull OCInclusionContext initialSubstitutions, @Nullable OCFile file2) {
        this(initialSubstitutions, file2, false, 0, initialSubstitutions.getInclusionLevel(), (Ref<Integer>)Ref.create((Object)0), false, (Ref<Long>)Ref.create((Object)1L), false, false);
    }

    public OCPreprocessingLexer(@NotNull OCInclusionContext initialSubstitutions, @Nullable OCFile file2, int lineNumber) {
        this(initialSubstitutions, file2, false, 0, initialSubstitutions.getInclusionLevel(), (Ref<Integer>)Ref.create((Object)0), false, (Ref<Long>)Ref.create((Object)new Long(lineNumber)), false, false);
    }

    private OCPreprocessingLexer(@NotNull OCInclusionContext initialSubstitutions, @Nullable OCFile file2, boolean evalDefined, int macroLevel, int includeLevel, Ref<Integer> totalMacroSubstitutions, boolean forcePreprocessingOfIncludes, @NotNull Ref<Long> lineCount, boolean atDefineDirective, boolean addTokensFromDirective) {
        super((Lexer)new OCLexer(initialSubstitutions.getLanguageKind(), false, OCCompilerHelper.supportsNullability(initialSubstitutions)));
        this.myState = initialSubstitutions;
        this.myFile = file2;
        this.myIncludeAnchor = file2;
        this.myEvalDefinedFunction = evalDefined;
        this.myMacroLevel = macroLevel;
        this.myIncludeLevel = includeLevel;
        this.myTotalMacroSubstitutionsCnt = totalMacroSubstitutions;
        this.myForcePreprocessingOfIncludes = forcePreprocessingOfIncludes;
        this.myLineCount = lineCount;
        this.myAtDefineDirective = atDefineDirective;
        this.myAddTokensFromDirective = addTokensFromDirective;
        this.myBraceStack = new Stack();
        this.myAtExternDeclaration = CurrentState.NONE;
        this.myInsideIfCondition = false;
        this.myDontSubstituteInDefines = file2 != null && file2.getProject().getUserData(DONT_SUBSTITUTE_IN_DEFINES) == Boolean.TRUE;
    }

    protected void lookAhead(Lexer baseLexer) {
        IElementType baseToken = baseLexer.getTokenType();
        if (baseToken == OCTokenTypes.IDENTIFIER || OCTokenTypes.KEYWORDS.contains(baseToken) || baseToken instanceof OCPunctuatorElementType && OCElementUtil.isAlternativeCppPunctuator(baseToken, LexerUtil.getTokenText((Lexer)baseLexer))) {
            String id = LexerUtil.getTokenText((Lexer)baseLexer).toString();
            if (this.myEvalDefinedFunction && "defined".equals(id)) {
                this.processDefinedFunction(baseLexer);
            } else if (this.myEvalDefinedFunction && "__has_include".equals(id)) {
                this.processHasInclude(baseLexer, false);
            } else if (this.myEvalDefinedFunction && "__has_include_next".equals(id)) {
                this.processHasInclude(baseLexer, true);
            } else {
                String numStr;
                OCMacroSymbol macro;
                if (!this.myInsideIfCondition && this.myEvalDefinedFunction) {
                    this.myState.isDefined(id);
                }
                if ((macro = this.myState.getDefinition(id)) == null && (numStr = OCPreprocessingLexer.lineNumberFromStub(id)) != null) {
                    macro = new OCMacroSymbol(null, null, -1, id, null, numStr);
                }
                if (!this.myAtDefineDirective && macro != null) {
                    this.processMacroSubstitution(baseLexer, macro, true);
                } else {
                    this.addToken(baseToken);
                    baseLexer.advance();
                    if (!this.myDontSubstituteInDefines) {
                        this.myAtDefineDirective = false;
                    }
                    this.updateBraceStack(baseToken, id);
                }
            }
        } else if (baseToken == OCTokenTypes.DEFINE_DIRECTIVE) {
            this.processDefineDirective(baseLexer);
        } else if (baseToken == OCTokenTypes.UNDEF_DIRECTIVE) {
            this.processUndefineDirective(baseLexer);
        } else if (baseToken == OCTokenTypes.INCLUDE_DIRECTIVE) {
            this.processIncludeDirective(baseLexer, false, false);
        } else if (baseToken == OCTokenTypes.IMPORT_DIRECTIVE) {
            this.processIncludeDirective(baseLexer, true, false);
        } else if (baseToken == OCTokenTypes.INCLUDE_NEXT_DIRECTIVE) {
            this.processIncludeDirective(baseLexer, false, true);
        } else if (baseToken == OCTokenTypes.IF_DIRECTIVE) {
            this.processIfDirective(baseLexer, this.IF_EVAL);
        } else if (baseToken == OCTokenTypes.IFDEF_DIRECTIVE) {
            this.processIfDirective(baseLexer, this.IFDEF_EVAL);
        } else if (baseToken == OCTokenTypes.IFNDEF_DIRECTIVE) {
            this.processIfDirective(baseLexer, this.IFNDEF_EVAL);
        } else if (baseToken == OCTokenTypes.PRAGMA_DIRECTIVE) {
            this.processPragmaDirective(baseLexer);
        } else if (OCTokenTypes.DIRECTIVES.contains(baseToken)) {
            this.skipDirectiveWithContent(baseLexer);
        } else {
            if (OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(baseToken)) {
                this.adjustLineCount(LexerUtil.getTokenText((Lexer)baseLexer));
            }
            this.updateBraceStack(baseToken, null);
            super.lookAhead(baseLexer);
        }
    }

    @Nullable
    private static String lineNumberFromStub(String stub) {
        Matcher matcher;
        if (stub.length() > LINE_MACRO_STUB_START.length() && (matcher = LINE_MACRO_STUB_PATTERN.matcher(stub)).find()) {
            return matcher.group(1);
        }
        return null;
    }

    private void adjustLineCount(@NotNull CharSequence tokenText) {
        int lbCount = StringUtil.countChars((CharSequence)tokenText, (char)'\n');
        if (lbCount > 0) {
            this.myLineCount.set((Object)((Long)this.myLineCount.get() + (long)lbCount));
        }
    }

    private void updateBraceStack(IElementType baseToken, String name) {
        if (baseToken == OCTokenTypes.EXTERN_KEYWORD) {
            this.myAtExternDeclaration = CurrentState.AFTER_EXTERN;
            return;
        }
        if (baseToken == OCTokenTypes.STRING_LITERAL && this.myAtExternDeclaration == CurrentState.AFTER_EXTERN) {
            this.myAtExternDeclaration = CurrentState.AFTER_EXTERN_C;
            return;
        }
        if (baseToken == OCTokenTypes.AT) {
            this.myAtExternDeclaration = CurrentState.AFTER_AT;
        } else {
            if (baseToken == OCTokenTypes.IMPORT_MODULE_KEYWORD && this.myAtExternDeclaration == CurrentState.AFTER_AT) {
                this.myAtExternDeclaration = CurrentState.AFTER_MODULE_IMPORT;
                this.myModuleNameParts = ContainerUtil.newArrayList();
                return;
            }
            if (this.myAtExternDeclaration == CurrentState.AFTER_MODULE_IMPORT) {
                if (baseToken == OCTokenTypes.IDENTIFIER) {
                    this.myModuleNameParts.add(name);
                    return;
                }
                if (baseToken != OCTokenTypes.DOT && !OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(baseToken) && !(baseToken instanceof OCMacroForeignLeafType)) {
                    String pathText;
                    this.myAtExternDeclaration = CurrentState.NONE;
                    ProgressManager.checkCanceled();
                    if (!OCModuleResolver.processModuleImports(this.getContext(), this.myModuleNameParts, new Processor<VirtualFile>(){

                        public boolean process(VirtualFile header) {
                            if (header.isValid()) {
                                OCPreprocessingLexer.this.doProcessImport(header);
                            }
                            return true;
                        }
                    }) && (pathText = OCModuleResolver.getGuessedPath(this.myModuleNameParts)) != null) {
                        OCIncludeSymbol.IncludePath path = new OCIncludeSymbol.IncludePath(pathText, true);
                        VirtualFile header = this.myState.resolvePath(path, this.myIncludeAnchor);
                        this.doProcessImport(header);
                    }
                    this.myModuleNameParts = null;
                } else {
                    return;
                }
            }
        }
        if (this.myAtExternDeclaration == CurrentState.AFTER_PROTOCOL) {
            if (OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(baseToken)) {
                return;
            }
            if (baseToken == OCTokenTypes.SEMICOLON || baseToken == OCTokenTypes.COMMA) {
                this.myAtExternDeclaration = CurrentState.NONE;
            } else {
                this.myAtExternDeclaration = CurrentState.NONE;
                this.myBraceStack.push(false);
            }
        } else {
            if (baseToken == OCTokenTypes.LBRACE) {
                this.myBraceStack.push(this.myAtExternDeclaration == CurrentState.AFTER_EXTERN_C);
            } else if (OCTokenTypes.OBJC_CLASS_KEYWORDS.contains(baseToken) && baseToken != OCTokenTypes.CLASS_KEYWORD && baseToken != OCTokenTypes.PROTOCOL_KEYWORD) {
                this.myBraceStack.push(false);
            }
            if (baseToken == OCTokenTypes.PROTOCOL_KEYWORD) {
                this.myAtExternDeclaration = CurrentState.AFTER_PROTOCOL;
            } else if (!(baseToken != OCTokenTypes.RBRACE && baseToken != OCTokenTypes.END_KEYWORD || this.myBraceStack.empty())) {
                this.myBraceStack.pop();
            }
            if (!OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(baseToken)) {
                this.myAtExternDeclaration = CurrentState.NONE;
            }
        }
    }

    private void doProcessImport(VirtualFile vFile) {
        PsiFile resolved;
        PsiFile psiFile = resolved = this.myFile == null ? null : this.myFile.getManager().findFile(vFile);
        if (resolved instanceof OCFile) {
            OCFile file2 = (OCFile)resolved;
            file2.markIncludedFrom(this.myFile);
            this.myState.preprocessInclude(file2, true, null, this.myIncludeLevel);
        }
    }

    public void setChangeSet(@Nullable OCContextChangeSet changeSet) {
        this.myChangeSet = changeSet;
    }

    private void processPragmaDirective(Lexer baseLexer) {
        this.advanceLexer(baseLexer);
        if (OCPreprocessingLexer.atDirectiveContent(baseLexer)) {
            String text = baseLexer.getTokenText();
            if ("once".equals(text.trim())) {
                VirtualFile virtualFile;
                VirtualFile virtualFile2 = virtualFile = this.myCurrentFile == null ? OCInclusionContextUtil.getVirtualFile(this.myFile) : this.myCurrentFile;
                if (virtualFile != null && virtualFile.isValid()) {
                    String pragmaId = OCInclusionContextUtil.pragmaOnceId(virtualFile);
                    if (!this.myState.isDefined(pragmaId)) {
                        this.myState.define(OCMacroSymbol.inclusionGuard(pragmaId));
                    }
                    this.addToken(new OCPragmaOnceContentElementType(text, virtualFile));
                    return;
                }
            }
            this.adjustLineCount(text);
            this.skipAsComment(baseLexer);
        }
        this.addToken(baseLexer.getTokenStart(), OCTokenTypes.END_OF_DIRECTIVE_CONTENT);
    }

    private void processHasInclude(Lexer lexer, boolean next) {
        if (this.myAddTokensFromDirective) {
            this.advanceLexer(lexer);
        } else {
            this.skipAsComment(lexer);
        }
        this.skipWhitespaces(lexer);
        boolean inPars = false;
        if (lexer.getTokenType() == OCTokenTypes.LPAR) {
            this.skipAsComment(lexer);
            this.skipWhitespaces(lexer);
            inPars = true;
        }
        boolean inAnglePars = false;
        if (lexer.getTokenType() == OCTokenTypes.LT) {
            this.skipAsComment(lexer);
            this.skipWhitespaces(lexer);
            inAnglePars = true;
        }
        IElementType tokenType = lexer.getTokenType();
        StringBuilder name = new StringBuilder();
        if (inAnglePars) {
            name.append("<");
        }
        while (tokenType == OCTokenTypes.IDENTIFIER || OCTokenTypes.KEYWORDS.contains(tokenType) || tokenType == OCTokenTypes.STRING_LITERAL || tokenType == OCTokenTypes.DOT || tokenType == OCTokenTypes.DIV || tokenType == OCTokenTypes.EOL_ESCAPE) {
            name.append(LexerUtil.getTokenText((Lexer)lexer).toString());
            if (this.myAddTokensFromDirective) {
                this.advanceLexer(lexer);
            } else {
                this.skipAsComment(lexer);
            }
            tokenType = lexer.getTokenType();
        }
        if (inAnglePars) {
            name.append(">");
        }
        if (!this.myAddTokensFromDirective) {
            if (this.myIncludeAnchor != null) {
                VirtualFile file2;
                VirtualFile virtualFile = file2 = next ? this.myState.resolveNextImportedFile(name, this.myIncludeAnchor) : this.myState.resolveImportedFile(name, this.myIncludeAnchor);
                if (file2 != null && file2.exists()) {
                    this.addToken(OCTokenTypes.FAKE_TRUE);
                } else {
                    this.addToken(OCTokenTypes.FAKE_FALSE);
                }
            } else {
                this.addToken(OCTokenTypes.FAKE_FALSE);
            }
        }
        this.skipWhitespaces(lexer);
        if (inAnglePars && lexer.getTokenType() == OCTokenTypes.GT) {
            this.skipAsComment(lexer);
        }
        this.skipWhitespaces(lexer);
        if (inPars && lexer.getTokenType() == OCTokenTypes.RPAR) {
            this.skipAsComment(lexer);
        }
    }

    private void processDefinedFunction(Lexer lexer) {
        IElementType tokenType;
        if (this.myAddTokensFromDirective) {
            this.advanceLexer(lexer);
        } else {
            this.skipAsComment(lexer);
        }
        this.skipWhitespaces(lexer);
        boolean inPars = false;
        if (lexer.getTokenType() == OCTokenTypes.LPAR) {
            this.skipAsComment(lexer);
            this.skipWhitespaces(lexer);
            inPars = true;
        }
        if ((tokenType = lexer.getTokenType()) == OCTokenTypes.IDENTIFIER || OCTokenTypes.KEYWORDS.contains(tokenType)) {
            String macro = LexerUtil.getTokenText((Lexer)lexer).toString();
            if (this.myAddTokensFromDirective) {
                this.advanceLexer(lexer);
            } else {
                this.skipAsComment(lexer);
            }
            if (!this.myAddTokensFromDirective) {
                if (this.myState.isDefined(macro)) {
                    this.addToken(OCTokenTypes.FAKE_TRUE);
                } else {
                    this.addToken(OCTokenTypes.FAKE_FALSE);
                }
            }
        }
        this.skipWhitespaces(lexer);
        if (inPars && lexer.getTokenType() == OCTokenTypes.RPAR) {
            this.skipAsComment(lexer);
        }
    }

    private void skipWhitespaces(Lexer lexer) {
        while (OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(lexer.getTokenType())) {
            this.skipAsComment(lexer);
        }
    }

    private void processIfDirective(Lexer lexer, Function<CharSequence, Boolean> decisionEvaluator) {
        this.advanceLexer(lexer);
        if (OCPreprocessingLexer.atDirectiveContent(lexer)) {
            CharSequence content = LexerUtil.getTokenText((Lexer)lexer);
            boolean decision = (Boolean)decisionEvaluator.fun((Object)content);
            boolean dontSubstituteFirst = decisionEvaluator == this.IFDEF_EVAL || decisionEvaluator == this.IFNDEF_EVAL;
            this.myInsideIfCondition = true;
            this.addTokensFromDirective(lexer, content, dontSubstituteFirst, true);
            this.myInsideIfCondition = false;
            if (decision) {
                this.processConditionals(lexer);
                IElementType tt = lexer.getTokenType();
                if (tt == OCTokenTypes.ELSE_DIRECTIVE || tt == OCTokenTypes.ELIF_DIRECTIVE) {
                    this.skipDirectiveWithContent(lexer);
                    this.skipConditionals(lexer, false);
                }
            } else {
                this.skipConditionals(lexer, true);
                IElementType tt = lexer.getTokenType();
                if (tt == OCTokenTypes.ELSE_DIRECTIVE) {
                    this.skipDirectiveWithContent(lexer);
                    this.processConditionals(lexer);
                } else if (tt == OCTokenTypes.ELIF_DIRECTIVE) {
                    this.processIfDirective(lexer, this.IF_EVAL);
                    return;
                }
            }
            if (lexer.getTokenType() == OCTokenTypes.ENDIF_DIRECTIVE) {
                this.skipDirectiveWithContent(lexer);
            }
        } else {
            this.addToken(lexer.getTokenStart(), OCTokenTypes.END_OF_DIRECTIVE_CONTENT);
        }
    }

    private static boolean atDirectiveContent(Lexer lexer) {
        IElementType tt = lexer.getTokenType();
        return tt == OCTokenTypes.DIRECTIVE_CONTENT || tt == OCTokenTypes.CODE_DIRECTIVE_CONTENT || tt == OCTokenTypes.INCLUDE_DIRECTIVE_CONTENT;
    }

    private void skipDirectiveWithContent(Lexer lexer) {
        IElementType tt = lexer.getTokenType();
        this.advanceLexer(lexer);
        if (OCPreprocessingLexer.atDirectiveContent(lexer)) {
            CharSequence content = LexerUtil.getTokenText((Lexer)lexer);
            if (tt == OCTokenTypes.ELIF_DIRECTIVE) {
                this.myInsideIfCondition = true;
                this.addTokensFromDirective(lexer, content, false, true);
                this.myInsideIfCondition = false;
            } else {
                this.adjustLineCount(content);
                this.advanceLexer(lexer);
            }
        } else {
            this.addToken(lexer.getTokenStart(), OCTokenTypes.END_OF_DIRECTIVE_CONTENT);
        }
    }

    private void processConditionals(Lexer lexer) {
        IElementType tt;
        while ((tt = lexer.getTokenType()) != null && !OCTokenTypes.END_IF_DIRECTIVES.contains(tt)) {
            this.lookAhead(lexer);
        }
    }

    private void skipConditionals(Lexer lexer, boolean stopOnElse) {
        IElementType tt;
        int nesting = 1;
        while (OCTokenTypes.WHITESPACES.contains(lexer.getTokenType())) {
            this.adjustLineCount(LexerUtil.getTokenText((Lexer)lexer));
            this.advanceAs(lexer, TokenType.WHITE_SPACE);
        }
        LexerPosition beforeEnd = null;
        while ((tt = lexer.getTokenType()) != null) {
            if (tt == OCTokenTypes.IF_DIRECTIVE || tt == OCTokenTypes.IFDEF_DIRECTIVE || tt == OCTokenTypes.IFNDEF_DIRECTIVE) {
                ++nesting;
            } else if (stopOnElse && (tt == OCTokenTypes.ELIF_DIRECTIVE || tt == OCTokenTypes.ELSE_DIRECTIVE) || tt == OCTokenTypes.ENDIF_DIRECTIVE) {
                if (--nesting == 0) break;
                if (tt != OCTokenTypes.ENDIF_DIRECTIVE) {
                    ++nesting;
                }
            }
            if (OCTokenTypes.WHITESPACES.contains(tt)) {
                this.adjustLineCount(LexerUtil.getTokenText((Lexer)lexer));
            } else {
                beforeEnd = lexer.getCurrentPosition();
            }
            lexer.advance();
        }
        if (beforeEnd != null) {
            lexer.restore(beforeEnd);
            this.advanceAs(lexer, OCTokenTypes.CONDITIONALLY_NON_COMPILED_COMMENT);
        }
        while (OCTokenTypes.WHITESPACES.contains(lexer.getTokenType())) {
            this.advanceAs(lexer, TokenType.WHITE_SPACE);
        }
    }

    private boolean evaluate(CharSequence expr) {
        OCExpression expression;
        IElementType tt;
        OCPreprocessingLexer lexer = new OCPreprocessingLexer(this.myState, this.myFile, true, 0, 0, this.myTotalMacroSubstitutionsCnt, this.myForcePreprocessingOfIncludes, this.getLineCountCopy(), false, false);
        lexer.myIncludeAnchor = this.myIncludeAnchor;
        StringBuilder subst = new StringBuilder();
        lexer.start(expr, 0, expr.length(), 8);
        while ((tt = lexer.getTokenType()) != null) {
            if (tt == OCTokenTypes.FAKE_TRUE || tt == OCTokenTypes.TRUE_CPP_KEYWORD) {
                subst.append("1");
            } else if (tt == OCTokenTypes.FAKE_FALSE) {
                subst.append("0");
            } else if (tt != OCTokenTypes.BLOCK_COMMENT) {
                if (tt instanceof TokenWrapper) {
                    ForeignLeafType wrapper;
                    IElementType delegate;
                    if (tt instanceof ForeignLeafType && !((delegate = (wrapper = (ForeignLeafType)tt).getDelegate()) instanceof TokenWrapper)) {
                        if (delegate == OCTokenTypes.FAKE_TRUE || delegate == OCTokenTypes.TRUE_CPP_KEYWORD) {
                            subst.append("1");
                        } else if (delegate == OCTokenTypes.FAKE_FALSE || delegate == OCTokenTypes.IDENTIFIER || OCTokenTypes.KEYWORDS.contains(delegate)) {
                            subst.append("0");
                        } else {
                            subst.append(wrapper.getValue());
                        }
                    }
                } else if (tt == OCTokenTypes.IDENTIFIER || OCTokenTypes.KEYWORDS.contains(tt)) {
                    subst.append("0");
                } else {
                    subst.append(lexer.getTokenText());
                }
            }
            lexer.advance();
        }
        try {
            String substTrimmed = subst.toString().trim();
            if (substTrimmed.isEmpty()) {
                return false;
            }
            Project project2 = this.myState.getProject();
            expression = (OCExpression)PsiTreeUtil.getChildOfType((PsiElement)OCElementFactory.expressionCodeFragment(substTrimmed, project2, null, false, false, OCLanguageKind.C), OCExpression.class);
            if (expression == null) {
                return false;
            }
        }
        catch (Throwable t) {
            return false;
        }
        Number value = OCExpressionEvaluator.evaluate(expression);
        return value != null && OCExpressionEvaluator.singAsInC(value) != 0;
    }

    @NotNull
    private Ref<Long> getLineCountCopy() {
        return new Ref(this.myLineCount.get());
    }

    private void processIncludeDirective(Lexer lexer, boolean isImport, boolean isNext) {
        ProgressManager.checkCanceled();
        this.advanceLexer(lexer);
        if (OCPreprocessingLexer.atDirectiveContent(lexer)) {
            CharSequence content = LexerUtil.getTokenText((Lexer)lexer);
            String newContent = this.preprocess(content.toString(), PreprocessingMode.DIRECTIVE_CONTENTS);
            this.adjustLineCount(content);
            if (this.myIncludeAnchor != null) {
                VirtualFile vFile;
                VirtualFile virtualFile = vFile = isNext ? this.myState.resolveNextImportedFile(newContent, this.myIncludeAnchor) : this.myState.resolveImportedFile(newContent, this.myIncludeAnchor);
                if (vFile != null && vFile.isValid()) {
                    PsiFile resolved;
                    PsiFile psiFile = resolved = this.myFile == null ? null : this.myFile.getManager().findFile(vFile);
                    if (!(resolved == null || !this.myForcePreprocessingOfIncludes && SymbolTableProvider.isSourceFile(resolved) && ContainerUtil.and(this.myBraceStack, ID))) {
                        this.skipAsComment(lexer);
                        if (this.myIncludeLevel < OCInclusionContext.getMaxInclusionLevel(this.myState.getProject()) && this.myState.reserveInclude(vFile, isImport) && this.myProcessingFiles.get((Object)resolved) < 10) {
                            IElementType type;
                            this.myProcessingFiles.put((Object)resolved, this.myProcessingFiles.get((Object)resolved) + 1);
                            OCPreprocessingLexer substLexer = new OCPreprocessingLexer(this.myState, this.myFile, this.myEvalDefinedFunction, this.myMacroLevel, this.myIncludeLevel + 1, this.myTotalMacroSubstitutionsCnt, this.myForcePreprocessingOfIncludes, (Ref<Long>)Ref.create((Object)1L), false, false);
                            substLexer.myCurrentFile = vFile;
                            substLexer.myIncludeAnchor = resolved;
                            substLexer.myProcessingFiles = this.myProcessingFiles;
                            substLexer.myBraceStack = this.myBraceStack;
                            substLexer.myInsideIfCondition = this.myInsideIfCondition;
                            substLexer.start(resolved.getText());
                            int offsetInSubstitution = 0;
                            boolean previousWhitespace = false;
                            while ((type = substLexer.getTokenType()) != null) {
                                if (type instanceof ForeignLeafType) {
                                    if (type instanceof OCMacroForeignLeafType) {
                                        ((OCMacroForeignLeafType)type).plungeIntoSubstitution(offsetInSubstitution);
                                    }
                                    this.addToken(lexer.getTokenStart(), type);
                                    ++offsetInSubstitution;
                                    previousWhitespace = false;
                                } else if (!OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(type)) {
                                    CharSequence tokenText = LexerUtil.getTokenText((Lexer)substLexer);
                                    this.addToken(lexer.getTokenStart(), new OCMacroForeignLeafType(type, tokenText, newContent, -1, null, offsetInSubstitution));
                                    ++offsetInSubstitution;
                                    previousWhitespace = false;
                                } else if (!previousWhitespace) {
                                    this.addToken(lexer.getTokenStart(), new OCMacroForeignLeafType(TokenType.WHITE_SPACE, " ", newContent, -1, null, offsetInSubstitution));
                                    ++offsetInSubstitution;
                                    previousWhitespace = true;
                                }
                                substLexer.advance();
                            }
                        }
                    } else if (resolved instanceof OCFile) {
                        if (Comparing.equal((CharSequence)newContent, (CharSequence)content)) {
                            this.advanceLexer(lexer);
                        } else {
                            this.addToken(lexer.getTokenStart(), new OCMacroForeignLeafType(OCTokenTypes.INCLUDE_DIRECTIVE_CONTENT, newContent, null, -1, null, 0));
                            this.skipAsComment(lexer);
                        }
                        OCFile file2 = (OCFile)resolved;
                        file2.markIncludedFrom(this.myFile);
                        this.myState.preprocessInclude(file2, isImport, null, this.myIncludeLevel, lexer.getTokenStart(), this.myChangeSet);
                    } else {
                        this.advanceLexer(lexer);
                    }
                } else {
                    this.advanceLexer(lexer);
                }
            } else {
                this.advanceLexer(lexer);
            }
        }
    }

    @Nullable
    private List<String> buildSubstitutionArguments(Lexer baseLexer) {
        ArrayList<String> args = new ArrayList<String>();
        LexerPosition pos = baseLexer.getCurrentPosition();
        while (OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(baseLexer.getTokenType())) {
            baseLexer.advance();
        }
        int level = 0;
        int templateLevel = 0;
        if (baseLexer.getTokenType() == OCTokenTypes.LPAR) {
            baseLexer.restore(pos);
            this.skipWhitespacesAndCommentByAdvance(baseLexer);
            this.skipMacroToken(baseLexer, false, false);
            StringBuilder builder = new StringBuilder();
            int argOffset = -1;
            LexerPosition restorePosition = null;
            int resetSize = 0;
            int builderLength = 0;
            while (true) {
                IElementType tt;
                if ((tt = baseLexer.getTokenType()) == null) {
                    if (restorePosition == null) break;
                    baseLexer.restore(restorePosition);
                    this.resetCacheSize(resetSize);
                    builder.setLength(builderLength);
                    break;
                }
                if (tt == OCTokenTypes.TEMPLATE_START_MARK) {
                    ++templateLevel;
                }
                if (tt == OCTokenTypes.TEMPLATE_STOP_MARK) {
                    --templateLevel;
                }
                if (tt == OCTokenTypes.RPAR && level == 0 && templateLevel == 0) break;
                if (tt == OCTokenTypes.COMMA && level == 0 && templateLevel == 0) {
                    args.add(builder.toString());
                    builder.setLength(0);
                    argOffset = -1;
                    this.skipMacroToken(baseLexer, false, false);
                    continue;
                }
                if (tt == OCTokenTypes.LPAR && templateLevel == 0) {
                    ++level;
                } else if (tt == OCTokenTypes.RPAR && templateLevel == 0) {
                    --level;
                } else if (restorePosition == null && (tt == OCTokenTypes.LBRACE || tt == OCTokenTypes.RBRACE || tt == OCTokenTypes.SEMICOLON)) {
                    resetSize = this.getCacheSize();
                    restorePosition = baseLexer.getCurrentPosition();
                    builderLength = builder.length();
                }
                if (argOffset == -1) {
                    argOffset = baseLexer.getTokenStart();
                }
                if (tt != OCTokenTypes.EOL_ESCAPE) {
                    CharSequence text;
                    if (OCTokenTypes.COMMENTS.contains(tt)) {
                        text = " ";
                    } else {
                        text = LexerUtil.getTokenText((Lexer)baseLexer);
                        if (StringUtil.equals((CharSequence)LINE_MACRO, (CharSequence)text)) {
                            text = LINE_MACRO_STUB_START + String.valueOf(this.myLineCount.get());
                        }
                    }
                    builder.append(text);
                }
                this.skipMacroToken(baseLexer, true, false);
            }
            args.add(builder.toString());
            this.skipMacroToken(baseLexer, false, false);
            return args;
        }
        baseLexer.restore(pos);
        return null;
    }

    private void skipWhitespacesAndCommentByAdvance(@NotNull Lexer baseLexer) {
        while (OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(baseLexer.getTokenType())) {
            this.skipMacroToken(baseLexer, false, false);
        }
    }

    @Nullable
    private OCMacroReferenceTokenType skipMacroToken(Lexer baseLexer, boolean isParamToken, boolean isRoot) {
        OCMacroReferenceTokenType result = null;
        IElementType baseToken = baseLexer.getTokenType();
        if (baseToken != null) {
            if (OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(baseToken)) {
                if (!isRoot) {
                    this.adjustLineCount(LexerUtil.getTokenText((Lexer)baseLexer));
                }
                this.advanceAs(baseLexer, baseToken);
            } else {
                CharSequence text = LexerUtil.getTokenText((Lexer)baseLexer);
                IElementType preprocessed = isRoot && (OCTokenTypes.KEYWORDS.contains(baseToken) || baseToken instanceof OCPunctuatorElementType && OCElementUtil.isAlternativeCppPunctuator(baseToken, text)) ? OCTokenTypes.IDENTIFIER : baseToken;
                result = new OCMacroReferenceTokenType(preprocessed, text, isParamToken, this.myMacroLevel, isRoot);
                this.advanceAs(baseLexer, result);
            }
        }
        return result;
    }

    private void skipAsComment(Lexer lexer) {
        this.advanceAs(lexer, OCTokenTypes.BLOCK_COMMENT);
    }

    private void processUndefineDirective(Lexer lexer) {
        this.advanceLexer(lexer);
        if (OCPreprocessingLexer.atDirectiveContent(lexer)) {
            CharSequence contents = LexerUtil.getTokenText((Lexer)lexer);
            this.addTokensFromDirective(lexer, contents, true, false);
            OCLexer l = new OCLexer(OCLanguageKind.CPP, false, false);
            l.start(contents);
            while (OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(l.getTokenType())) {
                l.advance();
            }
            if (l.getTokenType() == OCTokenTypes.IDENTIFIER) {
                this.myState.undef(LexerUtil.getTokenText((Lexer)l).toString());
            }
        } else {
            this.addToken(lexer.getTokenStart(), OCTokenTypes.END_OF_DIRECTIVE_CONTENT);
        }
    }

    private void processDefineDirective(Lexer baseLexer) {
        int offset = baseLexer.getTokenStart();
        this.advanceLexer(baseLexer);
        if (OCPreprocessingLexer.atDirectiveContent(baseLexer)) {
            CharSequence content = LexerUtil.getTokenText((Lexer)baseLexer);
            this.addTokensFromDirective(baseLexer, content, true, false);
            OCMacroSymbol def = OCMacroSymbol.parseFromDirectiveContent(content, this.myFile, offset);
            if (def != null) {
                this.myState.define(def);
            }
        } else {
            this.addToken(baseLexer.getTokenStart(), OCTokenTypes.END_OF_DIRECTIVE_CONTENT);
        }
    }

    private void addTokensFromDirective(Lexer baseLexer, CharSequence content, boolean dontSubstituteFirst, boolean evalDefined) {
        OCPreprocessingLexer lexer = new OCPreprocessingLexer(this.myState, this.myFile, evalDefined, 0, 0, this.myTotalMacroSubstitutionsCnt, this.myForcePreprocessingOfIncludes, this.myLineCount, dontSubstituteFirst, true);
        lexer.myInsideIfCondition = this.myInsideIfCondition;
        lexer.start(content, 0, content.length(), 8);
        int tokenStart = baseLexer.getTokenStart();
        while (lexer.getTokenType() != null) {
            IElementType originToken = lexer.getTokenType();
            OCElementType mappedToken = OCTokenTypes.KEYWORDS.contains(originToken) ? OCTokenTypes.IDENTIFIER : originToken;
            this.addToken(tokenStart + lexer.getTokenEnd(), mappedToken);
            lexer.advance();
        }
        this.addToken(baseLexer.getTokenEnd(), OCTokenTypes.END_OF_DIRECTIVE_CONTENT);
        baseLexer.advance();
    }

    @NotNull
    public OCInclusionContext getContext() {
        return this.myState;
    }

    @Nullable
    public OCFile getFile() {
        return this.myFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processMacroSubstitution(Lexer baseLexer, OCMacroSymbol macro, boolean advanceBaseLexer) {
        OCMacroSymbol possibleMacro;
        ProgressManager.checkCanceled();
        this.myTotalMacroSubstitutionsCnt.set((Object)((Integer)this.myTotalMacroSubstitutionsCnt.get() + 1));
        String id = macro.getName();
        LexerPosition pos = baseLexer.getCurrentPosition();
        if (advanceBaseLexer) {
            baseLexer.advance();
        }
        while (OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(baseLexer.getTokenType())) {
            baseLexer.advance();
        }
        boolean hasArgs = baseLexer.getTokenType() == OCTokenTypes.LPAR;
        baseLexer.restore(pos);
        if (macro.hasParameterList() && !hasArgs) {
            if (advanceBaseLexer) {
                this.advanceLexer(baseLexer);
            }
            return false;
        }
        if (advanceBaseLexer) {
            this.skipMacroToken(baseLexer, false, true);
        }
        OCImmutableList<String> params = macro.getParameterNames();
        List<String> args = macro.hasParameterList() ? this.buildSubstitutionArguments(baseLexer) : null;
        if ((Integer)this.myTotalMacroSubstitutionsCnt.get() > 200000) {
            return true;
        }
        if (this.myAddTokensFromDirective && !this.myInsideIfCondition) {
            return true;
        }
        SubstitutionResult subst = this.substitute(macro, (List<String>)((Object)params), OCPreprocessingLexer.buildParamIndices(params), OCPreprocessingLexer.buildParameterSubstitutionMap(params, args));
        TokenWrapper lastToken = null;
        String lastTokenName = null;
        int lastCacheSize = 0;
        OCMacroSymbol curDefinition = this.myState.getDefinition(id, OCImmutableInclusionContext.SignaturePart.NO);
        if (curDefinition != null) {
            this.myState.undef(id);
        }
        try {
            IElementType type;
            OCPreprocessingLexer substLexer = new OCPreprocessingLexer(this.myState, this.myFile, this.myEvalDefinedFunction, this.myMacroLevel + 1, this.myIncludeLevel, this.myTotalMacroSubstitutionsCnt, this.myForcePreprocessingOfIncludes, this.getLineCountCopy(), false, false);
            substLexer.myInsideIfCondition = this.myInsideIfCondition;
            String substString = subst.getString();
            substLexer.start(substString, 0, substString.length(), 8);
            List<Pair<Integer, TextRange>> substitutions = subst.getSubstitutions();
            int curSubstitutionIndex = 0;
            int offsetInSubstitution = 0;
            while ((type = substLexer.getTokenType()) != null) {
                TextRange range;
                Pair<Integer, TextRange> curSubstitution = curSubstitutionIndex < substitutions.size() ? substitutions.get(curSubstitutionIndex) : null;
                TextRange textRange = range = curSubstitution != null ? (TextRange)curSubstitution.getSecond() : null;
                if (OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(type)) {
                    this.addToken(baseLexer.getTokenStart(), type);
                } else if (type instanceof ForeignLeafType) {
                    if (type instanceof OCMacroForeignLeafType) {
                        ((OCMacroForeignLeafType)type).plungeIntoSubstitution(offsetInSubstitution);
                    }
                    this.updateBraceStack(((ForeignLeafType)type).getDelegate(), ((ForeignLeafType)type).getValue());
                    lastCacheSize = this.getCacheSize();
                    lastTokenName = ((ForeignLeafType)type).getValue();
                    lastToken = (ForeignLeafType)type;
                    this.addToken(baseLexer.getTokenStart(), type);
                    ++offsetInSubstitution;
                } else {
                    CharSequence tokenText = LexerUtil.getTokenText((Lexer)substLexer);
                    int macroArgumentIndex = -1;
                    TextRange rangeInMacroArgument = null;
                    if (range != null && substLexer.getTokenStart() >= range.getStartOffset()) {
                        if (curSubstitution.getFirst() != null) {
                            macroArgumentIndex = (Integer)curSubstitution.getFirst();
                        }
                        rangeInMacroArgument = new TextRange(substLexer.getTokenStart() - range.getStartOffset(), substLexer.getTokenEnd() - range.getStartOffset());
                    }
                    lastTokenName = tokenText.toString();
                    this.updateBraceStack(type, lastTokenName);
                    lastCacheSize = this.getCacheSize();
                    lastToken = new OCMacroForeignLeafType(type, tokenText, id, macroArgumentIndex, rangeInMacroArgument, offsetInSubstitution);
                    this.addToken(baseLexer.getTokenStart(), lastToken);
                    ++offsetInSubstitution;
                }
                substLexer.advance();
                if (range == null || substLexer.getTokenStart() < range.getEndOffset()) continue;
                ++curSubstitutionIndex;
            }
        }
        finally {
            if (curDefinition != null) {
                this.myState.define(curDefinition);
            }
        }
        if (lastTokenName != null && (possibleMacro = this.myState.getDefinition(lastTokenName)) != null && possibleMacro.hasParameterList() && possibleMacro != macro && this.processMacroSubstitution(baseLexer, possibleMacro, false)) {
            OCMacroForeignLeafType wrapped;
            OCMacroReferenceTokenType type = new OCMacroReferenceTokenType(lastToken.getDelegate(), lastTokenName, false, this.myMacroLevel, true);
            if (lastToken instanceof OCMacroForeignLeafType) {
                OCMacroForeignLeafType token = (OCMacroForeignLeafType)lastToken;
                wrapped = new OCMacroForeignLeafType(type, lastTokenName, token.getMacroName(), lastToken.getIndex(), token.getRangeInMacroArgument(), token.getOffsetInTopSubstitution());
            } else {
                wrapped = new OCMacroForeignLeafType(type, lastTokenName, null, 0, TextRange.EMPTY_RANGE, 0);
            }
            this.replaceCachedType(lastCacheSize, wrapped);
        }
        return true;
    }

    String preprocess(@NotNull CharSequence text, @NotNull PreprocessingMode mode) {
        IElementType tokenType;
        OCPreprocessingLexer lexer = new OCPreprocessingLexer(this.myState, this.myFile, false, 0, 0, this.myTotalMacroSubstitutionsCnt, true, this.getLineCountCopy(), false, false);
        lexer.start(text, 0, text.length(), mode == PreprocessingMode.FILE ? 0 : 1024);
        StringBuilder result = new StringBuilder();
        if (mode == PreprocessingMode.FIRST_MACRO_ARG || mode == PreprocessingMode.OTHER_MACRO_ARGS) {
            boolean hasLeadingWS = false;
            while (OCTokenTypes.WHITESPACES.contains(lexer.getTokenType())) {
                hasLeadingWS = true;
                lexer.advance();
            }
            if (hasLeadingWS && mode == PreprocessingMode.OTHER_MACRO_ARGS) {
                result.append(" ");
            }
        }
        int parenCount = 0;
        int directiveDepth = 0;
        int macroDepth = 0;
        boolean inMacro = false;
        while ((tokenType = lexer.getTokenType()) != null) {
            while (tokenType instanceof OCMacroForeignLeafType) {
                tokenType = ((OCMacroForeignLeafType)tokenType).getDelegate();
            }
            if (tokenType == OCTokenTypes.DEFINE_DIRECTIVE) {
                inMacro = true;
                macroDepth = directiveDepth++;
            } else if (OCTokenTypes.DIRECTIVES.contains(tokenType)) {
                if (!NON_CLOSING_DIRECTIVES.contains(tokenType)) {
                    ++directiveDepth;
                }
            } else if (tokenType == OCTokenTypes.END_OF_DIRECTIVE_CONTENT || tokenType == OCTokenTypes.DIRECTIVE_CONTENT) {
                if (--directiveDepth == macroDepth) {
                    inMacro = false;
                }
            } else if (OCTokenTypes.END_IF_DIRECTIVES.contains(tokenType)) {
                --directiveDepth;
            } else if (tokenType instanceof OCMacroReferenceTokenType) {
                IElementType delegate = tokenType;
                while (delegate instanceof OCMacroReferenceTokenType) {
                    delegate = ((OCMacroReferenceTokenType)delegate).getDelegate();
                }
                if (delegate == OCTokenTypes.LPAR) {
                    ++parenCount;
                } else if (delegate == OCTokenTypes.RPAR) {
                    --parenCount;
                }
            } else if (parenCount == 0 && directiveDepth == 0 && !inMacro && !SKIP_TOKENS.contains(tokenType)) {
                String tokenText = OCPreprocessingLexer.getPreprocessedTokenText((Lexer)lexer, mode != PreprocessingMode.DIRECTIVE_CONTENTS);
                result.append(tokenText);
            }
            lexer.advance();
        }
        return result.toString();
    }

    private static String getPreprocessedTokenText(Lexer lexer, boolean skipComments) {
        IElementType tokenType = lexer.getTokenType();
        if (tokenType instanceof TokenWrapper) {
            return ((TokenWrapper)tokenType).getValue();
        }
        if (skipComments && OCTokenTypes.COMMENTS.contains(tokenType)) {
            return "";
        }
        String text = lexer.getBufferSequence().subSequence(lexer.getTokenStart(), lexer.getTokenEnd()).toString();
        if (tokenType == TokenType.WHITE_SPACE && StringUtil.isEmpty((String)text)) {
            return " ";
        }
        return text;
    }

    private SubstitutionResult substitute(OCMacroSymbol macro, List<String> params, Map<String, Integer> paramIndices, Map<String, String> paramSubst) {
        OCLexer lexer = new OCLexer();
        String substitution = LINE_MACRO.equals(macro.getName()) ? String.valueOf(this.myLineCount.get()) : macro.getSubstitution();
        lexer.start(substitution, 0, substitution.length(), 8);
        THashMap substitutionMap = new THashMap(params.size());
        SubstitutionResult result = new SubstitutionResult();
        boolean haveHashPrefix = false;
        boolean haveHashHashPrefix = false;
        while (lexer.getTokenType() != null) {
            boolean hasSpace;
            String token = LexerUtil.getTokenText((Lexer)lexer).toString();
            IElementType tt = lexer.getTokenType();
            if (tt == OCTokenTypes.HASH) {
                haveHashPrefix = true;
                result.onHashOperator();
                lexer.advance();
                continue;
            }
            if (tt == OCTokenTypes.HASHHASH) {
                haveHashHashPrefix = true;
                lexer.advance();
                continue;
            }
            if (tt == OCTokenTypes.UNKNOWN_DIRECTIVE || tt == OCTokenTypes.IDENTIFIER || OCTokenTypes.KEYWORDS.contains(tt) || OCElementUtil.isAlternativeCppPunctuator(tt, token)) {
                lexer.advance();
                hasSpace = false;
                while (OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(lexer.getTokenType())) {
                    lexer.advance();
                    hasSpace = true;
                }
                boolean substitute = !haveHashHashPrefix && lexer.getTokenType() != OCTokenTypes.HASHHASH;
                boolean hashPrefix = tt == OCTokenTypes.UNKNOWN_DIRECTIVE || haveHashPrefix;
                String tokenText = tt == OCTokenTypes.UNKNOWN_DIRECTIVE ? token.substring(1) : token;
                this.processIndent(paramSubst, paramIndices, result, hashPrefix, substitute, tokenText, (Map<String, String>)substitutionMap);
                if (!hasSpace || lexer.getTokenType() == OCTokenTypes.HASHHASH) continue;
                result.append(" ");
                continue;
            }
            hasSpace = false;
            while (OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(lexer.getTokenType())) {
                lexer.advance();
                hasSpace = true;
            }
            if (hasSpace) {
                if (haveHashPrefix || haveHashHashPrefix || lexer.getTokenType() == OCTokenTypes.HASHHASH) continue;
                result.append(" ");
                continue;
            }
            lexer.advance();
            result.append(token);
            haveHashHashPrefix = false;
            haveHashPrefix = false;
        }
        return result;
    }

    private void processIndent(Map<String, String> paramSubst, Map<String, Integer> paramIndices, SubstitutionResult result, boolean haveHashPrefix, boolean substitute, String token, Map<String, String> substitutionCache) {
        String subst = paramSubst.get(token);
        Integer index = paramIndices.get(token);
        if (subst == null) {
            subst = paramSubst.get(token + "...");
        }
        if (index == null) {
            index = paramIndices.get(token + "...");
        }
        if (subst != null) {
            if (haveHashPrefix) {
                String content = OCPreprocessingLexer.stringify(OCPreprocessingLexer.revertMacroStubs(subst));
                if (index != null) {
                    result.addSubstitution(index, content.length());
                }
                result.append(content);
            } else {
                if (substitute) {
                    if (substitutionCache.containsKey(subst)) {
                        subst = substitutionCache.get(subst);
                    } else {
                        String processed2 = this.preprocess(subst, PreprocessingMode.FIRST_MACRO_ARG);
                        substitutionCache.put(subst, processed2);
                        subst = processed2;
                    }
                } else if ((subst = StringUtil.trimLeading((String)OCPreprocessingLexer.revertMacroStubs(subst))).isEmpty() && VA_ARGS_TOKEN.equals(token)) {
                    result.removeLastComma();
                }
                if (index != null) {
                    if (VA_ARGS_TOKEN.equals(token)) {
                        String curSubst;
                        int i = 0;
                        while ((curSubst = paramSubst.get(token + "..." + i)) != null) {
                            if (!curSubst.equals(VARARG_MACRO_PARAMS_SEPARATOR)) {
                                Integer n = index;
                                Integer n2 = index = Integer.valueOf(index + 1);
                                result.addSubstitution(n, curSubst.length());
                            }
                            PreprocessingMode mode = i == 0 ? PreprocessingMode.FIRST_MACRO_ARG : PreprocessingMode.OTHER_MACRO_ARGS;
                            result.append(this.preprocess(curSubst, mode));
                            ++i;
                        }
                    } else {
                        result.addSubstitution(index, subst.length());
                        result.append(subst);
                    }
                } else {
                    result.append(subst);
                }
            }
        } else {
            result.append(token);
        }
    }

    private static String revertMacroStubs(String subst) {
        return OCPreprocessingLexer.lineNumberFromStub(subst) != null ? LINE_MACRO : subst;
    }

    private static String stringify(String source) {
        OCLexer lexer = new OCLexer();
        lexer.start(source);
        while (OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(lexer.getTokenType())) {
            lexer.advance();
        }
        if (lexer.getTokenType() == null) {
            return "\"\"";
        }
        StringBuilder acc = new StringBuilder();
        acc.append("\"");
        boolean wasSpace = false;
        while (lexer.getTokenType() != null) {
            if (wasSpace) {
                acc.append(" ");
            }
            IElementType tt = lexer.getTokenType();
            String content = lexer.getTokenText();
            if (tt == OCTokenTypes.STRING_LITERAL || tt == OCTokenTypes.CHARACTER_LITERAL) {
                content = StringUtil.escapeStringCharacters((String)content);
            }
            acc.append(content);
            lexer.advance();
            wasSpace = false;
            while (OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(lexer.getTokenType())) {
                lexer.advance();
                wasSpace = true;
            }
        }
        acc.append("\"");
        return acc.toString();
    }

    private static Map<String, Integer> buildParamIndices(List<String> params) {
        if (params == null || params.size() == 0) {
            return Collections.emptyMap();
        }
        HashMap answer = new HashMap();
        int count = 0;
        for (String param : params) {
            answer.put((Object)param, (Object)count++);
        }
        return answer;
    }

    private static Map<String, String> buildParameterSubstitutionMap(List<String> parameterNames, List<String> args) {
        if (args == null || args.size() == 0) {
            return Collections.emptyMap();
        }
        HashMap paramSubst = new HashMap();
        int count = 0;
        for (String name : parameterNames) {
            if (name.endsWith("...")) {
                StringBuilder opts = new StringBuilder();
                int extraArgsCnt = 0;
                for (int i = count; i < args.size(); ++i) {
                    boolean first;
                    String argText = args.get(i);
                    boolean bl = first = i == count;
                    if (!first) {
                        opts.append(VARARG_MACRO_PARAMS_SEPARATOR);
                        paramSubst.put(name + extraArgsCnt++, VARARG_MACRO_PARAMS_SEPARATOR);
                    }
                    if (i == args.size() - 1) {
                        argText = StringUtil.trimTrailing((String)argText);
                    }
                    opts.append(argText);
                    paramSubst.put(name + extraArgsCnt++, argText);
                }
                paramSubst.put(name, opts.toString());
                break;
            }
            paramSubst.put(name, count >= args.size() ? "" : StringUtil.trimTrailing((String)args.get(count)));
            ++count;
        }
        return paramSubst;
    }

    private static class SubstitutionResult {
        private StringBuilder myString = new StringBuilder();
        private List<Pair<Integer, TextRange>> mySubstitutions = new ArrayList<Pair<Integer, TextRange>>();

        private SubstitutionResult() {
        }

        public String getString() {
            return this.myString.toString();
        }

        private void append(String string) {
            this.myString.append(string);
        }

        private void addSubstitution(int argumentIndex, int substLength) {
            this.mySubstitutions.add((Pair<Integer, TextRange>)new Pair((Object)argumentIndex, (Object)new TextRange(this.myString.length(), this.myString.length() + substLength)));
        }

        public List<Pair<Integer, TextRange>> getSubstitutions() {
            return this.mySubstitutions;
        }

        public void removeLastComma() {
            int lastIndex;
            for (lastIndex = this.myString.length() - 1; lastIndex >= 0 && this.myString.charAt(lastIndex) == ' '; --lastIndex) {
            }
            if (lastIndex >= 0 && this.myString.charAt(lastIndex) == ',') {
                this.myString.setLength(lastIndex);
            }
        }

        public void onHashOperator() {
            int end;
            int scanPos;
            for (scanPos = end = this.myString.length(); scanPos > 0 && Character.isJavaIdentifierPart(this.myString.charAt(scanPos - 1)); --scanPos) {
            }
            if (scanPos != end && OCStringLiteralUtil.isStringLiteralPrefix(this.myString.substring(scanPos, end))) {
                this.myString.append(" ");
            }
        }
    }

    static enum PreprocessingMode {
        FILE,
        DIRECTIVE_CONTENTS,
        FIRST_MACRO_ARG,
        OTHER_MACRO_ARGS;

    }

    private static enum CurrentState {
        NONE,
        AFTER_EXTERN,
        AFTER_EXTERN_C,
        AFTER_PROTOCOL,
        AFTER_AT,
        AFTER_MODULE_IMPORT;

    }
}

