/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.preprocessor;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCModuleResolver {
    private static final ExtensionPointName<OCModuleResolver> EP_NAME = ExtensionPointName.create((String)"cidr.lang.moduleResolver");

    public static boolean processModuleImports(@NotNull OCInclusionContext context, @NotNull List<String> moduleNameParts, @NotNull Processor<VirtualFile> headerProcessor) {
        boolean result = true;
        for (OCModuleResolver resolver : (OCModuleResolver[])EP_NAME.getExtensions()) {
            result &= resolver.processImports(context, moduleNameParts, headerProcessor);
        }
        return result;
    }

    @Nullable
    public static String getGuessedPath(@NotNull List<String> moduleNameParts) {
        if (moduleNameParts.isEmpty()) {
            return null;
        }
        if (moduleNameParts.size() == 1) {
            String name = moduleNameParts.get(0);
            return name + "/" + name + ".h";
        }
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<String> iterator = moduleNameParts.iterator();
        while (iterator.hasNext()) {
            String part = iterator.next();
            stringBuilder.append(part);
            if (!iterator.hasNext()) continue;
            stringBuilder.append("/");
        }
        stringBuilder.append(".h");
        return stringBuilder.toString();
    }

    protected abstract boolean processImports(@NotNull OCInclusionContext var1, @NotNull List<String> var2, @NotNull Processor<VirtualFile> var3);
}

