/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.preprocessor;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.impl.source.tree.ForeignLeafPsiElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.jetbrains.cidr.lang.preprocessor.OCMacroForeignLeafType;

public class OCMacroForeignLeafElement
extends ForeignLeafPsiElement {
    private String myMacroName;
    private int myMacroArgumentIndex;
    private TextRange myRangeInMacroArgument;
    private int myOffsetInTopSubstitution;

    public OCMacroForeignLeafElement(OCMacroForeignLeafType type, CharSequence text, String macroName, int macroArgumentIndex, TextRange rangeInMacroArgument, int inSubstitutionOffset) {
        super(type, text);
        this.myMacroName = macroName;
        this.myMacroArgumentIndex = macroArgumentIndex;
        this.myRangeInMacroArgument = rangeInMacroArgument;
        this.myOffsetInTopSubstitution = inSubstitutionOffset;
    }

    public int getMacroArgumentIndex() {
        return this.myMacroArgumentIndex;
    }

    public TextRange getRangeInMacroArgument() {
        return this.myRangeInMacroArgument;
    }

    public String getMacroName() {
        return this.myMacroName;
    }

    public int getOffsetInTopSubstitution() {
        return this.myOffsetInTopSubstitution;
    }

    public int getRealStartOffset() {
        int result = 0;
        TreeElement current = this;
        while (current.getTreeParent() != null) {
            result += current.getStartOffsetInParent();
            current = current.getTreeParent();
        }
        return result;
    }

    public TextRange getRealTextRange() {
        int offset = this.getRealStartOffset();
        return new TextRange(offset, offset);
    }

    public void copyFromElement(OCMacroForeignLeafElement element) {
        this.myMacroName = element.myMacroName;
        this.myMacroArgumentIndex = element.myMacroArgumentIndex;
        this.myRangeInMacroArgument = element.myRangeInMacroArgument;
        this.myOffsetInTopSubstitution = element.myOffsetInTopSubstitution;
    }
}

