/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.preprocessor;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.NotNullFunction;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.SmartHashSet;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCIncludeHelpers;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageStandard;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.lexer.OCLexer;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.preprocessor.OCContextChange;
import com.jetbrains.cidr.lang.preprocessor.OCContextChangeBuilder;
import com.jetbrains.cidr.lang.preprocessor.OCContextChangeBuilderImpl;
import com.jetbrains.cidr.lang.preprocessor.OCContextChangeSet;
import com.jetbrains.cidr.lang.preprocessor.OCImmutableInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCImportGraph;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.preprocessor.OCInitialInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCParsingNameScope;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCIncludeSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCMacroSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCTemplateSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCTypeParameterTypeSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCTypeParameterValueSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCUndefMacroSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCUsingSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.ContextSignature;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTable;
import com.jetbrains.cidr.lang.toolchains.CidrCompilerSwitches;
import com.jetbrains.cidr.lang.util.OCCommonProcessors;
import com.jetbrains.cidr.lang.util.OCImmutableList;
import com.jetbrains.cidr.lang.workspace.OCLanguageKindCalculator;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCResolveRootAndConfiguration;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceManager;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerMacros;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCInclusionContext
implements OCImmutableInclusionContext {
    public static final Key<Integer> MAX_INCLUSION_LEVEL_KEY = Key.create((String)"MAX_INCLUSION_LEVE_KEY");
    private static final int DEFAULT_MAX_INCLUSION_LEVEL = 256;
    @NotNull
    private final OCLanguageKind myLanguageKind;
    private final boolean myNotifyLocalDefinitions;
    @Nullable
    private final OCResolveConfiguration myConfiguration;
    @NotNull
    private final Project myProject;
    private THashSet<String> myNeverRefefineMacros = new SmartHashSet();
    @NotNull
    private final Map<String, OCMacroSymbol> mySubstitutions = new THashMap();
    @NotNull
    private final Set<String> myUndefList = new THashSet();
    @NotNull
    private volatile OCParsingNameScope myNameScope;
    @NotNull
    private final Set<VirtualFile> myProcessedFiles = new THashSet();
    @Nullable
    private final OCInclusionContext myParentContext;
    private final int myInclusionLevel;
    @Nullable
    private PsiFile myRootFile;
    @Nullable
    private OCFile myPrecompiledHeader;
    @Nullable
    private SignatureBuilder mySignatureBuilder = null;
    private Processor<OCSymbol> myProcessingListener;
    @Nullable
    private OCContextChangeBuilder myChangeBuilder;
    private static final NotNullLazyKey<Ref<OCFile>, OCResolveConfiguration> PREP_FILE = NotNullLazyKey.create((String)"PREP_FILE", (NotNullFunction)new NotNullFunction<OCResolveConfiguration, Ref<OCFile>>(){

        @NotNull
        public Ref<OCFile> fun(OCResolveConfiguration config) {
            PsiFile pchPsi;
            if (config == null) {
                return Ref.create();
            }
            VirtualFile pchFile = config.getPrecompiledHeader();
            if (pchFile != null && pchFile.isValid() && (pchPsi = PsiManager.getInstance((Project)config.getProject()).findFile(pchFile)) instanceof OCFile) {
                return Ref.create((Object)((OCFile)pchPsi));
            }
            return Ref.create();
        }
    });
    private static final NotNullLazyKey<Map<FileSymbolTable, Boolean>, OCResolveConfiguration> INCLUDE_RESOLVE_CACHE = NotNullLazyKey.create((String)"INCLUDE_RESOLVE_CACHE", (NotNullFunction)new NotNullFunction<OCResolveConfiguration, Map<FileSymbolTable, Boolean>>(){

        @NotNull
        public Map<FileSymbolTable, Boolean> fun(OCResolveConfiguration dom) {
            return ContainerUtil.createConcurrentWeakMap();
        }
    });
    private static final NotNullLazyKey<MultiMap<VirtualFile, OCResolveConfiguration>, Project> PCH_TO_CONFIGURATION_CACHE = NotNullLazyKey.create((String)"PCH_TO_CONFIGURATION_CACHE", (NotNullFunction)new NotNullFunction<Project, MultiMap<VirtualFile, OCResolveConfiguration>>(){

        @NotNull
        public MultiMap<VirtualFile, OCResolveConfiguration> fun(Project project2) {
            MultiMap result = new MultiMap();
            for (OCResolveConfiguration oCResolveConfiguration : OCWorkspaceManager.getWorkspace(project2).getConfigurations()) {
                VirtualFile file2;
                OCFile pch = OCInclusionContext.getPrecompiledHeader(oCResolveConfiguration);
                if (pch == null || (file2 = OCInclusionContextUtil.getVirtualFile(pch)) == null) continue;
                result.putValue((Object)file2, (Object)oCResolveConfiguration);
            }
            return result;
        }
    });
    private static final NotNullLazyKey<Couple<ConcurrentHashMap<String, OCImmutableInclusionContext>>, OCResolveConfiguration> INITIAL_PLAIN_AND_PCH_CONTEXTS_KEY = NotNullLazyKey.create((String)"INITIAL_CONTEXTS_KEY", (NotNullFunction)new NotNullFunction<OCResolveConfiguration, Couple<ConcurrentHashMap<String, OCImmutableInclusionContext>>>(){

        @NotNull
        public Couple<ConcurrentHashMap<String, OCImmutableInclusionContext>> fun(OCResolveConfiguration p) {
            return Couple.of(new ConcurrentHashMap(), new ConcurrentHashMap());
        }
    });

    public static int getMaxInclusionLevel(@Nullable Project project2) {
        Integer predefined = project2 != null ? (Integer)project2.getUserData(MAX_INCLUSION_LEVEL_KEY) : null;
        return predefined != null ? predefined : 256;
    }

    protected OCInclusionContext(@Nullable OCResolveConfiguration configuration, @NotNull Project project2, @NotNull OCLanguageKind languageKind) {
        assert (configuration == null || project2.equals(configuration.getProject()));
        this.myConfiguration = configuration;
        this.myProject = project2;
        this.myLanguageKind = languageKind;
        this.myNameScope = new OCParsingNameScope();
        this.myParentContext = null;
        this.myInclusionLevel = 0;
        this.myNotifyLocalDefinitions = false;
    }

    private OCInclusionContext(@Nullable OCResolveConfiguration configuration, @NotNull Project project2, @NotNull OCInclusionContext parentContext, @NotNull PsiFile rootFile, @NotNull OCParsingNameScope nameScope, boolean notifyLocalDefinitions) {
        this.myConfiguration = configuration;
        this.myProject = project2;
        this.myLanguageKind = parentContext.myLanguageKind;
        this.myParentContext = parentContext;
        this.myRootFile = rootFile;
        this.myNameScope = nameScope;
        this.myInclusionLevel = this.myParentContext.myInclusionLevel + 1;
        this.myNotifyLocalDefinitions = notifyLocalDefinitions;
        OCLog.LOG.assertTrue(this.myInclusionLevel <= OCInclusionContext.getMaxInclusionLevel(configuration != null ? configuration.getProject() : null) + 2, (Object)"Inclusion level is too high");
    }

    public static boolean isPrecompiledHeader(@NotNull VirtualFile file2, @NotNull OCResolveConfiguration configuration) {
        OCFile pch = OCInclusionContext.getPrecompiledHeader(configuration);
        return pch != null && file2.equals(OCInclusionContextUtil.getVirtualFile(pch));
    }

    @Override
    @NotNull
    public OCLanguageKind getLanguageKind() {
        return this.myLanguageKind;
    }

    public void addProcessedFile(@NotNull VirtualFile file2) {
        if (this.myChangeBuilder != null) {
            this.myChangeBuilder.addProcessedFile(file2);
        }
        this.myProcessedFiles.add(file2);
    }

    @NotNull
    public static Collection<OCResolveConfiguration> getBuildConfigurationByPchFile(@Nullable VirtualFile pchFile, @NotNull Project project2) {
        return ((MultiMap)PCH_TO_CONFIGURATION_CACHE.getValue((UserDataHolder)project2)).get((Object)pchFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkConformanceAndFillSignatures(@NotNull FileSymbolTable table) {
        this.enterConformanceCheckMode();
        boolean isCompatibleTable = false;
        try {
            ContextSignature sig = table.getSignature();
            if (sig.isCompatible(this)) {
                isCompatibleTable = this.myConfiguration == null || this.conformsToByIncludes(table);
            }
            boolean bl = isCompatibleTable;
            return bl;
        }
        finally {
            this.exitConformanceCheckMode(isCompatibleTable);
        }
    }

    public void setProcessingListener(@Nullable Processor<OCSymbol> processingListener) {
        this.myProcessingListener = processingListener;
    }

    public void setChangeBuilder(@Nullable OCContextChangeBuilder changeBuilder) {
        this.myChangeBuilder = changeBuilder;
    }

    private boolean conformsToByIncludes(final @NotNull FileSymbolTable table) {
        Map<FileSymbolTable, Boolean> resolveCache = this.getSymbolTablesConformingCache();
        Boolean conforms = resolveCache.get(table);
        if (conforms == null) {
            conforms = table.processIncludes(new Processor<OCIncludeSymbol>(){

                public boolean process(OCIncludeSymbol symbol) {
                    VirtualFile resolved;
                    VirtualFile targetFile = symbol.getTargetFile();
                    VirtualFile owner = table.getContainingFile();
                    OCIncludeSymbol.IncludePath path = symbol.getIncludePath();
                    Project project2 = table.getProject();
                    OCResolveRootAndConfiguration conf = OCInclusionContext.this.getRootAndConfiguration();
                    if (symbol.isNext()) {
                        Ref r = new Ref();
                        OCIncludeHelpers.resolveNextIncludedFile(conf, owner, owner, path, project2, (Ref<VirtualFile>)r);
                        resolved = (VirtualFile)r.get();
                    } else {
                        resolved = OCIncludeHelpers.resolveIncludedFile(conf, owner, path, project2);
                    }
                    return Comparing.equal((Object)targetFile, (Object)resolved);
                }
            });
            resolveCache.put(table, conforms);
        }
        return conforms;
    }

    @Override
    public int getInclusionLevel() {
        return this.myInclusionLevel;
    }

    @Override
    @Nullable
    public OCImmutableInclusionContext getParent() {
        return this.myParentContext;
    }

    public void setPrecompiledHeader(@Nullable OCFile precompiledHeader) {
        this.myPrecompiledHeader = precompiledHeader;
    }

    @Override
    @Nullable
    public OCFile getPrecompiledHeader() {
        if (this.myPrecompiledHeader != null) {
            return this.myPrecompiledHeader;
        }
        return this.myParentContext == null ? null : this.myParentContext.getPrecompiledHeader();
    }

    @Override
    public boolean hasRootFile() {
        return this.myRootFile != null;
    }

    @Override
    @NotNull
    public PsiFile getRootFile() {
        if (this.myRootFile == null) {
            OCLog.LOG.error("No root file");
        }
        return this.myRootFile;
    }

    private OCInclusionContext setRootFile(@Nullable PsiFile file2) {
        if (this.myRootFile != null && file2 != null) {
            throw new IllegalStateException("Trying to change root file for inclusion context with existing root file");
        }
        this.myRootFile = file2;
        return this;
    }

    public static void onPrecompiledContextChange(@Nullable OCResolveConfiguration configuration) {
        if (configuration == null) {
            return;
        }
        Project project2 = configuration.getProject();
        if (project2.isDisposed()) {
            return;
        }
        configuration.putUserData((Key)PREP_FILE, null);
        configuration.putUserData((Key)INITIAL_PLAIN_AND_PCH_CONTEXTS_KEY, null);
    }

    public static void clearSymbolTableConformanceCache(OCResolveConfiguration configuration) {
        if (configuration == null) {
            return;
        }
        Project project2 = configuration.getProject();
        if (project2.isDisposed()) {
            return;
        }
        configuration.putUserData((Key)INCLUDE_RESOLVE_CACHE, null);
        project2.putUserData(PCH_TO_CONFIGURATION_CACHE, null);
    }

    @NotNull
    public static OCInclusionContext empty(@NotNull OCLanguageKind kind, @NotNull PsiFile file2) {
        return new OCInclusionContext(null, file2.getProject(), kind).setRootFile(file2);
    }

    @NotNull
    static OCInclusionContext emptyWithBuiltinMacros(@Nullable OCLanguageKind kind, @NotNull PsiFile file2) {
        if (kind == null) {
            kind = OCLanguageKindCalculator.calculateLanguageKindFast(file2);
        }
        OCInclusionContext result = OCInclusionContext.empty(kind, file2);
        OCCompilerMacros.BUILT_INS.fillContext(result, file2);
        return result;
    }

    @NotNull
    public static OCInclusionContext beforePCHFileContext(@NotNull OCFile file2) {
        OCResolveConfiguration configuration = OCInclusionContextUtil.getActiveConfiguration(file2);
        return configuration == null ? OCInclusionContext.emptyWithBuiltinMacros(file2.getKind(), file2) : OCInclusionContext.beforePCHFileContext(configuration, file2.getKind(), file2);
    }

    @NotNull
    public static OCInclusionContext beforePCHFileContext(@NotNull OCResolveConfiguration configuration, @NotNull OCLanguageKind kind, @NotNull PsiFile file2) {
        return OCInclusionContext.initialContextWithoutRoot(configuration, kind, file2).derive(file2);
    }

    @NotNull
    public static OCInclusionContext sourceParsingContext(@NotNull OCResolveConfiguration configuration, @NotNull OCLanguageKind kind, @NotNull PsiFile file2) {
        return OCInclusionContext.initialPCHContextWithoutRoot(configuration, kind, file2).derive(file2);
    }

    @NotNull
    public static OCImmutableInclusionContext initialContextWithoutRoot(@NotNull OCResolveConfiguration configuration, @NotNull OCLanguageKind kind, @NotNull PsiFile file2) {
        ConcurrentHashMap switches2context = (ConcurrentHashMap)((Couple)OCInclusionContext.INITIAL_PLAIN_AND_PCH_CONTEXTS_KEY.getValue((UserDataHolder)configuration)).first;
        VirtualFile virtualFile = OCInclusionContextUtil.getVirtualFile(file2);
        Pair<String, CidrCompilerSwitches> keys = configuration.getCompilerSettings().getCompilerKeyAndSwitches(kind, virtualFile);
        OCImmutableInclusionContext context = (OCImmutableInclusionContext)switches2context.get(keys.first);
        if (context != null) {
            return context;
        }
        OCInitialInclusionContext ret = new OCInitialInclusionContext((CidrCompilerSwitches)keys.second, configuration, configuration.getProject(), kind);
        configuration.getCompilerMacros().fillContext(ret, file2);
        OCImmutableInclusionContext existing = switches2context.putIfAbsent(keys.first, ret);
        return existing == null ? ret : existing;
    }

    @NotNull
    public static OCImmutableInclusionContext initialPCHContextWithoutRoot(@NotNull OCResolveConfiguration configuration, @NotNull OCLanguageKind kind, @NotNull PsiFile file2) {
        OCFile pch = OCInclusionContext.getPrecompiledHeader(configuration);
        VirtualFile virtualFile = OCInclusionContextUtil.getVirtualFile(file2);
        if (!kind.supportsPrecompiledHeaders() || pch == null || virtualFile != null && OCInclusionContext.isPrecompiledHeader(virtualFile, configuration)) {
            return OCInclusionContext.initialContextWithoutRoot(configuration, kind, file2);
        }
        ConcurrentHashMap switches2context = (ConcurrentHashMap)((Couple)OCInclusionContext.INITIAL_PLAIN_AND_PCH_CONTEXTS_KEY.getValue((UserDataHolder)configuration)).second;
        String key = configuration.getCompilerSettings().getCompilerKey(kind, virtualFile);
        OCImmutableInclusionContext context = (OCImmutableInclusionContext)switches2context.get(key);
        if (context != null) {
            return context;
        }
        OCImmutableInclusionContext initial = OCInclusionContext.initialContextWithoutRoot(configuration, kind, file2);
        OCInclusionContext ctx = initial.derive(pch);
        ctx.setPrecompiledHeader(pch);
        ctx.preprocessInclude(pch, true);
        ctx.setRootFile(null);
        OCImmutableInclusionContext existing = switches2context.putIfAbsent(key, ctx);
        return existing == null ? ctx : existing;
    }

    @Nullable
    public static OCImmutableInclusionContext tryFindInCachedPCHPrecompiledContexts(@NotNull OCResolveConfiguration config, @NotNull VirtualFile header, @NotNull VirtualFile pchCandidate) {
        if (OCInclusionContext.isPrecompiledHeader(pchCandidate, config) && OCImportGraph.getAllRootHeaders(config, pchCandidate, null).contains(header)) {
            return OCInclusionContext.findInCachedPCHPrecompiledContexts(config, header);
        }
        return null;
    }

    @Nullable
    private static OCImmutableInclusionContext findInCachedPCHPrecompiledContexts(@NotNull OCResolveConfiguration config, @NotNull VirtualFile header) {
        Collection values = ((ConcurrentHashMap)((Couple)OCInclusionContext.INITIAL_PLAIN_AND_PCH_CONTEXTS_KEY.getValue((UserDataHolder)config)).second).values();
        OCImmutableInclusionContext bestContext = null;
        for (OCImmutableInclusionContext each : values) {
            OCLanguageKind eachContextLang = each.getLanguageKind();
            assert (eachContextLang.supportsPrecompiledHeaders());
            if (!each.isProcessed(header)) continue;
            assert (eachContextLang instanceof CLanguageKind);
            if (bestContext != null && bestContext.getLanguageKind() != CLanguageKind.min((CLanguageKind)eachContextLang, (CLanguageKind)bestContext.getLanguageKind())) continue;
            bestContext = each;
        }
        return bestContext;
    }

    @Nullable
    private static OCFile getPrecompiledHeader(@NotNull OCResolveConfiguration configuration) {
        return (OCFile)((Ref)PREP_FILE.getValue((UserDataHolder)configuration)).get();
    }

    private Map<FileSymbolTable, Boolean> getSymbolTablesConformingCache() {
        if (this.myConfiguration == null) {
            return new THashMap();
        }
        return (Map)INCLUDE_RESOLVE_CACHE.getValue((UserDataHolder)this.myConfiguration);
    }

    public void localDefine(String name, String value) {
        if (this.myConfiguration != null && this.canBeDefined(name)) {
            this.mySubstitutions.put(name, new OCMacroSymbol(this.myConfiguration.getProject(), null, 0, name, null, value));
        }
    }

    public Map<String, OCMacroSymbol> getSubstitutions() {
        assert (this.isInitial()) : "Operation is only supported for initial context";
        return this.mySubstitutions;
    }

    public boolean isInitial() {
        return this.myParentContext == null;
    }

    @NotNull
    public OCParsingNameScope getNameScope() {
        return this.myNameScope;
    }

    @Override
    @NotNull
    public OCInclusionContext derive() {
        if (this.myRootFile == null) {
            throw new IllegalStateException("Deriving from context without root file. Use 'derive(PsiFile)' instead");
        }
        return new OCInclusionContext(this.myConfiguration, this.myProject, this, this.myRootFile, this.myNameScope.copy(), true);
    }

    @Override
    @NotNull
    public OCInclusionContext derive(@NotNull PsiFile file2) {
        if (this.myRootFile != null) {
            throw new IllegalStateException("Deriving from context with existing root file. Use 'derive()' instead");
        }
        return new OCInclusionContext(this.myConfiguration, this.myProject, this, file2, this.myNameScope.copy(), true);
    }

    @Override
    @NotNull
    public OCInclusionContext derive(@NotNull OCParsingNameScope nameScope) {
        if (this.myRootFile == null) {
            throw new IllegalStateException("Deriving from context without root file. Use 'derive(PsiFile)' instead");
        }
        return new OCInclusionContext(this.myConfiguration, this.myProject, this, this.myRootFile, nameScope, true);
    }

    public OCInclusionContext deriveButDontCopyTypes(boolean notifyLocalDefinitions) {
        if (this.myRootFile == null) {
            throw new IllegalStateException("Deriving from context without root file. Use 'derive(PsiFile)' instead");
        }
        return new OCInclusionContext(this.myConfiguration, this.myProject, this, this.myRootFile, this.myNameScope, notifyLocalDefinitions);
    }

    public void define(OCMacroSymbol def) {
        String name = def.getName();
        if (this.canBeDefined(name)) {
            this.myUndefList.remove(name);
            this.mySubstitutions.put(name, def);
            if (this.myChangeBuilder != null) {
                this.myChangeBuilder.define(name, def);
            }
        }
    }

    public void define(String def, String content) {
        this.define(new OCMacroSymbol(this.getProject(), null, 0, def, OCImmutableList.emptyList(), content));
    }

    public void undef(String name) {
        if (this.canBeDefined(name)) {
            this.myUndefList.add(name);
            this.mySubstitutions.remove(name);
            if (this.myChangeBuilder != null) {
                this.myChangeBuilder.undef(name);
            }
        }
    }

    private boolean canBeDefined(String name) {
        if (name == null) {
            return false;
        }
        if (this.myNeverRefefineMacros.contains((Object)name)) {
            return false;
        }
        return this.myParentContext == null || this.myParentContext.canBeDefined(name);
    }

    public void addNeverRedefineMacros(Collection<String> macros) {
        this.myNeverRefefineMacros.addAll(macros);
    }

    public boolean isDefined(String name) {
        return this.getDefinition(name, OCImmutableInclusionContext.SignaturePart.HAS_DEFINITION) != null;
    }

    @Override
    @NotNull
    public OCLanguageStandard getLanguageStandard() {
        String std = this.getDefinitionUnprocessedValue("__STDC__");
        String c = this.getDefinitionUnprocessedValue("__STDC_VERSION__");
        String cpp = this.getDefinitionUnprocessedValue("__cplusplus");
        OCLanguageStandard cppStandard = OCCompilerMacros.CPP_VERSION_TO_STANDARD_MAP.get(cpp);
        OCLanguageStandard cStandard = OCCompilerMacros.C_VERSION_TO_STANDARD_MAP.get(c);
        if (cppStandard != null) {
            return cppStandard;
        }
        if (cStandard != null) {
            return cStandard;
        }
        if (Comparing.equal((String)"1", (String)std)) {
            return OCLanguageStandard.C89;
        }
        return OCLanguageStandard.UNKNOWN;
    }

    @Override
    public boolean isClangFeatureEnabled(@NotNull String feature) {
        OCMacroSymbol macroSymbol = this.getDefinition(OCCompilerMacros.clangFeature(feature));
        return macroSymbol != null && "1".equals(macroSymbol.getSubstitution());
    }

    @Override
    public boolean isClangExtensionEnabled(@NotNull String feature) {
        OCMacroSymbol macroSymbol = this.getDefinition(OCCompilerMacros.clangExtension(feature));
        return macroSymbol != null && "1".equals(macroSymbol.getSubstitution());
    }

    @Override
    public boolean isClangFeatureOrExtensionEnabled(@NotNull String feature) {
        return this.isClangFeatureEnabled(feature) || this.isClangExtensionEnabled(feature);
    }

    private String getDefinitionUnprocessedValue(@Nullable String id) {
        OCMacroSymbol macro = this.getDefinition(id);
        return macro == null ? null : macro.getSubstitution();
    }

    @Override
    @Nullable
    public OCMacroSymbol getDefinition(@Nullable String id) {
        return this.getDefinition(id, OCImmutableInclusionContext.SignaturePart.EXACT_DEFINITION);
    }

    private void enterConformanceCheckMode() {
        if (this.mySignatureBuilder != null) {
            this.mySignatureBuilder.enterConformanceCheckMode();
        }
        if (this.myParentContext != null) {
            this.myParentContext.enterConformanceCheckMode();
        }
    }

    private void exitConformanceCheckMode(boolean commit) {
        if (this.mySignatureBuilder != null) {
            this.mySignatureBuilder.exitConformanceCheckMode(commit);
        }
        if (this.myParentContext != null) {
            this.myParentContext.exitConformanceCheckMode(commit);
        }
    }

    @Override
    @Nullable
    public OCMacroSymbol getDefinition(@Nullable String id, @NotNull OCImmutableInclusionContext.SignaturePart sp) {
        OCMacroSymbol answer;
        boolean notify;
        if (id == null) {
            return null;
        }
        boolean bl = notify = sp != OCImmutableInclusionContext.SignaturePart.NO;
        if (this.myUndefList.contains(id)) {
            answer = null;
            notify = this.myNotifyLocalDefinitions;
        } else {
            OCMacroSymbol local = this.mySubstitutions.get(id);
            if (local != null) {
                answer = local;
                notify = this.myNotifyLocalDefinitions;
            } else {
                OCMacroSymbol oCMacroSymbol = answer = this.myParentContext != null ? this.myParentContext.getDefinition(id, sp) : null;
            }
        }
        if (notify && this.mySignatureBuilder != null) {
            switch (sp) {
                case HAS_DEFINITION: {
                    this.mySignatureBuilder.setDefined(id, answer != null);
                    break;
                }
                case EXACT_DEFINITION: {
                    if (answer == null) break;
                    this.mySignatureBuilder.setDefinition(id, answer);
                    break;
                }
            }
        }
        return answer;
    }

    @Override
    public boolean isProcessed(@Nullable VirtualFile file2) {
        return file2 != null && (this.myProcessedFiles.contains(file2) || this.myParentContext != null && this.myParentContext.isProcessed(file2));
    }

    @Override
    @NotNull
    public final Set<VirtualFile> getProcessedFiles() {
        THashSet files = new THashSet();
        this.collectProcessedFile((Set<VirtualFile>)files);
        return Collections.unmodifiableSet(files);
    }

    private void collectProcessedFile(Set<VirtualFile> result) {
        if (this.myParentContext != null) {
            this.myParentContext.collectProcessedFile(result);
        }
        result.addAll(this.myProcessedFiles);
    }

    public void setSignatureBuilder(@Nullable SignatureBuilder signatureBuilder) {
        this.mySignatureBuilder = signatureBuilder;
    }

    @Nullable
    public VirtualFile resolveNextPath(OCIncludeSymbol.IncludePath path, PsiFile contextFile) {
        Ref result = new Ref();
        OCIncludeHelpers.resolveNextIncludedFile(this.getRootAndConfiguration(), OCInclusionContextUtil.getVirtualFile(contextFile), OCInclusionContextUtil.getVirtualFile(contextFile), path, contextFile.getProject(), (Ref<VirtualFile>)result);
        return (VirtualFile)result.get();
    }

    @Nullable
    public VirtualFile resolvePath(OCIncludeSymbol.IncludePath path, PsiFile contextFile) {
        return OCIncludeHelpers.resolveIncludedFile(this.getRootAndConfiguration(), OCInclusionContextUtil.getVirtualFile(contextFile), path, contextFile.getProject());
    }

    @NotNull
    private OCResolveRootAndConfiguration getRootAndConfiguration() {
        VirtualFile file2 = OCInclusionContextUtil.getVirtualFile(this.myRootFile);
        if (file2 == null) {
            return new OCResolveRootAndConfiguration(this.myConfiguration, this.myLanguageKind);
        }
        return new OCResolveRootAndConfiguration(this.myConfiguration, file2);
    }

    @Nullable
    public VirtualFile resolveImportedFile(CharSequence directiveContent, PsiFile contextFile) {
        return this.resolvePath(OCInclusionContext.extractPath(directiveContent), contextFile);
    }

    @Nullable
    public VirtualFile resolveNextImportedFile(CharSequence directiveContent, PsiFile contextFile) {
        return this.resolveNextPath(OCInclusionContext.extractPath(directiveContent), contextFile);
    }

    public static OCIncludeSymbol.IncludePath extractPath(CharSequence content) {
        IElementType tt;
        OCLexer lexer = new OCLexer();
        lexer.start(content);
        int ltstart = -1;
        while ((tt = lexer.getTokenType()) != null) {
            if (tt == OCTokenTypes.STRING_LITERAL) {
                int start = lexer.getTokenStart();
                int end = lexer.getTokenEnd();
                if (end - start > 2 && content.charAt(start) == '\"' && content.charAt(end - 1) == '\"') {
                    return new OCIncludeSymbol.IncludePath(content.subSequence(start + 1, end - 1).toString(), false);
                }
                return OCIncludeSymbol.IncludePath.EMPTY;
            }
            if (tt == OCTokenTypes.LT) {
                ltstart = lexer.getTokenEnd();
            } else if (tt == OCTokenTypes.GT) {
                int gtstart = lexer.getTokenStart();
                if (ltstart >= 0 && gtstart - ltstart > 1) {
                    return new OCIncludeSymbol.IncludePath(content.subSequence(ltstart, gtstart).toString(), true);
                }
                return OCIncludeSymbol.IncludePath.EMPTY;
            }
            lexer.advance();
        }
        return OCIncludeSymbol.IncludePath.EMPTY;
    }

    @Override
    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    @Override
    @Nullable
    public OCResolveConfiguration getConfiguration() {
        return this.myConfiguration;
    }

    public boolean reserveInclude(@NotNull VirtualFile file2, boolean once) {
        if (file2.isValid()) {
            String includeId = OCInclusionContextUtil.inclusionId(file2);
            if (once && this.isDefined(includeId)) {
                return false;
            }
            String pragmaOnceId = OCInclusionContextUtil.pragmaOnceId(file2);
            if (this.isDefined(pragmaOnceId)) {
                return false;
            }
            this.define(OCMacroSymbol.inclusionGuard(includeId));
        }
        return true;
    }

    public void preprocessContextOf(PsiFile root, VirtualFile breakOn) {
        this.preprocessInclude(root, true, breakOn, this.myInclusionLevel);
    }

    public void preprocessInclude(PsiFile file2, boolean once) {
        this.preprocessInclude(file2, once, null, this.myInclusionLevel);
    }

    public boolean preprocessInclude(PsiFile file2, boolean once, VirtualFile breakOn, int inclusionLevel) {
        if (file2 == null || inclusionLevel >= OCInclusionContext.getMaxInclusionLevel(null)) {
            return true;
        }
        VirtualFile vFile = OCInclusionContextUtil.getVirtualFile(file2);
        if (vFile == null || !this.reserveInclude(vFile, once)) {
            return true;
        }
        this.addProcessedFile(vFile);
        FileSymbolTable table = FileSymbolTable.forFile(file2, this);
        if (table != null && file2 instanceof OCFile) {
            return this.preprocessFile((OCFile)file2, vFile, breakOn, inclusionLevel, -1, -1, table.getContents(), null) != null;
        }
        return true;
    }

    @Contract(value="_, _, null, _, _, _, _, _ -> !null")
    public OCInclusionContext preprocessFile(@Nullable OCFile file2, @Nullable VirtualFile vFile, @Nullable VirtualFile breakOn, int inclusionLevel, int afterOffset, int beforeOffset, @NotNull List<OCSymbol> symbols, OCContextChangeSet changeSet) {
        class Builder
        implements Processor<OCSymbol> {
            private OCParsingNameScope myNameScope;
            @Nullable
            private final OCContextChangeBuilder myContextChangeBuilder;
            private boolean wasTruncated;
            final /* synthetic */ OCFile val$file;
            final /* synthetic */ VirtualFile val$vFile;
            final /* synthetic */ VirtualFile val$breakOn;
            final /* synthetic */ int val$inclusionLevel;
            final /* synthetic */ OCContextChangeSet val$changeSet;
            final /* synthetic */ int val$afterOffset;
            final /* synthetic */ int val$beforeOffset;

            public Builder(@Nullable OCParsingNameScope nameScope, OCContextChangeBuilder builder) {
                this.val$file = oCFile;
                this.val$vFile = virtualFile;
                this.val$breakOn = virtualFile2;
                this.val$inclusionLevel = n;
                this.val$changeSet = oCContextChangeSet;
                this.val$afterOffset = n2;
                this.val$beforeOffset = n3;
                this.myNameScope = nameScope;
                this.myContextChangeBuilder = builder;
            }

            public boolean wasTruncated() {
                return this.wasTruncated;
            }

            public OCParsingNameScope getNameScope() {
                return this.myNameScope;
            }

            public boolean process(OCSymbol symbol) {
                if (OCInclusionContext.this.myProcessingListener != null) {
                    OCInclusionContext.this.myProcessingListener.process((Object)symbol);
                }
                OCContextChangeBuilder changeBuilder = this.myContextChangeBuilder;
                if (symbol instanceof OCIncludeSymbol) {
                    PsiFile psiFile;
                    assert (this.val$file != null);
                    assert (this.val$vFile != null);
                    OCIncludeSymbol include = (OCIncludeSymbol)symbol;
                    VirtualFile targetFile = include.getTargetFile();
                    PsiFile psiFile2 = psiFile = targetFile == null || !targetFile.isValid() ? null : this.val$file.getManager().findFile(targetFile);
                    if (psiFile instanceof OCFile) {
                        if (targetFile.equals(this.val$breakOn) || !OCInclusionContext.this.preprocessInclude(psiFile, include.isOnce(), this.val$breakOn, this.val$inclusionLevel + 1, include.getEndOffset(), this.val$changeSet)) {
                            return false;
                        }
                        OCImportGraph.addHeaderIncluder(psiFile.getProject(), targetFile, this.val$vFile);
                    }
                } else if (symbol instanceof OCMacroSymbol) {
                    OCInclusionContext.this.define((OCMacroSymbol)symbol);
                } else if (symbol instanceof OCUndefMacroSymbol) {
                    OCInclusionContext.this.undef(symbol.getName());
                } else {
                    OCSymbolKind kind = symbol.getKind();
                    OCParsingNameScope resultNameScope = this.myNameScope;
                    if (symbol instanceof OCNamespaceSymbol) {
                        OCNamespaceSymbol namespaceSymbol = (OCNamespaceSymbol)symbol;
                        List<OCSymbol> members = namespaceSymbol.getMembersList();
                        Collection usings = namespaceSymbol.getNamespaceUsings();
                        if (members != null || usings != null) {
                            OCSymbol lastMember;
                            OCParsingNameScope inner;
                            if (changeBuilder != null) {
                                changeBuilder.addSymbol(symbol);
                                changeBuilder = null;
                            }
                            if (this.val$afterOffset != -1 && this.val$afterOffset > symbol.getOffset()) {
                                inner = this.myNameScope;
                            } else {
                                inner = this.myNameScope.defineNamespace(symbol.getName());
                                if (symbol instanceof OCStructSymbol) {
                                    for (OCTypeParameterSymbol templateParam : ((OCStructSymbol)symbol).getTemplateParameters()) {
                                        if (templateParam instanceof OCTypeParameterTypeSymbol) {
                                            inner.defineType(templateParam.getName(), true);
                                            continue;
                                        }
                                        if (!(templateParam instanceof OCTypeParameterValueSymbol)) continue;
                                        inner.defineValue(templateParam.getName(), false);
                                    }
                                }
                            }
                            final Builder innerProcessor = new Builder(inner, null);
                            namespaceSymbol.processMembers(new Processor<OCSymbol>(){

                                public boolean process(OCSymbol member) {
                                    innerProcessor.process(member);
                                    return true;
                                }
                            }, this.val$afterOffset, this.val$beforeOffset);
                            OCSymbol oCSymbol = lastMember = members != null ? (OCSymbol)ContainerUtil.getLastItem(members) : null;
                            if (this.val$beforeOffset != -1 && lastMember != null && this.val$beforeOffset <= lastMember.getOffset() || innerProcessor.wasTruncated()) {
                                this.wasTruncated = true;
                                resultNameScope = innerProcessor.getNameScope();
                            } else {
                                resultNameScope = innerProcessor.getNameScope().getParent();
                            }
                            if (usings != null) {
                                OCResolveUtil.processSymbolsFromList(innerProcessor, (List<? extends OCSymbol>)usings, this.val$afterOffset, this.val$beforeOffset);
                            }
                        }
                    }
                    if (symbol instanceof OCUsingSymbol) {
                        if (changeBuilder != null) {
                            changeBuilder.addSymbol(symbol);
                        }
                        if (symbol.getKind() == OCSymbolKind.NAMESPACE_USING_SYMBOL) {
                            this.myNameScope.defineNamespaceUsing(((OCUsingSymbol)symbol).getSymbolReference().getQualifiedName().flatten());
                        } else {
                            this.myNameScope.defineSymbolUsing(((OCUsingSymbol)symbol).getSymbolReference().getQualifiedName().flatten());
                        }
                    } else if (kind.isType()) {
                        if (changeBuilder != null) {
                            changeBuilder.addSymbol(symbol);
                        }
                        if (kind.isClass()) {
                            if (kind == OCSymbolKind.PROTOCOL) {
                                this.myNameScope.defineProtocol(symbol.getName());
                            } else {
                                this.myNameScope.defineInterface(symbol.getName());
                            }
                            if (symbol instanceof OCClassSymbol) {
                                ((OCClassSymbol)symbol).processMembers((String)null, new OCCommonProcessors.SelfAdapterProcessor(this));
                            }
                        } else if (kind.isClassOrTypedef() || OCInclusionContext.this.myLanguageKind.isCpp()) {
                            boolean isTemplate = symbol instanceof OCTemplateSymbol && ((OCTemplateSymbol)symbol).isTemplateSymbol();
                            boolean isFriendClass = symbol instanceof OCStructSymbol && ((OCStructSymbol)symbol).isFriendClass();
                            this.myNameScope.defineType(symbol.getName(), isTemplate, isFriendClass, -1);
                        }
                        if (kind == OCSymbolKind.ENUM && symbol instanceof OCStructSymbol) {
                            ((OCStructSymbol)symbol).processFields(new Processor<OCDeclaratorSymbol>(){

                                public boolean process(OCDeclaratorSymbol symbol) {
                                    myNameScope.defineValue(symbol.getName(), false);
                                    return true;
                                }
                            });
                        }
                    } else if (symbol instanceof OCInstanceVariableSymbol) {
                        this.myNameScope.defineValue(symbol.getName(), false);
                    } else if (symbol instanceof OCFunctionSymbol && !symbol.getKind().isConstructorOrDestructor() && ((OCFunctionSymbol)symbol).getQualifiedName().getQualifier() == null) {
                        if (changeBuilder != null) {
                            changeBuilder.addSymbol(symbol);
                        }
                        this.myNameScope.defineValue(symbol.getName(), ((OCFunctionSymbol)symbol).isTemplateSymbol());
                    } else if (symbol instanceof OCDeclaratorSymbol && ((OCDeclaratorSymbol)symbol).getQualifiedName().getQualifier() == null) {
                        if (changeBuilder != null) {
                            changeBuilder.addSymbol(symbol);
                        }
                        this.myNameScope.defineValue(symbol.getName(), ((OCDeclaratorSymbol)symbol).isTemplateSymbol());
                    }
                    this.myNameScope = resultNameScope;
                }
                return true;
            }
        }
        Builder builder = new Builder(this.myNameScope, this.myChangeBuilder);
        if (OCResolveUtil.processSymbolsFromList(builder, symbols, afterOffset, beforeOffset)) {
            this.myNameScope = builder.getNameScope();
            return this;
        }
        return null;
    }

    public boolean preprocessInclude(@NotNull PsiFile file2, boolean once, @Nullable VirtualFile breakOn, int includeLevel, int offsetAfterInclude, @Nullable OCContextChangeSet changeSet) {
        boolean result;
        OCContextChangeBuilderImpl builder = null;
        OCContextChange change = null;
        if (changeSet != null && (change = changeSet.getChange(offsetAfterInclude)) == null) {
            builder = new OCContextChangeBuilderImpl(offsetAfterInclude);
            this.setChangeBuilder(builder);
        }
        if (change == null) {
            result = this.preprocessInclude(file2, once, breakOn, includeLevel);
        } else {
            change.apply(file2.getProject(), this);
            result = true;
        }
        if (builder != null && !this.isProcessed(OCInclusionContextUtil.getVirtualFile(this.myRootFile))) {
            changeSet.setChange(offsetAfterInclude, builder);
            this.setChangeBuilder(null);
        }
        return result;
    }

    public DeepEqual.Equality<OCInclusionContext> equality() {
        return new DeepEquality();
    }

    private static class DeepEquality
    implements DeepEqual.Equality<OCInclusionContext> {
        private DeepEquality() {
        }

        @Override
        public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull OCInclusionContext first, @NotNull OCInclusionContext second) {
            if (first.myLanguageKind != second.myLanguageKind) {
                return false;
            }
            if (first.myInclusionLevel != second.myInclusionLevel) {
                return false;
            }
            if (!Comparing.equal((Object)first.myRootFile, (Object)second.myRootFile)) {
                return false;
            }
            if (first.myNotifyLocalDefinitions != second.myNotifyLocalDefinitions) {
                return false;
            }
            if (first.myConfiguration != second.myConfiguration) {
                return false;
            }
            if (!first.myNeverRefefineMacros.equals((Object)second.myNeverRefefineMacros)) {
                return false;
            }
            if (!first.myUndefList.equals(second.myUndefList)) {
                return false;
            }
            if (!first.myProcessedFiles.equals(second.myProcessedFiles)) {
                return false;
            }
            if (!Comparing.equal((Object)first.mySignatureBuilder, (Object)second.mySignatureBuilder)) {
                return false;
            }
            if (!c.equalObjects(first.myParentContext, second.myParentContext)) {
                return false;
            }
            if (!c.equalMaps(first.mySubstitutions, second.mySubstitutions)) {
                return false;
            }
            return c.equalObjects(first.myNameScope, second.myNameScope);
        }
    }

    public static interface SignatureBuilder {
        public void setDefined(@NotNull String var1, boolean var2);

        public void setDefinition(@NotNull String var1, @NotNull OCMacroSymbol var2);

        public void enterConformanceCheckMode();

        public void exitConformanceCheckMode(boolean var1);
    }
}

