/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.preprocessor;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.progress.util.ReadTask;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.NotNullFunction;
import com.intellij.util.Processor;
import com.intellij.util.containers.ConcurrentMultiMap;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.psi.OCConfigurationOwner;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.impl.OCFileImpl;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceManager;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCImportGraph {
    private static final NotNullLazyKey<MultiMap<VirtualFile, VirtualFile>, Project> HEADER_TO_ALL_ROOTS_CACHE = NotNullLazyKey.create((String)"HEADER_TO_ALL_ROOTS_CACHE", (NotNullFunction)new NotNullFunction<Project, MultiMap<VirtualFile, VirtualFile>>(){

        @NotNull
        public MultiMap<VirtualFile, VirtualFile> fun(Project dom) {
            return new ConcurrentMultiMap();
        }
    });
    private static final NotNullLazyKey<Map<VirtualFile, Set<VirtualFile>>, OCResolveConfiguration> ROOT_TO_ALL_HEADERS_CACHE = NotNullLazyKey.create((String)"ROOT_TO_ALL_HEADERS_CACHE", (NotNullFunction)new NotNullFunction<OCResolveConfiguration, Map<VirtualFile, Set<VirtualFile>>>(){

        @NotNull
        public Map<VirtualFile, Set<VirtualFile>> fun(OCResolveConfiguration dom) {
            return new ConcurrentHashMap<VirtualFile, Set<VirtualFile>>();
        }
    });
    private static final NotNullLazyKey<Cache, Project> IMPORTS_GRAPH = NotNullLazyKey.create((String)"IMPORT_GRAPH", (NotNullFunction)new NotNullFunction<Project, Cache>(){

        @NotNull
        public Cache fun(Project project2) {
            return new Cache(project2);
        }
    });

    public static void invalidateHeaderRootsCache(@NotNull Project project2) {
        project2.putUserData(HEADER_TO_ALL_ROOTS_CACHE, null);
    }

    @NotNull
    public static Collection<VirtualFile> getAllHeaderRoots(@NotNull Project project2, @NotNull VirtualFile header) {
        MultiMap value = (MultiMap)HEADER_TO_ALL_ROOTS_CACHE.getValue((UserDataHolder)project2);
        if (!value.containsKey((Object)header)) {
            Collection<VirtualFile> roots = OCImportGraph.findAllRootsThatIncludes(project2, header, true);
            assert (!roots.isEmpty());
            value.put((Object)header, roots);
        }
        return value.get((Object)header);
    }

    public static void buildSymbolAndRootHeaderCache(@NotNull OCResolveConfiguration configuration, @NotNull VirtualFile rootFile, @Nullable OCLanguageKind kind, @Nullable ProgressIndicator indicator) {
        if (indicator != null) {
            indicator.checkCanceled();
        }
        if (!rootFile.isValid()) {
            return;
        }
        Project project2 = configuration.getProject();
        if (!OCInclusionContextUtil.isNeedToFindRoot(rootFile, project2)) {
            OCImportGraph.invalidateRootHeadersCache(configuration, rootFile);
            OCImportGraph.getAllRootHeaders(configuration, rootFile, indicator);
        } else {
            PsiFile psiFile = PsiManager.getInstance((Project)project2).findFile(rootFile);
            if (psiFile instanceof OCConfigurationOwner) {
                if (kind == null) {
                    kind = ((OCConfigurationOwner)psiFile).getKind();
                }
                OCInclusionContext context = OCInclusionContext.sourceParsingContext(configuration, kind, psiFile);
                context.preprocessInclude(psiFile, true);
            }
        }
    }

    public static void invalidateRootHeadersCache(OCResolveConfiguration configuration, VirtualFile file2) {
        ((Map)ROOT_TO_ALL_HEADERS_CACHE.getValue((UserDataHolder)configuration)).remove(file2);
    }

    public static void invalidateRootHeadersCache(OCResolveConfiguration configuration) {
        ((Map)ROOT_TO_ALL_HEADERS_CACHE.getValue((UserDataHolder)configuration)).clear();
    }

    @NotNull
    public static Set<VirtualFile> getAllRootHeaders(@NotNull OCResolveConfiguration configuration, @NotNull VirtualFile root, @Nullable ProgressIndicator indicator) {
        Project project2 = configuration.getProject();
        assert (!OCInclusionContextUtil.isNeedToFindRoot(root, project2)) : "Not a root file";
        Map value = (Map)ROOT_TO_ALL_HEADERS_CACHE.getValue((UserDataHolder)configuration);
        Set<Object> result = (Set)value.get(root);
        if (result == null) {
            PsiFile rootPsi;
            PsiManager psiManager = PsiManager.getInstance((Project)project2);
            PsiFile psiFile = rootPsi = root.isValid() ? psiManager.findFile(root) : null;
            if (rootPsi instanceof OCConfigurationOwner) {
                if (OCInclusionContext.isPrecompiledHeader(root, configuration)) {
                    result = OCImportGraph.getAllPCHRootHeaders(psiManager, project2, configuration, root, indicator);
                } else {
                    OCInclusionContext context = OCInclusionContext.sourceParsingContext(configuration, ((OCConfigurationOwner)rootPsi).getKind(), rootPsi);
                    context.preprocessInclude(rootPsi, true);
                    result = context.getProcessedFiles();
                }
            } else {
                result = Collections.emptySet();
            }
            value.put(root, result);
        }
        return result;
    }

    private static Set<VirtualFile> getAllPCHRootHeaders(@NotNull PsiManager psiManager, @NotNull Project project2, @NotNull OCResolveConfiguration configuration, @NotNull VirtualFile pch, @Nullable ProgressIndicator indicator) {
        HashSet<Pair> srcs = new HashSet<Pair>();
        OCWorkspace workspace = OCWorkspaceManager.getWorkspace(project2);
        for (VirtualFile vroot : OCSearchScope.getExplicitlySpecifiedProjectSourceFiles(project2)) {
            OCLanguageKind kind;
            PsiFile rootPsi;
            if (!OCFileImpl.isSourceCodeFile(vroot.getName()) || pch.equals(vroot)) continue;
            if (indicator != null) {
                indicator.checkCanceled();
            }
            if (!workspace.getConfigurationsForFile(vroot).contains(configuration) || (rootPsi = vroot.isValid() ? psiManager.findFile(vroot) : null) == null || !(rootPsi instanceof OCConfigurationOwner) || !(kind = ((OCConfigurationOwner)rootPsi).getKind()).supportsPrecompiledHeaders()) continue;
            srcs.add(Pair.create((Object)kind, (Object)rootPsi));
        }
        THashSet result = new THashSet();
        for (Pair src : srcs) {
            if (indicator != null) {
                indicator.checkCanceled();
            }
            result.addAll(OCInclusionContext.initialPCHContextWithoutRoot(configuration, (OCLanguageKind)src.first, (PsiFile)src.second).getProcessedFiles());
        }
        result.remove((Object)pch);
        return Collections.unmodifiableSet(result);
    }

    @NotNull
    public static Set<OCResolveConfiguration> getAllHeaderConfigurations(@NotNull OCFile header, @Nullable ProgressIndicator progress) {
        Project project2 = header.getProject();
        VirtualFile file2 = OCInclusionContextUtil.getVirtualFile(header);
        if (file2 == null) {
            return Collections.emptySet();
        }
        HashSet<OCResolveConfiguration> ret = new HashSet<OCResolveConfiguration>();
        for (VirtualFile root : OCImportGraph.getAllHeaderRoots(header.getProject(), file2)) {
            OCImportGraph.fillHeaderConfigurationsForRoot(project2, file2, root, ret, progress);
        }
        return Collections.unmodifiableSet(ret);
    }

    public static void fillHeaderConfigurationsForRoot(@NotNull Project project2, @NotNull VirtualFile header, @NotNull VirtualFile root, @NotNull Set<OCResolveConfiguration> result, @Nullable ProgressIndicator progress) {
        if (progress != null) {
            progress.checkCanceled();
        }
        Collection<? extends OCResolveConfiguration> configs = OCInclusionContextUtil.getAllBuildConfigurationsOfTargetsOfFile(root, project2);
        if (!OCInclusionContextUtil.isNeedToFindRoot(root, project2)) {
            for (OCResolveConfiguration oCResolveConfiguration : configs) {
                if (progress != null) {
                    progress.checkCanceled();
                }
                if (!OCImportGraph.getAllRootHeaders(oCResolveConfiguration, root, progress).contains(header)) continue;
                result.add(oCResolveConfiguration);
            }
        } else {
            result.addAll(configs);
        }
    }

    private static boolean processPossibleRootsThatInclude(@NotNull Project project2, @NotNull VirtualFile headerFile, @NotNull Processor<VirtualFile> processor2, boolean strict) {
        ArrayList<VirtualFile> importers = new ArrayList<VirtualFile>();
        HashSet<VirtualFile> processed2 = new HashSet<VirtualFile>();
        importers.add(headerFile);
        while (!importers.isEmpty()) {
            ArrayList<VirtualFile> upperImporters = new ArrayList<VirtualFile>();
            for (VirtualFile headerHolder : importers) {
                if (headerHolder == null || !processed2.add(headerHolder)) continue;
                Collection<VirtualFile> maybeUpperImporter = OCImportGraph.findImmediateIncludingFiles(project2, headerHolder, strict);
                for (VirtualFile importHolder : maybeUpperImporter) {
                    if (!importHolder.isValid()) continue;
                    PsiFile psiImportHolder = PsiManager.getInstance((Project)project2).findFile(importHolder);
                    if (psiImportHolder instanceof OCFile && !OCInclusionContextUtil.isNeedToFindRoot(psiImportHolder) && !processor2.process((Object)importHolder)) {
                        return false;
                    }
                    upperImporters.add(importHolder);
                }
            }
            importers = upperImporters;
        }
        return true;
    }

    @NotNull
    public static Collection<VirtualFile> findAllRootsThatIncludes(@NotNull Project project2, @NotNull VirtualFile original, boolean strict) {
        if (!OCInclusionContextUtil.isNeedToFindRoot(original, project2)) {
            return Collections.singletonList(original);
        }
        PsiFile originalFile = PsiManager.getInstance((Project)project2).findFile(original);
        if (!(originalFile instanceof OCFile)) {
            return Collections.singletonList(original);
        }
        final THashSet result = new THashSet();
        OCImportGraph.processPossibleRootsThatInclude(project2, original, new Processor<VirtualFile>(){

            public boolean process(VirtualFile virtualFile) {
                result.add((Object)virtualFile);
                return true;
            }
        }, strict);
        return result.isEmpty() ? Collections.singletonList(original) : new ArrayList(result);
    }

    @NotNull
    public static Collection<VirtualFile> findImmediateIncludingFiles(@NotNull Project project2, @NotNull VirtualFile file2, boolean strict) {
        return ((Cache)IMPORTS_GRAPH.getValue((UserDataHolder)project2)).get(file2, strict);
    }

    public static void addHeaderIncluder(@NotNull Project project2, @NotNull VirtualFile header, @NotNull VirtualFile includer) {
        ((Cache)IMPORTS_GRAPH.getValue((UserDataHolder)project2)).add(header, includer);
    }

    public static void removeHeaderIncluder(@NotNull Project project2, @NotNull VirtualFile header, @NotNull VirtualFile includer) {
        ((Cache)IMPORTS_GRAPH.getValue((UserDataHolder)project2)).remove(header, includer);
    }

    private static class Cache {
        @NotNull
        private final Project myProject;
        @NotNull
        private final AtomicInteger isEnsuringFilesProcessed = new AtomicInteger();
        @NotNull
        private final Object myLock = new Object();
        MultiMap<VirtualFile, VirtualFile> myHeaderToIncluders = MultiMap.createConcurrentSet();
        MultiMap<VirtualFile, VirtualFile> myAddOnlyHeaderToIncluders = MultiMap.createConcurrentSet();

        private Cache(@NotNull Project project2) {
            this.myProject = project2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public Collection<VirtualFile> get(@NotNull VirtualFile header, boolean strict) {
            if (strict) {
                Application app = ApplicationManager.getApplication();
                app.assertReadAccessAllowed();
                boolean sync = !app.isDispatchThread() || app.isUnitTestMode();
                this.ensureFilesProcessed(sync);
            }
            Object object = this.myLock;
            synchronized (object) {
                Collection<VirtualFile> rs;
                if (!strict && (rs = this.getInner(header, true)) != null) {
                    return rs;
                }
                return this.getInner(header, false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        @Contract(value="_, false -> !null")
        private Collection<VirtualFile> getInner(@NotNull VirtualFile header, boolean fromAddOnlyCache) {
            Object object = this.myLock;
            synchronized (object) {
                MultiMap<VirtualFile, VirtualFile> h2is;
                MultiMap<VirtualFile, VirtualFile> multiMap = h2is = fromAddOnlyCache ? this.myAddOnlyHeaderToIncluders : this.myHeaderToIncluders;
                if (fromAddOnlyCache && !h2is.containsKey((Object)header)) {
                    return null;
                }
                Collection files = h2is.get((Object)header);
                boolean allValid = true;
                for (VirtualFile file2 : files) {
                    if (file2.isValid()) continue;
                    allValid = false;
                    break;
                }
                if (!allValid) {
                    ArrayList fs = new ArrayList(files);
                    for (VirtualFile file3 : fs) {
                        if (file3.isValid()) continue;
                        h2is.remove((Object)header, (Object)file3);
                    }
                    files = h2is.get((Object)header);
                    if (!fromAddOnlyCache) {
                        OCImportGraph.invalidateHeaderRootsCache(this.myProject);
                    }
                }
                return files;
            }
        }

        private void ensureFilesProcessed(boolean sync) {
            if (sync) {
                this.isEnsuringFilesProcessed.incrementAndGet();
                try {
                    this.ensurePendingFilesProcessed(null);
                    return;
                }
                finally {
                    this.isEnsuringFilesProcessed.decrementAndGet();
                }
            }
            if (this.isEnsuringFilesProcessed.incrementAndGet() > 1) {
                this.isEnsuringFilesProcessed.decrementAndGet();
                return;
            }
            ProgressIndicatorUtils.scheduleWithWriteActionPriority(new ReadTask(){

                @Override
                public void computeInReadAction(@NotNull ProgressIndicator indicator) {
                    try {
                        this.ensurePendingFilesProcessed(indicator);
                    }
                    finally {
                        isEnsuringFilesProcessed.decrementAndGet();
                    }
                }

                @Override
                public void onCanceled(@NotNull ProgressIndicator indicator) {
                    this.ensureFilesProcessed(false);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void ensurePendingFilesProcessed(@Nullable ProgressIndicator indicator) {
            if (this.myProject.isDisposed() || !FileSymbolTablesCache.areSymbolsLoaded(this.myProject)) {
                return;
            }
            FileSymbolTablesCache cache = FileSymbolTablesCache.getInstance(this.myProject);
            cache.ensurePendingFilesProcessed(indicator, true);
            Object object = this.myLock;
            synchronized (object) {
                this.myAddOnlyHeaderToIncluders.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(@NotNull VirtualFile header, @NotNull VirtualFile includer) {
            Object object = this.myLock;
            synchronized (object) {
                this.myHeaderToIncluders.putValue((Object)header, (Object)includer);
                if (this.myAddOnlyHeaderToIncluders.containsKey((Object)header)) {
                    this.myAddOnlyHeaderToIncluders.putValue((Object)header, (Object)includer);
                }
                OCImportGraph.invalidateHeaderRootsCache(this.myProject);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove(@NotNull VirtualFile header, @NotNull VirtualFile includer) {
            Object object = this.myLock;
            synchronized (object) {
                if (this.myHeaderToIncluders.remove((Object)header, (Object)includer)) {
                    if (!this.myAddOnlyHeaderToIncluders.containsKey((Object)header)) {
                        this.myAddOnlyHeaderToIncluders.putValues((Object)header, this.myHeaderToIncluders.get((Object)header));
                        this.myAddOnlyHeaderToIncluders.putValue((Object)header, (Object)includer);
                    }
                    OCImportGraph.invalidateHeaderRootsCache(this.myProject);
                }
            }
        }
    }
}

