/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.preprocessor;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCIncludeHelpers;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.preprocessor.OCModuleResolver;
import com.jetbrains.cidr.lang.workspace.OCResolveRootAndConfiguration;
import com.jetbrains.cidr.lang.workspace.headerRoots.AppleFramework;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class OCDefaultModuleResolver
extends OCModuleResolver {
    @Override
    protected boolean processImports(@NotNull OCInclusionContext context, @NotNull List<String> moduleNameParts, @NotNull Processor<VirtualFile> headerProcessor) {
        if (moduleNameParts.isEmpty()) {
            return true;
        }
        if (context.hasRootFile()) {
            List<VirtualFile> headersToInclude;
            String frameworkName = moduleNameParts.get(0);
            Project project2 = context.getProject();
            OCResolveRootAndConfiguration configuration = OCInclusionContextUtil.getResolveRootAndActiveConfiguration(context.getRootFile().getVirtualFile(), project2);
            AppleFramework framework = OCIncludeHelpers.getFramework(configuration, frameworkName);
            if (framework != null && moduleNameParts.size() == 1 && !(headersToInclude = framework.getPublicHeadersToInclude()).isEmpty()) {
                ContainerUtil.process(headersToInclude, headerProcessor);
                return true;
            }
        }
        return false;
    }
}

