/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.parser;

import com.intellij.lang.ASTNode;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderFactory;
import com.intellij.lang.PsiParser;
import com.intellij.lang.impl.PsiBuilderImpl;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.impl.LineSet;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.reference.SoftReference;
import com.intellij.util.NotNullFunction;
import com.intellij.util.Processor;
import com.intellij.util.ThreeState;
import com.intellij.util.TripleFunction;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.lexer.OCLexer;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCParsing;
import com.jetbrains.cidr.lang.parser.OCPartialContext;
import com.jetbrains.cidr.lang.parser.OCRootElementType;
import com.jetbrains.cidr.lang.preprocessor.OCContextChangeSet;
import com.jetbrains.cidr.lang.preprocessor.OCImmutableInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.preprocessor.OCParsingNameScope;
import com.jetbrains.cidr.lang.preprocessor.OCPreprocessingLexer;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCCodeFragment;
import com.jetbrains.cidr.lang.psi.OCCppNamespaceQualifier;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.psi.OCParameterDeclaration;
import com.jetbrains.cidr.lang.psi.OCTemplateParameterList;
import com.jetbrains.cidr.lang.psi.OCTypeParameterDeclaration;
import com.jetbrains.cidr.lang.psi.impl.OCFileImpl;
import com.jetbrains.cidr.lang.psi.impl.OCLazyBlockStatementImpl;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveVisitor;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTable;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.workspace.OCLanguageKindCalculator;
import com.jetbrains.cidr.lang.workspace.OCResolveLanguageAndConfiguration;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCParser
implements PsiParser {
    private static final NotNullLazyKey<CachedValue<OCImmutableInclusionContext>, OCFile> FRAGMENT_CONTEXTS = NotNullLazyKey.create((String)"FRAGMENT_CONTEXTS", OCParser.createContextCalculator(false));
    private static final NotNullLazyKey<CachedValue<OCImmutableInclusionContext>, OCFile> FORCED_OBJCPP_FRAGMENT_CONTEXTS = NotNullLazyKey.create((String)"FRAGMENT_CONTEXTS", OCParser.createContextCalculator(true));
    private static final Key<SoftReference<OCPartialContext>> PARTIAL_CONTEXT = Key.create((String)"PARTIAL_CONTEXT");
    private static final Key<SoftReference<FileTextInfo>> FILE_TEXT = Key.create((String)"FILE_TEXT");
    private static final OCParser instance = new OCParser();
    private final List<Processor<PsiElement>> myListeners = new ArrayList<Processor<PsiElement>>();
    private boolean isLazyParsingEnabled = true;
    private static Boolean ourForceContextChangeCacheUsage;
    private static final TripleFunction<ASTNode, LighterASTNode, FlyweightCapableTreeStructure<LighterASTNode>, ThreeState> GLOBAL_REPARSE;

    private OCParser() {
    }

    public static OCParser getInstance() {
        return instance;
    }

    public void setLazyParsingEnabled(boolean isLazyParsingEnabled) {
        this.isLazyParsingEnabled = isLazyParsingEnabled;
    }

    private static NotNullFunction<OCFile, CachedValue<OCImmutableInclusionContext>> createContextCalculator(final boolean forceObjCpp) {
        return new NotNullFunction<OCFile, CachedValue<OCImmutableInclusionContext>>(){

            @NotNull
            public CachedValue<OCImmutableInclusionContext> fun(final OCFile dom) {
                return CachedValuesManager.getManager((Project)dom.getProject()).createCachedValue((CachedValueProvider)new CachedValueProvider<OCImmutableInclusionContext>(){

                    public CachedValueProvider.Result<OCImmutableInclusionContext> compute() {
                        OCInclusionContext inclusionContext = forceObjCpp ? OCInclusionContextUtil.calculateHeaderContext(dom, OCLanguageKind.OBJ_CPP) : OCInclusionContextUtil.headerContext(dom).derive();
                        OCFile context = dom;
                        while (context != null) {
                            inclusionContext.preprocessInclude(context, true);
                            PsiElement ctx = context.getContext();
                            context = ctx != null ? (OCFile)ctx.getContainingFile() : null;
                        }
                        return CachedValueProvider.Result.create((Object)inclusionContext, (Object[])new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT});
                    }
                }, false);
            }
        };
    }

    public static OCImmutableInclusionContext getCachedInclusionContext(OCFile file2, boolean forceObjCpp) {
        return (OCImmutableInclusionContext)((CachedValue)(forceObjCpp ? FORCED_OBJCPP_FRAGMENT_CONTEXTS : FRAGMENT_CONTEXTS).getValue((UserDataHolder)file2)).getValue();
    }

    public void addListener(Processor<PsiElement> listener2) {
        this.myListeners.add(listener2);
    }

    public void clearListeners() {
        this.myListeners.clear();
    }

    @NotNull
    public ASTNode parse(IElementType root, PsiBuilder builder) {
        builder.setDebugMode(false);
        builder.putUserDataUnprotected(PsiBuilderImpl.CUSTOM_COMPARATOR, GLOBAL_REPARSE);
        return new OCParsing(builder, root, this.isLazyParsingEnabled ? OCParsing.BlockParsingMode.LAZY : OCParsing.BlockParsingMode.EAGER).parse();
    }

    public ASTNode parseDumbFile(IElementType root, PsiBuilder builder) {
        builder.setDebugMode(false);
        return new OCParsing(builder, root).parseDumpFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ASTNode parse(OCRootElementType root, ASTNode chameleon) {
        PsiElement element = chameleon.getPsi();
        PsiFile file2 = element.getContainingFile();
        Project project2 = file2.getProject();
        PsiFile original = file2.getOriginalFile();
        PsiElement context = file2.getContext();
        OCImmutableInclusionContext baseContext = null;
        boolean parseAsDummy = false;
        for (Processor<PsiElement> listener2 : this.myListeners) {
            listener2.process((Object)element);
        }
        int lazyOffset = -1;
        if (element instanceof OCLazyBlockStatementImpl) {
            lazyOffset = (context == null ? element : context).getTextRange().getStartOffset();
            element = element.getParent();
        }
        int offset = element.getTextRange().getStartOffset();
        if (context != null && !(element instanceof OCFile) && !(file2 instanceof OCFile)) {
            file2 = context.getContainingFile();
            offset = context.getParent().getTextRange().getStartOffset();
        }
        int lineNumber = 1;
        PsiFile psiFile = OCParser.partialContextHolder(file2);
        synchronized (psiFile) {
            OCContextChangeSet contextChangeSet = null;
            if (project2.isDefault() || file2 instanceof OCCodeFragment) {
                if (!project2.isDefault() && context != null && context.getContainingFile() instanceof OCFile) {
                    boolean forcedObjCpp = ((OCCodeFragment)file2).getKind() == OCLanguageKind.OBJ_CPP && ((OCFile)context.getContainingFile()).getKind() != OCLanguageKind.OBJ_CPP;
                    baseContext = OCParser.getCachedInclusionContext((OCFile)context.getContainingFile(), forcedObjCpp);
                } else {
                    baseContext = OCInclusionContext.empty(OCLanguageKindCalculator.calculateLanguageKindFast(file2), file2);
                }
            } else if (FileSymbolTablesCache.areSymbolsLoaded(project2) && OCCodeInsightUtil.isCodeInsightAvailable(chameleon.getTextLength())) {
                if (element instanceof OCFile || !(file2 instanceof OCFile)) {
                    baseContext = OCInclusionContextUtil.headerContext(file2);
                    contextChangeSet = OCParser.changeSet(file2, 0, -1);
                    parseAsDummy = baseContext.getInclusionLevel() >= OCInclusionContext.getMaxInclusionLevel(project2);
                } else {
                    baseContext = OCParser.evaluatePartialContext((OCFile)file2, offset);
                    if (lazyOffset >= 0) {
                        lineNumber = OCParser.getCachedFileTextInfo((PsiFile)file2).lineSet.findLineIndex(lazyOffset) + 1;
                    }
                }
            } else {
                parseAsDummy = true;
            }
            if (parseAsDummy) {
                OCLog.LOG.assertTrue(element instanceof OCFile, element.getClass());
                PsiBuilderFactory factory = PsiBuilderFactory.getInstance();
                PsiBuilder builder = factory.createBuilder(project2, chameleon, (Lexer)new OCLexer(), root.getLanguage(), chameleon.getChars());
                ASTNode result = this.parseDumbFile(chameleon.getElementType(), builder);
                return result.getFirstChildNode();
            }
            OCInclusionContext currentFileContext = baseContext.derive();
            if (element instanceof OCFileImpl) {
                OCParser.setPartialContext(file2, null);
                ((OCFileImpl)file2).setParsedResolveLanguageAndConfiguration(new OCResolveLanguageAndConfiguration(currentFileContext.getConfiguration(), currentFileContext.getLanguageKind()));
            } else {
                currentFileContext = OCParser.updatePartialContext(context != null ? context.getParent() : element, currentFileContext);
            }
            PsiFile baseFile = context != null ? context.getContainingFile() : original;
            OCPreprocessingLexer lexer = new OCPreprocessingLexer(currentFileContext, baseFile instanceof OCFile ? (OCFile)baseFile : null, lineNumber);
            lexer.setChangeSet(contextChangeSet);
            PsiBuilderFactory factory = PsiBuilderFactory.getInstance();
            PsiBuilder builder = factory.createBuilder(project2, chameleon, (Lexer)lexer, root.getLanguage(), chameleon.getChars());
            lexer.setChangeSet(null);
            OCParser.cacheContextChangeIfRequired(file2, contextChangeSet);
            ASTNode result = root.doParse(chameleon, builder);
            return result.getFirstChildNode();
        }
    }

    private static void cacheContextChangeIfRequired(PsiFile file2, OCContextChangeSet changeCache) {
        VirtualFile virtualFile;
        if (changeCache != null && changeCache.isUpdated() && (virtualFile = OCInclusionContextUtil.getVirtualFile(file2)) != null) {
            OCInclusionContextUtil.storeCachedContextChangeSet(file2.getProject(), virtualFile, changeCache);
        }
    }

    private static OCContextChangeSet changeSet(PsiFile file2, int validateFrom, int validateTo) {
        if (ourForceContextChangeCacheUsage != null && !ourForceContextChangeCacheUsage.booleanValue()) {
            return null;
        }
        VirtualFile virtualFile = OCInclusionContextUtil.getVirtualFile(file2);
        if (virtualFile == null) {
            return null;
        }
        Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
        if (document == null) {
            return null;
        }
        OCContextChangeSet cached = OCInclusionContextUtil.cachedContextChangeSet(file2.getProject(), virtualFile);
        String text = OCParser.getCachedFileTextInfo((PsiFile)file2).text;
        return OCContextChangeSet.reuse(text, cached, validateFrom, validateTo);
    }

    protected static OCImmutableInclusionContext evaluatePartialContext(OCFile file2, int offset) {
        OCImmutableInclusionContext result;
        VirtualFile virtualFile = OCInclusionContextUtil.getVirtualFile(file2);
        FileSymbolTablesCache symbolsCache = (FileSymbolTablesCache)((Object)file2.getProject().getComponent(FileSymbolTablesCache.class));
        if (virtualFile != null && symbolsCache != null) {
            FileSymbolTable symbolTable;
            OCInclusionContext context;
            OCPartialContext partialContext = OCParser.getPartialContext(file2);
            if (partialContext == null) {
                context = OCInclusionContextUtil.headerContext(file2).derive();
                symbolTable = symbolsCache.calcTableUsingPSI(file2, virtualFile, context);
                OCPartialContext ctx = new OCPartialContext(symbolTable, context, 0);
                OCParser.setPartialContext(file2, ctx);
                OCParser.ensureLazyBlocksParsed(file2, 0, offset - 1);
                partialContext = OCParser.getPartialContext(file2);
            }
            if (partialContext == null || partialContext.getFinalOffset() > offset) {
                context = OCInclusionContextUtil.headerContext(file2).derive();
                symbolTable = symbolsCache.calcTableUsingPSI(file2, virtualFile, context);
                OCContextChangeSet changeSet = OCParser.changeSet(file2, 0, offset);
                context = context.preprocessFile(file2, virtualFile, null, context.getInclusionLevel(), 0, offset, symbolTable.getContents(), changeSet);
                OCParser.cacheContextChangeIfRequired(file2, changeSet);
                OCPartialContext ctx = new OCPartialContext(symbolTable, context, offset);
                OCParser.setPartialContext(file2, ctx);
                result = context;
            } else {
                context = partialContext.getInclusionContext();
                OCParser.ensureLazyBlocksParsed(file2, partialContext.getFinalOffset(), offset - 1);
                OCContextChangeSet changeSet = OCParser.changeSet(file2, partialContext.getFinalOffset(), offset);
                context = context.preprocessFile(file2, virtualFile, null, context.getInclusionLevel(), partialContext.getFinalOffset(), offset, partialContext.getSymbolTable().getContents(), changeSet);
                OCParser.cacheContextChangeIfRequired(file2, changeSet);
                partialContext.setFinalOffset(offset);
                partialContext.setInclusionContext(context);
                result = context;
            }
        } else {
            result = OCInclusionContextUtil.headerContext(file2);
        }
        return result;
    }

    @NotNull
    public static PsiFile partialContextHolder(@NotNull PsiFile file2) {
        return file2.getOriginalFile();
    }

    private static void setPartialContext(@NotNull PsiFile file2, @Nullable OCPartialContext ctx) {
        PARTIAL_CONTEXT.set((UserDataHolder)OCParser.partialContextHolder(file2), (Object)new SoftReference((Object)ctx));
    }

    @Nullable
    private static OCPartialContext getPartialContext(@NotNull PsiFile file2) {
        SoftReference ctxRef = (SoftReference)PARTIAL_CONTEXT.get((UserDataHolder)OCParser.partialContextHolder(file2));
        return ctxRef == null ? null : (OCPartialContext)ctxRef.get();
    }

    protected static void ensureLazyBlocksParsed(PsiFile file2, int fromOffset, int toOffset) {
        PsiElement from;
        if (fromOffset > toOffset) {
            return;
        }
        PsiElement to = PsiTreeUtil.findPrevParent((PsiElement)file2, (PsiElement)file2.findElementAt(toOffset));
        OCRecursiveVisitor visitor = new OCRecursiveVisitor(new TextRange(fromOffset, toOffset)){

            @Override
            protected TextRange getTextRange(PsiElement child) {
                return child.getTextRange();
            }
        };
        for (from = PsiTreeUtil.findPrevParent((PsiElement)file2, (PsiElement)file2.findElementAt(fromOffset)); from != to && from != null; from = from.getNextSibling()) {
            from.accept((PsiElementVisitor)visitor);
        }
        if (from != null) {
            from.accept((PsiElementVisitor)visitor);
        } else {
            OCLog.LOG.error("Assertion failed", new String[]{file2.getText()});
        }
    }

    protected static OCInclusionContext updatePartialContext(PsiElement context, OCInclusionContext currentFileContext) {
        OCParsingNameScope nameScope;
        block9: {
            block8: {
                nameScope = currentFileContext.getNameScope();
                if (!(context instanceof OCMethod)) break block8;
                nameScope = nameScope.defineLocalScope();
                for (OCMethodSelectorPart part : ((OCMethod)context).getParameters()) {
                    String parameterName = part.getParameterName();
                    if (parameterName == null) continue;
                    nameScope.defineValue(parameterName, false);
                }
                break block9;
            }
            if (!(context instanceof OCCallable)) break block9;
            OCDeclarator declarator = context instanceof OCFunctionDeclaration ? ((OCFunctionDeclaration)context).getDeclarator() : null;
            ArrayList<Object> qualifiers = new ArrayList<Object>();
            for (OCCppNamespaceQualifier namespaceQualifier = declarator != null ? declarator.getNamespaceQualifier() : null; namespaceQualifier != null; namespaceQualifier = namespaceQualifier.getNamespaceQualifier()) {
                String name = namespaceQualifier.getName();
                if (name == null) continue;
                qualifiers.add(0, name);
            }
            for (String string : qualifiers) {
                if (string == null) continue;
                nameScope = nameScope.defineNamespace(string);
            }
            nameScope = nameScope.defineLocalScope();
            List<PsiNamedElement> parameters = ((OCCallable)context).getParameters();
            OCTemplateParameterList oCTemplateParameterList = (OCTemplateParameterList)PsiTreeUtil.getChildOfType((PsiElement)context, OCTemplateParameterList.class);
            if (oCTemplateParameterList != null) {
                for (OCTypeParameterDeclaration oCTypeParameterDeclaration : oCTemplateParameterList.getTypeParameterDeclarations()) {
                    String name = oCTypeParameterDeclaration.getName();
                    if (name == null) continue;
                    nameScope.defineType(name, true);
                }
                for (OCParameterDeclaration oCParameterDeclaration : oCTemplateParameterList.getParameterDeclarations()) {
                    declarator = oCParameterDeclaration.getDeclarator();
                    if (declarator == null) continue;
                    nameScope.defineValue(declarator.getName(), false);
                }
            }
            if (parameters != null) {
                for (PsiNamedElement psiNamedElement : parameters) {
                    nameScope.defineValue(psiNamedElement.getName(), false);
                }
            }
        }
        return currentFileContext.derive(nameScope);
    }

    public static void setForceContextChangeCacheUsage(@Nullable Boolean forceContextChangeCacheUsage) {
        ourForceContextChangeCacheUsage = forceContextChangeCacheUsage;
    }

    @NotNull
    private static FileTextInfo getCachedFileTextInfo(@NotNull PsiFile file2) {
        SoftReference textCacheRef = (SoftReference)FILE_TEXT.get((UserDataHolder)file2);
        FileTextInfo textCache = (FileTextInfo)SoftReference.deref((Getter)textCacheRef);
        long modificationStamp = file2.getModificationStamp();
        if (textCache == null || textCache.timestamp != modificationStamp) {
            String text = file2.getText();
            textCache = new FileTextInfo(text, LineSet.createLineSet(text), modificationStamp);
            FILE_TEXT.set((UserDataHolder)file2, (Object)new SoftReference((Object)textCache));
        }
        return textCache;
    }

    static {
        GLOBAL_REPARSE = new TripleFunction<ASTNode, LighterASTNode, FlyweightCapableTreeStructure<LighterASTNode>, ThreeState>(){

            public ThreeState fun(ASTNode oldNode, LighterASTNode newNode, FlyweightCapableTreeStructure<LighterASTNode> structure) {
                if (oldNode.getElementType() == OCElementTypes.LAZY_BLOCK_STATEMENT && newNode.getTokenType() == OCElementTypes.LAZY_BLOCK_STATEMENT) {
                    return ThreeState.NO;
                }
                return ThreeState.UNSURE;
            }
        };
    }

    private static class FileTextInfo {
        @NotNull
        final String text;
        @NotNull
        final LineSet lineSet;
        final long timestamp;

        private FileTextInfo(@NotNull String text, @NotNull LineSet lineSet, long timestamp) {
            this.text = text;
            this.lineSet = lineSet;
            this.timestamp = timestamp;
        }
    }
}

