/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.navigation;

import com.intellij.codeInsight.generation.actions.PresentableCodeInsightActionHandler;
import com.intellij.icons.AllIcons;
import com.intellij.lang.LanguageCodeInsightActionHandler;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.navigation.OCGotoAction;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCClassPredeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.search.OCFunctionAncestorsQuery;
import com.jetbrains.cidr.lang.search.OCMemberInheritorsSearch;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCProtocolSymbol;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCGotoSuperHandler
implements PresentableCodeInsightActionHandler,
LanguageCodeInsightActionHandler {
    @Override
    public void update(@NotNull Editor editor, @NotNull PsiFile file2, Presentation presentation) {
        presentation.setText("S_uper Definition");
        presentation.setDescription("");
    }

    public boolean isValidFor(Editor editor, PsiFile file2) {
        return file2 instanceof OCFile;
    }

    @Nullable
    public static OCGotoAction getAction(final PsiElement element) {
        List<? extends OCSymbol> supers = OCGotoSuperHandler.getSuperSymbols(element);
        if (supers != null && !supers.isEmpty()) {
            return new OCGotoAction(element){

                @Override
                protected List<? extends OCSymbol> evaluateTargets() {
                    OCSymbol superSymbol;
                    List supers = OCGotoSuperHandler.getSuperSymbols(element);
                    this.mySpecialIcons = new ArrayList();
                    boolean isImplementor = true;
                    for (OCSymbol superSymbol2 : supers) {
                        boolean isCurImplementor = superSymbol2 instanceof OCProtocolSymbol ? true : (superSymbol2 instanceof OCMethodSymbol ? ((OCMethodSymbol)superSymbol2).getParent() instanceof OCProtocolSymbol : superSymbol2 instanceof OCFunctionSymbol && superSymbol2.isPredeclaration());
                        isImplementor &= isCurImplementor;
                        this.mySpecialIcons.add(isCurImplementor ? AllIcons.Gutter.ImplementingMethod : AllIcons.Gutter.OverridingMethod);
                    }
                    this.myIcon = isImplementor ? AllIcons.Gutter.ImplementingMethod : AllIcons.Gutter.OverridingMethod;
                    this.myName = "Go to ";
                    OCSymbol oCSymbol = superSymbol = supers.isEmpty() ? null : (OCSymbol)supers.get(0);
                    if (superSymbol instanceof OCMemberSymbol) {
                        this.myName = this.myName + "super " + superSymbol.getKind().getNameLowercase() + " in " + ((OCClassSymbol)((OCMemberSymbol)superSymbol).getParent()).getNameWithKindLowercase();
                    } else if (superSymbol instanceof OCFunctionSymbol) {
                        OCSymbolWithQualifiedName parent = ((OCFunctionSymbol)superSymbol).getParent();
                        if (parent != null) {
                            this.myName = this.myName + "base function in " + parent.getNameWithKindLowercase();
                        }
                    } else {
                        this.myName = this.myName + "super type";
                    }
                    return supers;
                }
            };
        }
        return null;
    }

    @Nullable
    private static List<? extends OCSymbol> getSuperSymbols(PsiElement element) {
        OCStructSymbol structSymbol;
        if (element instanceof OCClassDeclaration && !(element instanceof OCClassPredeclaration)) {
            return ((OCClassDeclaration)element).getSuperSymbols();
        }
        if (element instanceof OCDeclarator || element instanceof OCMethod) {
            Object symbol = ((OCSymbolDeclarator)element).getSymbol();
            if (symbol instanceof OCFunctionSymbol && ((OCDeclarator)element).getParameterList() != null && ((OCDeclarator)element).isPossibleStructMember()) {
                return (List)new OCFunctionAncestorsQuery((OCFunctionSymbol)symbol, false, false).findAll();
            }
            if (symbol instanceof OCMemberSymbol) {
                CommonProcessors.CollectUniquesProcessor processor2 = new CommonProcessors.CollectUniquesProcessor();
                OCMemberInheritorsSearch.SearchParameters<OCMemberSymbol> parameters = OCMemberInheritorsSearch.getParameters((OCMemberSymbol)symbol);
                parameters.setIncludeSelfImplementation(false);
                parameters.setInheritors(false);
                parameters.setAncestors(true);
                if (((OCMemberSymbol)symbol).getParent() instanceof OCImplementationSymbol) {
                    parameters.setImplementationsThenInterfaces(true);
                } else {
                    parameters.setInterfacesThenImplementations(true);
                }
                OCMemberInheritorsSearch.search(parameters).forEach((Processor)processor2);
                return new ArrayList(processor2.getResults());
            }
        } else if (element instanceof OCStruct && (structSymbol = (OCStructSymbol)((OCStruct)element).getSymbol()) != null) {
            final ArrayList supers = new ArrayList();
            structSymbol.processBaseClasses(new OCResolveContext((PsiElement)element.getContainingFile()), new OCStructSymbol.BaseClassProcessor(){

                @Override
                public boolean process(OCSymbol symbol, OCVisibility visibility) {
                    supers.add(symbol);
                    return true;
                }
            });
            return supers;
        }
        return null;
    }

    public void invoke(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file2) {
        OCGotoAction action;
        PsiElement element = file2.findElementAt(editor.getCaretModel().getOffset());
        PsiElement context = PsiTreeUtil.getContextOfType((PsiElement)element, (Class[])new Class[]{OCFunctionDeclaration.class, OCMethod.class, OCClassDeclaration.class});
        if (context instanceof OCFunctionDeclaration) {
            context = ((OCFunctionDeclaration)context).getDeclarator();
        }
        if ((action = OCGotoSuperHandler.getAction(context)) != null) {
            action.navigate(null, editor);
        }
    }

    public boolean startInWriteAction() {
        return false;
    }
}

