/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.util.OCCallableUtil;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCSplitFunctionIntentionAction
implements IntentionAction {
    @NotNull
    public String getText() {
        return "Split function into declaration and definition";
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (!OCCodeInsightUtil.isValid((PsiElement)file2)) {
            return false;
        }
        OCFunctionDefinition function = OCSplitFunctionIntentionAction.getFunction(editor, file2);
        return function != null && function.getNamespaceQualifier() == null && PsiTreeUtil.getParentOfType((PsiElement)function, OCStruct.class) == null;
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        OCFunctionSymbol symbol;
        if (!FileModificationService.getInstance().prepareFileForWrite(file2)) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        OCFunctionDefinition function = OCSplitFunctionIntentionAction.getFunction(editor, file2);
        OCFunctionSymbol oCFunctionSymbol = symbol = function != null ? function.getSymbol() : null;
        if (symbol == null) {
            return;
        }
        PsiElement insertAnchor = this.getInsertAnchor(function);
        if (insertAnchor == null) {
            return;
        }
        String definitionText = OCCallableUtil.functionText(symbol, OCCallableUtil.functionSignature(symbol, false, insertAnchor), insertAnchor, null);
        OCFunctionDefinition definition = (OCFunctionDefinition)OCElementFactory.declarationFromText(definitionText, insertAnchor, true);
        OCElementUtil.restoreFunction(function, definition);
        OCChangeUtil.replaceHandlingMacros(definition.getBody(), function.getBody());
        definition = OCChangeUtil.addAfter(insertAnchor.getParent(), definition, insertAnchor);
        String declarationText = OCCallableUtil.functionSignature(symbol, true, function) + ";";
        OCFunctionDeclaration declaration = symbol.isCppConstructor() ? (OCFunctionDeclaration)OCElementFactory.constructorFromText(declarationText, function, false) : (OCFunctionDeclaration)OCElementFactory.declarationFromText(declarationText, function, false);
        OCElementUtil.restoreFunction(function, declaration);
        OCChangeUtil.replaceHandlingMacros(function, declaration);
        Document document = PsiDocumentManager.getInstance((Project)project2).getDocument(definition.getContainingFile());
        if (document != null) {
            PsiDocumentManager.getInstance((Project)project2).doPostponedOperationsAndUnblockDocument(document);
        }
        CodeStyleManager.getInstance((Project)file2.getProject()).adjustLineIndent(definition.getContainingFile(), definition.getTextRange());
    }

    public boolean startInWriteAction() {
        return true;
    }

    @Nullable
    protected PsiElement getInsertAnchor(OCFunctionDefinition function) {
        OCDeclaration declaration;
        OCStruct struct = (OCStruct)PsiTreeUtil.getParentOfType((PsiElement)function, OCStruct.class);
        if (struct != null && (declaration = (OCDeclaration)PsiTreeUtil.getParentOfType((PsiElement)struct, OCDeclaration.class)) != null) {
            return declaration;
        }
        return function;
    }

    @Nullable
    protected static OCFunctionDefinition getFunction(Editor editor, PsiFile file2) {
        PsiElement element = file2.findElementAt(editor.getCaretModel().getOffset());
        return (OCFunctionDefinition)PsiTreeUtil.getParentOfType((PsiElement)element, OCFunctionDefinition.class, (boolean)false, (Class[])new Class[]{OCBlockStatement.class});
    }
}

