/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.intentions.OCMergeElseIfIntention;
import com.jetbrains.cidr.lang.psi.OCBinaryExpression;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCDeclarationOrExpression;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCIfStatement;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import org.jetbrains.annotations.NotNull;

public class OCMergeIfAndIntention
extends PsiElementBaseIntentionAction {
    public boolean isAvailable(@NotNull Project project2, Editor editor, @NotNull PsiElement element) {
        OCStatement statement2 = (OCStatement)PsiTreeUtil.getParentOfType((PsiElement)element, OCStatement.class);
        if (statement2 == null) {
            return false;
        }
        if (!OCMergeElseIfIntention.checkCursorInAppropriatePosition(editor, statement2)) {
            return false;
        }
        if (this.checkStatement(statement2)) {
            return true;
        }
        statement2 = (OCStatement)PsiTreeUtil.getParentOfType((PsiElement)statement2, OCStatement.class);
        while (statement2 instanceof OCBlockStatement) {
            statement2 = (OCStatement)PsiTreeUtil.getParentOfType((PsiElement)statement2, OCStatement.class);
        }
        return this.checkStatement(statement2);
    }

    @NotNull
    public String getFamilyName() {
        return "Merge Nested Ifs";
    }

    public void invoke(@NotNull Project project2, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (!FileModificationService.getInstance().prepareFileForWrite(element.getContainingFile())) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        OCStatement parentStatement = (OCStatement)PsiTreeUtil.getParentOfType((PsiElement)element, OCStatement.class);
        if (parentStatement == null) {
            return;
        }
        if (!this.checkStatement(parentStatement)) {
            parentStatement = (OCStatement)PsiTreeUtil.getParentOfType((PsiElement)parentStatement, OCIfStatement.class);
        }
        if (parentStatement == null) {
            return;
        }
        OCIfStatement parentIfStatement = (OCIfStatement)parentStatement;
        OCStatement childStatement = OCParenthesesUtils.stripBraces(parentIfStatement.getThenBranch());
        if (!(childStatement instanceof OCIfStatement)) {
            return;
        }
        OCIfStatement childIfStatement = (OCIfStatement)childStatement;
        OCDeclarationOrExpression childCondition = childIfStatement.getCondition();
        OCExpression childExpressionCondition = childCondition.getExpression();
        OCDeclarationOrExpression parentCondition = parentIfStatement.getCondition();
        OCExpression parentExpressionCondition = parentCondition.getExpression();
        OCBinaryExpression newCondition = (OCBinaryExpression)OCElementFactory.expressionFromText("1 && 2", childExpressionCondition);
        OCParenthesesUtils.replaceExpressionAndAppendParentheses(newCondition.getLeft(), parentExpressionCondition);
        OCParenthesesUtils.replaceExpressionAndAppendParentheses(newCondition.getRight(), childExpressionCondition);
        parentExpressionCondition.replace(newCondition);
        parentIfStatement.getThenBranch().replace(childIfStatement.getThenBranch());
    }

    private boolean checkStatement(OCStatement statement2) {
        if (statement2 instanceof OCIfStatement) {
            this.setText(this.getFamilyName());
            OCIfStatement ifStatement = (OCIfStatement)statement2;
            OCStatement thenBranch = ifStatement.getThenBranch();
            thenBranch = OCParenthesesUtils.stripBraces(thenBranch);
            OCStatement elseBranch = ifStatement.getElseBranch();
            elseBranch = OCParenthesesUtils.stripBraces(elseBranch);
            if (thenBranch == null || elseBranch != null || !(thenBranch instanceof OCIfStatement)) {
                return false;
            }
            if (ifStatement.getCondition() == null || ifStatement.getCondition().getExpression() == null) {
                return false;
            }
            OCIfStatement childIfStatement = (OCIfStatement)thenBranch;
            if (childIfStatement.getCondition() == null || childIfStatement.getCondition().getExpression() == null) {
                return false;
            }
            return childIfStatement.getElseBranch() == null;
        }
        return false;
    }
}

