/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.generate.handlers.OCGeneratePropertiesHandler;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCGeneratePropertyIntentionAction
extends OCGeneratePropertiesHandler
implements IntentionAction {
    @NotNull
    public String getText() {
        return "Generate property";
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @Override
    @Nullable
    protected OCInstanceVariableSymbol locateCandidate(@NotNull Project project2, Editor editor, PsiFile file2) {
        OCSymbol symbol;
        PsiElement at = file2.findElementAt(editor.getCaretModel().getOffset());
        OCDeclarator parent = OCElementUtil.getAdjacentParentOfType(at, OCDeclarator.class);
        OCSymbol oCSymbol = symbol = parent != null ? parent.getSymbol() : null;
        if (!(symbol instanceof OCInstanceVariableSymbol)) {
            return null;
        }
        OCInstanceVariableSymbol ivar = (OCInstanceVariableSymbol)symbol;
        return ivar.getAssociatedProperty() == null ? ivar : null;
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        return OCSearchScope.isInProjectSources(this.locateCandidate(project2, editor, file2));
    }

    @Override
    protected OCClassSymbol getParent(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file2) {
        OCInstanceVariableSymbol ivar = this.locateCandidate(project2, editor, file2);
        return ivar != null ? ((OCClassSymbol)ivar.getParent()).getMainInterface() : null;
    }

    @Override
    protected boolean replaceAllIvars() {
        return false;
    }

    @Override
    protected boolean enableChooseDialog(Collection<OCInstanceVariableSymbol> candidates) {
        return false;
    }
}

