/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.generate.OCCppDefinitionsUtil;
import com.jetbrains.cidr.lang.generate.OCGenerateUtil;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCGenerateDefinitionsIntentionActionBase
implements IntentionAction {
    @Nls
    @NotNull
    public String getFamilyName() {
        return OCBundle.message("generate.definitions.intention.familyName", new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        assert (editor != null);
        return OCGenerateDefinitionsIntentionActionBase.isAvailable(OCGenerateDefinitionsIntentionActionBase.findFunction(editor, file2));
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        OCFunctionSymbol function = OCGenerateDefinitionsIntentionActionBase.findFunction(editor, file2);
        if (OCGenerateDefinitionsIntentionActionBase.isAvailable(function)) {
            List<OCGenerateUtil.Replacement> replacements = this.isInline() ? OCCppDefinitionsUtil.getInlineReplacements(file2, Collections.singletonList(function)) : OCCppDefinitionsUtil.getOutsideReplacementsAtPreferredPosition(file2, Collections.singletonList(function));
            OCGenerateUtil.applyReplacements(project2, OCBundle.message("generate.definitions.commandName", new Object[0]), replacements);
        }
    }

    public boolean startInWriteAction() {
        return false;
    }

    protected abstract boolean isInline();

    @Nullable
    private static OCFunctionSymbol findFunction(@NotNull Editor editor, @NotNull PsiFile file2) {
        PsiElement at = file2.findElementAt(editor.getCaretModel().getOffset());
        OCFunctionDeclaration function = (OCFunctionDeclaration)PsiTreeUtil.getParentOfType((PsiElement)at, OCFunctionDeclaration.class);
        OCSymbolWithQualifiedName symbol = function != null ? (OCSymbolWithQualifiedName)function.getSymbol() : null;
        return (OCFunctionSymbol)ObjectUtils.tryCast((Object)symbol, OCFunctionSymbol.class);
    }

    @Contract(value="null -> false")
    private static boolean isAvailable(OCFunctionSymbol function) {
        return function != null && !(function.getParent() instanceof OCStructSymbol) && OCCppDefinitionsUtil.shouldGenerateDefinitionsFor(function);
    }
}

