/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.HashMap;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCBinaryExpression;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class OCFlipComparisonIntentionAction
extends PsiElementBaseIntentionAction {
    private static final Map<OCElementType, String> FLIPPED_OPERATORS = new HashMap(7);

    public boolean isAvailable(@NotNull Project project2, Editor editor, @NotNull PsiElement element) {
        OCBinaryExpression binaryExpression = (OCBinaryExpression)PsiTreeUtil.getParentOfType((PsiElement)element, OCBinaryExpression.class, (boolean)false);
        while (binaryExpression != null) {
            OCElementType operator = binaryExpression.getOperationSign();
            if (FLIPPED_OPERATORS.containsKey((Object)operator)) {
                if (binaryExpression.getRight() == null) {
                    return false;
                }
                if (!OCCodeInsightUtil.isValid(binaryExpression.getLeft())) {
                    return false;
                }
                if (!OCCodeInsightUtil.isValid(binaryExpression.getRight())) {
                    return false;
                }
                String operatorText = binaryExpression.getOperationSignNode().getText();
                String flippedOperatorText = FLIPPED_OPERATORS.get((Object)operator);
                if (flippedOperatorText.equals(operatorText)) {
                    this.setText("Flip " + operatorText);
                } else {
                    this.setText("Flip " + operatorText + " to " + flippedOperatorText);
                }
                return true;
            }
            binaryExpression = (OCBinaryExpression)PsiTreeUtil.getParentOfType((PsiElement)binaryExpression, OCBinaryExpression.class);
        }
        return false;
    }

    @NotNull
    public String getFamilyName() {
        return "Flip Binary Operation";
    }

    public void invoke(@NotNull Project project2, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (!FileModificationService.getInstance().preparePsiElementForWrite(element)) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        OCBinaryExpression binaryExpression = OCElementUtil.getAdjacentParentOfType(element, OCBinaryExpression.class);
        while (binaryExpression != null) {
            OCElementType sign = binaryExpression.getOperationSign();
            if (FLIPPED_OPERATORS.containsKey((Object)sign)) {
                OCExpression right = binaryExpression.getRight();
                if (right == null) {
                    return;
                }
                String newSign = FLIPPED_OPERATORS.get((Object)sign);
                OCBinaryExpression newBinaryExpression = (OCBinaryExpression)OCElementFactory.expressionFromText("1" + newSign + "2", element);
                OCChangeUtil.replaceHandlingMacros(newBinaryExpression.getLeft(), binaryExpression.getRight());
                OCChangeUtil.replaceHandlingMacros(newBinaryExpression.getRight(), binaryExpression.getLeft());
                binaryExpression.replace(newBinaryExpression);
                return;
            }
            binaryExpression = (OCBinaryExpression)PsiTreeUtil.getParentOfType((PsiElement)binaryExpression, OCBinaryExpression.class);
        }
    }

    static {
        FLIPPED_OPERATORS.put(OCTokenTypes.ANDAND, "&&");
        FLIPPED_OPERATORS.put(OCTokenTypes.OROR, "||");
        FLIPPED_OPERATORS.put(OCTokenTypes.EQEQ, "==");
        FLIPPED_OPERATORS.put(OCTokenTypes.EXCLEQ, "!=");
        FLIPPED_OPERATORS.put(OCTokenTypes.GTEQ, "<=");
        FLIPPED_OPERATORS.put(OCTokenTypes.LTEQ, ">=");
        FLIPPED_OPERATORS.put(OCTokenTypes.GT, "<");
        FLIPPED_OPERATORS.put(OCTokenTypes.LT, ">");
    }
}

