/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.generate.handlers.OCDeclareActionContext;
import com.jetbrains.cidr.lang.generate.handlers.OCDeclareMembersHandler;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCProperty;
import com.jetbrains.cidr.lang.quickfixes.OCChangePropertyAttributeIntentionAction;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCDeclarePropertyInPrivateCategoryIntentionAction
extends OCDeclareMembersHandler
implements IntentionAction {
    @NotNull
    public String getText() {
        return "Declare property as 'readwrite' in private category";
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        OCPropertySymbol property = this.locateCandidate(project2, editor, file2);
        return property != null && OCSearchScope.isInProjectSources(property) && !"".equals(((OCClassSymbol)property.getParent()).getCategoryName()) && property.getAssociatedPropertyInPrivateCategory() == null;
    }

    @Override
    @NotNull
    protected OCDeclareActionContext evaluateActionContext(OCClassSymbol parent, PsiElement element) {
        OCDeclareActionContext context = super.evaluateActionContext(parent, element);
        context.setTarget(OCDeclareActionContext.Target.PRIVATE_CATEGORY);
        return context;
    }

    @Override
    protected boolean enableChooseDialog(Collection<OCMemberSymbol> candidates) {
        return false;
    }

    @Override
    @Nullable
    protected OCPropertySymbol locateCandidate(@NotNull Project project2, Editor editor, PsiFile file2) {
        PsiElement at = file2.findElementAt(editor.getCaretModel().getOffset());
        OCDeclarator declarator = OCElementUtil.getAdjacentParentOfType(at, OCDeclarator.class);
        if (declarator == null) {
            return null;
        }
        OCSymbol symbol = declarator.getSymbol();
        return symbol instanceof OCPropertySymbol ? (OCPropertySymbol)symbol : null;
    }

    @Override
    protected OCClassSymbol getParent(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file2) {
        OCPropertySymbol property = this.locateCandidate(project2, editor, file2);
        return property != null ? (OCClassSymbol)property.getParent() : null;
    }

    @Override
    protected PsiElement moveDeclaration(PsiElement parent, PsiElement declaration) {
        OCProperty newProperty = (OCProperty)OCChangeUtil.add(parent, declaration);
        new OCChangePropertyAttributeIntentionAction(newProperty, OCPropertySymbol.PropertyAttribute.READONLY, OCPropertySymbol.PropertyAttribute.READWRITE).invoke(declaration.getProject(), null, newProperty.getContainingFile());
        new OCChangePropertyAttributeIntentionAction((OCProperty)declaration, OCPropertySymbol.PropertyAttribute.READWRITE, OCPropertySymbol.PropertyAttribute.READONLY).invoke(declaration.getProject(), null, declaration.getContainingFile());
        return newProperty;
    }
}

