/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.inspections;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.OCTestFrameworks;
import com.jetbrains.cidr.lang.inspections.OCUnusedCodeInspection;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.impl.OCArraySelectionExpressionImpl;
import com.jetbrains.cidr.lang.quickfixes.OCChangeGCCAttributeIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCSafeDeleteIntentionAction;
import com.jetbrains.cidr.lang.search.OCElementInMacroAndNonCompiledCodeReferencesSearch;
import com.jetbrains.cidr.lang.search.OCMemberInheritorsSearch;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class OCUnusedMethodInspection
extends OCUnusedCodeInspection {
    @Override
    @NotNull
    public OCUnusedCodeInspection.UnusedVisitor buildVisitor() {
        return new OCUnusedCodeInspection.UnusedVisitor(){

            @Override
            public void visitMethod(OCMethod method) {
                SearchScope scope;
                OCSymbol symbol = this.getSymbol(method);
                if (!(symbol instanceof OCMethodSymbol) || symbol.hasAttribute("unused") || symbol.hasAttribute("used")) {
                    return;
                }
                OCMethodSymbol methodSymbol = (OCMethodSymbol)symbol;
                OCFile.UnusedChecksMode checksMode = (OCFile.UnusedChecksMode)((Object)method.getProject().getUserData(OCFile.UNUSED_CHECKS));
                if (!OCSearchScope.isInProjectSources(symbol) || checksMode == OCFile.UnusedChecksMode.DISABLED) {
                    return;
                }
                String selector = method.getSelector();
                OCMethodSymbol associatedSymbol = methodSymbol.getAssociatedSymbol();
                if (OCTestFrameworks.isTestMethod(methodSymbol) && OCTestFrameworks.isTestClass(methodSymbol.getParent()) || methodSymbol.getName().startsWith("keyPathsForValuesAffecting") || OCArraySelectionExpressionImpl.isArraySubscriptMethod(methodSymbol)) {
                    return;
                }
                if (associatedSymbol != null) {
                    if (!this.myOnTheFly && (methodSymbol.isDefinition() || methodSymbol.getGeneratedFromProperty() != null) || associatedSymbol.hasAttribute("unused") || associatedSymbol.hasAttribute("used")) {
                        return;
                    }
                    OCPropertySymbol property = associatedSymbol.getGeneratedFromProperty();
                    if (property != null) {
                        this.checkSymbolUsed(method, method.getParameters().get(0).getSelectorIdentifier(), property, false);
                        return;
                    }
                }
                Object object = scope = this.myScope != null ? this.myScope : OCSearchScope.getProjectSourcesScope(method.getProject());
                if (scope instanceof GlobalSearchScope && PsiSearchHelper.SERVICE.getInstance((Project)method.getProject()).isCheapEnoughToSearch(selector, (GlobalSearchScope)scope, method.getContainingFile(), null) == PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES) {
                    return;
                }
                if (ReferencesSearch.search((PsiElement)method, (SearchScope)scope, (boolean)false).findFirst() != null) {
                    return;
                }
                CommonProcessors.FindFirstProcessor macroFinder = new CommonProcessors.FindFirstProcessor();
                ReferencesSearch.SearchParameters macroParameters = new ReferencesSearch.SearchParameters((PsiElement)method, (SearchScope)OCSearchScope.getProjectSourcesScope(method.getProject()), false);
                new OCElementInMacroAndNonCompiledCodeReferencesSearch().execute(macroParameters, (Processor<OCElementInMacroAndNonCompiledCodeReferencesSearch.Usage>)macroFinder);
                if (macroFinder.isFound()) {
                    return;
                }
                OCMemberInheritorsSearch.SearchParameters<OCMethodSymbol> searchParameters = OCMemberInheritorsSearch.getParameters(method);
                searchParameters.setInheritors(false);
                searchParameters.setAncestors(true);
                searchParameters.setIncludeFromID(true);
                if (OCMemberInheritorsSearch.search(searchParameters).findFirst() == null) {
                    List<PsiElement> selectors = method.getSelectors();
                    if (!this.myOnTheFly && !selectors.isEmpty()) {
                        selectors = Collections.singletonList(selectors.get(0));
                    }
                    this.registerProblems(selectors, symbol.getNameWithKindUppercase() + " is never used", ProblemHighlightType.LIKE_UNUSED_SYMBOL, new IntentionAction[]{new OCSafeDeleteIntentionAction((PsiElement)method, symbol.getNameWithKindLowercase()), new OCChangeGCCAttributeIntentionAction.SuppressFix(methodSymbol, "unused", "__unused", true)});
                }
            }
        };
    }
}

