/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.inspections;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.daemon.OCSuppressionGroup;
import com.jetbrains.cidr.lang.inspections.OCInspections;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.quickfixes.OCSuppressClangDiagnosticIntentionAction;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCNotLocalizedStringInspection
extends OCInspections.GeneralObjC {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        return "Non-localized string";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        return new OCVisitor(){

            @Override
            public void visitLiteralExpression(OCLiteralExpression expression) {
                String literalText;
                OCMacroCall macroCall;
                if (!(isOnTheFly && (!ApplicationManager.getApplication().isUnitTestMode() || !expression.getUnescapedLiteralText().equals("NLS")) || expression.getReferences().length != 0 || OCElementUtil.isPartOfMacroSubstitution(expression) || !expression.getResolvedType().isPointerToStringCompatible() || (macroCall = (OCMacroCall)PsiTreeUtil.getParentOfType((PsiElement)expression, OCMacroCall.class)) != null && macroCall.getMacroReferenceElement() != null && macroCall.getMacroReferenceElement().getName().startsWith("NSLocalizedString") || (literalText = expression.getUnescapedLiteralText()).isEmpty())) {
                    OCNotLocalizedStringInspection.this.registerProblem(holder, null, null, isOnTheFly, expression, "Non-localized string: " + expression.getRawLiteralText(), "CIDR", ProblemHighlightType.INFORMATION, new IntentionAction[0]);
                }
            }
        };
    }

    public boolean isSuppressedFor(@NotNull PsiElement element) {
        return false;
    }

    @NotNull
    public SuppressQuickFix[] getBatchSuppressActions(@Nullable PsiElement element) {
        OCSuppressionGroup suppressionGroup = new OCSuppressionGroup("ide", ((Object)((Object)this)).getClass().getSimpleName());
        return new SuppressQuickFix[]{new OCSuppressClangDiagnosticIntentionAction.SuppressFixForStatement(suppressionGroup), new OCSuppressClangDiagnosticIntentionAction.SuppressFixForCallable(suppressionGroup), new OCSuppressClangDiagnosticIntentionAction.SuppressFixForFile(suppressionGroup)};
    }
}

