/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.inspections;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import com.intellij.util.containers.hash.HashSet;
import com.jetbrains.cidr.lang.inspections.OCInspections;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCDefineDirective;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCForStatement;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.OCUnaryExpression;
import com.jetbrains.cidr.lang.psi.OCWhileStatement;
import com.jetbrains.cidr.lang.psi.impl.OCMacroReferenceElementImpl;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveVisitor;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCLoopDoesntUseConditionVariableInspection
extends OCInspections.GeneralCpp {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        return "Loop condition isn't updated inside the loop";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new ForLoopThatDoesntUseLoopVariableVisitor(holder);
    }

    private class ForLoopThatDoesntUseLoopVariableVisitor
    extends OCVisitor {
        private final ProblemsHolder myHolder;

        public ForLoopThatDoesntUseLoopVariableVisitor(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        @Override
        public void visitForStatement(@NotNull OCForStatement statement2) {
            this.visitLoop(statement2.getCondition(), statement2.getBody(), statement2.getIncrement());
        }

        @Override
        public void visitWhileStatement(OCWhileStatement statement2) {
            this.visitLoop(statement2.getCondition(), statement2.getBody(), null);
        }

        private void visitLoop(@Nullable OCElement condition, final @Nullable OCElement body, final @Nullable OCElement updater) {
            if (condition == null) {
                return;
            }
            final Ref declaratorUsed = new Ref((Object)false);
            HashSet usedSymbols = new HashSet();
            if (OCCodeInsightUtil.hasSideEffects(condition)) {
                return;
            }
            this.processAllUsedSymbol(condition, new PairProcessor<OCSymbolDeclarator, OCElement>((Set)usedSymbols){
                final /* synthetic */ Set val$usedSymbols;
                {
                    this.val$usedSymbols = set;
                }

                public boolean process(OCSymbolDeclarator declarator, OCElement element) {
                    OCExpression unparen;
                    Object symbol = declarator.getSymbol();
                    if (symbol == null || !symbol.getKind().isLocal() || symbol instanceof OCDeclaratorSymbol && ((OCDeclaratorSymbol)symbol).isBlockModifiable()) {
                        declaratorUsed.set((Object)true);
                        return false;
                    }
                    if (element.getParent() instanceof OCReferenceExpression && (OCCodeInsightUtil.isLValue(unparen = OCParenthesesUtils.topmostParenthesized((OCExpression)element.getParent())) || unparen.getParent() instanceof OCUnaryExpression && ((OCUnaryExpression)unparen.getParent()).getOperationSign() == OCTokenTypes.MUL)) {
                        declaratorUsed.set((Object)true);
                        return false;
                    }
                    this.val$usedSymbols.add(declarator);
                    return true;
                }
            });
            if (!((Boolean)declaratorUsed.get()).booleanValue() && !usedSymbols.isEmpty()) {
                for (OCSymbolDeclarator declarator : usedSymbols) {
                    ReferencesSearch.SearchParameters searchParameters = new ReferencesSearch.SearchParameters((PsiElement)declarator, declarator.getUseScope(), false);
                    ReferencesSearch.search((ReferencesSearch.SearchParameters)searchParameters).forEach((Processor)new Processor<PsiReference>(){

                        public boolean process(PsiReference reference) {
                            PsiElement element = reference.getElement();
                            if (PsiTreeUtil.isAncestor((PsiElement)body, (PsiElement)element, (boolean)false) || PsiTreeUtil.isAncestor((PsiElement)updater, (PsiElement)element, (boolean)false)) {
                                if (element instanceof OCReferenceElement) {
                                    element = element.getParent();
                                }
                                if (element instanceof OCExpression && OCCodeInsightUtil.isLValue((OCExpression)element)) {
                                    declaratorUsed.set((Object)true);
                                    return false;
                                }
                            }
                            return true;
                        }
                    });
                    if (!((Boolean)declaratorUsed.get()).booleanValue()) continue;
                    break;
                }
                if (!((Boolean)declaratorUsed.get()).booleanValue()) {
                    StringBuilder builder = new StringBuilder();
                    builder.append("Local ");
                    if (usedSymbols.size() > 1) {
                        builder.append("variables used in loop condition are ");
                    } else {
                        builder.append("variable used in loop condition is ");
                    }
                    builder.append("not updated in the loop");
                    OCLoopDoesntUseConditionVariableInspection.this.registerProblem(this.myHolder, null, null, this.myHolder.isOnTheFly(), condition, builder.toString(), "warn_variables_not_in_loop_body", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new IntentionAction[0]);
                }
            }
        }

        private void processAllUsedSymbol(OCElement condition, final PairProcessor<OCSymbolDeclarator, OCElement> processor2) {
            condition.accept(new OCRecursiveVisitor(){
                public boolean myStopped = false;

                @Override
                public void visitReferenceElement(OCReferenceElement element) {
                    this.checkReferences(element);
                    super.visitReferenceElement(element);
                }

                @Override
                public void visitQualifiedExpression(OCQualifiedExpression expression) {
                    this.checkReferences(expression);
                    super.visitQualifiedExpression(expression);
                }

                @Override
                public void visitSendMessageExpression(OCSendMessageExpression expression) {
                    this.checkReferences(expression);
                    super.visitSendMessageExpression(expression);
                }

                @Override
                public void visitExpression(OCExpression expression) {
                    this.checkReferences(expression);
                    super.visitExpression(expression);
                }

                private void checkReferences(OCElement element) {
                    PsiElement resolved;
                    PsiReference ref;
                    if (!(this.myStopped || (ref = element.getReference()) == null || !((resolved = ref.resolve()) instanceof OCSymbolDeclarator) || resolved instanceof OCDefineDirective || resolved instanceof OCMacroReferenceElementImpl || processor2.process((Object)((OCSymbolDeclarator)resolved), (Object)element))) {
                        this.myStopped = true;
                    }
                }
            });
        }
    }
}

