/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.inspections;

import com.intellij.codeInsight.daemon.impl.DefaultHighlightVisitorBasedInspection;
import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalSimpleInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.Processor;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.SortedList;
import com.jetbrains.cidr.lang.inspections.OCGlobalSearchScopeForUnusedCode;
import com.jetbrains.cidr.lang.inspections.OCInspectionToolProvider;
import com.jetbrains.cidr.lang.inspections.OCUnusedCodeInspection;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCSynthesizeProperty;
import com.jetbrains.cidr.lang.refactoring.OCSafeDeleteProcessorDelegate;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.search.usages.OCReadWriteAccessDetector;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolOffsetUtil;
import com.jetbrains.cidr.lang.symbols.cpp.OCMacroSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCGlobalUnusedInspection
extends GlobalSimpleInspectionTool {
    private static Key<Set<OCSymbol>> USED_SYMBOLS = Key.create((String)"USED_SYMBOLS");
    private static Key<Set<OCSymbol>> ACCESSED_SYMBOLS = Key.create((String)"ACCESSED_SYMBOLS");
    private static Key<Set<String>> USED_MACRO_NAMES = Key.create((String)"USED_MACRO_NAMES");
    private static Key<Set<VirtualFile>> ANALYZED_FILES = Key.create((String)"ANALYSIS_SCOPE");
    private ProblemsHolder myProblemsHolder;

    public OCGlobalUnusedInspection(ProblemsHolder problemsHolder) {
        this.myProblemsHolder = problemsHolder;
    }

    public OCGlobalUnusedInspection() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void markSymbolAsUsed(@Nullable OCSymbol symbol, PsiElement usage) {
        if (symbol == null || !OCSearchScope.isInProjectSources(symbol)) {
            return;
        }
        Project project2 = symbol.getProject();
        if (project2 != null) {
            Set usedSymbols = (Set)project2.getUserData(USED_SYMBOLS);
            Set usedMacroNames = (Set)project2.getUserData(USED_MACRO_NAMES);
            Set accessedSymbols = (Set)project2.getUserData(ACCESSED_SYMBOLS);
            if (usedSymbols != null) {
                Set set = usedSymbols;
                synchronized (set) {
                    boolean isWrite;
                    if (symbol instanceof OCStructSymbol && OCSafeDeleteProcessorDelegate.isSafeToDelete(usage, ((OCStructSymbol)symbol).locateDefinition())) {
                        return;
                    }
                    usedSymbols.add(symbol);
                    boolean bl = isWrite = OCUnusedCodeInspection.isWritableSymbol(symbol) && new OCReadWriteAccessDetector().getExpressionAccess(usage) == ReadWriteAccessDetector.Access.Write;
                    if (!isWrite) {
                        accessedSymbols.add(symbol);
                    }
                    if (symbol instanceof OCMacroSymbol) {
                        usedMacroNames.add(symbol.getName());
                    }
                    OCPropertySymbol property = null;
                    if (symbol instanceof OCMethodSymbol) {
                        property = ((OCMethodSymbol)symbol).getGeneratedFromProperty();
                    }
                    if (symbol instanceof OCInstanceVariableSymbol && ((OCInstanceVariableSymbol)symbol).getGeneratedFromProperty() != null && !(usage instanceof OCSynthesizeProperty)) {
                        property = ((OCInstanceVariableSymbol)symbol).getAssociatedProperty();
                    }
                    if (property != null) {
                        isWrite = OCUnusedCodeInspection.isWritableSymbol(property) && new OCReadWriteAccessDetector().getExpressionAccess(usage) == ReadWriteAccessDetector.Access.Write;
                        usedSymbols.add(property);
                        if (!isWrite) {
                            accessedSymbols.add(property);
                        }
                    }
                }
            }
        }
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        return "Global unused analysis";
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        return "General";
    }

    public void checkFile(@NotNull PsiFile file2, @NotNull InspectionManager manager, @NotNull ProblemsHolder problemsHolder, @NotNull GlobalInspectionContext globalContext, @NotNull ProblemDescriptionsProcessor problemDescriptionsProcessor) {
        Set analysisScope = (Set)file2.getProject().getUserData(ANALYZED_FILES);
        if (analysisScope != null && file2 instanceof OCFile) {
            analysisScope.add(file2.getVirtualFile());
        }
    }

    public void inspectionStarted(@NotNull InspectionManager manager, @NotNull GlobalInspectionContext globalContext, @NotNull ProblemDescriptionsProcessor problemDescriptionsProcessor) {
        manager.getProject().putUserData(USED_SYMBOLS, (Object)new THashSet());
        manager.getProject().putUserData(ACCESSED_SYMBOLS, (Object)new THashSet());
        manager.getProject().putUserData(USED_MACRO_NAMES, (Object)new THashSet());
        manager.getProject().putUserData(ANALYZED_FILES, new LinkedHashSet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inspectionFinished(@NotNull InspectionManager manager, @NotNull GlobalInspectionContext globalContext, @NotNull ProblemDescriptionsProcessor problemDescriptionsProcessor) {
        final Project project2 = manager.getProject();
        final Set usedSymbols = (Set)project2.getUserData(USED_SYMBOLS);
        final Set accessedSymbols = (Set)project2.getUserData(ACCESSED_SYMBOLS);
        final Set usedMacroNames = (Set)project2.getUserData(USED_MACRO_NAMES);
        final Set analyzedFiles = (Set)project2.getUserData(ANALYZED_FILES);
        try {
            final ArrayList<OCUnusedCodeInspection.UnusedVisitor> visitors = new ArrayList<OCUnusedCodeInspection.UnusedVisitor>();
            if (usedSymbols == null || accessedSymbols == null || analyzedFiles == null || usedMacroNames == null) {
                return;
            }
            OCGlobalSearchScopeForUnusedCode searchScope = new OCGlobalSearchScopeForUnusedCode(OCSearchScope.getProjectSourcesScope(manager.getProject())){

                @Override
                public boolean contains(@NotNull VirtualFile file2) {
                    return super.contains(file2) && !analyzedFiles.contains(file2);
                }
            };
            for (Class clazz : OCInspectionToolProvider.getInstance().getStandaloneInspectionClasses()) {
                if (!OCUnusedCodeInspection.class.isAssignableFrom(clazz)) continue;
                try {
                    OCUnusedCodeInspection.UnusedVisitor visitor = ((OCUnusedCodeInspection)((Object)clazz.newInstance())).buildVisitor();
                    if (visitor == null) continue;
                    visitor.setUpForBatchMode(problemDescriptionsProcessor, globalContext, (SearchScope)searchScope);
                    visitor.setHolder(this.myProblemsHolder);
                    visitors.add(visitor);
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
            MultiMap<VirtualFile, OCSymbol> unusedSymbolsPerFile = new MultiMap<VirtualFile, OCSymbol>(){

                @NotNull
                protected Collection<OCSymbol> createCollection() {
                    return new SortedList((Comparator)new Comparator<OCSymbol>(){

                        @Override
                        public int compare(OCSymbol s1, OCSymbol s2) {
                            return OCSymbolOffsetUtil.compare(s1.getComplexOffset(), s2.getComplexOffset());
                        }
                    });
                }
            };
            Processor<OCSymbol> collector = new Processor<OCSymbol>((MultiMap)unusedSymbolsPerFile){
                final /* synthetic */ MultiMap val$unusedSymbolsPerFile;
                {
                    this.val$unusedSymbolsPerFile = multiMap;
                }

                public boolean process(OCSymbol symbol) {
                    ProgressManager.checkCanceled();
                    if (!(!analyzedFiles.contains(symbol.getContainingFile()) || accessedSymbols.contains(symbol) || symbol instanceof OCMacroSymbol && usedMacroNames.contains(symbol.getName()))) {
                        this.val$unusedSymbolsPerFile.putValue((Object)symbol.getContainingFile(), (Object)symbol);
                    }
                    return true;
                }
            };
            ApplicationManager.getApplication().runReadAction(new Runnable((Processor)collector){
                final /* synthetic */ Processor val$collector;
                {
                    this.val$collector = processor2;
                }

                @Override
                public void run() {
                    OCGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(project2, (Processor<OCSymbol>)this.val$collector, null);
                }
            });
            ProgressManager.progress((String)"Evaluating unused symbols");
            for (VirtualFile eachAnalyzedFile : analyzedFiles) {
                for (final OCSymbol symbol : unusedSymbolsPerFile.get((Object)eachAnalyzedFile)) {
                    final Ref prevElement = new Ref();
                    ApplicationManager.getApplication().runReadAction(new Runnable(){

                        @Override
                        public void run() {
                            ProgressManager.checkCanceled();
                            Object definition = symbol.locateDefinition();
                            if (definition != null && !definition.equals(prevElement.get())) {
                                prevElement.set(definition);
                                for (OCUnusedCodeInspection.UnusedVisitor visitor : visitors) {
                                    visitor.checkFromBatchMode(symbol, (PsiElement)definition, usedSymbols.contains(symbol));
                                }
                            }
                        }
                    });
                }
            }
        }
        finally {
            project2.putUserData(USED_SYMBOLS, null);
            project2.putUserData(ACCESSED_SYMBOLS, null);
            project2.putUserData(ANALYZED_FILES, null);
            project2.putUserData(USED_MACRO_NAMES, null);
        }
    }

    @Nullable
    public String getMainToolId() {
        return new DefaultHighlightVisitorBasedInspection.AnnotatorBasedInspection().getShortName();
    }
}

