/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.inspections;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.lang.annotation.AnnotationSession;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ui.CheckBox;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.dfa.OCControlFlowGraph;
import com.jetbrains.cidr.lang.dfa.OCInstruction;
import com.jetbrains.cidr.lang.dfa.OCLocalDefinitionsSearcher;
import com.jetbrains.cidr.lang.dfa.OCUnreachableCodeFinder;
import com.jetbrains.cidr.lang.dfa.contextSensitive.OCContextSensitiveControlFlowBuilder;
import com.jetbrains.cidr.lang.dfa.contextSensitive.OCDFAUtils;
import com.jetbrains.cidr.lang.dfa.contextSensitive.OCSourceGliderComponent;
import com.jetbrains.cidr.lang.inspections.OCInspections;
import com.jetbrains.cidr.lang.inspections.OCSimplifyInspection;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.preprocessor.OCMacroForeignLeafElement;
import com.jetbrains.cidr.lang.psi.OCBinaryExpression;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCIfStatement;
import com.jetbrains.cidr.lang.psi.OCLoopStatement;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveVisitor;
import com.jetbrains.cidr.lang.quickfixes.OCAddInitializerIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCChangeElementIntentionAction;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementsRange;
import com.jetbrains.sourceglider.ManagerInstancesProvider;
import com.jetbrains.sourceglider.atttributes.Attribute;
import com.jetbrains.sourceglider.bdd.BDDMemoryOverflowException;
import com.jetbrains.sourceglider.relations.IRelation;
import com.jetbrains.sourceglider.relations.RelationSignature;
import com.jetbrains.sourceglider.scripts.rml.ProfileManager;
import com.jetbrains.sourceglider.ui.DummyThreadCallback;
import com.jetbrains.sourceglider.ui.Task;
import com.jetbrains.sourceglider.ui.ThreadCallback;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCDFAInspection
extends OCInspections.DataFlowAnalysis {
    private static final Boolean ENABLE_RML_PROFILING = false;
    private static final Boolean ENABLE_BDD_PROFILING = false;
    private static final Boolean ENABLE_RELATIONS_PROFILING = false;
    public static final long TIME_LIMIT = 5000000000L;
    public static final Key<Long> DFA_TIME_LIMIT = Key.create((String)"DFA_TIME_LIMIT");
    private ProblemsHolder myProblemsHolder;
    private Map<Object, Object> myTestOptions;
    public boolean enableConstantCondition = true;
    public boolean enableIncompatibleCast = true;
    public boolean enableNullDereference = true;
    public boolean enableUnrecognizedSelector = true;
    public boolean enableUnreachableCode = true;

    public OCDFAInspection() {
    }

    public OCDFAInspection(ProblemsHolder problemsHolder, Map<Object, Object> testOptions) {
        this.myProblemsHolder = problemsHolder;
        this.myTestOptions = testOptions;
    }

    public JComponent createOptionsPanel() {
        JPanel panel = new JPanel((LayoutManager)new VerticalFlowLayout());
        panel.add((Component)new CheckBox("Constant conditions", (InspectionProfileEntry)this, "enableConstantCondition"));
        panel.add((Component)new CheckBox("Incompatible casts", (InspectionProfileEntry)this, "enableIncompatibleCast"));
        panel.add((Component)new CheckBox("Null dereferences", (InspectionProfileEntry)this, "enableNullDereference"));
        panel.add((Component)new CheckBox("Unrecognized selectors", (InspectionProfileEntry)this, "enableUnrecognizedSelector"));
        panel.add((Component)new CheckBox("Unreachable code", (InspectionProfileEntry)this, "enableUnreachableCode"));
        return panel;
    }

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        return "Context-sensitive analysis";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inspectionFinished(@NotNull LocalInspectionToolSession session, @NotNull ProblemsHolder problemsHolder) {
        if (!(session.getFile() instanceof OCFile)) {
            return;
        }
        OCFile file2 = (OCFile)session.getFile();
        HashMap<Object, Object> options = new HashMap<Object, Object>();
        if (this.myTestOptions != null) {
            options.putAll(this.myTestOptions);
        }
        if (ENABLE_RML_PROFILING.booleanValue()) {
            options.put(ProfileManager.class, true);
        }
        if (this.myProblemsHolder != null) {
            problemsHolder = this.myProblemsHolder;
        }
        Class<OCDFAInspection> clazz = OCDFAInspection.class;
        synchronized (OCDFAInspection.class) {
            try {
                file2.pushAnnotationSession(new AnnotationSession((PsiFile)file2));
                Ref contextSensitiveResult = Ref.create();
                Ref contextInsensitiveResult = Ref.create();
                OCDFAInspection.runAnalysisInParallel(file2, new HashMap<Object, Object>(options), true, (Ref<Result>)contextSensitiveResult);
                OCDFAInspection.runAnalysisInParallel(file2, new HashMap<Object, Object>(options), false, (Ref<Result>)contextInsensitiveResult);
                try {
                    Class<Result> clazz2 = Result.class;
                    synchronized (Result.class) {
                        while (contextSensitiveResult.isNull() || contextInsensitiveResult.isNull()) {
                            Result.class.wait();
                        }
                        // ** MonitorExit[var8_8] (shouldn't be in output)
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                {
                    OCContextSensitiveControlFlowBuilder flowBuilder;
                    ManagerInstancesProvider provider;
                    if (((Result)contextSensitiveResult.get()).isFinishedSuccessfully()) {
                        provider = ((Result)contextSensitiveResult.get()).getProvider();
                        flowBuilder = ((Result)contextSensitiveResult.get()).getFlowBuilder();
                    } else if (((Result)contextInsensitiveResult.get()).isFinishedSuccessfully()) {
                        provider = ((Result)contextInsensitiveResult.get()).getProvider();
                        flowBuilder = ((Result)contextInsensitiveResult.get()).getFlowBuilder();
                        this.reportTimeOverWarning(problemsHolder, file2, "File is too complex to perform context-sensitive data-flow analysis");
                    } else {
                        this.reportTimeOverWarning(problemsHolder, file2, "File is too complex to perform data-flow analysis");
                        // ** MonitorExit[var5_5] (shouldn't be in output)
                        return;
                    }
                    if (this.enableConstantCondition) {
                        HashSet<PsiElement> elements = new HashSet<PsiElement>();
                        OCDFAInspection.getElements(elements, provider, file2, "AlwaysTrueStatement");
                        OCDFAInspection.getElements(elements, provider, file2, "AlwaysFalseStatement");
                        OCDFAInspection.getElements(elements, provider, file2, "AlwaysTrueWhenReachedStatement");
                        OCDFAInspection.getElements(elements, provider, file2, "AlwaysFalseWhenReachedStatement");
                        Set<PsiElement> parents = OCDFAInspection.getParents(elements);
                        this.registerWarnings(problemsHolder, provider, file2, parents, "AlwaysTrueStatement", "Condition is always true", OCDFAInspection.getSimplifyFixes(file2, true));
                        this.registerWarnings(problemsHolder, provider, file2, parents, "AlwaysFalseStatement", "Condition is always false", OCDFAInspection.getSimplifyFixes(file2, false));
                        this.registerWarnings(problemsHolder, provider, file2, parents, "AlwaysTrueWhenReachedStatement", "Condition is always true when reached", OCDFAInspection.getSimplifyFixes(file2, true));
                        this.registerWarnings(problemsHolder, provider, file2, parents, "AlwaysFalseWhenReachedStatement", "Condition is always false when reached", OCDFAInspection.getSimplifyFixes(file2, false));
                    }
                    if (this.enableIncompatibleCast) {
                        this.registerWarnings(problemsHolder, provider, file2, null, "IllegalCastExpression", "Casting to probably incompatible type", null);
                    }
                    if (this.enableNullDereference) {
                        this.registerWarnings(problemsHolder, provider, file2, null, "NullDereference", "Reference may be " + (file2.getKind().isObjC() ? "nil" : "null"), OCDFAInspection.getInitializeFix(flowBuilder));
                    }
                    if (this.enableNullDereference) {
                        this.registerWarnings(problemsHolder, provider, file2, null, "NullReceiver", "Receiver is always " + (file2.getKind().isObjC() ? "nil" : "null"), OCDFAInspection.getInitializeFix(flowBuilder));
                    }
                    if (this.enableUnrecognizedSelector) {
                        this.registerWarnings(problemsHolder, provider, file2, null, "NoResponder", "Statement may fail with \"unrecognized selector\"", null);
                    }
                    if (this.enableUnreachableCode && file2.getProject().getUserData(OCFile.DFA_UNREACHABLE_CODE) != Boolean.FALSE) {
                        this.registerUnreachableWarnings(problemsHolder, provider, file2, flowBuilder, "UnreachableNode", "Unreachable code");
                    }
                    if (ENABLE_BDD_PROFILING.booleanValue()) {
                        provider.getUIInstancesProvider().getConsoleCommandProcessor().run(8, new String[0], null);
                    }
                    if (ENABLE_RELATIONS_PROFILING.booleanValue()) {
                        provider.getUIInstancesProvider().getConsoleCommandProcessor().run(9, new String[0], null);
                    }
                }
            }
            finally {
                OCSourceGliderComponent.getInstance().clearVisitorRunners();
                file2.popAnnotationSession();
            }
            {
                // ** MonitorExit[var5_5] (shouldn't be in output)
            }
            return;
        }
    }

    private static void runAnalysisInParallel(final OCFile file2, Map<Object, Object> options, boolean contextSensitive, final Ref<Result> result) {
        final OCSourceGliderComponent sourceGliderComponent = OCSourceGliderComponent.getInstance();
        final int index = contextSensitive ? 0 : 1;
        final ManagerInstancesProvider provider = sourceGliderComponent.getProvider(index);
        final Ref flowBuilder = Ref.create();
        sourceGliderComponent.addVisitorRunner(index, new OCSourceGliderComponent.VisitorRunner(){

            @Override
            public void run(final Map options, final ThreadCallback threadCallback) {
                flowBuilder.set((Object)new OCContextSensitiveControlFlowBuilder(provider.getSymbolTable(), new OCContextSensitiveControlFlowBuilder.TuplesConsumer(){

                    @Override
                    public void addTuple(RelationSignature signature, Attribute ... attributes) {
                        sourceGliderComponent.getVisitor(index).addTuple(signature, attributes);
                    }
                }));
                file2.accept(new OCRecursiveVisitor(){

                    @Override
                    public void visitCallable(OCCallable callable) {
                        ((OCContextSensitiveControlFlowBuilder)((Object)flowBuilder.get())).processCallable(callable, options, threadCallback);
                    }
                });
            }
        });
        provider.init();
        Long timeLimit = (Long)file2.getUserData(DFA_TIME_LIMIT);
        final OCDFAUtils.WorkingTimeMeasurer measurer = new OCDFAUtils.WorkingTimeMeasurer(timeLimit != null ? timeLimit : 5000000000L);
        options.put("CONTEXT_SENSITIVITY", contextSensitive);
        List<Task> plan = provider.getHypoteticRepository().getRelationBuildPlan("AlwaysTrueStatement", options);
        if (plan != null) {
            for (final Task task : plan) {
                if (task.getName().startsWith("Running")) {
                    final ProgressIndicator indicator = OCDFAInspection.createIndicator();
                    ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                        @Override
                        public void run() {
                            ProgressManager.getInstance().executeProcessUnderProgress(new Runnable(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public void run() {
                                    boolean success = false;
                                    try {
                                        success = OCDFAInspection.runTask(file2, measurer, task);
                                    }
                                    finally {
                                        Class<Result> clazz = Result.class;
                                        synchronized (Result.class) {
                                            result.set((Object)new Result(provider, (OCContextSensitiveControlFlowBuilder)((Object)flowBuilder.get()), success));
                                            Result.class.notifyAll();
                                            // ** MonitorExit[var2_2] (shouldn't be in output)
                                        }
                                    }
                                }
                            }, indicator);
                        }
                    });
                    return;
                }
                if (OCDFAInspection.runTask(file2, measurer, task)) continue;
                result.set((Object)new Result(provider, (OCContextSensitiveControlFlowBuilder)((Object)flowBuilder.get()), false));
                return;
            }
        }
        result.set((Object)new Result(provider, (OCContextSensitiveControlFlowBuilder)((Object)flowBuilder.get()), false));
    }

    private static ProgressIndicator createIndicator() {
        ProgressIndicator mainIndicator = ProgressManager.getInstance().getProgressIndicator();
        return mainIndicator != null ? new SensitiveProgressWrapper(mainIndicator) : new ProgressIndicatorBase();
    }

    private static boolean runTask(OCFile file2, final OCDFAUtils.WorkingTimeMeasurer measurer, Task task) {
        try {
            task.run(new DummyThreadCallback(){

                @Override
                public boolean checkCancelled() {
                    ProgressManager.checkCanceled();
                    if (measurer.isTimeOver()) {
                        throw new OCDFAUtils.DFAException("DFA time is over");
                    }
                    return false;
                }
            });
        }
        catch (BDDMemoryOverflowException e) {
            OCLog.LOG.warn(file2.getName() + ": " + e.getMessage());
            return false;
        }
        catch (OCDFAUtils.DFAException e) {
            String message = file2.getName() + ": " + e.getMessage();
            Application app = ApplicationManager.getApplication();
            if (app.isUnitTestMode() || app.isInternal()) {
                OCLog.LOG.warn(message);
            } else {
                OCLog.LOG.info(message);
            }
            return false;
        }
        return true;
    }

    private void reportTimeOverWarning(ProblemsHolder problemsHolder, OCFile file2, String message) {
        final Ref elementRef = new Ref();
        file2.accept(new OCRecursiveVisitor(){

            @Override
            public void visitClassDeclaration(OCClassDeclaration dcl) {
                if (elementRef.isNull()) {
                    elementRef.set((Object)dcl.getNameIdentifier());
                }
            }

            @Override
            public void visitStruct(OCStruct struct) {
                if (elementRef.isNull()) {
                    elementRef.set((Object)struct.getNameIdentifier());
                }
            }

            @Override
            public void visitFunctionDefinition(OCFunctionDefinition functionDefinition) {
                if (elementRef.isNull()) {
                    elementRef.set((Object)functionDefinition.getNameIdentifier());
                }
            }
        });
        if (!elementRef.isNull()) {
            this.registerProblem(problemsHolder, null, null, problemsHolder.isOnTheFly(), (PsiElement)elementRef.get(), message, "CIDR", ProblemHighlightType.WEAK_WARNING, new IntentionAction[0]);
        }
    }

    private void registerWarnings(ProblemsHolder problemsHolder, ManagerInstancesProvider provider, PsiFile file2, @Nullable Set<PsiElement> excludeElements, String relationName, String message, @Nullable ElementFix fixes) {
        HashSet<PsiElement> elements = new HashSet<PsiElement>();
        if (!OCDFAInspection.getElements(elements, provider, file2, relationName)) {
            return;
        }
        if (excludeElements != null) {
            elements.removeAll(excludeElements);
        }
        for (PsiElement element : elements) {
            List<IntentionAction> fixesList = fixes != null ? fixes.getFixes(element) : Collections.emptyList();
            this.registerProblem(problemsHolder, null, null, problemsHolder.isOnTheFly(), element, message, "CIDR", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, fixesList.toArray(new IntentionAction[fixesList.size()]));
        }
    }

    private static boolean getElements(Set<PsiElement> elements, ManagerInstancesProvider provider, PsiFile file2, String relationName) {
        if (!provider.getRelationsRepository().containsRelation(relationName)) {
            return false;
        }
        IRelation relation = provider.getRelationsRepository().getRelation(relationName);
        for (Attribute[] attributes : relation.getAttributes(provider.getSymbolTable())) {
            int endOffset;
            int startOffset = attributes[0].getSrcPos();
            OCElement element = OCCodeInsightUtil.findElementAtRange(file2, startOffset, endOffset = startOffset + attributes[0].getSrcLength(), OCElement.class, true);
            if (element == null) continue;
            elements.add(element);
        }
        return true;
    }

    private static Set<PsiElement> getParents(Set<PsiElement> elements) {
        HashSet<PsiElement> parents = new HashSet<PsiElement>();
        for (PsiElement element : elements) {
            for (PsiElement parent = element.getParent(); parent != null; parent = parent.getParent()) {
                parents.add(parent);
            }
        }
        return parents;
    }

    private void registerUnreachableWarnings(ProblemsHolder problemsHolder, ManagerInstancesProvider provider, PsiFile file2, OCContextSensitiveControlFlowBuilder flowBuilder, String relationName, String message) {
        if (!provider.getRelationsRepository().containsRelation(relationName)) {
            return;
        }
        IRelation relation = provider.getRelationsRepository().getRelation(relationName);
        ArrayList<OCElementsRange> ranges = new ArrayList<OCElementsRange>();
        for (OCControlFlowGraph graph : flowBuilder.getAllControlFlowGraphs()) {
            OCUnreachableCodeFinder finder = new OCUnreachableCodeFinder(graph);
            finder.process();
            ranges.addAll(finder.getUnreachableRanges(false));
        }
        for (Attribute[] attributes : relation.getAttributes(provider.getSymbolTable())) {
            OCElementsRange range;
            int endOffset;
            int startOffset = attributes[0].getSrcPos();
            OCCallable callable = OCCodeInsightUtil.findElementAtRange(file2, startOffset, endOffset = startOffset + attributes[0].getSrcLength(), OCCallable.class, true);
            if (callable == null || (range = flowBuilder.getRange(callable, Integer.decode(attributes[1].getKey()))) == null) continue;
            ranges.add(range);
        }
        for (OCElementsRange range : OCElementsRange.mergeRanges(ranges)) {
            PsiElement startElement = range.getFirstElement();
            PsiElement endElement = range.getLastElement();
            while (startElement instanceof OCMacroForeignLeafElement) {
                startElement = startElement.getParent();
            }
            while (endElement instanceof OCMacroForeignLeafElement) {
                endElement = startElement.getParent();
            }
            range = new OCElementsRange(startElement, endElement);
            OCElementsRange trimmedRange = range.trim(TokenSet.orSet((TokenSet[])new TokenSet[]{OCElementsRange.NON_IMPORTANT_TOKENS, TokenSet.create((IElementType[])new IElementType[]{OCTokenTypes.SEMICOLON})}));
            if (trimmedRange == null || trimmedRange.isEmpty()) continue;
            this.registerProblem(problemsHolder, null, null, problemsHolder.isOnTheFly(), range, message, "CIDR", ProblemHighlightType.LIKE_UNUSED_SYMBOL, new IntentionAction[0]);
        }
    }

    private static ElementFix getSimplifyFixes(final OCFile file2, final boolean constantCondition) {
        return new ElementFix(){

            public List<IntentionAction> getFixes(PsiElement element) {
                ArrayList<IntentionAction> fixes = new ArrayList<IntentionAction>();
                String constant = OCIntType.getAppropriateBool(file2).getValue(constantCondition);
                OCExpression newElement = OCElementFactory.expressionFromText(constant, element, false);
                fixes.add(new OCChangeElementIntentionAction(element, (PsiElement)newElement, "Simplify condition to '" + constant + "'"));
                OCElement parent = (OCElement)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{OCIfStatement.class, OCLoopStatement.class, OCBinaryExpression.class});
                OCElement simplified = null;
                if (parent instanceof OCStatement) {
                    simplified = OCSimplifyInspection.simplifyStatementWithConstCondition(constantCondition, (OCStatement)parent);
                } else if (parent instanceof OCBinaryExpression) {
                    simplified = OCSimplifyInspection.simplifyLogicExpression(constantCondition, (OCBinaryExpression)parent, element);
                }
                if (simplified != null) {
                    fixes.add(OCSimplifyInspection.getSimplifyFix(parent, simplified));
                }
                return fixes;
            }
        };
    }

    private static ElementFix getInitializeFix(final OCContextSensitiveControlFlowBuilder flowBuilder) {
        return new ElementFix(){

            @Override
            public List<? extends IntentionAction> getFixes(PsiElement element) {
                OCSymbol symbol;
                OCSymbol oCSymbol = symbol = element instanceof OCReferenceElement ? ((OCReferenceElement)element).resolveToSymbol() : null;
                if (symbol != null) {
                    OCControlFlowGraph graph;
                    OCCallable callable = (OCCallable)PsiTreeUtil.getParentOfType((PsiElement)element, OCCallable.class);
                    OCControlFlowGraph oCControlFlowGraph = graph = callable != null ? flowBuilder.getControlFlowGraph(callable) : null;
                    if (graph != null) {
                        OCInstruction instruction;
                        OCLocalDefinitionsSearcher defSearcher = new OCLocalDefinitionsSearcher(graph, symbol, element.getParent(), false, true, true);
                        defSearcher.process();
                        Collection<OCInstruction> declarators = defSearcher.getInstructionsOfKind(OCInstruction.InstructionKind.DECLARATOR);
                        if (!declarators.isEmpty() && (instruction = declarators.iterator().next()).getRValue() instanceof OCDeclarator) {
                            return Collections.singletonList(new OCAddInitializerIntentionAction((OCDeclarator)instruction.getRValue(), symbol));
                        }
                    }
                }
                return Collections.emptyList();
            }
        };
    }

    private static interface ElementFix {
        public List<? extends IntentionAction> getFixes(PsiElement var1);
    }

    private static class Result {
        private ManagerInstancesProvider myProvider;
        private OCContextSensitiveControlFlowBuilder myFlowBuilder;
        private boolean myFinishedSuccessfully;

        public Result(ManagerInstancesProvider myProvider, OCContextSensitiveControlFlowBuilder flowBuilder, boolean finishedSuccessfully) {
            this.myProvider = myProvider;
            this.myFlowBuilder = flowBuilder;
            this.myFinishedSuccessfully = finishedSuccessfully;
        }

        public ManagerInstancesProvider getProvider() {
            return this.myProvider;
        }

        public OCContextSensitiveControlFlowBuilder getFlowBuilder() {
            return this.myFlowBuilder;
        }

        public boolean isFinishedSuccessfully() {
            return this.myFinishedSuccessfully;
        }
    }
}

