/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.hierarchy.structureVIew;

import com.intellij.icons.AllIcons;
import com.intellij.ide.util.FileStructureNodeProvider;
import com.intellij.ide.util.treeView.smartTree.ActionPresentation;
import com.intellij.ide.util.treeView.smartTree.ActionPresentationData;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.hierarchy.structureVIew.OCStructureViewElement;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.types.OCObjectType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class OCInheritorsAndCategoriesNodeProvider
implements FileStructureNodeProvider<OCStructureViewElement> {
    @NonNls
    private static final String ID = "INHERITORS_AND_CATEGORIES";

    @NotNull
    public String getCheckBoxText() {
        return "Other Categories and Inherited Members";
    }

    @NotNull
    public Shortcut[] getShortcut() {
        return KeymapManager.getInstance().getActiveKeymap().getShortcuts("FileStructurePopup");
    }

    @NotNull
    public Collection<OCStructureViewElement> provideNodes(@NotNull TreeElement node) {
        OCClassSymbol ownSymbol;
        PsiElement context;
        if (node instanceof OCStructureViewElement && ((OCStructureViewElement)node).isAllowInheritorsAndCategories() && (context = ((OCStructureViewElement)node).getValue()) instanceof OCClassDeclaration && (ownSymbol = ((OCClassDeclaration)context).getSymbol()) != null) {
            final HashSet processed2 = new HashSet();
            ownSymbol.processMembers(OCMemberSymbol.class, new Processor<OCMemberSymbol>(){

                public boolean process(OCMemberSymbol symbol) {
                    processed2.add(symbol.getNameWithParent());
                    return true;
                }
            });
            OCObjectType type = ((OCClassDeclaration)context).getType(true);
            if (type != null) {
                final ArrayList<OCStructureViewElement> answer = new ArrayList<OCStructureViewElement>();
                final HashSet parents = new HashSet();
                type.processMembers(OCMemberSymbol.class, new Processor<OCMemberSymbol>(){

                    public boolean process(OCMemberSymbol symbol) {
                        if (symbol instanceof OCInstanceVariableSymbol) {
                            return true;
                        }
                        OCClassSymbol parent = (OCClassSymbol)symbol.getParent();
                        if (parent == null || parents.contains(parent)) {
                            return true;
                        }
                        if (!processed2.add(symbol.getNameWithParent())) {
                            return true;
                        }
                        if (parents.add(parent)) {
                            String categoryName;
                            if ("NSObject".equals(parent.getName()) && !StringUtil.isEmpty((String)(categoryName = parent.getCategoryName())) && !categoryName.startsWith("NSKeyValue")) {
                                return true;
                            }
                            Object declaration = parent.locateDefinition();
                            if (declaration != null) {
                                answer.add(new OCStructureViewElement((PsiElement)declaration, false, context));
                            }
                        }
                        return true;
                    }
                });
                return answer;
            }
        }
        return Collections.emptyList();
    }

    @NotNull
    public ActionPresentation getPresentation() {
        return new ActionPresentationData("Show Inherited", "Show inherited members and members in other categories", AllIcons.Hierarchy.Supertypes);
    }

    @NotNull
    public String getName() {
        return ID;
    }
}

