/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.hierarchy.call;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.HierarchyTreeStructure;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.hierarchy.call.OCCallHierarchyNodeAggregator;
import com.jetbrains.cidr.lang.hierarchy.call.OCCallHierarchyNodeDescriptor;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCCppNewExpression;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.search.OCFunctionAncestorsQuery;
import com.jetbrains.cidr.lang.search.OCFunctionInheritorsSearch;
import com.jetbrains.cidr.lang.search.OCFunctionReferenceSearch;
import com.jetbrains.cidr.lang.search.OCMemberInheritorsSearch;
import com.jetbrains.cidr.lang.search.usages.OCReadWriteAccessDetector;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.types.OCObjectTypeContext;
import java.util.ArrayList;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public final class OCCalleeMethodsTreeStructure
extends HierarchyTreeStructure {
    private final String myScopeType;

    public OCCalleeMethodsTreeStructure(Project project2, OCCallable method, String scopeType) {
        super(project2, new OCCallHierarchyNodeDescriptor(project2, null, OCCalleeMethodsTreeStructure.getImplementationOfMethod(method), true, false));
        this.myScopeType = scopeType;
    }

    private static OCCallable getImplementationOfMethod(OCCallable method) {
        OCSymbol symbol = method.getSymbol();
        if (symbol != null && symbol.isPredeclaration()) {
            Object implElement;
            OCSymbol impl = symbol.getDefinitionSymbol();
            if (impl != null) {
                symbol = impl;
            }
            if ((implElement = symbol.locateDefinition()) instanceof OCCallable) {
                method = (OCCallable)implElement;
            }
            if (implElement != null && implElement.getParent() instanceof OCCallable) {
                method = (OCCallable)implElement.getParent();
            }
        }
        return method;
    }

    @Override
    @NotNull
    protected final Object[] buildChildren(@NotNull HierarchyNodeDescriptor descriptor) {
        OCBlockStatement body;
        OCCallHierarchyNodeDescriptor nodeDescriptor = (OCCallHierarchyNodeDescriptor)descriptor;
        if (nodeDescriptor.getPossibleResponders().size() > 1) {
            ArrayList<OCCallHierarchyNodeDescriptor> result = new ArrayList<OCCallHierarchyNodeDescriptor>();
            for (OCSymbol symbol : nodeDescriptor.getPossibleResponders()) {
                Object element;
                OCSymbol impl;
                if (symbol.isPredeclaration() && (impl = symbol.getDefinitionSymbol()) != null) {
                    symbol = impl;
                }
                if ((element = symbol.locateDefinition()) == null) continue;
                result.add(new OCCallHierarchyNodeDescriptor(this.myProject, descriptor, (PsiElement)element, false, false));
            }
            return result.toArray();
        }
        ChildrenCalculator calculator = new ChildrenCalculator(nodeDescriptor);
        OCCallable enclosingElement = nodeDescriptor.getEnclosingElement();
        if (enclosingElement != null && (body = (enclosingElement = OCCalleeMethodsTreeStructure.getImplementationOfMethod(enclosingElement)).getBody()) != null) {
            calculator.visit(body);
        }
        return calculator.getChildren();
    }

    private class ChildrenCalculator
    extends OCCallHierarchyNodeAggregator {
        private final boolean myParentIsConstructorDestructor;

        private ChildrenCalculator(OCCallHierarchyNodeDescriptor parentDescriptor) {
            OCFunctionSymbol function;
            OCSymbol symbol;
            super(parentDescriptor);
            OCCallable parent = parentDescriptor.getEnclosingElement();
            this.myParentIsConstructorDestructor = parent != null ? ((symbol = parent.getSymbol()) instanceof OCFunctionSymbol ? (function = (OCFunctionSymbol)symbol).isCppConstructor() || function.isCppDestructor() : false) : false;
        }

        private void visit(PsiElement element) {
            PsiElement[] children2;
            for (final PsiElement child : children2 = element.getChildren()) {
                String selectorName;
                OCCallHierarchyNodeDescriptor desc;
                OCMethodSymbol impl;
                OCSymbol known;
                this.visit(child);
                if (child instanceof OCReferenceElement) {
                    PsiElement parent = child.getParent().getParent();
                    if (!(parent instanceof OCCallExpression) && !(parent instanceof OCCppNewExpression) || !((known = ((OCReferenceElement)child).resolveToSymbol()) instanceof OCFunctionSymbol)) continue;
                    boolean isVirtual = !this.myParentIsConstructorDestructor && ((OCReferenceElement)child).getNamespaceQualifier() == null;
                    this.processFunctionSymbol((OCFunctionSymbol)known, (OCElement)child, isVirtual);
                    continue;
                }
                if (child instanceof OCQualifiedExpression) {
                    known = ((OCQualifiedExpression)child).resolveToSymbol();
                    if (known instanceof OCMethodSymbol) {
                        this.processMethodSymbol((OCMethodSymbol)known, (OCElement)child);
                        continue;
                    }
                    if (child.getParent() instanceof OCCallExpression && known instanceof OCFunctionSymbol) {
                        boolean isVirtual = !this.myParentIsConstructorDestructor && OCFunctionReferenceSearch.isCallViaReference(((OCQualifiedExpression)child).getQualifier());
                        this.processFunctionSymbol((OCFunctionSymbol)known, (OCElement)child, isVirtual);
                        continue;
                    }
                    if (!(known instanceof OCPropertySymbol)) continue;
                    final OCPropertySymbol property = (OCPropertySymbol)known;
                    final ReadWriteAccessDetector.Access access = new OCReadWriteAccessDetector().getExpressionAccess(child);
                    ((OCClassSymbol)property.getParent()).processMembers(OCMethodSymbol.class, new Processor<OCMethodSymbol>(){

                        public boolean process(OCMethodSymbol method) {
                            if (method.getGeneratedFromProperty() == property && (access == ReadWriteAccessDetector.Access.Read && method.isGetter() || access == ReadWriteAccessDetector.Access.Write && method.isSetter() || access == ReadWriteAccessDetector.Access.ReadWrite)) {
                                ChildrenCalculator.this.processMethodSymbol(method, (OCElement)child);
                            }
                            return true;
                        }
                    });
                    continue;
                }
                if (!(child instanceof OCSendMessageExpression)) continue;
                OCSendMessageExpression callExpression = (OCSendMessageExpression)child;
                OCSendMessageExpression.ProbableResponders responders = callExpression.getProbableResponders();
                final OCObjectTypeContext receiverContext = callExpression.getReceiverContext();
                if (receiverContext == null) continue;
                OCMethodSymbol known2 = responders.getKnownResponder();
                if (known2 != null && !known2.isDefinition() && (impl = known2.getDefinitionSymbol()) instanceof OCMethodSymbol) {
                    known2 = impl;
                }
                if ((desc = this.addNodeDescriptor(known2, selectorName = callExpression.getMessageSelector(), (OCElement)child)) == null) continue;
                OCMemberInheritorsSearch.SearchParameters<OCMethodSymbol> parameters = OCMemberInheritorsSearch.getParameters(selectorName, receiverContext.getType().getClassSymbol(), OCCalleeMethodsTreeStructure.this.myProject, OCMethodSymbol.class, receiverContext.getStaticMode());
                this.setSearchParameters(parameters);
                OCMemberInheritorsSearch.search(parameters).forEach((Processor)new Processor<OCMethodSymbol>(){

                    public boolean process(OCMethodSymbol symbol) {
                        if (receiverContext.fitsStaticness(symbol) && symbol.isDefinition()) {
                            desc.addPossibleResponder(symbol);
                        }
                        return true;
                    }
                });
            }
        }

        private void processMethodSymbol(OCMethodSymbol known, OCElement context) {
            OCCallHierarchyNodeDescriptor desc;
            OCMethodSymbol impl;
            if (!known.isDefinition() && (impl = known.getDefinitionSymbol()) instanceof OCMethodSymbol) {
                known = impl;
            }
            if ((desc = this.addNodeDescriptor(known, null, context)) != null) {
                OCMemberInheritorsSearch.SearchParameters<OCMethodSymbol> parameters = OCMemberInheritorsSearch.getParameters(known);
                this.setSearchParameters(parameters);
                OCMemberInheritorsSearch.search(parameters).forEach((Processor)new Processor<OCMethodSymbol>(){

                    public boolean process(OCMethodSymbol symbol) {
                        if (symbol.isDefinition()) {
                            desc.addPossibleResponder(symbol);
                        }
                        return true;
                    }
                });
            }
        }

        private void processFunctionSymbol(OCFunctionSymbol known, OCElement context, boolean virtualCall) {
            OCCallHierarchyNodeDescriptor desc;
            OCSymbol impl;
            if (known.isPredeclaration() && (impl = known.getDefinitionSymbol()) instanceof OCFunctionSymbol) {
                known = (OCFunctionSymbol)impl;
            }
            if ((desc = this.addNodeDescriptor(known, null, context)) != null && virtualCall && OCFunctionAncestorsQuery.findFirstVirtual(known, true) != null) {
                OCFile file2 = context.getContainingOCFile();
                OCFunctionInheritorsSearch.SearchParameters parameters = OCFunctionInheritorsSearch.getParameters(known, file2, true);
                final HashSet names = new HashSet();
                parameters.setImplementationsThenPredeclarations(true);
                parameters.setIncludeSameSymbols(true);
                OCFunctionInheritorsSearch.search(parameters).forEach((Processor)new Processor<OCFunctionSymbol>(){

                    public boolean process(OCFunctionSymbol symbol) {
                        if (names.add(symbol.getResolvedQualifiedName())) {
                            desc.addPossibleResponder(symbol);
                        }
                        return true;
                    }
                });
            }
        }

        private void setSearchParameters(OCMemberInheritorsSearch.SearchParameters parameters) {
            parameters.setIncludeSelfImplementation(true);
            parameters.setInterfacesThenImplementations(false);
            parameters.setIncludeFromID(true);
            parameters.setInheritors(true);
            parameters.setAncestors(false);
        }
    }
}

