/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.hierarchy;

import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.HierarchyTreeStructure;
import com.intellij.ide.hierarchy.TypeHierarchyBrowserBase;
import com.intellij.ide.util.treeView.AlphaComparator;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.hierarchy.OCClassHierarchyNodeDescriptor;
import com.jetbrains.cidr.lang.hierarchy.OCImportSubHierarchyTreeStructure;
import com.jetbrains.cidr.lang.hierarchy.OCImportSuperHierarchyTreeStructure;
import com.jetbrains.cidr.lang.hierarchy.OCStructSubTypesHierarchyTreeStructure;
import com.jetbrains.cidr.lang.hierarchy.OCStructSuperTypesHierarchyTreeStructure;
import com.jetbrains.cidr.lang.hierarchy.OCSubTypesHierarchyTreeStructure;
import com.jetbrains.cidr.lang.hierarchy.OCSuperTypesHierarchyTreeStructure;
import com.jetbrains.cidr.lang.hierarchy.OCTypeHierarchyTreeStructure;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCProtocol;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import java.util.Comparator;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;

public class OCTypeHierarchyBrowser
extends TypeHierarchyBrowserBase {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lang.javascript.hierarchy.type.jsclass.JSTypeHierarchyBrowser");
    private boolean myIsImplementation;

    public OCTypeHierarchyBrowser(Project project2, OCElement jsClass) {
        super(project2, jsClass);
    }

    public boolean isImplementation() {
        return this.myIsImplementation;
    }

    @Override
    protected boolean isInterface(PsiElement psiElement) {
        return psiElement instanceof OCProtocol || psiElement instanceof OCStruct || psiElement instanceof OCFile;
    }

    @Override
    protected void setHierarchyBase(@NotNull PsiElement element) {
        super.setHierarchyBase(element);
        this.myIsImplementation = element instanceof OCFile && !((OCFile)element).isHeader();
    }

    @Override
    protected String getContentDisplayName(@NotNull String typeName, @NotNull PsiElement element) {
        if (element instanceof PsiFile) {
            typeName = typeName == SUPERTYPES_HIERARCHY_TYPE ? "Files included from {0}" : "Files including {0}";
        }
        return super.getContentDisplayName(typeName, element);
    }

    @Override
    protected void createTrees(@NotNull Map<String, JTree> trees) {
        DefaultActionGroup group = new DefaultActionGroup();
        this.createTreeAndSetupCommonActions(trees, (ActionGroup)group);
    }

    @Override
    protected JPanel createLegendPanel() {
        return null;
    }

    @Override
    protected PsiElement getElementFromDescriptor(@NotNull HierarchyNodeDescriptor descriptor) {
        if (!(descriptor instanceof OCClassHierarchyNodeDescriptor)) {
            return null;
        }
        return ((OCClassHierarchyNodeDescriptor)descriptor).getType();
    }

    @Override
    protected boolean isApplicableElement(@NotNull PsiElement element) {
        return element instanceof OCClassDeclaration || element instanceof OCStruct || element instanceof OCFile;
    }

    @Override
    protected Comparator<NodeDescriptor> getComparator() {
        return AlphaComparator.INSTANCE;
    }

    @Override
    protected HierarchyTreeStructure createHierarchyTreeStructure(@NotNull String typeName, @NotNull PsiElement element) {
        if (element instanceof OCClassDeclaration) {
            if (SUPERTYPES_HIERARCHY_TYPE.equals(typeName)) {
                return new OCSuperTypesHierarchyTreeStructure(this.myProject, (OCClassDeclaration)element);
            }
            if (SUBTYPES_HIERARCHY_TYPE.equals(typeName)) {
                return new OCSubTypesHierarchyTreeStructure(this.myProject, (OCClassDeclaration)element);
            }
            if (TYPE_HIERARCHY_TYPE.equals(typeName)) {
                return new OCTypeHierarchyTreeStructure(this.myProject, (OCClassDeclaration)element);
            }
        } else if (element instanceof OCStruct) {
            if (SUPERTYPES_HIERARCHY_TYPE.equals(typeName)) {
                return new OCStructSuperTypesHierarchyTreeStructure(this.myProject, (OCStruct)element);
            }
            if (SUBTYPES_HIERARCHY_TYPE.equals(typeName)) {
                return new OCStructSubTypesHierarchyTreeStructure(this.myProject, (OCStruct)element);
            }
        } else if (element instanceof OCFile) {
            if (SUPERTYPES_HIERARCHY_TYPE.equals(typeName)) {
                return new OCImportSubHierarchyTreeStructure(this.myProject, (OCFile)element);
            }
            return new OCImportSuperHierarchyTreeStructure(this.myProject, (OCFile)element);
        }
        LOG.error("unexpected type: " + typeName);
        return null;
    }

    @Override
    protected boolean canBeDeleted(PsiElement psiElement) {
        return psiElement instanceof OCClassDeclaration;
    }

    @Override
    protected String getQualifiedName(PsiElement psiElement) {
        Object symbol;
        if (psiElement instanceof OCClassDeclaration) {
            return ((OCClassDeclaration)psiElement).getCanonicalName();
        }
        if (psiElement instanceof OCSymbolDeclarator && (symbol = ((OCSymbolDeclarator)psiElement).getSymbol()) instanceof OCSymbolWithQualifiedName) {
            OCQualifiedName resolvedQualifiedName = ((OCSymbolWithQualifiedName)symbol).getResolvedQualifiedName();
            if (resolvedQualifiedName != null) {
                return resolvedQualifiedName.toString();
            }
            return ((OCSymbolWithQualifiedName)symbol).getQualifiedName().toString();
        }
        return "";
    }
}

