/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate.handlers.implement;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.OCIcons;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.generate.OCCppDefinitionsUtil;
import com.jetbrains.cidr.lang.generate.OCGenerateUtil;
import com.jetbrains.cidr.lang.generate.OCMemberChooser;
import com.jetbrains.cidr.lang.generate.OCMemberChooserObject;
import com.jetbrains.cidr.lang.generate.actions.OCOverrideImplementCppActionContext;
import com.jetbrains.cidr.lang.generate.handlers.OCClassActionHandlerBase;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.settings.OCBooleanOption;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.settings.OCOption;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCMembersContainer;
import com.jetbrains.cidr.lang.util.OCCallableUtil;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCCommonProcessors;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCOverrideImplementCppFunctionsHandlerBase
extends OCClassActionHandlerBase<OCMembersContainer, OCFunctionSymbol, OCOverrideImplementCppActionContext> {
    protected static final OCBooleanOption INSERT_OVERRIDE = new OCBooleanOption(OCBundle.message("override.implement.cpp.action.insertOverride", new Object[0]));

    @Override
    public boolean isValidFor(Editor editor, PsiFile file2) {
        return OCCodeInsightUtil.isValid((PsiElement)file2);
    }

    @Override
    protected Class<? extends OCSymbolDeclarator> getParentClass() {
        return OCStruct.class;
    }

    @Override
    protected String getActionTitle() {
        return OCBundle.message("override.implement.cpp.action.title", new Object[0]);
    }

    @Override
    protected OCMemberChooserObject[] getChooserNodes(OCMemberChooser chooser, Collection<OCFunctionSymbol> candidates, OCOverrideImplementCppActionContext actionContext, int moreNodesLevel) {
        final Map<OCSymbol, OCSymbol> parentsMap = actionContext.createParentsMap(candidates);
        final OCNamespaceSymbol parent = actionContext.getParent() instanceof OCNamespaceSymbol ? (OCNamespaceSymbol)actionContext.getParent() : null;
        return (OCMemberChooserObject[])ContainerUtil.map2Array(candidates, OCMemberChooserObject.class, (Function)new Function<OCFunctionSymbol, OCMemberChooserObject>(){

            public OCMemberChooserObject fun(OCFunctionSymbol m) {
                boolean isIncomplete = m.isPureVirtual() || Comparing.equal((Object)parent, (Object)m.getParent());
                return new OCMemberChooserObject((OCSymbol)m, OCIcons.getFunctionIcon(m.isStatic(), isIncomplete, !m.isVirtual(), m.getVisibility()), (Map<OCSymbol, OCSymbol>)parentsMap);
            }
        });
    }

    @Override
    @Nullable
    protected OCOverrideImplementCppActionContext evaluateActionContext(Project project2, @Nullable Editor editor, PsiFile file2) {
        List<OCOverrideImplementCppActionContext> contexts = this.getContexts(project2, editor, file2);
        return contexts.isEmpty() ? null : contexts.get(0);
    }

    @Override
    @NotNull
    protected List<OCOverrideImplementCppActionContext> getContexts(@NotNull Project project2, @Nullable Editor editor, @NotNull PsiFile psiFile) {
        OCFile file2 = (OCFile)psiFile;
        final PsiElement context = OCGenerateUtil.getElementAt(editor, psiFile);
        OCStructLike struct = (OCStructLike)PsiTreeUtil.getContextOfType((PsiElement)context, (Class[])new Class[]{OCStruct.class});
        ArrayList<OCStructSymbol> parents = new ArrayList<OCStructSymbol>();
        if (struct != null) {
            OCStructSymbol symbol = (OCStructSymbol)struct.getSymbol();
            if (symbol != null && !symbol.isPredeclaration()) {
                parents.add(symbol);
            }
        } else {
            OCFile header;
            CommonProcessors.CollectProcessor<OCStructSymbol> collector = new CommonProcessors.CollectProcessor<OCStructSymbol>(){

                protected boolean accept(OCStructSymbol symbol) {
                    return !symbol.isPredeclaration();
                }
            };
            OCCommonProcessors.TypeFilteredProcessor processor2 = new OCCommonProcessors.TypeFilteredProcessor((Processor<OCStructSymbol>)collector, OCStructSymbol.class);
            file2.processSymbolsRecursively(processor2);
            if (!file2.isHeader() && (header = file2.getAssociatedFile()) != null) {
                header.processSymbolsRecursively(processor2);
            }
            for (OCStructSymbol symbol : collector.getResults()) {
                parents.add(symbol);
            }
        }
        return ContainerUtil.mapNotNull(parents, (Function)new Function<OCStructSymbol, OCOverrideImplementCppActionContext>(){

            public OCOverrideImplementCppActionContext fun(OCStructSymbol symbol) {
                OCOverrideImplementCppActionContext actionContext = (OCOverrideImplementCppActionContext)OCOverrideImplementCppFunctionsHandlerBase.this.evaluateActionContext(symbol, context);
                if (actionContext != null && (!actionContext.getMemberCandidates().isEmpty() || OCOverrideImplementCppFunctionsHandlerBase.this.allowEmptySelection(actionContext))) {
                    return actionContext;
                }
                return null;
            }
        });
    }

    @Override
    protected void performAction(@NotNull Project project2, @Nullable Editor editor, final @NotNull PsiFile file2, final @NotNull OCOverrideImplementCppActionContext actionContext, @NotNull List<OCFunctionSymbol> chosenCandidates) {
        if (actionContext.getParent() instanceof OCStructSymbol) {
            FeatureUsageTracker.getInstance().triggerFeatureUsed("codeassists.overrideimplement");
            Collections.sort(chosenCandidates, new Comparator<OCFunctionSymbol>(){

                @Override
                public int compare(@NotNull OCFunctionSymbol fun1, @NotNull OCFunctionSymbol fun2) {
                    OCVisibility visibility2;
                    OCVisibility visibility1 = OCOverrideImplementCppFunctionsHandlerBase.getInheritorVisibility(fun1, (OCStructSymbol)actionContext.getParent(), file2);
                    if (visibility1 == (visibility2 = OCOverrideImplementCppFunctionsHandlerBase.getInheritorVisibility(fun2, (OCStructSymbol)actionContext.getParent(), file2))) {
                        int filesCmp = FileUtil.comparePaths((String)fun1.getContainingFile().getPath(), (String)fun2.getContainingFile().getPath());
                        return filesCmp != 0 ? filesCmp : fun1.getOffset() - fun2.getOffset();
                    }
                    return visibility1.compareTo(visibility2);
                }
            });
            List<OCGenerateUtil.Replacement> replacements = this.getReplacements(editor, file2, actionContext, chosenCandidates);
            OCGenerateUtil.applyReplacements(project2, this.getActionTitle(), replacements);
        }
    }

    private static int getInsertPositionInsideClass(@NotNull OCStruct structDefinition, @Nullable Editor editor, @NotNull PsiFile editorFile) {
        int functionsStartOffset = structDefinition.getFunctionsStartOffset();
        int functionsEndOffset = structDefinition.getFunctionsEndOffset();
        if (editor == null || !editorFile.equals(structDefinition.getContainingFile())) {
            return functionsStartOffset;
        }
        int caretOffset = editor.getCaretModel().getOffset();
        if (caretOffset < functionsStartOffset) {
            return functionsStartOffset;
        }
        if (caretOffset >= functionsEndOffset) {
            return functionsEndOffset;
        }
        PsiElement atCaret = editorFile.findElementAt(caretOffset);
        if (atCaret == null || !PsiTreeUtil.isAncestor((PsiElement)structDefinition, (PsiElement)atCaret, (boolean)true)) {
            return functionsStartOffset;
        }
        PsiElement prev = null;
        for (PsiElement curr = atCaret; curr != null; curr = curr.getParent()) {
            if (structDefinition.equals(curr)) {
                if (prev == atCaret || prev == null) {
                    return caretOffset;
                }
                return prev.getTextRange().getEndOffset();
            }
            prev = curr;
        }
        return functionsStartOffset;
    }

    @NotNull
    private List<OCGenerateUtil.Replacement> getReplacements(@Nullable Editor editor, @NotNull PsiFile file2, @NotNull OCOverrideImplementCppActionContext actionContext, @NotNull List<OCFunctionSymbol> functions) {
        Document structDefinitionDocument;
        boolean inline;
        Document document = PsiDocumentManager.getInstance((Project)file2.getProject()).getDocument(file2);
        if (document == null) {
            OCLog.LOG.warn("No document for " + file2);
            return Collections.emptyList();
        }
        boolean bl = inline = editor != null && OCCppDefinitionsUtil.shouldInline(editor, file2, actionContext.getParent());
        assert (actionContext.getParent() instanceof OCStructSymbol);
        OCStructSymbol parent = (OCStructSymbol)actionContext.getParent();
        Object element = parent.locateDefinition();
        if (element == null || !(element instanceof OCStruct)) {
            return Collections.emptyList();
        }
        OCStruct structDefinition = (OCStruct)element;
        PsiFile structDefinitionFile = structDefinition.getContainingFile();
        if (structDefinitionFile.equals(file2)) {
            structDefinitionDocument = document;
        } else {
            structDefinitionDocument = PsiDocumentManager.getInstance((Project)file2.getProject()).getDocument(structDefinitionFile);
            if (structDefinitionDocument == null) {
                OCLog.LOG.warn("No document for " + structDefinitionFile);
                return Collections.emptyList();
            }
        }
        int insertPositionInsideClass = OCOverrideImplementCppFunctionsHandlerBase.getInsertPositionInsideClass(structDefinition, editor, file2);
        StringBuilder result = new StringBuilder();
        ArrayList<OCFunctionSymbol> overriding = new ArrayList<OCFunctionSymbol>(functions.size());
        ArrayList<OCFunctionSymbol> bases = new ArrayList<OCFunctionSymbol>(functions.size());
        OCVisibility curVisibility = OCVisibility.getVisibilityAtOffset(structDefinition, insertPositionInsideClass);
        for (OCFunctionSymbol function : functions) {
            OCVisibility visibility = OCOverrideImplementCppFunctionsHandlerBase.getInheritorVisibility(function, parent, structDefinitionFile);
            if (curVisibility != visibility) {
                curVisibility = visibility;
                result.append((Object)visibility).append(":");
            }
            boolean insertOverride = this.getOption(actionContext, INSERT_OVERRIDE) == Boolean.TRUE;
            OCFunctionSymbol overridingFunction = OCCallableUtil.createOverridingFunction(function, parent, structDefinition, curVisibility, insertOverride);
            OCFunctionSymbol baseToCall = !function.isPureVirtual() ? function : null;
            result.append(OCCallableUtil.exactFunctionText(overridingFunction, "", inline, baseToCall, structDefinition));
            overriding.add(overridingFunction);
            bases.add(baseToCall);
        }
        RangeMarker marker = structDefinitionDocument.createRangeMarker(insertPositionInsideClass, insertPositionInsideClass);
        marker.setGreedyToRight(true);
        List<OCGenerateUtil.Replacement> insideClassReplacements = Collections.singletonList(new OCGenerateUtil.Replacement(new OCGenerateUtil.ReplacePosition(marker, structDefinitionFile, structDefinition, false), result.toString()));
        List<Object> outsideClassReplacements = inline ? Collections.emptyList() : (editor != null ? OCCppDefinitionsUtil.getOutsideReplacementsAtCaretPosition(file2, editor, overriding, bases) : OCCppDefinitionsUtil.getOutsideReplacementsAtPreferredPosition(file2, overriding, bases, element));
        return ContainerUtil.concat(insideClassReplacements, outsideClassReplacements);
    }

    private static OCVisibility getInheritorVisibility(OCFunctionSymbol symbol, OCStructSymbol inheritorClassSymbol, PsiFile file2) {
        OCVisibility declaredVisibility = symbol.getVisibility();
        declaredVisibility = declaredVisibility != null ? declaredVisibility : OCVisibility.PRIVATE;
        return OCVisibility.max(declaredVisibility, OCVisibility.getMaxInheritanceVisibility((OCStructSymbol)symbol.getParent(), inheritorClassSymbol, file2));
    }

    protected static void loadOverride(PsiFile file2, @Nullable OCCodeStyleSettings settings, @NotNull List<Pair<OCOption, Object>> result) {
        if (OCCompilerHelper.supportsOverrideControl(file2)) {
            result.add((Pair<OCOption, Object>)new Pair((Object)INSERT_OVERRIDE, (Object)(settings == null || settings.INSERT_OVERRIDE ? 1 : 0)));
        }
    }

    protected static void saveOverride(PsiFile file2, @NotNull OCCodeStyleSettings settings, @NotNull Map<OCOption, Object> optionValues) {
        if (OCCompilerHelper.supportsOverrideControl(file2) && optionValues.containsKey(INSERT_OVERRIDE)) {
            settings.INSERT_OVERRIDE = OCOverrideImplementCppFunctionsHandlerBase.getOption(optionValues, INSERT_OVERRIDE);
        }
    }
}

