/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate.handlers.implement;

import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.generate.OCMemberChooser;
import com.jetbrains.cidr.lang.generate.OCMemberChooserObject;
import com.jetbrains.cidr.lang.generate.actions.OCOverrideImplementCppActionContext;
import com.jetbrains.cidr.lang.generate.handlers.implement.OCOverrideImplementCppFunctionsHandlerBase;
import com.jetbrains.cidr.lang.quickfixes.OCMakeFunctionVirtualFix;
import com.jetbrains.cidr.lang.settings.OCBooleanOption;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.settings.OCOption;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCMembersContainer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCOverrideImplementCppFunctionsHandler
extends OCOverrideImplementCppFunctionsHandlerBase {
    protected static final OCBooleanOption SHOW_NON_VIRTUAL_FUNCTIONS = new OCBooleanOption(OCBundle.message("override.implement.cpp.action.showNonVirtual", new Object[0]));

    @Override
    @Nullable
    public String getActionName() {
        return OCBundle.message("override.implement.cpp.action.name", new Object[0]);
    }

    @Override
    protected String getMembersChooserTitle() {
        return OCBundle.message("override.implement.cpp.action.memberChooserTitle", new Object[0]);
    }

    @Override
    protected String getNoMembersMessage(@NotNull OCOverrideImplementCppActionContext context) {
        return OCBundle.message("override.implement.cpp.action.noMember", context.getParentNameUppercase());
    }

    @Override
    protected String getNoParentsMessage() {
        return OCBundle.message("override.implement.cpp.action.noParent", new Object[0]);
    }

    @Override
    protected OCOverrideImplementCppActionContext evaluateActionContext(OCMembersContainer parent, PsiElement context) {
        return new OCOverrideImplementCppActionContext(parent, context, false);
    }

    @Override
    protected OCMemberChooserObject[] getChooserNodes(OCMemberChooser chooser, Collection<OCFunctionSymbol> candidates, OCOverrideImplementCppActionContext actionContext, int moreNodesLevel) {
        final Boolean showNonVirtual = OCOverrideImplementCppFunctionsHandler.getOption(chooser.getOptionSelections(), SHOW_NON_VIRTUAL_FUNCTIONS);
        return super.getChooserNodes(chooser, (Collection<OCFunctionSymbol>)ContainerUtil.filter(candidates, (Condition)new Condition<OCFunctionSymbol>(){

            public boolean value(OCFunctionSymbol symbol) {
                VirtualFile file2 = symbol.getContainingFile();
                return symbol.isVirtual() || showNonVirtual != false && file2 != null && file2.isWritable();
            }
        }), actionContext, moreNodesLevel);
    }

    @Override
    protected List<Pair<OCOption, Object>> loadOptions(PsiFile file2, @Nullable OCCodeStyleSettings settings, @NotNull OCOverrideImplementCppActionContext context) {
        if (!(context.getParent() instanceof OCStructSymbol)) {
            return Collections.emptyList();
        }
        ArrayList<Pair<OCOption, Object>> result = new ArrayList<Pair<OCOption, Object>>();
        result.add(new Pair((Object)SHOW_NON_VIRTUAL_FUNCTIONS, (Object)true));
        OCOverrideImplementCppFunctionsHandler.loadOverride(file2, settings, result);
        return result;
    }

    @Override
    protected void saveOptions(PsiFile file2, @NotNull OCCodeStyleSettings settings, Map<OCOption, Object> optionValues) {
        OCOverrideImplementCppFunctionsHandler.saveOverride(file2, settings, optionValues);
    }

    @Override
    protected void optionValueChanged(OCMemberChooser chooser, Collection<OCFunctionSymbol> candidates, OCOption option, OCOverrideImplementCppActionContext actionContext) {
        if (SHOW_NON_VIRTUAL_FUNCTIONS.equals(option)) {
            chooser.resetElements(this.getChooserNodes(chooser, candidates, actionContext, 0));
        }
    }

    @Override
    protected void performAction(final @NotNull Project project2, final @Nullable Editor editor, final @NotNull PsiFile file2, @NotNull OCOverrideImplementCppActionContext actionContext, final @NotNull List<OCFunctionSymbol> chosenCandidates) {
        final OCStructSymbol parent = actionContext.getParent() instanceof OCStructSymbol ? (OCStructSymbol)actionContext.getParent() : null;
        super.performAction(project2, editor, file2, actionContext, (List<OCFunctionSymbol>)ContainerUtil.map(chosenCandidates, (Function)new Function<OCFunctionSymbol, OCFunctionSymbol>(){

            public OCFunctionSymbol fun(OCFunctionSymbol symbol) {
                if (!symbol.isVirtual() && parent != null && !parent.equals(symbol.getParent())) {
                    return new OCFunctionSymbol(symbol){

                        @Override
                        public boolean isVirtual() {
                            return true;
                        }
                    };
                }
                return symbol;
            }
        }));
        new WriteCommandAction(project2, new PsiFile[]{file2}){

            protected void run(@NotNull Result result) throws Throwable {
                Collections.sort(chosenCandidates, new Comparator<OCFunctionSymbol>(){

                    @Override
                    public int compare(OCFunctionSymbol o1, OCFunctionSymbol o2) {
                        return o2.getOffset() - o1.getOffset();
                    }
                });
                for (OCFunctionSymbol candidate : chosenCandidates) {
                    OCMakeFunctionVirtualFix fix = new OCMakeFunctionVirtualFix(candidate, false);
                    if (candidate.isVirtual() || parent == null || parent.equals(candidate.getParent()) || !fix.isAvailable(project2, editor, file2)) continue;
                    fix.invoke(project2, editor, file2);
                }
            }
        }.execute();
    }
}

