/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate.handlers;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.generate.OCMemberChooser;
import com.jetbrains.cidr.lang.generate.OCMemberChooserObject;
import com.jetbrains.cidr.lang.generate.actions.OCGenerateFromIvarsActionContext;
import com.jetbrains.cidr.lang.generate.handlers.OCClassActionHandlerBase;
import com.jetbrains.cidr.lang.inspections.OCNotReleasedIvarInspection;
import com.jetbrains.cidr.lang.intentions.OCMoveToPrivateCategoryIntentionAction;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCProperty;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.OCSynthesizePropertiesList;
import com.jetbrains.cidr.lang.quickfixes.OCReleaseVariablesIntentionAction;
import com.jetbrains.cidr.lang.refactoring.OCConvertMemberRefactoringProcessor;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.settings.OCBooleanOption;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.settings.OCOption;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCSynthesizeSymbol;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCGeneratePropertiesHandler
extends OCClassActionHandlerBase<OCClassSymbol, OCInstanceVariableSymbol, OCGenerateFromIvarsActionContext> {
    protected static final OCBooleanOption SHOW_SYNTHESIZED = new OCBooleanOption("Show ivars with synthesized properties");
    protected static final OCBooleanOption CONVERT_USAGES = new OCBooleanOption(UIUtil.removeMnemonic((String)OCBundle.message("refactoring.convertIvarUsagesToProperties", new Object[0])));

    @Override
    protected String getMembersChooserTitle() {
        return "Select Instance Variables to make Properties";
    }

    @Override
    protected String getActionTitle() {
        return "Generate Properties from Instance Variables";
    }

    @Override
    protected String getNoMembersMessage(@NotNull OCGenerateFromIvarsActionContext context) {
        return context.getParentNameUppercase() + " has no instance variables to generate properties from";
    }

    @Override
    protected Class<? extends OCSymbolDeclarator> getParentClass() {
        return OCClassDeclaration.class;
    }

    @Override
    protected List<Pair<OCOption, Object>> loadOptions(PsiFile file2, @Nullable OCCodeStyleSettings settings, @NotNull OCGenerateFromIvarsActionContext context) {
        ArrayList<Pair<OCOption, Object>> result = new ArrayList<Pair<OCOption, Object>>();
        result.add(new Pair((Object)SHOW_SYNTHESIZED, (Object)true));
        if (OCCompilerHelper.supportsAutosynthesis(file2)) {
            result.add((Pair<OCOption, Object>)new Pair((Object)CONVERT_USAGES, (Object)true));
        }
        return result;
    }

    @Override
    @NotNull
    protected OCGenerateFromIvarsActionContext evaluateActionContext(OCClassSymbol parent, PsiElement element) {
        return new OCGenerateFromIvarsActionContext(parent, parent.getResolvedType(true), element);
    }

    @Override
    @NotNull
    protected Condition<OCInstanceVariableSymbol> getCandidatesFilter(@NotNull OCGenerateFromIvarsActionContext actionContext) {
        return new Condition<OCInstanceVariableSymbol>(){

            public boolean value(OCInstanceVariableSymbol symbol) {
                return symbol.getGeneratedFromProperty() == null;
            }
        };
    }

    @Override
    protected void performAction(@NotNull Project project2, @Nullable Editor editor, @NotNull PsiFile file2, @NotNull OCGenerateFromIvarsActionContext context, @NotNull List<OCInstanceVariableSymbol> ivars) {
        this.performAction(file2, context, ivars, null, null, false, this.convertUsages(context), false);
    }

    protected boolean convertUsages(OCGenerateFromIvarsActionContext context) {
        Boolean value = (Boolean)context.getOptionValues().get(CONVERT_USAGES);
        return value != null ? value : true;
    }

    protected void performAction(final PsiFile file2, OCGenerateFromIvarsActionContext context, final List<OCInstanceVariableSymbol> ivars, final @Nullable String customName, final @Nullable OCPropertySymbol.PropertySemantics customSemantics, boolean isReadonly, final boolean convertUsages, final boolean putToPrivateCategory) {
        FeatureUsageTracker.getInstance().triggerFeatureUsed("codeassists.altInsert");
        final OCInterfaceSymbol interfaceSymbol = (OCInterfaceSymbol)context.getInterfaceSymbol();
        final HashMap newNames = new HashMap();
        HashMap newDeclarations = new HashMap();
        HashMap existingDeclarations = new HashMap();
        ArrayList synthesizes = new ArrayList();
        boolean replaceAllIvars = this.replaceAllIvars();
        PsiFile psiContext = context.getContext().isValid() ? context.getContext() : file2;
        ArrayList nonReleasedIvars = new ArrayList();
        OCNotReleasedIvarInspection.IvarsInfo ivarsInfo = OCNotReleasedIvarInspection.startInspection(file2);
        ApplicationManager.getApplication().runWriteAction(new Runnable((PsiElement)psiContext, isReadonly, newDeclarations, existingDeclarations, replaceAllIvars, synthesizes, ivarsInfo, nonReleasedIvars){
            final /* synthetic */ PsiElement val$psiContext;
            final /* synthetic */ boolean val$isReadonly;
            final /* synthetic */ Map val$newDeclarations;
            final /* synthetic */ Map val$existingDeclarations;
            final /* synthetic */ boolean val$replaceAllIvars;
            final /* synthetic */ List val$synthesizes;
            final /* synthetic */ OCNotReleasedIvarInspection.IvarsInfo val$ivarsInfo;
            final /* synthetic */ List val$nonReleasedIvars;
            {
                this.val$psiContext = psiElement;
                this.val$isReadonly = bl2;
                this.val$newDeclarations = map2;
                this.val$existingDeclarations = map3;
                this.val$replaceAllIvars = bl3;
                this.val$synthesizes = list2;
                this.val$ivarsInfo = ivarsInfo;
                this.val$nonReleasedIvars = list3;
            }

            @Override
            public void run() {
                for (OCInstanceVariableSymbol ivar : ivars) {
                    OCType ivarType;
                    OCPropertySymbol associatedProperty = ivar.getAssociatedProperty();
                    String propName = customName != null ? customName : (associatedProperty != null ? associatedProperty.getName() : OCNameSuggester.getNonCollidingName(ivar, true));
                    newNames.put(ivar, convertUsages ? propName : OCNameSuggester.getClang4ImplicitIvarName(propName));
                    CommonProcessors.FindFirstProcessor finder = new CommonProcessors.FindFirstProcessor();
                    if (interfaceSymbol != null) {
                        interfaceSymbol.processMembers(propName, OCPropertySymbol.class, finder);
                    }
                    if (!finder.isFound()) {
                        OCPropertySymbol.PropertySemantics semantics = null;
                        OCType type = ivar.getResolvedType();
                        if (customSemantics != null) {
                            semantics = customSemantics;
                        } else if (OCCompilerHelper.isArcEnabled(file2) && type.isPointerToObjectCompatible()) {
                            semantics = ivar.getARCAttribute(this.val$psiContext).getPropertyCompatibleSemantics(type, this.val$psiContext);
                        }
                        OCProperty property = OCElementFactory.propertyDeclaration(propName, type, this.val$psiContext, semantics, this.val$isReadonly);
                        this.val$newDeclarations.put(ivar, property);
                    } else {
                        this.val$existingDeclarations.put(ivar, finder.getFoundValue());
                    }
                    if (!(this.val$replaceAllIvars || OCCompilerHelper.supportsAutosynthesis(file2) && OCNameSuggester.getClang4ImplicitIvarName(propName).equals(ivar.getName()))) {
                        OCSynthesizePropertiesList synthesize = OCElementFactory.synthesizeList("@synthesize", propName, propName.equals(ivar.getName()) ? null : ivar.getName(), this.val$psiContext);
                        this.val$synthesizes.add(synthesize);
                    }
                    if (!(ivarType = ivar.getResolvedType()).isPointerToObjectCompatible() || this.val$ivarsInfo == null || OCNotReleasedIvarInspection.isIvarReleased(ivar, file2, this.val$ivarsInfo)) continue;
                    this.val$nonReleasedIvars.add(ivar);
                }
            }
        });
        OCReleaseVariablesIntentionAction releaseAction = OCCompilerHelper.isArcDisabled(file2) && !nonReleasedIvars.isEmpty() ? new OCReleaseVariablesIntentionAction(nonReleasedIvars) : null;
        OCConvertMemberRefactoringProcessor<OCInstanceVariableSymbol> processor2 = new OCConvertMemberRefactoringProcessor<OCInstanceVariableSymbol>((OCClassSymbol)interfaceSymbol, ivars, newNames, newDeclarations, existingDeclarations, replaceAllIvars ? null : synthesizes, releaseAction, (OCElementType)OCTokenTypes.DOT, this.getActionTitle(), convertUsages){

            @Override
            protected boolean showConflicts(@NotNull MultiMap<PsiElement, String> conflicts, @Nullable UsageInfo[] usages) {
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    OCGeneratePropertiesHandler.this.passConflictsToTest(new ArrayList<String>(conflicts.values()));
                    this.prepareSuccessful();
                    return true;
                }
                return super.showConflicts(conflicts, usages);
            }

            @Override
            protected void performRefactoring(@NotNull UsageInfo[] usages) {
                OCMoveToPrivateCategoryIntentionAction action;
                PsiElement newDeclaration;
                super.performRefactoring(usages);
                PsiElement psiElement = newDeclaration = this.myNewDeclarations.isEmpty() ? null : (PsiElement)this.myNewDeclarations.values().iterator().next();
                if (putToPrivateCategory && newDeclaration instanceof OCProperty && (action = new OCMoveToPrivateCategoryIntentionAction(){

                    @Override
                    protected OCMemberSymbol locateCandidate(@NotNull Project project2, Editor editor, PsiFile file2) {
                        return (OCMemberSymbol)((OCProperty)newDeclaration).getDeclaration().getDeclarators().get(0).getSymbol();
                    }
                }).isAvailable(this.myProject, null, newDeclaration.getContainingFile())) {
                    action.invoke(this.myProject, null, newDeclaration.getContainingFile());
                }
            }
        };
        processor2.run();
    }

    protected void passConflictsToTest(List<String> conflicts) {
    }

    protected boolean replaceAllIvars() {
        return false;
    }

    @Override
    protected OCMemberChooserObject[] getChooserNodes(OCMemberChooser chooser, Collection<OCInstanceVariableSymbol> candidates, OCGenerateFromIvarsActionContext actionContext, int moreNodesLevel) {
        if (OCGeneratePropertiesHandler.getOption(chooser.getOptionSelections(), SHOW_SYNTHESIZED).booleanValue()) {
            return super.getChooserNodes(chooser, candidates, actionContext, moreNodesLevel);
        }
        final HashSet synthesizedIvars = new HashSet();
        actionContext.getType().processMembers(OCSynthesizeSymbol.class, new Processor<OCSynthesizeSymbol>(){

            public boolean process(OCSynthesizeSymbol symbol) {
                if (symbol.isSynthesize()) {
                    synthesizedIvars.add(symbol.getIvarName());
                }
                return true;
            }
        });
        if (OCCompilerHelper.supportsAutosynthesis(actionContext.getContext().getContainingFile())) {
            actionContext.getInterfaceSymbol().processMembersInAllCategories(null, OCPropertySymbol.class, new Processor<OCPropertySymbol>(){

                public boolean process(OCPropertySymbol propertySymbol) {
                    OCInstanceVariableSymbol ivar = propertySymbol.getAssociatedIvar();
                    if (ivar != null) {
                        synthesizedIvars.add(ivar.getName());
                    }
                    return true;
                }
            }, false);
        }
        return super.getChooserNodes(chooser, ContainerUtil.filter(candidates, (Condition)new Condition<OCInstanceVariableSymbol>(){

            public boolean value(OCInstanceVariableSymbol ivar) {
                return !synthesizedIvars.contains(ivar.getName());
            }
        }), actionContext, moreNodesLevel);
    }

    @Override
    protected void optionValueChanged(OCMemberChooser chooser, Collection<OCInstanceVariableSymbol> candidates, OCOption option, OCGenerateFromIvarsActionContext actionContext) {
        if (SHOW_SYNTHESIZED.equals(option)) {
            chooser.resetElements(this.getChooserNodes(chooser, candidates, actionContext, 0));
        }
    }
}

