/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate.handlers;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.lang.generate.OCMemberChooser;
import com.jetbrains.cidr.lang.generate.OCMemberChooserObject;
import com.jetbrains.cidr.lang.generate.actions.OCGenerateIvarsActionContext;
import com.jetbrains.cidr.lang.generate.handlers.OCClassActionHandlerBase;
import com.jetbrains.cidr.lang.inspections.OCNotReleasedIvarInspection;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.OCSynthesizePropertiesList;
import com.jetbrains.cidr.lang.quickfixes.OCReleaseVariablesIntentionAction;
import com.jetbrains.cidr.lang.refactoring.OCConvertMemberRefactoringProcessor;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.settings.OCBooleanOption;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.settings.OCOption;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCProtocolSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCSynthesizeSymbol;
import com.jetbrains.cidr.lang.types.ARCAttribute;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCGenerateIvarsHandler
extends OCClassActionHandlerBase<OCClassSymbol, OCPropertySymbol, OCGenerateIvarsActionContext> {
    protected static final OCBooleanOption SHOW_SYNTHESIZED = new OCBooleanOption("Show synthesized properties");

    @Override
    protected String getMembersChooserTitle() {
        return "Select Properties to make Instance Variables";
    }

    @Override
    protected String getActionTitle() {
        return "Generate Instance Variables from Properties";
    }

    @Override
    protected String getNoMembersMessage(@NotNull OCGenerateIvarsActionContext context) {
        return context.getParentNameUppercase() + " has no properties to generate instance variables from";
    }

    @Override
    protected Class<? extends OCSymbolDeclarator> getParentClass() {
        return OCClassDeclaration.class;
    }

    @Override
    protected List<Pair<OCOption, Object>> loadOptions(PsiFile file2, @Nullable OCCodeStyleSettings settings, @NotNull OCGenerateIvarsActionContext context) {
        ArrayList<Pair<OCOption, Object>> result = new ArrayList<Pair<OCOption, Object>>();
        result.add(new Pair((Object)SHOW_SYNTHESIZED, (Object)true));
        return result;
    }

    @Override
    @NotNull
    protected OCGenerateIvarsActionContext evaluateActionContext(OCClassSymbol parent, PsiElement element) {
        return new OCGenerateIvarsActionContext(parent, parent.getResolvedType(true), element);
    }

    public static boolean isPropertyDefective(OCPropertySymbol property) {
        OCClassSymbol parent = (OCClassSymbol)property.getParent();
        if (parent instanceof OCProtocolSymbol) {
            return false;
        }
        OCFile file2 = parent.getContainingOCFile();
        OCType type = parent.getType().resolve(file2, true);
        if (type instanceof OCObjectType) {
            OCGenerateIvarsActionContext context = new OCGenerateIvarsActionContext(parent, (OCObjectType)type, file2);
            return OCGenerateIvarsHandler.getDefectiveCondition(context).value((Object)property);
        }
        return false;
    }

    @Override
    protected void performAction(@NotNull Project project2, @Nullable Editor editor, @NotNull PsiFile file2, @NotNull OCGenerateIvarsActionContext context, @NotNull List<OCPropertySymbol> properties) {
        OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)file2.getProject()).getCustomSettings(OCCodeStyleSettings.class);
        boolean declareInImpl = OCCompilerHelper.supportsIvarsInImplementation() && (settings == null || settings.PUT_IVARS_TO_IMPLEMENTATION);
        this.performAction(file2, context, properties, null, declareInImpl);
    }

    public void performAction(final PsiFile file2, OCGenerateIvarsActionContext context, final List<OCPropertySymbol> properties, final String customName, boolean declareInImplementation) {
        OCClassSymbol parent;
        FeatureUsageTracker.getInstance().triggerFeatureUsed("codeassists.altInsert");
        final OCInterfaceSymbol interfaceSymbol = (OCInterfaceSymbol)context.getInterfaceSymbol();
        final OCImplementationSymbol implementationSymbol = context.getImplementationSymbol();
        final HashMap ivarNames = new HashMap();
        ArrayList<String> nonReleasedIvarNames = new ArrayList<String>();
        final HashMap newDeclarations = new HashMap();
        HashMap existingDeclarations = new HashMap();
        ArrayList synthesizes = new ArrayList();
        final boolean replaceAllProps = this.replaceAllProperties();
        final Condition<OCPropertySymbol> defectiveCondition = OCGenerateIvarsHandler.getDefectiveCondition(context);
        PsiFile psiContext = context.getContext().isValid() ? context.getContext() : file2;
        ArrayList<OCPropertySymbol> nonReleasedProperties = new ArrayList<OCPropertySymbol>();
        OCNotReleasedIvarInspection.IvarsInfo ivarsInfo = OCNotReleasedIvarInspection.startInspection(file2);
        ApplicationManager.getApplication().runWriteAction(new Runnable((PsiElement)psiContext, existingDeclarations, synthesizes, ivarsInfo, nonReleasedProperties, nonReleasedIvarNames){
            final /* synthetic */ PsiElement val$psiContext;
            final /* synthetic */ Map val$existingDeclarations;
            final /* synthetic */ List val$synthesizes;
            final /* synthetic */ OCNotReleasedIvarInspection.IvarsInfo val$ivarsInfo;
            final /* synthetic */ List val$nonReleasedProperties;
            final /* synthetic */ List val$nonReleasedIvarNames;
            {
                this.val$psiContext = psiElement;
                this.val$existingDeclarations = map3;
                this.val$synthesizes = list2;
                this.val$ivarsInfo = ivarsInfo;
                this.val$nonReleasedProperties = list3;
                this.val$nonReleasedIvarNames = list4;
            }

            @Override
            public void run() {
                for (OCPropertySymbol property : properties) {
                    if (!replaceAllProps && !defectiveCondition.value((Object)property)) continue;
                    OCInstanceVariableSymbol associatedIvar = property.getAssociatedIvar();
                    String ivarName = customName != null ? customName : (associatedIvar != null ? associatedIvar.getName() : OCNameSuggester.getNonCollidingName(property));
                    ivarNames.put(property, ivarName);
                    CommonProcessors.FindFirstProcessor<OCInstanceVariableSymbol> finder = new CommonProcessors.FindFirstProcessor<OCInstanceVariableSymbol>(){

                        protected boolean accept(OCInstanceVariableSymbol symbol) {
                            return symbol.getGeneratedFromProperty() == null;
                        }
                    };
                    interfaceSymbol.processMembersInAllCategories(ivarName, OCInstanceVariableSymbol.class, finder);
                    implementationSymbol.processMembers(ivarName, OCInstanceVariableSymbol.class, finder);
                    OCType type = property.getResolvedType();
                    if (!finder.isFound()) {
                        ARCAttribute ivarAttribute;
                        OCPropertySymbol.PropertyAttribute propAttribute = property.getAttributeOfGroup(OCPropertySymbol.PropertyAttribute.ASSIGN, type, (PsiElement)file2);
                        String modifier = null;
                        if (propAttribute != null && OCCompilerHelper.isArcEnabled(file2) && type.isPointerToObjectCompatible() && !(ivarAttribute = propAttribute.getIvarCompatibleARCAttribute()).isDefault()) {
                            modifier = ivarAttribute.getTokenName();
                        }
                        newDeclarations.put(property, OCElementFactory.declaration(modifier, ivarName, property.getType(), this.val$psiContext));
                    } else {
                        this.val$existingDeclarations.put(property, finder.getFoundValue());
                    }
                    if (replaceAllProps) continue;
                    String name = ivarName.equals(property.getName()) ? null : ivarName;
                    OCSynthesizePropertiesList synthesize = OCElementFactory.synthesizeList("@synthesize", property.getName(), name, this.val$psiContext);
                    this.val$synthesizes.add(synthesize);
                    if (!type.isPointerToObjectCompatible() || !property.isRetained() || finder.isFound() && this.val$ivarsInfo != null && OCNotReleasedIvarInspection.isIvarReleased((OCInstanceVariableSymbol)finder.getFoundValue(), file2, this.val$ivarsInfo)) continue;
                    this.val$nonReleasedProperties.add(property);
                    this.val$nonReleasedIvarNames.add(ivarName);
                }
            }
        });
        if (!newDeclarations.isEmpty()) {
            Boolean generateIvars = this.generateIvars(file2.getProject());
            if (generateIvars == null) {
                return;
            }
            if (!generateIvars.booleanValue()) {
                newDeclarations.clear();
            }
        }
        OCReleaseVariablesIntentionAction releaseAction = null;
        if (OCCompilerHelper.isArcDisabled(file2) && !nonReleasedProperties.isEmpty()) {
            parent = (OCClassSymbol)properties.get(0).getParent();
            releaseAction = new OCReleaseVariablesIntentionAction(OCSymbolKind.INSTANCE_VARIABLE, parent, nonReleasedProperties, nonReleasedIvarNames);
        }
        parent = declareInImplementation ? context.getImplementationSymbol() : context.getInterfaceSymbol();
        OCConvertMemberRefactoringProcessor<OCPropertySymbol> processor2 = new OCConvertMemberRefactoringProcessor<OCPropertySymbol>(parent, properties, ivarNames, newDeclarations, existingDeclarations, replaceAllProps ? null : synthesizes, releaseAction, (OCElementType)OCTokenTypes.DEREF, this.getActionTitle(), replaceAllProps){

            @Override
            protected boolean showConflicts(@NotNull MultiMap<PsiElement, String> conflicts, @Nullable UsageInfo[] usages) {
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    OCGenerateIvarsHandler.this.passConflictsToTest(new ArrayList<String>(conflicts.values()));
                    this.prepareSuccessful();
                    return true;
                }
                return super.showConflicts(conflicts, usages);
            }
        };
        processor2.run();
    }

    protected void passConflictsToTest(List<String> conflicts) {
    }

    protected boolean replaceAllProperties() {
        return false;
    }

    @Nullable
    protected static Boolean askGenerateIvars(Project project2) {
        final Ref result = Ref.create();
        OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)project2).getCustomSettings(OCCodeStyleSettings.class);
        OCCodeStyleSettings.RememberedOption option = OCCodeStyleSettings.askAndSave(settings.GENERATE_INSTANCE_VARIABLES_FOR_PROPERTIES, "Do you want to generate instance variables for chosen properties?", "Generate instance variables", new Ref<Boolean>(){

            public void set(@Nullable Boolean value) {
                result.set((Object)value);
            }
        });
        if (option == null) {
            return null;
        }
        settings.GENERATE_INSTANCE_VARIABLES_FOR_PROPERTIES = option;
        return (Boolean)result.get();
    }

    @Nullable
    protected Boolean generateIvars(Project project2) {
        if (this.replaceAllProperties()) {
            return true;
        }
        return OCGenerateIvarsHandler.askGenerateIvars(project2);
    }

    @Override
    protected OCMemberChooserObject[] getChooserNodes(OCMemberChooser chooser, Collection<OCPropertySymbol> candidates, OCGenerateIvarsActionContext actionContext, int moreNodesLevel) {
        if (OCGenerateIvarsHandler.getOption(chooser.getOptionSelections(), SHOW_SYNTHESIZED).booleanValue()) {
            return super.getChooserNodes(chooser, candidates, actionContext, moreNodesLevel);
        }
        Condition<OCPropertySymbol> condition = OCGenerateIvarsHandler.getDefectiveCondition(actionContext);
        return super.getChooserNodes(chooser, ContainerUtil.filter(candidates, condition), actionContext, moreNodesLevel);
    }

    private static Condition<OCPropertySymbol> getDefectiveCondition(final OCGenerateIvarsActionContext actionContext) {
        final HashMap implementedProperties = new HashMap();
        actionContext.getType().processMembers(OCMemberSymbol.class, new Processor<OCMemberSymbol>(){

            public boolean process(OCMemberSymbol member) {
                if (member instanceof OCSynthesizeSymbol) {
                    implementedProperties.put(member.getName(), 10);
                } else if (member instanceof OCMethodSymbol && member.isDefinition()) {
                    OCPropertySymbol property;
                    OCMethodSymbol intfMethod = (OCMethodSymbol)member.getAssociatedSymbol();
                    OCPropertySymbol oCPropertySymbol = property = intfMethod != null ? intfMethod.getGeneratedFromProperty() : null;
                    if (property != null) {
                        Integer curValue = (Integer)implementedProperties.get(property.getName());
                        implementedProperties.put(property.getName(), curValue != null ? curValue + 1 : 1);
                    }
                }
                return true;
            }
        });
        return new Condition<OCPropertySymbol>(){

            public boolean value(OCPropertySymbol property) {
                String categoryName = ((OCClassSymbol)property.getParent()).getCategoryName();
                if (categoryName != null && !categoryName.isEmpty()) {
                    return false;
                }
                if (((OCClassSymbol)property.getParent()).equals(actionContext.getInterfaceSymbol())) {
                    Integer value = (Integer)implementedProperties.get(property.getName());
                    return (property.isReadonly() ? 1 : 2) > (value != null ? value : 0);
                }
                return property.getAssociatedSymbol() == null;
            }
        };
    }

    @Override
    protected void optionValueChanged(OCMemberChooser chooser, Collection<OCPropertySymbol> candidates, OCOption option, OCGenerateIvarsActionContext actionContext) {
        if (SHOW_SYNTHESIZED.equals(option)) {
            chooser.resetElements(this.getChooserNodes(chooser, candidates, actionContext, 0));
        }
    }
}

