/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate.handlers;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.generate.actions.OCGenerateMethodActionContext;
import com.jetbrains.cidr.lang.generate.handlers.OCGenerateMethodHandler;
import com.jetbrains.cidr.lang.psi.OCImplementation;
import com.jetbrains.cidr.lang.psi.OCInterface;
import com.jetbrains.cidr.lang.quickfixes.OCReleaseVariablesIntentionAction;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.settings.OCOption;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCProtocolSymbol;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCRealType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCCallableUtil;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCGenerateEncodeHandler
extends OCGenerateMethodHandler {
    @Override
    protected String getActionTitle() {
        return "Generate -encodeWithCoder:/-initWithCoder:";
    }

    @Override
    protected String[] getMethodNames() {
        return new String[]{"initWithCoder:", "encodeWithCoder:"};
    }

    @Override
    @Nullable
    protected String getParentProtocol() {
        return "NSCoding";
    }

    @Override
    protected String getNoMembersMessage(@NotNull OCGenerateMethodActionContext context) {
        return context.getParentNameUppercase() + " has no encodable members";
    }

    @Override
    protected List<Pair<OCOption, Object>> loadOptions(PsiFile file2, @Nullable OCCodeStyleSettings settings, @NotNull OCGenerateMethodActionContext context) {
        return Collections.singletonList(new Pair((Object)DECLARE_IN_INTERFACE, (Object)(settings == null || settings.DECLARE_GENERATED_METHODS ? 1 : 0)));
    }

    @Override
    protected void saveOptions(PsiFile file2, @NotNull OCCodeStyleSettings settings, Map<OCOption, Object> optionValues) {
        settings.DECLARE_GENERATED_METHODS = OCGenerateEncodeHandler.getOption(optionValues, DECLARE_IN_INTERFACE);
    }

    @Override
    @NotNull
    protected String getInsertText(@NotNull PsiElement element, @Nullable PsiElement at, @NotNull List<OCInstanceVariableSymbol> members, @NotNull OCGenerateMethodActionContext actionContext) {
        OCMethodSymbol initMethod = actionContext.getBaseMethods().get(0);
        OCMethodSymbol encodeMethod = actionContext.getBaseMethods().get(1);
        StringBuilder builder = new StringBuilder();
        if (element instanceof OCInterface) {
            builder.append(OCCallableUtil.methodSignature(initMethod, element)).append(";");
            builder.append(OCCallableUtil.methodSignature(encodeMethod, element)).append(";");
        } else {
            OCMethodSymbol initBaseMethod;
            StringBuilder initBody = new StringBuilder();
            StringBuilder encodeBody = new StringBuilder();
            OCObjectType superType = actionContext.getType().getSuperType();
            OCProtocolSymbol codingProtocol = (OCProtocolSymbol)initMethod.getParent();
            OCType coderType = initMethod.getSelectors().get(0).getParameter().getType().resolve(element.getContainingFile(), true);
            if (superType != null && superType.implementsProtocol(codingProtocol)) {
                encodeBody.append("[super encodeWithCoder: coder];\n");
                initBaseMethod = initMethod;
            } else {
                CommonProcessors.FindFirstProcessor finder = new CommonProcessors.FindFirstProcessor();
                if (superType != null) {
                    superType.processMembers("init", OCMethodSymbol.class, finder);
                }
                initBaseMethod = (initBaseMethod = (OCMethodSymbol)finder.getFoundValue()) != null ? initBaseMethod : initMethod;
            }
            for (OCInstanceVariableSymbol ivar : members) {
                OCPropertySymbol property = ivar.getAssociatedProperty();
                OCType type = ivar.getType().resolve(element.getContainingFile(), true);
                boolean hasSetter = property != null && !property.isReadonly();
                String initMemberName = hasSetter ? "self." + property.getName() : ivar.getName();
                String encodeMemberName = property != null ? "self." + property.getName() : ivar.getName();
                OCGenerateEncodeHandler.appendMember(initBody, encodeBody, type, initMemberName, encodeMemberName, codingProtocol, coderType, hasSetter ? null : ivar, actionContext.getNonReleasedIvars(), element);
            }
            builder.append(OCCallableUtil.methodText(initBaseMethod, null, OCCallableUtil.methodSignature(initMethod, element), initBody.toString().trim(), element));
            builder.append(OCCallableUtil.methodText(OCCallableUtil.methodSignature(encodeMethod, element), encodeBody.toString().trim(), element));
        }
        return builder.toString();
    }

    @Override
    protected boolean showSymbolInChooser(OCInstanceVariableSymbol ivar, OCGenerateMethodActionContext actionContext) {
        if (!super.showSymbolInChooser(ivar, actionContext)) {
            return false;
        }
        PsiFile containingFile = actionContext.getContext().getContainingFile();
        OCType type = ivar.getType().resolve(containingFile, true);
        OCProtocolSymbol codingProtocol = (OCProtocolSymbol)actionContext.getBaseMethods().get(0).getParent();
        return OCGenerateEncodeHandler.appendMember(new StringBuilder(), new StringBuilder(), type, "", "", codingProtocol, null, null, new ArrayList<OCInstanceVariableSymbol>(), actionContext.getContext());
    }

    @Override
    protected void performAction(@NotNull Project project2, @NotNull PsiElement element, int caretPos, PsiElement at, @NotNull List<OCInstanceVariableSymbol> members, @NotNull OCGenerateMethodActionContext context) {
        super.performAction(project2, element, caretPos, at, members, context);
        if (element instanceof OCImplementation && !context.getNonReleasedIvars().isEmpty()) {
            new OCReleaseVariablesIntentionAction(context.getNonReleasedIvars()).invoke(project2, null, element.getContainingFile());
        }
    }

    private static boolean appendMember(final StringBuilder initBody, final StringBuilder encodeBody, OCType type, final String initMemberName, final String encodeMemberName, final OCProtocolSymbol codingProtocol, final @Nullable OCType coderType, @Nullable OCInstanceVariableSymbol ivar, final List<OCInstanceVariableSymbol> nonReleasedIvars, final PsiElement context) {
        if (type instanceof OCStructType && !type.isScalar() && coderType != null && coderType.isPointerToObject()) {
            OCDeclaratorSymbol encodeParam;
            OCObjectType coderObjectType = (OCObjectType)coderType.getTerminalType();
            String typeName = type.getName();
            typeName = typeName.startsWith("NS") ? typeName.substring(2) : typeName;
            OCMethodSymbol encodeMethod = coderObjectType.findMember("encode" + typeName + ":forKey:", OCMethodSymbol.class);
            OCMethodSymbol decodeMethod = coderObjectType.findMember("decode" + typeName + "ForKey:", OCMethodSymbol.class);
            if (encodeMethod != null && decodeMethod != null && (encodeParam = encodeMethod.getSelectors().get(0).getParameter()) != null && type.equalsAfterResolving(encodeParam.getType(), (PsiElement)context.getContainingFile()) && type.equalsAfterResolving(decodeMethod.getReturnType(), (PsiElement)context.getContainingFile())) {
                encodeBody.append("[coder encode").append(typeName).append(":").append(encodeMemberName);
                encodeBody.append(" forKey:@\"").append(initMemberName).append("\"];\n");
                initBody.append(initMemberName).append("=").append("[coder decode").append(typeName).append("ForKey:@\"");
                initBody.append(initMemberName).append("\"];\n");
                return true;
            }
        }
        if (OCGenerateEncodeHandler.processStructFields(type, new Processor<OCDeclaratorSymbol>(){

            public boolean process(OCDeclaratorSymbol field) {
                OCGenerateEncodeHandler.appendMember(initBody, encodeBody, field.getResolvedType(), initMemberName + "." + field.getName(), encodeMemberName + "." + field.getName(), codingProtocol, coderType, null, nonReleasedIvars, context);
                return true;
            }
        })) {
            return true;
        }
        if (type.isPointerToObject() && ((OCObjectType)type.getTerminalType()).implementsProtocol(codingProtocol)) {
            encodeBody.append("[coder encodeObject:").append(encodeMemberName).append(" forKey:@\"").append(initMemberName).append("\"];\n");
            initBody.append(initMemberName).append("=");
            if (ivar != null && OCCompilerHelper.isArcDisabled(context.getContainingFile())) {
                initBody.append("[[coder decodeObjectForKey:@\"").append(initMemberName).append("\"]");
                initBody.append(type.isPointerToString() ? "copy" : "retain").append("];\n");
                nonReleasedIvars.add(ivar);
            } else {
                initBody.append("[coder decodeObjectForKey:@\"").append(initMemberName).append("\"];\n");
            }
            return true;
        }
        if (OCIntType.isBool(type, context)) {
            encodeBody.append("[coder encodeBool:").append(encodeMemberName).append(" forKey:@\"").append(initMemberName).append("\"];\n");
            initBody.append(initMemberName).append("=").append("[coder decodeBoolForKey:@\"").append(initMemberName).append("\"];\n");
            return true;
        }
        if (type instanceof OCIntType && ((OCIntType)type).getRank(context) > OCIntType.INT.getRank(context)) {
            encodeBody.append("[coder encodeInt64:").append(encodeMemberName).append(" forKey:@\"").append(initMemberName).append("\"];\n");
            initBody.append(initMemberName).append("=").append("[coder decodeInt64ForKey:@\"").append(initMemberName).append("\"];\n");
            return true;
        }
        if (type.isIntegerCompatible(context)) {
            encodeBody.append("[coder encodeInt:").append(encodeMemberName).append(" forKey:@\"").append(initMemberName).append("\"];\n");
            String cast = type.isCompatible(OCIntType.INT, context) ? "" : "(" + type.getBestNameInContext(context) + ")";
            initBody.append(initMemberName).append("=").append(cast).append("[coder decodeIntForKey:@\"").append(initMemberName).append("\"];\n");
            return true;
        }
        if (type.equals((Object)OCRealType.FLOAT, context)) {
            encodeBody.append("[coder encodeFloat:").append(encodeMemberName).append(" forKey:@\"").append(initMemberName).append("\"];\n");
            initBody.append(initMemberName).append("=").append("[coder decodeFloatForKey:@\"").append(initMemberName).append("\"];\n");
            return true;
        }
        if (type instanceof OCRealType) {
            encodeBody.append("[coder encodeDouble:").append(encodeMemberName).append(" forKey:@\"").append(initMemberName).append("\"];\n");
            initBody.append(initMemberName).append("=").append("[coder decodeDoubleForKey:@\"").append(initMemberName).append("\"];\n");
            return true;
        }
        if (type.isPointerToChar()) {
            encodeBody.append("[coder encodeObject: [NSData dataWithBytes: ").append(initMemberName).append(" length: strlen(");
            encodeBody.append(initMemberName).append(")] forKey:@\"").append(encodeMemberName).append("\"];\n");
            initBody.append(initMemberName).append("=strdup(").append("((NSData*)[coder decodeObjectForKey:@\"").append(initMemberName).append("\"]).bytes);\n");
            return true;
        }
        return false;
    }
}

