/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate.handlers;

import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.generate.actions.OCGenerateMethodActionContext;
import com.jetbrains.cidr.lang.generate.handlers.OCGenerateMethodHandler;
import com.jetbrains.cidr.lang.psi.OCInterface;
import com.jetbrains.cidr.lang.settings.OCBooleanOption;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.settings.OCOption;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCCallableUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCGenerateDescriptionHandler
extends OCGenerateMethodHandler {
    protected static final OCBooleanOption INCLUDE_MEMBER_NAMES = new OCBooleanOption("Include member names");

    @Override
    protected String getActionTitle() {
        return "Generate -description";
    }

    @Override
    protected String[] getMethodNames() {
        return new String[]{"description"};
    }

    @Override
    protected boolean allowEmptySelection(OCGenerateMethodActionContext context) {
        return true;
    }

    @Override
    protected List<Pair<OCOption, Object>> loadOptions(PsiFile file2, @Nullable OCCodeStyleSettings settings, @NotNull OCGenerateMethodActionContext context) {
        ArrayList<Pair<OCOption, Object>> list = new ArrayList<Pair<OCOption, Object>>();
        list.add(new Pair((Object)INCLUDE_MEMBER_NAMES, (Object)(settings == null || settings.DESCRIPTION_INCLUDE_MEMBER_NAMES ? 1 : 0)));
        list.add(new Pair((Object)DECLARE_IN_INTERFACE, (Object)(settings == null || settings.DECLARE_GENERATED_METHODS ? 1 : 0)));
        return list;
    }

    @Override
    protected void saveOptions(PsiFile file2, @NotNull OCCodeStyleSettings settings, Map<OCOption, Object> optionValues) {
        settings.DESCRIPTION_INCLUDE_MEMBER_NAMES = OCGenerateDescriptionHandler.getOption(optionValues, INCLUDE_MEMBER_NAMES);
        settings.DECLARE_GENERATED_METHODS = OCGenerateDescriptionHandler.getOption(optionValues, DECLARE_IN_INTERFACE);
    }

    @Override
    @NotNull
    protected String getInsertText(@NotNull PsiElement element, @Nullable PsiElement at, @NotNull List<OCInstanceVariableSymbol> ivars, @NotNull OCGenerateMethodActionContext actionContext) {
        OCImplementationSymbol oCImplementationSymbol;
        if (element instanceof OCInterface) {
            return OCCallableUtil.methodSignature(actionContext.getBaseMethod(), element) + ";";
        }
        boolean includeMemberNames = this.getOption(actionContext, INCLUDE_MEMBER_NAMES);
        ArrayList<Pair<String, String>> strings = new ArrayList<Pair<String, String>>();
        StringBuilder body = new StringBuilder();
        boolean isFirst = true;
        for (OCInstanceVariableSymbol oCInstanceVariableSymbol : ivars) {
            OCPropertySymbol property = oCInstanceVariableSymbol.getAssociatedProperty();
            OCType type = oCInstanceVariableSymbol.getType().resolve(element.getContainingFile(), true);
            OCGenerateDescriptionHandler.appendMember(strings, property != null ? "self." + property.getName() : oCInstanceVariableSymbol.getName(), type, includeMemberNames);
        }
        for (Pair pair : strings) {
            body.append("[description appendFormat: @\"");
            if (!isFirst) {
                body.append(", ");
            }
            body.append((String)pair.getFirst()).append("\", ").append((String)pair.getSecond()).append("];\n");
            isFirst = false;
        }
        OCObjectType superType = actionContext.getType().getSuperType();
        OCImplementationSymbol oCImplementationSymbol2 = oCImplementationSymbol = superType != null ? superType.getImplementation() : null;
        String templateName = oCImplementationSymbol != null && !oCImplementationSymbol.processMembersInAllCategories("description", OCMethodSymbol.class, new CommonProcessors.FindFirstProcessor(), true) ? "OC Overridden Description Body 1.m" : (strings.size() > 0 ? "OC Overridden Description Body 2.m" : "OC Overridden Description Body 3.m");
        return OCCallableUtil.methodFromTemplate(actionContext.getBaseMethod(), templateName, body.toString().trim(), element);
    }

    private static void appendMember(final List<Pair<String, String>> strings, final String memberName, OCType type, final boolean includeMemberNames) {
        if (type instanceof OCStructType && !type.isScalar()) {
            if (!OCGenerateDescriptionHandler.processStructFields(type, new Processor<OCDeclaratorSymbol>(){

                public boolean process(OCDeclaratorSymbol field) {
                    OCGenerateDescriptionHandler.appendMember(strings, memberName + "." + field.getName(), field.getResolvedType(), includeMemberNames);
                    return true;
                }
            })) {
                strings.add((Pair<String, String>)Pair.create((Object)(includeMemberNames ? memberName + "=%s" : "%s"), (Object)("(const char*)" + memberName)));
            }
        } else {
            strings.add((Pair<String, String>)Pair.create((Object)(includeMemberNames ? memberName + "=" + type.getFormatString() : type.getFormatString()), (Object)memberName));
        }
    }
}

